/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="profitIncomeService")
public class ProfitIncomeServiceImpl
extends BaseServiceImpl<ProfitIncomeMapper, ProfitIncomeEntity>
implements IProfitIncomeService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ProfitIncomeMapper mapper;

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Integer inAdvanceFlag, String day, String date, List<Long> projectIdList) {
        String endDate = null;
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            Date executeDate = null;
            try {
                executeDate = DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            endDate = DateFormatUtils.format((Date)DateUtils.addMonths(executeDate, (int)-1), (String)"yyyy-MM-dd");
        } else {
            if (!day.equals(DateFormatUtils.format((Date)new Date(), (String)"d"))) {
                throw new BusinessException("\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u5339\u914d\u8bbe\u7f6e\u65e5\u671f");
            }
            endDate = DateFormatUtils.format((Date)DateUtils.addMonths((Date)new Date(), (int)-1), (String)"yyyy-MM-dd");
        }
        List<Object> profitIncomeVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            endDate = date;
            profitIncomeVOList = this.queryProjects(endDate, projectIdList);
        } else if (inAdvanceFlag == 1) {
            endDate = date;
            profitIncomeVOList = this.queryProjects(endDate, null);
        } else {
            profitIncomeVOList = this.queryProjects(endDate, null);
        }
        List<ProfitIncomeVO> costanalysisList = this.queryCostanalysis(endDate);
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            for (Object profitIncomeVO : profitIncomeVOList) {
                void var10_11;
                Object var10_12 = null;
                try {
                    Date date2 = DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd"});
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                profitIncomeVO.setReportingMonth((Date)var10_11);
                for (ProfitIncomeVO profitIncomeVO1 : costanalysisList) {
                    if (!profitIncomeVO.getProjectId().equals(profitIncomeVO1.getProjectId())) continue;
                    profitIncomeVO.setRealProduct(profitIncomeVO1.getCumulativeIncome() == null ? new BigDecimal("0") : profitIncomeVO1.getCumulativeIncome());
                    profitIncomeVO.setCostAnalysisCreateTime(profitIncomeVO1.getCostAnalysisCreateTime());
                    profitIncomeVO.setCreateTime(new Date());
                }
            }
            for (Object profitIncomeVO : profitIncomeVOList) {
                Object innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse commonResponse = this.iOrgApi.detailById(profitIncomeVO.getProjectDepartmentId());
                if (!commonResponse.isSuccess() || null == commonResponse.getData() || !(orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = ((String)(innerCode = ((OrgVO)commonResponse.getData()).getInnerCode())).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                profitIncomeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                profitIncomeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                profitIncomeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
            }
            List<ProfitIncomeVO> engineermeasurementList = this.queryEngineermeasurement(endDate);
            if (CollectionUtils.isNotEmpty(engineermeasurementList)) {
                for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                    for (ProfitIncomeVO profitIncomeVO1 : engineermeasurementList) {
                        if (!profitIncomeVO.getProjectId().equals(profitIncomeVO1.getProjectId())) continue;
                        profitIncomeVO.setNotarizeProduct(profitIncomeVO1.getCurrentBatch() == null ? new BigDecimal(0) : profitIncomeVO1.getCurrentBatch());
                    }
                }
            } else {
                for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                    profitIncomeVO.setNotarizeProduct(new BigDecimal(0));
                }
            }
            for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 5) {
                    profitIncomeVO.setNotarizeProduct(profitIncomeVO.getRealProduct());
                }
                profitIncomeVO.setUnliquidated(ComputeUtil.safeSub((BigDecimal)profitIncomeVO.getRealProduct(), (BigDecimal)profitIncomeVO.getNotarizeProduct()));
            }
            this.logger.info("-----------------------------------------\u6536\u5165\u5206\u6790\u751f\u6210\u6570\u636e,\u622a\u6b62\u65e5\u671f:" + endDate + " :" + JSONObject.toJSONString(profitIncomeVOList));
            if (CollectionUtils.isNotEmpty(projectIdList)) {
                for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.set(ProfitIncomeEntity::getOrgId, (Object)profitIncomeVO.getOrgId());
                    updateWrapper.set(ProfitIncomeEntity::getOrgCode, (Object)profitIncomeVO.getOrgCode());
                    updateWrapper.set(ProfitIncomeEntity::getOrgName, (Object)profitIncomeVO.getOrgName());
                    updateWrapper.set(ProfitIncomeEntity::getProjectDepartmentId, (Object)profitIncomeVO.getProjectDepartmentId());
                    updateWrapper.set(ProfitIncomeEntity::getProjectName, (Object)profitIncomeVO.getProjectName());
                    updateWrapper.set(ProfitIncomeEntity::getProjectCode, (Object)profitIncomeVO.getProjectCode());
                    updateWrapper.set(ProfitIncomeEntity::getProjectStatus, (Object)profitIncomeVO.getProjectStatus());
                    updateWrapper.set(ProfitIncomeEntity::getRealProduct, (Object)profitIncomeVO.getRealProduct());
                    updateWrapper.set(ProfitIncomeEntity::getNotarizeProduct, (Object)profitIncomeVO.getNotarizeProduct());
                    updateWrapper.set(ProfitIncomeEntity::getUnliquidated, (Object)profitIncomeVO.getUnliquidated());
                    updateWrapper.set(ProfitIncomeEntity::getProjectCreateTime, (Object)profitIncomeVO.getProjectCreateTime());
                    updateWrapper.set(ProfitIncomeEntity::getCostAnalysisCreateTime, (Object)profitIncomeVO.getCostAnalysisCreateTime());
                    updateWrapper.eq(ProfitIncomeEntity::getProjectId, (Object)profitIncomeVO.getProjectId());
                    updateWrapper.eq(ProfitIncomeEntity::getReportingMonth, (Object)endDate);
                    boolean flag = this.update((Wrapper)updateWrapper);
                    if (flag) continue;
                    this.logger.info("-----------------------------------------\u6536\u5165\u5206\u6790\u66f4\u65b0\u6570\u636e\u5931\u8d25,\u622a\u6b62\u65e5\u671f:" + endDate + "\u9879\u76eeid" + profitIncomeVO.getProjectId() + "");
                    throw new BusinessException("\u6536\u5165\u5206\u6790\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff01");
                }
            } else if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
                Date executeDate = null;
                try {
                    executeDate = DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd"});
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
                String dateDel = simpleDateFormat.format(executeDate);
                this.deleteByReportingMonth(dateDel);
                this.saveOrUpdateBatch(BeanMapper.mapList(profitIncomeVOList, ProfitIncomeEntity.class));
            }
        }
    }

    @Override
    public List<ProfitIncomeVO> queryProject(String endDate) {
        return ((ProfitIncomeMapper)this.baseMapper).getProject(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryCostanalysis(String endDate) {
        return ((ProfitIncomeMapper)this.baseMapper).getCostanalysis(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryEngineermeasurement(String endDate) {
        return ((ProfitIncomeMapper)this.baseMapper).getEngineermeasurement(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryProjects(String endDate, List<Long> idList) {
        return ((ProfitIncomeMapper)this.baseMapper).getProjects(endDate, idList);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ProfitIncomeVO> processingList(List<ProfitIncomeVO> profitIncomeVOList) {
        void var37_42;
        int i;
        BigDecimal realProduct1 = new BigDecimal("0");
        BigDecimal notarizeProduct1 = new BigDecimal("0");
        BigDecimal unliquidated1 = new BigDecimal("0");
        ArrayList<ProfitIncomeVO> profitIncomeVOList1 = new ArrayList<ProfitIncomeVO>();
        ProfitIncomeVO profitIncomeVO1 = new ProfitIncomeVO();
        BigDecimal realProduct2 = new BigDecimal("0");
        BigDecimal notarizeProduct2 = new BigDecimal("0");
        BigDecimal unliquidated2 = new BigDecimal("0");
        ArrayList<ProfitIncomeVO> profitIncomeVOList2 = new ArrayList<ProfitIncomeVO>();
        ProfitIncomeVO profitIncomeVO2 = new ProfitIncomeVO();
        BigDecimal realProduct3 = new BigDecimal("0");
        BigDecimal notarizeProduct3 = new BigDecimal("0");
        BigDecimal unliquidated3 = new BigDecimal("0");
        ArrayList<ProfitIncomeVO> profitIncomeVOList3 = new ArrayList<ProfitIncomeVO>();
        ProfitIncomeVO profitIncomeVO3 = new ProfitIncomeVO();
        BigDecimal realProduct4 = new BigDecimal("0");
        BigDecimal notarizeProduct4 = new BigDecimal("0");
        BigDecimal unliquidated4 = new BigDecimal("0");
        ArrayList<ProfitIncomeVO> profitIncomeVOList4 = new ArrayList<ProfitIncomeVO>();
        ProfitIncomeVO profitIncomeVO4 = new ProfitIncomeVO();
        BigDecimal realProduct5 = new BigDecimal("0");
        BigDecimal notarizeProduct5 = new BigDecimal("0");
        BigDecimal unliquidated5 = new BigDecimal("0");
        ArrayList<ProfitIncomeVO> profitIncomeVOList5 = new ArrayList<ProfitIncomeVO>();
        ProfitIncomeVO profitIncomeVO5 = new ProfitIncomeVO();
        BigDecimal realProduct6 = new BigDecimal("0");
        BigDecimal notarizeProduct6 = new BigDecimal("0");
        BigDecimal unliquidated6 = new BigDecimal("0");
        ArrayList<ProfitIncomeVO> profitIncomeVOList6 = new ArrayList<ProfitIncomeVO>();
        ProfitIncomeVO profitIncomeVO6 = new ProfitIncomeVO();
        BigDecimal realProductTotoal = new BigDecimal("0");
        BigDecimal notarizeProductTotoal = new BigDecimal("0");
        BigDecimal unliquidatedTotoal = new BigDecimal("0");
        ProfitIncomeVO profitIncomeVO7 = new ProfitIncomeVO();
        for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
            if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 1) {
                realProduct1 = ComputeUtil.safeAdd((BigDecimal)realProduct1, (BigDecimal)(profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") : profitIncomeVO.getRealProduct()));
                notarizeProduct1 = ComputeUtil.safeAdd((BigDecimal)notarizeProduct1, (BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct()));
                unliquidated1 = ComputeUtil.safeAdd((BigDecimal)unliquidated1, (BigDecimal)(profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") : profitIncomeVO.getUnliquidated()));
                profitIncomeVOList1.add(profitIncomeVO);
            }
            if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 2) {
                realProduct2 = ComputeUtil.safeAdd((BigDecimal)realProduct2, (BigDecimal)(profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") : profitIncomeVO.getRealProduct()));
                notarizeProduct2 = ComputeUtil.safeAdd((BigDecimal)notarizeProduct2, (BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct()));
                unliquidated2 = ComputeUtil.safeAdd((BigDecimal)unliquidated2, (BigDecimal)(profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") : profitIncomeVO.getUnliquidated()));
                profitIncomeVOList2.add(profitIncomeVO);
            }
            if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 3) {
                realProduct3 = ComputeUtil.safeAdd((BigDecimal)realProduct3, (BigDecimal)(profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") : profitIncomeVO.getRealProduct()));
                notarizeProduct3 = ComputeUtil.safeAdd((BigDecimal)notarizeProduct3, (BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct()));
                unliquidated3 = ComputeUtil.safeAdd((BigDecimal)unliquidated3, (BigDecimal)(profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") : profitIncomeVO.getUnliquidated()));
                profitIncomeVOList3.add(profitIncomeVO);
            }
            if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 4) {
                realProduct4 = ComputeUtil.safeAdd((BigDecimal)realProduct4, (BigDecimal)(profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") : profitIncomeVO.getRealProduct()));
                notarizeProduct4 = ComputeUtil.safeAdd((BigDecimal)notarizeProduct4, (BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct()));
                unliquidated4 = ComputeUtil.safeAdd((BigDecimal)unliquidated4, (BigDecimal)(profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") : profitIncomeVO.getUnliquidated()));
                profitIncomeVOList4.add(profitIncomeVO);
            }
            if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 5) {
                realProduct5 = ComputeUtil.safeAdd((BigDecimal)realProduct5, (BigDecimal)(profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") : profitIncomeVO.getRealProduct()));
                notarizeProduct5 = ComputeUtil.safeAdd((BigDecimal)notarizeProduct5, (BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct()));
                unliquidated5 = ComputeUtil.safeAdd((BigDecimal)unliquidated5, (BigDecimal)(profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") : profitIncomeVO.getUnliquidated()));
                profitIncomeVOList5.add(profitIncomeVO);
            }
            if (profitIncomeVO.getProjectStatus() == null || profitIncomeVO.getProjectStatus() != 6) continue;
            realProduct6 = ComputeUtil.safeAdd((BigDecimal)realProduct6, (BigDecimal)(profitIncomeVO.getRealProduct() == null ? new BigDecimal("0") : profitIncomeVO.getRealProduct()));
            notarizeProduct6 = ComputeUtil.safeAdd((BigDecimal)notarizeProduct6, (BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? new BigDecimal("0") : profitIncomeVO.getNotarizeProduct()));
            unliquidated6 = ComputeUtil.safeAdd((BigDecimal)unliquidated6, (BigDecimal)(profitIncomeVO.getUnliquidated() == null ? new BigDecimal("0") : profitIncomeVO.getUnliquidated()));
            profitIncomeVOList6.add(profitIncomeVO);
        }
        realProductTotoal = ProfitIncomeServiceImpl.getBigDecimalSum(realProduct1, realProduct2, realProduct3, realProduct4, realProduct5, realProduct6);
        notarizeProductTotoal = ProfitIncomeServiceImpl.getBigDecimalSum(notarizeProduct1, notarizeProduct2, notarizeProduct3, notarizeProduct4, notarizeProduct5, notarizeProduct6);
        unliquidatedTotoal = ProfitIncomeServiceImpl.getBigDecimalSum(unliquidated1, unliquidated2, unliquidated3, unliquidated4, unliquidated5, unliquidated6);
        for (i = 0; i < profitIncomeVOList1.size(); ++i) {
            ((ProfitIncomeVO)profitIncomeVOList1.get(i)).setNumber("" + (i + 1) + "");
        }
        for (i = 0; i < profitIncomeVOList2.size(); ++i) {
            ((ProfitIncomeVO)profitIncomeVOList2.get(i)).setNumber("" + (i + 1) + "");
        }
        for (i = 0; i < profitIncomeVOList3.size(); ++i) {
            ((ProfitIncomeVO)profitIncomeVOList3.get(i)).setNumber("" + (i + 1) + "");
        }
        for (i = 0; i < profitIncomeVOList4.size(); ++i) {
            ((ProfitIncomeVO)profitIncomeVOList4.get(i)).setNumber("" + (i + 1) + "");
        }
        for (i = 0; i < profitIncomeVOList5.size(); ++i) {
            ((ProfitIncomeVO)profitIncomeVOList5.get(i)).setNumber("" + (i + 1) + "");
        }
        for (i = 0; i < profitIncomeVOList6.size(); ++i) {
            ((ProfitIncomeVO)profitIncomeVOList6.get(i)).setNumber("" + (i + 1) + "");
        }
        ArrayList<Object> profitIncomeVOS = new ArrayList<ProfitIncomeVO>();
        profitIncomeVO7.setNumber("\u5408\u8ba1");
        profitIncomeVO7.setId(Long.valueOf(Long.parseLong("7")));
        profitIncomeVO7.setRealProduct(realProductTotoal);
        profitIncomeVO7.setNotarizeProduct(notarizeProductTotoal);
        profitIncomeVO7.setUnliquidated(unliquidatedTotoal);
        profitIncomeVOS.add(profitIncomeVO7);
        if (CollectionUtils.isNotEmpty(profitIncomeVOList1)) {
            profitIncomeVO1.setId(Long.valueOf(Long.parseLong("1")));
            profitIncomeVO1.setNumber("\u5c0f\u8ba1");
            profitIncomeVO1.setRealProduct(realProduct1);
            profitIncomeVO1.setNotarizeProduct(notarizeProduct1);
            profitIncomeVO1.setUnliquidated(unliquidated1);
            profitIncomeVOS.add(profitIncomeVO1);
            profitIncomeVOS.addAll(this.formatList(profitIncomeVOList1));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList2)) {
            profitIncomeVO2.setId(Long.valueOf(Long.parseLong("2")));
            profitIncomeVO2.setNumber("\u5c0f\u8ba1");
            profitIncomeVO2.setRealProduct(realProduct2);
            profitIncomeVO2.setNotarizeProduct(notarizeProduct2);
            profitIncomeVO2.setUnliquidated(unliquidated2);
            profitIncomeVOS.add(profitIncomeVO2);
            profitIncomeVOS.addAll(this.formatList(profitIncomeVOList2));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList3)) {
            profitIncomeVO3.setId(Long.valueOf(Long.parseLong("3")));
            profitIncomeVO3.setNumber("\u5c0f\u8ba1");
            profitIncomeVO3.setRealProduct(realProduct3);
            profitIncomeVO3.setNotarizeProduct(notarizeProduct3);
            profitIncomeVO3.setUnliquidated(unliquidated3);
            profitIncomeVOS.add(profitIncomeVO3);
            profitIncomeVOS.addAll(this.formatList(profitIncomeVOList3));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList4)) {
            profitIncomeVO4.setId(Long.valueOf(Long.parseLong("4")));
            profitIncomeVO4.setNumber("\u5c0f\u8ba1");
            profitIncomeVO4.setRealProduct(realProduct4);
            profitIncomeVO4.setNotarizeProduct(notarizeProduct4);
            profitIncomeVO4.setUnliquidated(unliquidated4);
            profitIncomeVOS.add(profitIncomeVO4);
            profitIncomeVOS.addAll(this.formatList(profitIncomeVOList4));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList5)) {
            profitIncomeVO5.setId(Long.valueOf(Long.parseLong("5")));
            profitIncomeVO5.setNumber("\u5c0f\u8ba1");
            profitIncomeVO5.setRealProduct(realProduct5);
            profitIncomeVO5.setNotarizeProduct(notarizeProduct5);
            profitIncomeVO5.setUnliquidated(unliquidated5);
            profitIncomeVOS.add(profitIncomeVO5);
            profitIncomeVOS.addAll(this.formatList(profitIncomeVOList5));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList6)) {
            profitIncomeVO6.setId(Long.valueOf(Long.parseLong("6")));
            profitIncomeVO6.setNumber("\u5c0f\u8ba1");
            profitIncomeVO6.setRealProduct(realProduct6);
            profitIncomeVO6.setNotarizeProduct(notarizeProduct6);
            profitIncomeVO6.setUnliquidated(unliquidated6);
            profitIncomeVOS.add(profitIncomeVO6);
            profitIncomeVOS.addAll(this.formatList(profitIncomeVOList6));
        }
        for (ProfitIncomeVO profitIncomeVO : profitIncomeVOS) {
            if (profitIncomeVO.getProjectName().equals("\u901a\u5dde\u65b0\u57ceA")) {
                this.logger.info("-----------------------------------------\u901a\u5dde\u65b0\u57ceA :" + profitIncomeVO.getRealProduct());
                this.logger.info("-----------------------------------------\u901a\u5dde\u65b0\u57ceA :" + ComputeUtil.safeDiv((BigDecimal)profitIncomeVO.getRealProduct(), (BigDecimal)new BigDecimal(10000)));
            }
            profitIncomeVO.setRealProduct(ComputeUtil.safeDiv((BigDecimal)(profitIncomeVO.getRealProduct() == null ? BigDecimal.ZERO : profitIncomeVO.getRealProduct()), (BigDecimal)new BigDecimal(10000)));
            profitIncomeVO.setNotarizeProduct(ComputeUtil.safeDiv((BigDecimal)(profitIncomeVO.getNotarizeProduct() == null ? BigDecimal.ZERO : profitIncomeVO.getNotarizeProduct()), (BigDecimal)new BigDecimal(10000)));
            profitIncomeVO.setUnliquidated(ComputeUtil.safeDiv((BigDecimal)(profitIncomeVO.getUnliquidated() == null ? BigDecimal.ZERO : profitIncomeVO.getUnliquidated()), (BigDecimal)new BigDecimal(10000)));
        }
        boolean bl = false;
        while (var37_42 < profitIncomeVOS.size()) {
            if (!"\u5c0f\u8ba1".equals(((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getNumber()) && !"\u5408\u8ba1".equals(((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getNumber())) {
                if (((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getProjectStatus() == 1) {
                    ((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).setProjectStatusName("\u672a\u5f00\u5de5");
                }
                if (((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getProjectStatus() == 2) {
                    ((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).setProjectStatusName("\u5728\u5efa");
                }
                if (((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getProjectStatus() == 3) {
                    ((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).setProjectStatusName("\u505c\u7f13\u5efa");
                }
                if (((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getProjectStatus() == 4) {
                    ((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).setProjectStatusName("\u7ae3\u5de5\u672a\u7ed3\u7b97");
                }
                if (((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getProjectStatus() == 5) {
                    ((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).setProjectStatusName("\u7ae3\u5de5\u5df2\u7ed3\u7b97");
                }
                if (((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).getProjectStatus() == 6) {
                    ((ProfitIncomeVO)profitIncomeVOS.get((int)var37_42)).setProjectStatusName("\u5b8c\u5de5");
                }
            }
            ++var37_42;
        }
        if (profitIncomeVOS.size() == 1) {
            profitIncomeVOS = new ArrayList();
        }
        return profitIncomeVOS;
    }

    @Override
    public List<ProfitIncomeVO> queryListPage(Map<String, Object> paramMapper) {
        return this.mapper.queryList(paramMapper);
    }

    @Override
    public void deleteByReportingMonth(String reportingMonth) {
        this.mapper.deleteByReportingMonth(reportingMonth);
    }

    public static BigDecimal getBigDecimalSum(BigDecimal i, BigDecimal ... arg) {
        BigDecimal sum = i;
        for (BigDecimal b : arg) {
            sum = sum.add(b);
        }
        return sum;
    }

    public List<ProfitIncomeVO> formatList(List<ProfitIncomeVO> profitIncomeVOList) {
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            ArrayList<ProfitIncomeVO> profitIncomeVOList7 = new ArrayList<ProfitIncomeVO>();
            BigDecimal realProduct1 = new BigDecimal("0");
            BigDecimal notarizeProduct1 = new BigDecimal("0");
            BigDecimal unliquidated1 = new BigDecimal("0");
            ArrayList<ProfitIncomeVO> profitIncomeVOList1 = new ArrayList<ProfitIncomeVO>();
            ProfitIncomeVO profitIncomeVO1 = new ProfitIncomeVO();
            BigDecimal realProduct2 = new BigDecimal("0");
            BigDecimal notarizeProduct2 = new BigDecimal("0");
            BigDecimal unliquidated2 = new BigDecimal("0");
            ArrayList<ProfitIncomeVO> profitIncomeVOList2 = new ArrayList<ProfitIncomeVO>();
            ProfitIncomeVO profitIncomeVO2 = new ProfitIncomeVO();
            BigDecimal realProduct3 = new BigDecimal("0");
            BigDecimal notarizeProduct3 = new BigDecimal("0");
            BigDecimal unliquidated3 = new BigDecimal("0");
            ArrayList<ProfitIncomeVO> profitIncomeVOList3 = new ArrayList<ProfitIncomeVO>();
            ProfitIncomeVO profitIncomeVO3 = new ProfitIncomeVO();
            BigDecimal realProduct4 = new BigDecimal("0");
            BigDecimal notarizeProduct4 = new BigDecimal("0");
            BigDecimal unliquidated4 = new BigDecimal("0");
            ArrayList<ProfitIncomeVO> profitIncomeVOList4 = new ArrayList<ProfitIncomeVO>();
            ProfitIncomeVO profitIncomeVO4 = new ProfitIncomeVO();
            BigDecimal realProduct5 = new BigDecimal("0");
            BigDecimal notarizeProduct5 = new BigDecimal("0");
            BigDecimal unliquidated5 = new BigDecimal("0");
            ArrayList<ProfitIncomeVO> profitIncomeVOList5 = new ArrayList<ProfitIncomeVO>();
            ProfitIncomeVO profitIncomeVO5 = new ProfitIncomeVO();
            BigDecimal realProduct6 = new BigDecimal("0");
            BigDecimal notarizeProduct6 = new BigDecimal("0");
            BigDecimal unliquidated6 = new BigDecimal("0");
            ArrayList<ProfitIncomeVO> profitIncomeVOList6 = new ArrayList<ProfitIncomeVO>();
            ProfitIncomeVO profitIncomeVO6 = new ProfitIncomeVO();
            for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                if (null != profitIncomeVO.getTwoOrgName() && "\u4e2d\u5efa\u79d1\u6280\u96c6\u56e2\u6709\u9650\u516c\u53f8".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList1.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "\u4e2d\u5efa\u79d1\u6280\u96c6\u56e2\u534e\u5357\u6709\u9650\u516c\u53f8".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList2.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "\u4e2d\u5efa\u79d1\u6280\u96c6\u56e2\u534e\u4e1c\u6709\u9650\u516c\u53f8".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList3.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "\u4e2d\u5efa\u79d1\u6280\u96c6\u56e2\u534e\u5317\u6709\u9650\u516c\u53f8".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList4.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "\u4e2d\u5efa\u79d1\u6280\u96c6\u56e2\u897f\u90e8\u6709\u9650\u516c\u53f8".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList5.add(profitIncomeVO);
                }
                if (null != profitIncomeVO.getTwoOrgName() && "\u4e2d\u5efa\u96c6\u6210\u5efa\u7b51\u6709\u9650\u516c\u53f8".equals(profitIncomeVO.getTwoOrgName())) {
                    profitIncomeVOList6.add(profitIncomeVO);
                    continue;
                }
                profitIncomeVOList7.add(profitIncomeVO);
            }
            realProduct1 = profitIncomeVOList1.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            notarizeProduct1 = profitIncomeVOList1.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            unliquidated1 = profitIncomeVOList1.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
            realProduct2 = profitIncomeVOList2.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            notarizeProduct2 = profitIncomeVOList2.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            unliquidated2 = profitIncomeVOList2.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
            realProduct3 = profitIncomeVOList3.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            notarizeProduct3 = profitIncomeVOList3.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            unliquidated3 = profitIncomeVOList3.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
            realProduct4 = profitIncomeVOList4.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            notarizeProduct4 = profitIncomeVOList4.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            unliquidated4 = profitIncomeVOList4.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
            realProduct5 = profitIncomeVOList5.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            notarizeProduct5 = profitIncomeVOList5.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            unliquidated5 = profitIncomeVOList5.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
            realProduct6 = profitIncomeVOList6.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            notarizeProduct6 = profitIncomeVOList6.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
            unliquidated6 = profitIncomeVOList6.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
            ArrayList<ProfitIncomeVO> newList = new ArrayList<ProfitIncomeVO>();
            if (CollectionUtils.isNotEmpty(profitIncomeVOList1)) {
                profitIncomeVO1.setId(Long.valueOf(IdWorker.getId()));
                profitIncomeVO1.setNumber("\u5c0f\u8ba1");
                profitIncomeVO1.setRealProduct(realProduct1);
                profitIncomeVO1.setNotarizeProduct(notarizeProduct1);
                profitIncomeVO1.setUnliquidated(unliquidated1);
                newList.add(profitIncomeVO1);
                newList.addAll(profitIncomeVOList1);
            }
            if (CollectionUtils.isNotEmpty(profitIncomeVOList2)) {
                profitIncomeVO2.setId(Long.valueOf(IdWorker.getId()));
                profitIncomeVO2.setNumber("\u5c0f\u8ba1");
                profitIncomeVO2.setRealProduct(realProduct2);
                profitIncomeVO2.setNotarizeProduct(notarizeProduct2);
                profitIncomeVO2.setUnliquidated(unliquidated2);
                newList.add(profitIncomeVO2);
                newList.addAll(profitIncomeVOList2);
            }
            if (CollectionUtils.isNotEmpty(profitIncomeVOList3)) {
                profitIncomeVO3.setId(Long.valueOf(IdWorker.getId()));
                profitIncomeVO3.setNumber("\u5c0f\u8ba1");
                profitIncomeVO3.setRealProduct(realProduct3);
                profitIncomeVO3.setNotarizeProduct(notarizeProduct3);
                profitIncomeVO3.setUnliquidated(unliquidated3);
                newList.add(profitIncomeVO3);
                newList.addAll(profitIncomeVOList3);
            }
            if (CollectionUtils.isNotEmpty(profitIncomeVOList4)) {
                profitIncomeVO4.setId(Long.valueOf(IdWorker.getId()));
                profitIncomeVO4.setNumber("\u5c0f\u8ba1");
                profitIncomeVO4.setRealProduct(realProduct4);
                profitIncomeVO4.setNotarizeProduct(notarizeProduct4);
                profitIncomeVO4.setUnliquidated(unliquidated4);
                newList.add(profitIncomeVO4);
                newList.addAll(profitIncomeVOList4);
            }
            if (CollectionUtils.isNotEmpty(profitIncomeVOList5)) {
                profitIncomeVO5.setId(Long.valueOf(IdWorker.getId()));
                profitIncomeVO5.setNumber("\u5c0f\u8ba1");
                profitIncomeVO5.setRealProduct(realProduct5);
                profitIncomeVO5.setNotarizeProduct(notarizeProduct5);
                profitIncomeVO5.setUnliquidated(unliquidated5);
                newList.add(profitIncomeVO5);
                newList.addAll(profitIncomeVOList5);
            }
            if (CollectionUtils.isNotEmpty(profitIncomeVOList6)) {
                profitIncomeVO6.setId(Long.valueOf(IdWorker.getId()));
                profitIncomeVO6.setNumber("\u5c0f\u8ba1");
                profitIncomeVO6.setRealProduct(realProduct6);
                profitIncomeVO6.setNotarizeProduct(notarizeProduct6);
                profitIncomeVO6.setUnliquidated(unliquidated6);
                newList.add(profitIncomeVO6);
                newList.addAll(profitIncomeVOList6);
            }
            if (CollectionUtils.isNotEmpty(profitIncomeVOList7)) {
                newList.addAll(profitIncomeVOList7);
            }
            return newList;
        }
        return null;
    }
}

