package com.ejianc.business.analysis.controller;

import java.io.IOException;
import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

import com.ejianc.business.analysis.bean.ProDurationDelayEntity;
import com.ejianc.business.analysis.service.IProDurationDelayService;
import com.ejianc.business.analysis.vo.ProDurationDelayVO;

/**
 * 工期延误项目成本风险化解情况
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("proDurationDelay")
public class ProDurationDelayController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProDurationDelayService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProDurationDelayVO> saveOrUpdate(@RequestBody ProDurationDelayVO saveOrUpdateVO) {
        ProDurationDelayEntity entity = BeanMapper.map(saveOrUpdateVO, ProDurationDelayEntity.class);
        service.saveOrUpdate(entity, false);
        ProDurationDelayVO vo = BeanMapper.map(entity, ProDurationDelayVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProDurationDelayVO> queryDetail(Long id) {
        ProDurationDelayEntity entity = service.selectById(id);
        ProDurationDelayVO vo = BeanMapper.map(entity, ProDurationDelayVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProDurationDelayVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProDurationDelayVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProDurationDelayVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProDurationDelayVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 筛选栏：  项目,组织 */
        String reportingMonth = null;
        if(param.getParams().get("reportingMonth").getValue() != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
            param.getParams().remove("reportingMonth");
        }
        if(param.getParams().get("reportingMonth") != null){
            param.getParams().remove("reportingMonth");
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getParams().put("reporting_month", new Parameter(QueryParam.LE, reportingMonth));
        IPage<ProDurationDelayEntity> page = service.queryPage(param,false);
        IPage<ProDurationDelayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProDurationDelayVO.class));
        ProDurationDelayVO proDurationDelayVO = new ProDurationDelayVO();
        List<ProDurationDelayVO> list = new ArrayList<>();
        List<ProDurationDelayVO> list1 = new ArrayList<>();
        List<ProDurationDelayVO> list2 = new ArrayList<>();
        List<ProDurationDelayVO> list3 = new ArrayList<>();
        List<ProDurationDelayVO> list4 = new ArrayList<>();
        List<ProDurationDelayVO> list5 = new ArrayList<>();
        List<ProDurationDelayVO> list6 = new ArrayList<>();
        for (ProDurationDelayVO vo : pageData.getRecords()) {
            if (vo.getProjectStatus() == 1) { //未开工
                list1.add(vo);
            }else if (vo.getProjectStatus() == 2) { //在建
                list2.add(vo);
            }else if (vo.getProjectStatus() == 3) { //停缓建
                list3.add(vo);
            }else if (vo.getProjectStatus() == 4) { //竣工未结算
                list4.add(vo);
            }else if (vo.getProjectStatus() == 5) { //竣工已结算
                list5.add(vo);
            }else if (vo.getProjectStatus() == 6) { //完工
                list6.add(vo);
            }
        }
        pageData.setRecords(null);
        if (CollectionUtils.isNotEmpty(list1)) {
            list.addAll(calculation(list1));
        }
        if (CollectionUtils.isNotEmpty(list2)) {
            list.addAll(calculation(list2));
        }
        if (CollectionUtils.isNotEmpty(list3)) {
            list.addAll(calculation(list3));
        }
        if (CollectionUtils.isNotEmpty(list4)) {
            list.addAll(calculation(list4));
        }
        if (CollectionUtils.isNotEmpty(list5)) {
            list.addAll(calculation(list5));
        }
        if (CollectionUtils.isNotEmpty(list6)) {
            list.addAll(calculation(list6));
        }
        int i = 1;
        for (ProDurationDelayVO vo : list) {
            if (vo.getOrder() == null) {
                vo.setOrder(String.valueOf(i));
                i++;
            }
            if (!vo.getOrder().equals("小计")) {
                proDurationDelayVO.setOrder("合计");
                proDurationDelayVO.setDelayDaysTotal(ComputeUtil.safeAdd(proDurationDelayVO.getDelayDaysTotal(), vo.getDelayDaysTotal()));
                proDurationDelayVO.setDelayDaysCasej(ComputeUtil.safeAdd(proDurationDelayVO.getDelayDaysCasej(), vo.getDelayDaysCasej()));
                proDurationDelayVO.setDelayDaysCasey(ComputeUtil.safeAdd(proDurationDelayVO.getDelayDaysCasey(), vo.getDelayDaysCasey()));
                proDurationDelayVO.setDelayCostTotal(ComputeUtil.safeAdd(proDurationDelayVO.getDelayCostTotal(), vo.getDelayCostTotal()));
                proDurationDelayVO.setDelayCostCasej(ComputeUtil.safeAdd(proDurationDelayVO.getDelayCostCasej(), vo.getDelayCostCasej()));
                proDurationDelayVO.setDelayCostCasey(ComputeUtil.safeAdd(proDurationDelayVO.getDelayCostCasey(), vo.getDelayCostCasey()));
                proDurationDelayVO.setDelayClaimEstimate(ComputeUtil.safeAdd(proDurationDelayVO.getDelayClaimEstimate(), vo.getDelayClaimEstimate()));
                proDurationDelayVO.setDelayClaimBasis(ComputeUtil.safeAdd(proDurationDelayVO.getDelayClaimBasis(), vo.getDelayClaimBasis()));
                proDurationDelayVO.setCompensateDate(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateDate(), vo.getCompensateDate()));
                proDurationDelayVO.setCompensateCost(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateCost(), vo.getCompensateCost()));
                proDurationDelayVO.setCompensateConfirmDays(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateConfirmDays(), vo.getCompensateConfirmDays()));
                proDurationDelayVO.setCompensateConfirmCost(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateConfirmCost(), vo.getCompensateConfirmCost()));
                proDurationDelayVO.setProjectCompletionDays(ComputeUtil.safeAdd(proDurationDelayVO.getProjectCompletionDays(), vo.getProjectCompletionDays()));
                proDurationDelayVO.setProjectCompletionCost(ComputeUtil.safeAdd(proDurationDelayVO.getProjectCompletionCost(), vo.getProjectCompletionCost()));
            }
        }
        list.add(proDurationDelayVO);
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryDetail 计算数值
     * @param list
     */
    @RequestMapping(value = "/calculation", method = RequestMethod.GET)
    @ResponseBody
    public List<ProDurationDelayVO> calculation(List<ProDurationDelayVO> list){
        ProDurationDelayVO proDurationDelayVO = new ProDurationDelayVO();
        List<ProDurationDelayVO> proDurationDelayVOS = new ArrayList<>();
        for (int i = 0;i<list.size();i++) {
            proDurationDelayVOS.add(list.get(i));
            proDurationDelayVO.setDelayDaysTotal(ComputeUtil.safeAdd(proDurationDelayVO.getDelayDaysTotal(), list.get(i).getDelayDaysTotal()));
            proDurationDelayVO.setDelayDaysCasej(ComputeUtil.safeAdd(proDurationDelayVO.getDelayDaysCasej(), list.get(i).getDelayDaysCasej()));
            proDurationDelayVO.setDelayDaysCasey(ComputeUtil.safeAdd(proDurationDelayVO.getDelayDaysCasey(), list.get(i).getDelayDaysCasey()));
            proDurationDelayVO.setDelayCostTotal(ComputeUtil.safeAdd(proDurationDelayVO.getDelayCostTotal(), list.get(i).getDelayCostTotal()));
            proDurationDelayVO.setDelayCostCasej(ComputeUtil.safeAdd(proDurationDelayVO.getDelayCostCasej(), list.get(i).getDelayCostCasej()));
            proDurationDelayVO.setDelayCostCasey(ComputeUtil.safeAdd(proDurationDelayVO.getDelayCostCasey(), list.get(i).getDelayCostCasey()));
            proDurationDelayVO.setDelayClaimEstimate(ComputeUtil.safeAdd(proDurationDelayVO.getDelayClaimEstimate(), list.get(i).getDelayClaimEstimate()));
            proDurationDelayVO.setDelayClaimBasis(ComputeUtil.safeAdd(proDurationDelayVO.getDelayClaimBasis(), list.get(i).getDelayClaimBasis()));
            proDurationDelayVO.setCompensateDate(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateDate(), list.get(i).getCompensateDate()));
            proDurationDelayVO.setCompensateCost(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateCost(), list.get(i).getCompensateCost()));
            proDurationDelayVO.setCompensateConfirmDays(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateConfirmDays(), list.get(i).getCompensateConfirmDays()));
            proDurationDelayVO.setCompensateConfirmCost(ComputeUtil.safeAdd(proDurationDelayVO.getCompensateConfirmCost(), list.get(i).getCompensateConfirmCost()));
            proDurationDelayVO.setProjectCompletionDays(ComputeUtil.safeAdd(proDurationDelayVO.getProjectCompletionDays(), list.get(i).getProjectCompletionDays()));
            proDurationDelayVO.setProjectCompletionCost(ComputeUtil.safeAdd(proDurationDelayVO.getProjectCompletionCost(), list.get(i).getProjectCompletionCost()));
            if (i == list.size() - 1) {
                proDurationDelayVO.setOrder("小计");
                proDurationDelayVO.setId(IdWorker.getId());
                proDurationDelayVOS.add(proDurationDelayVO);
            }
        }
        return proDurationDelayVOS;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        String reportingMonth = null;
        if(param.getParams().get("reportingMonth").getValue() != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
            param.getParams().remove("reportingMonth");
        }
        if(param.getParams().get("reportingMonth") != null){
            param.getParams().remove("reportingMonth");
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProDurationDelayVO> vos = queryList(param).getData().getRecords();
        for (ProDurationDelayVO vo : vos) {
            if (vo.getProjectStatus() != null) {
                if (vo.getProjectStatus() == 1) {
                    vo.setProjectStatusName("未开工");
                } else if (vo.getProjectStatus() == 2) {
                    vo.setProjectStatusName("在建");
                } else if (vo.getProjectStatus() == 3) {
                    vo.setProjectStatusName("停缓建");
                } else if (vo.getProjectStatus() == 4) {
                    vo.setProjectStatusName("竣工未结算");
                } else if (vo.getProjectStatus() == 5) {
                    vo.setProjectStatusName("竣工已结算");
                } else if (vo.getProjectStatus() == 6) {
                    vo.setProjectStatusName("完工");
                }
            }
            if (vo.getCompensateConfirm() != null) {
                if (vo.getCompensateConfirm() == 1) {
                    vo.setCompensateConfirmName("是");
                } else if (vo.getCompensateConfirm() == 2) {
                    vo.setCompensateConfirmName("否");
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);

        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;

        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            beans.put("dateFormat", dateFormat);
            beans.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource("excel/ProDurationDelay-export.xlsx" );
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), beans);
            Sheet sheet = workbook.getSheetAt(0);
            sheet.getRow(0).getCell(0).setCellValue("截至"+ getdate(reportingMonth)+"工期延误项目成本风险化解情况");
            workbook.write(outputStream);
        } catch (Exception var18) {
            var18.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                } catch (IOException var17) {
                    var17.printStackTrace();
                }
            }
        }
    }
    public static String getdate(String date) {
        String[] datel = date.split(" ");
        String[] date2 = datel[0].split("-");
        String date4 = date2[0] + "年" + date2[1] + "月";
        return date4;
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProDurationDelayData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProDurationDelayVO>> refProDurationDelayData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProDurationDelayEntity> page = service.queryPage(param,false);
        IPage<ProDurationDelayVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProDurationDelayVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     *  定时任务生成单据
     * @return
     */
    @RequestMapping(value = "/execute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        //定时任务设置天数，执行当前天数到上月当前天数
        String day = request.getParameter("day");
        //此日期方便手动调用接口数据
        String date = request.getParameter("date");
        service.execute(day,date);
        return CommonResponse.success("工期延误项目成本风险化解情况数据生成成功！");
    }

    /**
     *  定时任务生成单据
     * @return
     */
    @RequestMapping(value = "/executeTest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> executeTest(String day, String date) {
        //定时任务设置天数，执行当前天数到上月当前天数
        //String day = request.getParameter("day");
        ////此日期方便手动调用接口数据
        //String date = request.getParameter("date");
        service.execute(day,date);
        return CommonResponse.success("工期延误项目成本风险化解情况数据生成成功！");
    }
}
