package com.ejianc.business.analysis.controller;

import java.io.Serializable;

import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.RequestVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.analysis.bean.ProjectIndexEntity;
import com.ejianc.business.analysis.service.IProjectIndexService;
import com.ejianc.business.analysis.vo.ProjectIndexVO;

/**
 * 项目工程造价指标分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectIndex")
public class ProjectIndexController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProjectIndexService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectIndexVO> saveOrUpdate(@RequestBody ProjectIndexVO saveOrUpdateVO) {
    	ProjectIndexEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectIndexEntity.class);
    	service.saveOrUpdate(entity, false);
    	ProjectIndexVO vo = BeanMapper.map(entity, ProjectIndexVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectIndexVO> queryDetail(Long id) {
    	ProjectIndexEntity entity = service.selectById(id);
    	ProjectIndexVO vo = BeanMapper.map(entity, ProjectIndexVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectIndexVO> vos) {
        service.removeByIds(vos.stream().map(ProjectIndexVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectIndexVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("buildingFunction");
        fuzzyFields.add("buildPlace");
        fuzzyFields.add("structMethod");
        fuzzyFields.add("earthquakeFortification");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取本下组织信息失败！");
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProjectIndexEntity> page = service.queryPage(param,false);
        IPage<ProjectIndexVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectIndexVO> projectIndexVOS = BeanMapper.mapList(page.getRecords(), ProjectIndexVO.class);
        List<ProjectIndexVO> feeNewList = service.dealData(projectIndexVOS);
        pageData.setRecords(feeNewList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("projectName");
        fuzzyFields.add("buildingFunction");
        fuzzyFields.add("buildPlace");
        fuzzyFields.add("structMethod");
        fuzzyFields.add("earthquakeFortification");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        String reportingMonth = null;
        if(param.getParams().get("reportingMonth") != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectIndexEntity> list = service.queryList(param);
        List<ProjectIndexVO> feeNewList = service.dealData(BeanMapper.mapList(list, ProjectIndexVO.class));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", feeNewList);
        CommonUtils.setExcelName(response, reportingMonth,"项目工程造价指标分析","excel/ProjectIndex-export.xlsx", beans);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectIndexData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectIndexVO>> refProjectIndexData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }


        IPage<ProjectIndexEntity> page = service.queryPage(param,false);
        IPage<ProjectIndexVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectIndexVO> projectIndexVOS = BeanMapper.mapList(page.getRecords(), ProjectIndexVO.class);
        List<ProjectIndexVO> feeNewList = service.dealData(projectIndexVOS);
        pageData.setRecords(feeNewList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     *
     * @return
     */
    @RequestMapping(value = "/execute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        //定时任务设置天数，执行当前天数到上月当前天数
        String day = request.getParameter("day");
        service.execute(null,day,null);
        return CommonResponse.success("项目工程造价指标分析数据生成成功！");
    }


    /**
     *预生成本期数据
     * flag:1代表预生成按钮
     * @return
     */
    @RequestMapping(value = "/executeInAdvance", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> executeInAdvance(@RequestBody RequestVO requestVO) {
        service.execute(requestVO.getInAdvanceFlag(),requestVO.getDay(),requestVO.getProjectIdList());
        return CommonResponse.success("项目工程造价指标分析数据生成成功！");
    }
}
