package com.ejianc.business.analysis.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.analysis.bean.CompleteSettlementEntity;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.bean.ProjectPaymentEntity;
import com.ejianc.business.analysis.service.IProjectPaymentService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.CompleteSettlementVO;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.business.analysis.vo.RequestVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 工程确权收付款情况
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectPayment")
public class ProjectPaymentController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectPaymentService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectPaymentVO> saveOrUpdate(@RequestBody ProjectPaymentVO saveOrUpdateVO) {
    	ProjectPaymentEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectPaymentEntity.class);
    	service.saveOrUpdate(entity, false);
    	ProjectPaymentVO vo = BeanMapper.map(entity, ProjectPaymentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPaymentVO> queryDetail(Long id) {
    	ProjectPaymentEntity entity = service.selectById(id);
    	ProjectPaymentVO vo = BeanMapper.map(entity, ProjectPaymentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPaymentVO> vos) {
        service.removeByIds(vos.stream().map(ProjectPaymentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectPaymentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ProjectPaymentEntity> page = service.queryPage(param,false);
        IPage<ProjectPaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectPaymentVO> projectPaymentVOList = BeanMapper.mapList(page.getRecords(), ProjectPaymentVO.class);
        List<ProjectPaymentVO> feeNewList = service.dealData(projectPaymentVOList);
        pageData.setRecords(feeNewList);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        String reportingMonth = null;
        if(param.getParams().get("reportingMonth") != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
        }
        List<ProjectPaymentEntity> list = service.queryList(param);
        List<ProjectPaymentVO> feeNewList = service.dealData(BeanMapper.mapList(list, ProjectPaymentVO.class));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", feeNewList);
        CommonUtils.setExcelName(response, reportingMonth,"工程确权收付款情况","excel/ProjectPayment.xlsx", beans);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectPaymentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPaymentVO>> refProjectPaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectPaymentEntity> page = service.queryPage(param,false);
        IPage<ProjectPaymentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPaymentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     *预生成本期数据
     * flag:1代表预生成按钮
     * @return
     */
    @RequestMapping(value = "/preExecute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> preExecute(@RequestBody RequestVO requestVO) {
        service.execute(requestVO.getInAdvanceFlag(),requestVO.getDay(),requestVO.getProjectIdList());
        return CommonResponse.success("工程确权收付款情况数据生成成功！");
    }

    @RequestMapping(value = "/execute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        //定时任务设置天数，执行当前天数到上月当前天数
        String day = request.getParameter("day");
        service.execute(null,day,null);
        return CommonResponse.success("工程确权收付款情况数据生成成功！");
    }
}
