package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructProBusinessVO;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ConstructProBusinessMapper;
import com.ejianc.business.analysis.bean.ConstructProBusinessEntity;
import com.ejianc.business.analysis.service.IConstructProBusinessService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 在建项目商务报表
 *
 * @author generator
 *
 */
@Service("constructProBusinessService")
public class ConstructProBusinessServiceImpl extends BaseServiceImpl<ConstructProBusinessMapper, ConstructProBusinessEntity> implements IConstructProBusinessService{

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConstructProBusinessService constructProBusinessService;
    @Autowired
    private ConstructProBusinessMapper constructProBusinessMapper;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ConstructProBusinessEntity> lambdaFee = Wrappers.<ConstructProBusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ConstructProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructProBusinessEntity::getReportingMonth, reportingMonth);

        constructProBusinessService.remove(lambdaFee);

        //查询项目信息数据
        List<ConstructProBusinessVO> constructProBusinessVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            constructProBusinessVOList = constructProBusinessMapper.queryProjectIds(projectIdList);
        }else{
            //等于1代表预生成数据
            constructProBusinessVOList = constructProBusinessMapper.queryProjectIds(null);
        }

        List<Long> projectIds = constructProBusinessVOList.stream().map(ConstructProBusinessVO::getProjectId).collect(Collectors.toList());
        // 查询施工类合同
        List<ConstructProBusinessVO> contractVOS = constructProBusinessMapper.queryContract(projectIds);
        Map<Long, ConstructProBusinessVO> contractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目目标管理责任书
        List<ConstructProBusinessVO> bookVOS = constructProBusinessMapper.queryBook(projectIds);
        Map<Long, ConstructProBusinessVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目商务策划会签
        List<ConstructProBusinessVO> countersignatureVOS = constructProBusinessMapper.queryCountersignature(projectIds);
        Map<Long, ConstructProBusinessVO> countersignatureMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(countersignatureVOS)) {
            countersignatureMap = countersignatureVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目商务策划效果
        List<ConstructProBusinessVO> businessplanningeffectVOS = constructProBusinessMapper.queryBusinessplanningeffect(projectIds);
        Map<Long, ConstructProBusinessVO> businessplanningeffectMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(businessplanningeffectVOS)) {
            businessplanningeffectMap = businessplanningeffectVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目月度成本分析报告
        List<ConstructProBusinessVO> costanalysisVOS = constructProBusinessMapper.queryCostanalysis(projectIds,reportingMonth);
        Map<Long, ConstructProBusinessVO> costanalysisMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            for (ConstructProBusinessVO costanalysisVO : costanalysisVOS) {
                if (!costanalysisMap.containsKey(costanalysisVO.getProjectId())) {
                    costanalysisMap.put(costanalysisVO.getProjectId(), costanalysisVO);
                }else {
                    if (costanalysisMap.get(costanalysisVO.getProjectId()).getContractIncome()==null && costanalysisVO.getContractIncome() != null) {
                        costanalysisMap.get(costanalysisVO.getProjectId()).setContractIncome(costanalysisVO.getContractIncome());
                    }
                    if (costanalysisMap.get(costanalysisVO.getProjectId()).getRealCost()==null && costanalysisVO.getRealCost() != null) {
                        costanalysisMap.get(costanalysisVO.getProjectId()).setRealCost(costanalysisVO.getRealCost());
                    }
                }
            }
        }
        // 查询工程计量台账
        List<ConstructProBusinessVO> engineermeasurementVOS = constructProBusinessMapper.queryEngineermeasurement(projectIds,reportingMonth);
        Map<Long, BigDecimal> LJMap = new HashMap<>();// 营业收入取自工程计量台账-财务列表收入往期累计值
        Map<Long, ConstructProBusinessVO> engineermeasurementMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(engineermeasurementVOS)){
            LJMap = engineermeasurementVOS.stream().collect(Collectors.groupingBy(ConstructProBusinessVO::getProjectId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getOperatingRevenue()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            for (ConstructProBusinessVO engineermeasurementVO : engineermeasurementVOS) {
                if (!engineermeasurementMap.containsKey(engineermeasurementVO.getProjectId())) {
                    engineermeasurementMap.put(engineermeasurementVO.getProjectId(), new ConstructProBusinessVO());
                }else {
                    if (engineermeasurementMap.get(engineermeasurementVO.getProjectId()).getOwnerCrValue()==null && engineermeasurementVO.getOwnerCrValue() != null) {
                        engineermeasurementMap.get(engineermeasurementVO.getProjectId()).setOwnerCrValue(engineermeasurementVO.getOwnerCrValue());
                        engineermeasurementMap.get(engineermeasurementVO.getProjectId()).setOwnerCrAcValue(engineermeasurementVO.getOwnerCrValue());
                    }
                    if (engineermeasurementMap.get(engineermeasurementVO.getProjectId()).getContractReceivableMny()==null && engineermeasurementVO.getContractReceivableMny() != null) {
                        engineermeasurementMap.get(engineermeasurementVO.getProjectId()).setContractReceivableMny(engineermeasurementVO.getContractReceivableMny());
                    }
                    if (engineermeasurementMap.get(engineermeasurementVO.getProjectId()).getRealRecrived() == null && engineermeasurementVO.getRealRecrived() != null) {
                        engineermeasurementMap.get(engineermeasurementVO.getProjectId()).setRealRecrived(engineermeasurementVO.getRealRecrived());
                    }
                }
            }
        }
        for (ConstructProBusinessVO vo : constructProBusinessVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                vo.setPromoter(contractMap.get(projectId).getPromoter());
                vo.setPromoterName(contractMap.get(projectId).getPromoterName());
                vo.setProjectLocation(contractMap.get(projectId).getProjectLocation());
                vo.setContractSignTime(contractMap.get(projectId).getContractSignTime());
                vo.setContractStartDate(contractMap.get(projectId).getContractStartDate());
                vo.setContractEndDate(contractMap.get(projectId).getContractEndDate());
                vo.setContractAmount(contractMap.get(projectId).getContractAmount());
                vo.setAcContractAmount(CommonUtils.parseYuanToWanZ(contractMap.get(projectId).getAcContractAmount()));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setUndertakeRate(bookMap.get(projectId).getUndertakeRate());
                vo.setTargetRate(bookMap.get(projectId).getTargetRate());
                vo.setSignDate(bookMap.get(projectId).getSignDate());
            }
            if (!countersignatureMap.isEmpty() && countersignatureMap.containsKey(projectId)) {
                vo.setBusinessPlanApprovalDate(countersignatureMap.get(projectId).getBusinessPlanApprovalDate());
            }
            if (!businessplanningeffectMap.isEmpty() && businessplanningeffectMap.containsKey(projectId)) {
                vo.setPlanExpectedRevenueGenerationAmount(businessplanningeffectMap.get(projectId).getPlanExpectedRevenueGenerationAmount());
                vo.setPlanRevenueGenerationAmount(businessplanningeffectMap.get(projectId).getPlanRevenueGenerationAmount());
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                vo.setContractIncome(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getContractIncome()));
                vo.setAcContractIncome(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getContractIncome()));
                vo.setRealCost(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getRealCost()));
                vo.setAcRealCost(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getRealCost()));
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                vo.setOwnerCrValue(CommonUtils.parseNullValue(engineermeasurementMap.get(projectId).getOwnerCrValue()));
                vo.setOwnerCrAcValue(CommonUtils.parseNullValue(engineermeasurementMap.get(projectId).getOwnerCrAcValue()));
                vo.setContractReceivableMny(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getContractReceivableMny()));
                vo.setOperatingRevenue(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getOperatingRevenue()));
                vo.setRealRecrived(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getRealRecrived()));
                vo.setSettlementFlag(1);// 是否办理其中结算  否:0  是:1
            } else {
                vo.setSettlementFlag(0);// 是否办理其中结算  否:0  是:1
            }
            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setThreeOrgId(orgVos.getData().getId());
                    vo.setThreeOrgName(orgVos.getData().getName());
                }
            }
            vo.setPergaContractAmountProportion(CommonUtils.calculateRate(vo.getPlanExpectedRevenueGenerationAmount(), vo.getAcContractAmount()));//策划预计创效金额占自施合同额比
            vo.setPrgaContractIncomeProportion(CommonUtils.calculateRate(vo.getPlanRevenueGenerationAmount(), vo.getAcContractIncome()));//策划创效金额占自施产值比
            vo.setProfit(CommonUtils.calculateRate(vo.getContractIncome(), vo.getRealCost()));//利润
            vo.setProfitRate(CommonUtils.calculateRate(vo.getProfit(), vo.getContractIncome()));//利润率(%)
            vo.setAcProfitRate(CommonUtils.calculateRate(vo.getProfit(), vo.getAcContractIncome()));//自施利润率(%)
            vo.setValueCrRate(CommonUtils.calculateRate(vo.getOwnerCrValue(),vo.getContractIncome()));//产值确权率(%)
            vo.setAcValueCrRate(CommonUtils.calculateRate(vo.getOwnerCrAcValue(), vo.getAcContractIncome()));//自施产值确权率(%)
            vo.setOperatingRevenue(LJMap.get(projectId));// 营业收入
            vo.setRevenueCrRate(CommonUtils.calculateRate(vo.getOwnerCrValue(), vo.getOperatingRevenue()));//营收确权率(%)
            if (vo.getFourOrgId() != null) {
                CommonResponse<OrgVO> fourOrgVO = orgApi.detailById(vo.getFourOrgId());
                if (fourOrgVO.isSuccess() && null != fourOrgVO.getData()) {
                    vo.setFourOrgName(fourOrgVO.getData().getName());// 股份公司四级单位
                }
            }
            if (vo.getContractorName() == null) {
                CommonResponse<OrgVO> orgVO = orgApi.detailById(vo.getContractor());
                if (orgVO.isSuccess() && null != orgVO.getData()) {
                    vo.setContractorName(orgVO.getData().getName());// 承包人名称
                }
            }
        }
        List<ConstructProBusinessEntity> constructProBusinessEntityList = BeanMapper.mapList(constructProBusinessVOList, ConstructProBusinessEntity.class);
        constructProBusinessService.saveBatch(constructProBusinessEntityList);
    }

    @Override
    public List<ConstructProBusinessVO> dealData(List<ConstructProBusinessVO> constructProBusinessVOS) {
        //处理第一行合计值
        ConstructProBusinessVO constructProBusinessVO = new ConstructProBusinessVO();
        ArrayList<ConstructProBusinessVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(constructProBusinessVOS)) {
            getSumDate(constructProBusinessVOS, constructProBusinessVO);
            constructProBusinessVO.setNumber("合计");
            constructProBusinessVO.setId(IdWorker.getId());
            newList.add(constructProBusinessVO);
        }
        Integer number = 1;
        for (ConstructProBusinessVO vo : constructProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            number++;
            vo.setProjectStatusName(CommonUtils.getProjectStatusName(vo.getProjectStatus()));
            switch (vo.getSettlementFlag()) {
                case 0:vo.setSettlementFlagName("否");break;
                case 1:vo.setSettlementFlagName("是");break;
            }
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337":vo.setProjectCategoryName("工业厂房");break;
                case "1470216222511185922":vo.setProjectCategoryName("公共建筑");break;
                case "1470216274176622593":vo.setProjectCategoryName("民用住宅");break;
                case "1470216311648534530":vo.setProjectCategoryName("基础设施");break;
                case "1470216348239642626":vo.setProjectCategoryName("其它");break;
            }
        }

        newList.addAll(constructProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<ConstructProBusinessVO> constructProBusinessVOS, ConstructProBusinessVO constructProBusinessVO) {
        constructProBusinessVO.setContractAmount(constructProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(ConstructProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractAmount(constructProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ConstructProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanExpectedRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanExpectedRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractIncome(constructProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(ConstructProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractIncome(constructProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(ConstructProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealCost(constructProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(ConstructProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcRealCost(constructProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(ConstructProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setProfit(constructProBusinessVOS.stream().filter(s -> s.getProfit() != null).map(ConstructProBusinessVO::getProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(ConstructProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrAcValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(ConstructProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractReceivableMny(constructProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(ConstructProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOperatingRevenue(constructProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(ConstructProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealRecrived(constructProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(ConstructProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add));
    }
}
