package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.FeeMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IFeeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.CostVO;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.RiskVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.CostMapper;
import com.ejianc.business.analysis.bean.CostEntity;
import com.ejianc.business.analysis.service.ICostService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 薪酬及三公费用占现场经费比例分析
 * 
 * @author generator
 * 
 */
@Service("costService")
public class CostServiceImpl extends BaseServiceImpl<CostMapper, CostEntity> implements ICostService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private CostMapper costMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostService costService;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
//        String reportingMonth = "2023-06";

        //先删后增
        LambdaQueryWrapper<CostEntity> lambdaFee = Wrappers.<CostEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(CostEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(CostEntity::getReportingMonth, reportingMonth);
        costService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }

        //获取业务数据
        List<CostVO> costVOList = costMapper.getData(reportingMonth, projectIdList);
        Map<Long, List<CostVO>> mapLj = new HashMap<>();
        Map<String, List<CostVO>> mapProAndPeriod = new HashMap<>();

        if (CollectionUtils.isNotEmpty(costVOList)){
            mapLj = costVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
            mapProAndPeriod = costVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId() + "-" +s.getReportingMonth()
                    ));
        }

        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<CostVO> feeVOList = BeanMapper.mapList(profitIncomeVOList, CostVO.class);
            for (CostVO feeVO : feeVOList){
                feeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                feeVO.setCreateTime(new Date());
                //设置本年值
                if (mapLj.containsKey(feeVO.getProjectId())){
                    List<CostVO> feeVOS = mapLj.get(feeVO.getProjectId());
                    List<CostVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(CostVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    CostVO periodVO = collectCompare.stream().findFirst().get();
                    String key = feeVO.getProjectId() +"-" + periodVO.getReportingMonth();
                    if (mapProAndPeriod.containsKey(key)){
                        List<CostVO> listLast = mapProAndPeriod.get(key);
                        //行转列取值
                        Map<String, List<CostVO>> costMap = listLast.stream().collect(
                                Collectors.groupingBy(
                                        s -> s.getCode()
                                ));

                        feeVO.setXcMny(CommonUtils.parseNullValue(costMap.get("一").stream().findFirst().get().getCostMny()));
                        feeVO.setBgMny(CommonUtils.parseNullValue(costMap.get("二").stream().findFirst().get().getCostMny()));
                        feeVO.setClMny(CommonUtils.parseNullValue(costMap.get("三").stream().findFirst().get().getCostMny()));
                        feeVO.setZdMny(CommonUtils.parseNullValue(costMap.get("四").stream().findFirst().get().getCostMny()));
                        feeVO.setQtMny(CommonUtils.parseNullValue(costMap.get("五").stream().findFirst().get().getCostMny()));
                        feeVO.setMny(listLast.stream().findFirst().get().getMny());
                    }else {
                        feeVO.setXcMny(BigDecimal.ZERO);
                        feeVO.setBgMny(BigDecimal.ZERO);
                        feeVO.setClMny(BigDecimal.ZERO);
                        feeVO.setZdMny(BigDecimal.ZERO);
                        feeVO.setQtMny(BigDecimal.ZERO);
                        feeVO.setMny(BigDecimal.ZERO);
                    }
                }else{
                    feeVO.setXcMny(BigDecimal.ZERO);
                    feeVO.setBgMny(BigDecimal.ZERO);
                    feeVO.setClMny(BigDecimal.ZERO);
                    feeVO.setZdMny(BigDecimal.ZERO);
                    feeVO.setQtMny(BigDecimal.ZERO);
                    feeVO.setMny(BigDecimal.ZERO);
                }

                //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(feeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        feeVO.setTwoOrgId(orgVos.getData().getId());
                        feeVO.setTwoOrgName(orgVos.getData().getName());
                        feeVO.setTwoOrgCode(orgVos.getData().getCode());
                        feeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }

            List<CostEntity> feeEntityList = BeanMapper.mapList(feeVOList, CostEntity.class);
            costService.saveBatch(feeEntityList);
        }


    }

    @Override
    public List<CostVO> dealData(List<CostVO> feeVOS) {
        //处理第一行合计值
        CostVO costVO = new CostVO();
        List<CostVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, costVO);
            costVO.setNumber("合计");
            costVO.setId(IdWorker.getId());
            feeNewList.add(costVO);
        }
        //计算排序字段
        for(CostVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
//            feeVOrder.setOrgStatusOrder(CommonUtils.getOrgOrderNum(feeVOrder.getTwoOrgName()));
        }

        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(CostVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<CostVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            CostVO projectStatusSumfeeVO = new CostVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(CostVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<CostVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                CostVO orgStatusSumfeeVO = new CostVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(CostVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (CostVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    //转万元赋值
                    feeVONum.setXcMny(CommonUtils.parseYuanToWan(feeVONum.getXcMny()));
                    feeVONum.setBgMny(CommonUtils.parseYuanToWan(feeVONum.getBgMny()));
                    feeVONum.setClMny(CommonUtils.parseYuanToWan(feeVONum.getClMny()));
                    feeVONum.setZdMny(CommonUtils.parseYuanToWan(feeVONum.getZdMny()));
                    feeVONum.setQtMny(CommonUtils.parseYuanToWan(feeVONum.getQtMny()));
                    feeVONum.setMny(CommonUtils.parseYuanToWan(feeVONum.getMny()));

                    //计算占比
                    feeVONum.setXcRate(CommonUtils.calculateRate(feeVONum.getXcMny(),feeVONum.getMny()));
                    feeVONum.setBgRate(CommonUtils.calculateRate(feeVONum.getBgMny(),feeVONum.getMny()));
                    feeVONum.setClRate(CommonUtils.calculateRate(feeVONum.getClMny(),feeVONum.getMny()));
                    feeVONum.setZdRate(CommonUtils.calculateRate(feeVONum.getZdMny(),feeVONum.getMny()));
                    feeVONum.setQtRate(CommonUtils.calculateRate(feeVONum.getQtMny(),feeVONum.getMny()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });

        return feeNewList;
    }

    private void getSumData(List<CostVO> feeVOS, CostVO feeVO) {
        BigDecimal xcMny = feeVOS.stream().map(CostVO::getXcMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal bgMny = feeVOS.stream().map(CostVO::getBgMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal clMny = feeVOS.stream().map(CostVO::getClMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal zdMny = feeVOS.stream().map(CostVO::getZdMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal qtMny = feeVOS.stream().map(CostVO::getQtMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal mny = feeVOS.stream().map(CostVO::getMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //转万元赋值
        feeVO.setXcMny(CommonUtils.parseYuanToWan(xcMny));
        feeVO.setBgMny(CommonUtils.parseYuanToWan(bgMny));
        feeVO.setClMny(CommonUtils.parseYuanToWan(clMny));
        feeVO.setZdMny(CommonUtils.parseYuanToWan(zdMny));
        feeVO.setQtMny(CommonUtils.parseYuanToWan(qtMny));
        feeVO.setMny(CommonUtils.parseYuanToWan(mny));

        //计算占比
        feeVO.setXcRate(CommonUtils.calculateRate(feeVO.getXcMny(),feeVO.getMny()));
        feeVO.setBgRate(CommonUtils.calculateRate(feeVO.getBgMny(),feeVO.getMny()));
        feeVO.setClRate(CommonUtils.calculateRate(feeVO.getClMny(),feeVO.getMny()));
        feeVO.setZdRate(CommonUtils.calculateRate(feeVO.getZdMny(),feeVO.getMny()));
        feeVO.setQtRate(CommonUtils.calculateRate(feeVO.getQtMny(),feeVO.getMny()));

    }
}
