package com.ejianc.business.analysis.service.impl;

import com.ejianc.business.analysis.vo.ProSignReserveVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.service.IProSignReserveService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 项目责任书签订及风险金预留情况
 *
 * @author generator
 *
 */
@Service("proSignReserveService")
public class ProSignReserveServiceImpl extends BaseServiceImpl<ProSignReserveMapper, ProSignReserveEntity> implements IProSignReserveService{

    @Override
    public void execute(String day, String date) {
        //结束日期:执行日期减一天
        String endDate = null;
        //如果配置了手动生成日期，则不执行用户设置日期
        if(StringUtils.isNotEmpty(date)){
            Date executeDate = null;
            try {
                //方便手动调用接口日期
                executeDate = DateUtils.parseDate(date,"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //结束日期:执行日期减一个月
            endDate = DateFormatUtils.format(DateUtils.addMonths(executeDate, -1), "yyyy-MM-dd");
        }else{
            //如果当前日期不等于设置天数，不执行
            if (!day.equals(DateFormatUtils.format(new Date(), "d"))) {
                throw new BusinessException("当前日期，不匹配设置日期");
            }else{
                //结束日期:执行日期减一个月之前得所有数据
                endDate = DateFormatUtils.format(DateUtils.addMonths(new Date(), -1), "yyyy-MM-dd");
            }
        }
        // 根据结束日期生成单据
        List<ProSignReserveVO> vos = new ArrayList<>();
        List<ProSignReserveVO> projectIdsList = queryProjectIds(endDate);
        for (ProSignReserveVO vo : projectIdsList) {
            //查询施工类合同
            List<ProSignReserveVO> proSignReserveIncontractVOS = queryIncontract(vo.getProjectId(),endDate);
            List<Date> incontractDateList = new ArrayList<>();
            for (ProSignReserveVO proSignReserveVO : proSignReserveIncontractVOS) {
                incontractDateList.add(proSignReserveVO.getCreateTime());
            }
            Date incontractDate = Collections.min(incontractDateList);
            ProSignReserveVO proSignReserveIncontractVO = null;
            for (ProSignReserveVO proSignReserveVO : proSignReserveIncontractVOS) {
                if (incontractDate == proSignReserveVO.getCreateTime()) {
                    vo.setContractSignTime(proSignReserveVO.getCreateTime()); // 合同签订时间
                }
                vo.setContractAmount(ComputeUtil.safeAdd(vo.getContractAmount(),proSignReserveVO.getContractAmount())); // 合同额(万元)
                vo.setAcContractAmount(ComputeUtil.safeAdd(vo.getAcContractAmount(),proSignReserveVO.getAcContractAmount())); // 自施合同额(万元)
            }
            // 查询项目目标管理责任书
            List<ProSignReserveVO> proSignReserveBookVOS = queryBook(vo.getProjectId());
            List<Date> booksDateList = new ArrayList<>();
            for (ProSignReserveVO proSignReserveVO : proSignReserveBookVOS) {
                booksDateList.add(proSignReserveVO.getCreateTime());
            }
            Date booksDate = Collections.max(booksDateList);
            ProSignReserveVO proSignReserveBookVO = new ProSignReserveVO();
            for (ProSignReserveVO proSignReserveVO : proSignReserveBookVOS) {
                if (booksDate == proSignReserveVO.getCreateTime()) {
                    vo.setResponsibilityCost(proSignReserveVO.getResponsibilityCost());// 责任成本(万元)
                    vo.setUndertakingBenefits(proSignReserveVO.getUndertakingBenefits());// 承接效益
                    vo.setUndertakingBenefitsRate(proSignReserveVO.getUndertakingBenefitsRate());// 承接效益率
                    vo.setOverallProfitMargin(proSignReserveVO.getOverallProfitMargin());// 整体上缴利润率
                }
            }
            // 查询项目目标管理责任书
            List<ProSignReserveVO> proSignReserveAllocateVOS = queryAllocate(vo.getProjectId());
            List<Date> allocateDateList = new ArrayList<>();
            for (ProSignReserveVO proSignReserveVO : proSignReserveAllocateVOS) {
                allocateDateList.add(proSignReserveVO.getCreateTime());
            }
            Date allocateDate = Collections.max(allocateDateList);
            ProSignReserveVO proSignReserveAllocateVO = new ProSignReserveVO();
            for (ProSignReserveVO proSignReserveVO : proSignReserveAllocateVOS) {
                if (allocateDate == proSignReserveAllocateVO.getCreateTime()) {
                    vo.setTrsReservedAmount(proSignReserveVO.getTrsReservedAmount());// 目标责任书应预留金额(万元)
                    vo.setApprovedReservedAmount(proSignReserveVO.getApprovedReservedAmount());// 核定应预留金额(万元)
                    vo.setActualReservedAmount(proSignReserveVO.getActualReservedAmount());// 实际预留金额(万元)
                    vo.setRiskReserve(ComputeUtil.safeDiv((ComputeUtil.safeDiv(vo.getActualReservedAmount(), vo.getApprovedReservedAmount())), BigDecimal.valueOf(100)));// 风险金预留%
                }
            }
            vos.add(vo);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            saveOrUpdateBatch(BeanMapper.mapList(vos, ProSignReserveEntity.class));
        }
    }

    @Override
    public void saveBatch(String endDate) {
        baseMapper.saveBatch(endDate);
    }

    @Override
    public List<ProSignReserveVO> queryProjectIds(String endDate) {
        List<ProSignReserveVO> vos = baseMapper.queryProjectIds(endDate);
        return vos;
    }

    @Override
    public List<ProSignReserveVO> queryIncontract(Long id , String endDate) {
        List<ProSignReserveVO> vos = baseMapper.queryIncontract(id,endDate);
        return vos;
    }

    @Override
    public List<ProSignReserveVO> queryBook(Long id) {
        List<ProSignReserveVO> vos = baseMapper.queryBook(id);
        return vos;
    }

    @Override
    public List<ProSignReserveVO> queryAllocate(Long id) {
        List<ProSignReserveVO> vos = baseMapper.queryAllocate(id);
        return vos;
    }
}
