package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.CompleteSettlementVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 收入分析
 * 
 * @author generator
 * 
 */
@Service("profitIncomeService")
public class ProfitIncomeServiceImpl extends BaseServiceImpl<ProfitIncomeMapper, ProfitIncomeEntity> implements IProfitIncomeService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ProfitIncomeMapper mapper;

    @Override
    public void execute(Integer inAdvanceFlag,String day,List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag,day,projectIdList);

        //先删后增
        LambdaQueryWrapper<ProfitIncomeEntity> lambdaPro = Wrappers.<ProfitIncomeEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaPro.in(ProfitIncomeEntity::getProjectId, projectIdList);
        }
        lambdaPro.in(ProfitIncomeEntity::getReportingMonth, reportingMonth);
        remove(lambdaPro);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = queryProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            if(inAdvanceFlag == 1){
                profitIncomeVOList = queryProjects(null);
            }else{
                profitIncomeVOList = queryProjects(null);
            }

        }
        //查询项目月度成本分析
        List<ProfitIncomeVO> costanalysisList = queryCostanalysis(reportingMonth);
        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            for(ProfitIncomeVO profitIncomeVO :profitIncomeVOList){
                profitIncomeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                if(CollectionUtils.isNotEmpty(costanalysisList)){
                    Map<Long, ProfitIncomeVO> costanalysisListMap = costanalysisList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    if(costanalysisListMap.containsKey(profitIncomeVO.getProjectId())){
                        ProfitIncomeVO profitIncomeVO1 = costanalysisListMap.get(profitIncomeVO.getProjectId());
                        profitIncomeVO.setRealProduct(profitIncomeVO1.getCumulativeIncome() == null ? new BigDecimal("0") : profitIncomeVO1.getCumulativeIncome());
                        profitIncomeVO.setCostAnalysisCreateTime(profitIncomeVO1.getCostAnalysisCreateTime());
                        profitIncomeVO.setCreateTime(new Date());
                    }

                }
                //查询工程计量台账
                List<ProfitIncomeVO> engineermeasurementList = queryEngineermeasurement(reportingMonth);
                if(CollectionUtils.isNotEmpty(engineermeasurementList)){
                    //补全工程计量台账信息
                    Map<Long, ProfitIncomeVO> engineermeasurementListMap = engineermeasurementList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    if(engineermeasurementListMap.containsKey(profitIncomeVO.getProjectId())){
                        ProfitIncomeVO profitIncomeVO1 = engineermeasurementListMap.get(profitIncomeVO.getProjectId());
                        profitIncomeVO.setNotarizeProduct(profitIncomeVO1.getCurrentBatch() == null ? new BigDecimal(0) : profitIncomeVO1.getCurrentBatch());
                    }else{
                        profitIncomeVO.setNotarizeProduct(new BigDecimal(0));
                    }
                }
                //如果项目状态=已竣已结算  业主确认产值=实际完成产值
                if(profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 5){
                    profitIncomeVO.setNotarizeProduct(CommonUtils.setBigDecimalDefaultValue(profitIncomeVO.getRealProduct()));
                }
                //已完工未结算 = 实际完成产值-业主确认产值
                profitIncomeVO.setUnliquidated(ComputeUtil.safeSub(profitIncomeVO.getRealProduct(), profitIncomeVO.getNotarizeProduct()));

                CommonResponse<OrgVO> orgVo = iOrgApi.detailById(profitIncomeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        profitIncomeVO.setTwoOrgId(orgVos.getData().getId());
                        profitIncomeVO.setTwoOrgName(orgVos.getData().getName());
                        profitIncomeVO.setTwoOrgCode(orgVos.getData().getCode());
                        profitIncomeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }

            }

            logger.info("-----------------------------------------收入分析生成数据,截止日期:"+reportingMonth+" :"+ com.alibaba.fastjson.JSONObject.toJSONString(profitIncomeVOList));
            saveOrUpdateBatch(BeanMapper.mapList(profitIncomeVOList, ProfitIncomeEntity.class));
        }
    }

    @Override
    public List<ProfitIncomeVO> queryProject(String endDate) {
        return baseMapper.getProject(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryCostanalysis(String endDate) {
        return baseMapper.getCostanalysis(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryEngineermeasurement(String endDate) {
        return baseMapper.getEngineermeasurement(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryProjects(List<Long> idList) {
        return baseMapper.getProjects(idList);
    }

    @Override
    public List<ProfitIncomeVO> processingList(List<ProfitIncomeVO> profitIncomeVOList) {
        //处理第一行合计值
        ProfitIncomeVO profitIncomeVO = new ProfitIncomeVO();
        ArrayList<ProfitIncomeVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            getSumData(profitIncomeVOList, profitIncomeVO);
            profitIncomeVO.setNumber("合计");
            profitIncomeVO.setId(IdWorker.getId());
            feeNewList.add(profitIncomeVO);
        }

        //计算排序字段
        for(ProfitIncomeVO profitIncomeVO1 :profitIncomeVOList){
            profitIncomeVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(profitIncomeVO1.getProjectStatus()));
        }

        //计算项目状态合计
        profitIncomeVOList = profitIncomeVOList.stream().sorted(Comparator.comparing(ProfitIncomeVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ProfitIncomeVO>> mapProjectStatusOrder = profitIncomeVOList.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ProfitIncomeVO projectStatusSumfeeVO = new ProfitIncomeVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProfitIncomeVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProfitIncomeVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ProfitIncomeVO orgStatusSumfeeVO = new ProfitIncomeVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(com.baomidou.mybatisplus.core.toolkit.IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProfitIncomeVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ProfitIncomeVO proNum : orgStatusList){
                    proNum.setNumber(number +"");
                    number = number + 1;
                    proNum.setProjectStatusName(CommonUtils.getProjectStatusName(proNum.getProjectStatus()));
                    //转万元赋值
                    proNum.setRealProduct(CommonUtils.parseYuanToWan(proNum.getRealProduct()));
                    proNum.setNotarizeProduct(CommonUtils.parseYuanToWan(proNum.getNotarizeProduct()));
                    proNum.setUnliquidated(CommonUtils.parseYuanToWan(proNum.getUnliquidated()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });
        return feeNewList;
    }

    private void getSumData(List<ProfitIncomeVO> profitIncomeVOList, ProfitIncomeVO feeVO) {
        BigDecimal realProduct = profitIncomeVOList.stream().filter(s->s.getRealProduct()!=null).map(ProfitIncomeVO::getRealProduct)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal notarizeProduct = profitIncomeVOList.stream().filter(s->s.getNotarizeProduct()!=null).map(ProfitIncomeVO::getNotarizeProduct)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal unliquidated = profitIncomeVOList.stream().filter(s->s.getUnliquidated()!=null).map(ProfitIncomeVO::getUnliquidated)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        //转万元赋值
        feeVO.setRealProduct(CommonUtils.parseYuanToWan(realProduct));
        feeVO.setNotarizeProduct(CommonUtils.parseYuanToWan(notarizeProduct));
        feeVO.setUnliquidated(CommonUtils.parseYuanToWan(unliquidated));

    }

    @Override
    public List<ProfitIncomeVO> queryListPage(Map<String, Object> paramMapper) {
        return mapper.queryList(paramMapper);
    }

    @Override
    public void deleteByReportingMonth(String reportingMonth) {
         mapper.deleteByReportingMonth(reportingMonth);
    }
}
