package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IFeeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.RiskVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.RiskMapper;
import com.ejianc.business.analysis.bean.RiskEntity;
import com.ejianc.business.analysis.service.IRiskService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目人员风险金预留分配表
 * 
 * @author generator
 * 
 */
@Service("riskService")
public class RiskServiceImpl extends BaseServiceImpl<RiskMapper, RiskEntity> implements IRiskService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private IRiskService riskService;
    @Autowired
    private RiskMapper riskMapper;
    @Autowired
    private IOrgApi orgApi;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<RiskEntity> lambdaFee = Wrappers.<RiskEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(RiskEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(RiskEntity::getReportingMonth, reportingMonth);
        riskService.remove(lambdaFee);

        //获取项目人员风险金预留分配表包含的项目id
        List<Long> projectIds = riskMapper.getProjectIds(reportingMonth);
        List<Long> projectIdAll = new ArrayList<>();


        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
            projectIdAll = projectIdList;
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIds);
            projectIdAll = projectIds;
        }

        //获取所有符合条件的业务数据
       List<RiskVO> riskVOList = riskMapper.getDataAll(reportingMonth,projectIdAll);

        Map<Long, List<RiskVO>> mapPro = new HashMap<>();
        Map<String, List<RiskVO>> mapProAndPeriod = new HashMap<>();

        if (CollectionUtils.isNotEmpty(riskVOList)){
            mapPro = riskVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
            mapProAndPeriod = riskVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId() +"-"+s.getReportingMonth()
                    ));
        }
        //最新的数据
        ArrayList<RiskVO> lastList = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<RiskVO> riskVOProList = BeanMapper.mapList(profitIncomeVOList, RiskVO.class);
            for (RiskVO riskVO : riskVOProList){
                riskVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                riskVO.setCreateTime(new Date());
                //取每个项目最近一期的数据
                if (mapPro.containsKey(riskVO.getProjectId())){
                    List<RiskVO> riskVOS = mapPro.get(riskVO.getProjectId());
                    List<RiskVO> collectCompare = riskVOS.stream().sorted(Comparator.comparing(RiskVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    RiskVO riskVOPeriod = collectCompare.stream().findFirst().get();
                    String key = riskVO.getProjectId() +"-" + riskVOPeriod.getReportingMonth();
                    if (mapProAndPeriod.containsKey(key)){
                        List<RiskVO> riskVOListLast = mapProAndPeriod.get(key);
                        //补全二级组织信息
                        CommonResponse<OrgVO> orgVo = orgApi.detailById(riskVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                        if (orgVo.isSuccess() && null != orgVo.getData()) {
                            String innerCode = orgVo.getData().getInnerCode();
                            String[] strs = innerCode.split("\\|");
                            CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                            if (orgVos.isSuccess() && null != orgVos.getData()) {
                                //二级组织信息
                                for (RiskVO riskVOLast : riskVOListLast){
                                    riskVOLast.setTwoOrgId(orgVos.getData().getId());
                                    riskVOLast.setTwoOrgName(orgVos.getData().getName());
                                    riskVOLast.setTwoOrgCode(orgVos.getData().getCode());
                                    riskVOLast.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                                    riskVOLast.setOrgId(riskVO.getOrgId());
                                    riskVOLast.setOrgName(riskVO.getOrgName());
                                    riskVOLast.setProjectDepartmentId(riskVO.getProjectDepartmentId());
                                    riskVOLast.setProjectName(riskVO.getProjectName());
                                    riskVOLast.setProjectCode(riskVO.getProjectCode());
                                    riskVOLast.setProjectStatus(riskVO.getProjectStatus());
                                    riskVOLast.setCreateTime(new Date());
                                    riskVOLast.setProjectCreateTime(riskVO.getProjectCreateTime());

                                }
                            }
                        }

                        lastList.addAll(riskVOListLast);
                    }
                }

            }

        }
        //新增数据
        if(CollectionUtils.isNotEmpty(lastList)){
            List<RiskEntity> riskEntityList = BeanMapper.mapList(lastList, RiskEntity.class);
            riskService.saveBatch(riskEntityList);
        }

    }

    @Override
    public List<RiskVO> dealData(List<RiskVO> feeVOS) {
        if (CollectionUtils.isEmpty(feeVOS)){
            return new ArrayList<RiskVO>();
        }
        //处理第一行合计值
        RiskVO feeVO = new RiskVO();
        ArrayList<RiskVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }
        //计算组织状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(RiskVO::getOrgStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<RiskVO>> mapOrgStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getOrgStatusOrder()
                ));
        mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
            RiskVO orgStatusSumfeeVO = new RiskVO();
            orgStatusSumfeeVO.setNumber("单位小计");
            orgStatusSumfeeVO.setId(IdWorker.getId());
            orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
            orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
            getSumData(orgStatusList, orgStatusSumfeeVO);
            feeNewList.add(orgStatusSumfeeVO);
            Integer number = 1;
            orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(RiskVO::getProjectCreateTime))
                    .collect(Collectors.toList());
            for (RiskVO feeVONum : orgStatusList){
                feeVONum.setNumber(number +"");
                number = number + 1;
                feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                //转万元赋值
                feeVONum.setYMny(feeVONum.getYMny());
                feeVONum.setAMny(feeVONum.getAMny());
                feeVONum.setYSMny(feeVONum.getYSMny());
                feeVONum.setASMny(feeVONum.getASMny());
            }
            feeNewList.addAll(orgStatusList);
        });
        return feeNewList;
    }

    private void getSumData(List<RiskVO> riskVOS, RiskVO riskVO) {
        BigDecimal yMny = riskVOS.stream().map(RiskVO::getYMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal aMny = riskVOS.stream().map(RiskVO::getAMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ysMny = riskVOS.stream().map(RiskVO::getYSMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal asMny = riskVOS.stream().map(RiskVO::getASMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //转万元赋值
        riskVO.setYMny(yMny);
        riskVO.setAMny(aMny);
        riskVO.setYSMny(ysMny);
        riskVO.setASMny(asMny);

    }

}
