package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ConstructProBusinessEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructProBusinessVO;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.bean.UnsettledProBusinessEntity;
import com.ejianc.business.analysis.service.IUnsettledProBusinessService;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 竣工未结算项目商务报表
 *
 * @author generator
 *
 */
@Service("unsettledProBusinessService")
public class UnsettledProBusinessServiceImpl extends BaseServiceImpl<UnsettledProBusinessMapper, UnsettledProBusinessEntity> implements IUnsettledProBusinessService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUnsettledProBusinessService unsettledProBusinessService;
    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<UnsettledProBusinessEntity> lambdaFee = Wrappers.<UnsettledProBusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(UnsettledProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(UnsettledProBusinessEntity::getReportingMonth, reportingMonth);
        unsettledProBusinessService.remove(lambdaFee);

        //查询项目信息数据
        List<UnsettledProBusinessVO> unsettledProBusinessVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            unsettledProBusinessVOList = unsettledProBusinessMapper.queryProjectIds(projectIdList);
        }else{
            //等于1代表预生成数据
            unsettledProBusinessVOList = unsettledProBusinessMapper.queryProjectIds(null);
        }
        List<Long> projectIds = unsettledProBusinessVOList.stream().map(UnsettledProBusinessVO::getProjectId).collect(Collectors.toList());

        // 查询施工类合同
        List<UnsettledProBusinessVO> contractVOS = unsettledProBusinessMapper.queryContract(projectIds);
        Map<Long, UnsettledProBusinessVO> contractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目目标管理责任书
        List<UnsettledProBusinessVO> bookVOS = unsettledProBusinessMapper.queryBook(projectIds);
        Map<Long, UnsettledProBusinessVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目月度成本分析报告
        List<UnsettledProBusinessVO> costanalysisVOS = unsettledProBusinessMapper.queryCostanalysis(projectIds,reportingMonth);
        Map<Long, UnsettledProBusinessVO> costanalysisMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            costanalysisMap = costanalysisVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询工程计量台账
        List<UnsettledProBusinessVO> engineermeasurementVOS = unsettledProBusinessMapper.queryEngineermeasurement(projectIds,reportingMonth);
        Map<Long, UnsettledProBusinessVO> engineermeasurementMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(engineermeasurementVOS)){
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        for (UnsettledProBusinessVO vo : unsettledProBusinessVOList) {
            vo.setReportEndDate(changDate(reportingMonth));// 本报表统计截止日（为当季度最后一个日历天）
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                vo.setPromoter(contractMap.get(projectId).getPromoter());
                vo.setPromoterName(contractMap.get(projectId).getPromoterName());
                vo.setProjectLocation(contractMap.get(projectId).getProjectLocation());
                vo.setContractSignTime(contractMap.get(projectId).getContractSignTime());
                vo.setContractStartDate(contractMap.get(projectId).getContractStartDate());
                vo.setContractEndDate(contractMap.get(projectId).getContractEndDate());
                vo.setContractAmount(CommonUtils.parseYuanToWanZ(contractMap.get(projectId).getContractAmount()));
                vo.setAcContractAmount(CommonUtils.parseYuanToWanZ(contractMap.get(projectId).getAcContractAmount()));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setUndertakeRate(bookMap.get(projectId).getUndertakeRate());
                vo.setTargetRate(bookMap.get(projectId).getTargetRate());
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                vo.setContractIncome(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getContractIncome()));
                vo.setAcContractIncome(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getContractIncome()));
                vo.setRealCost(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getRealCost()));
                vo.setAcRealCost(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getRealCost()));
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                vo.setOwnerCrValue(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getOwnerCrValue()));
                vo.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getOwnerCrValue()));
                vo.setContractReceivableMny(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getContractReceivableMny()));
                vo.setOperatingRevenue(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getOperatingRevenue()));
                vo.setRealRecrived(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).getRealRecrived()));
            }
            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setThreeOrgId(orgVos.getData().getId());
                    vo.setThreeOrgName(orgVos.getData().getName());
                }
            }
            if (vo.getFourOrgId() != null) {
                CommonResponse<OrgVO> fourOrgVO = orgApi.detailById(vo.getFourOrgId());
                if (fourOrgVO.isSuccess() && null != fourOrgVO.getData()) {
                    vo.setFourOrgName(fourOrgVO.getData().getName());// 股份公司四级单位
                }
            }
            if (vo.getContractorName() == null) {
                CommonResponse<OrgVO> orgVO = orgApi.detailById(vo.getContractor());
                if (orgVO.isSuccess() && null != orgVO.getData()) {
                    vo.setContractorName(orgVO.getData().getName());// 承包人名称
                }
            }
            // 竣工未结算持续时间（天数）
            vo.setUnsrttledDays(ComputeUtil.safeDiv(new BigDecimal(vo.getReportEndDate().getTime() - vo.getEndDate().getTime()), new BigDecimal(86400000)));
            // 利润率(%)
            vo.setProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub(vo.getContractIncome(), vo.getRealCost()), vo.getContractIncome()));
            // 自施利润率(%)
            vo.setAcProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub(vo.getAcContractIncome(), vo.getAcRealCost()), vo.getAcContractIncome()));

        }
        List<UnsettledProBusinessEntity> unsettledProBusinessEntityList = BeanMapper.mapList(unsettledProBusinessVOList, UnsettledProBusinessEntity.class);
        unsettledProBusinessService.saveBatch(unsettledProBusinessEntityList);
    }

    @Override
    public Date changDate(String reportingMonth) {
        LocalDate date = LocalDate.now();
        String[] data = String.valueOf(date).split("-");
        String lastDayOfMonth = reportingMonth +"-"+ data[2];
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.parse(lastDayOfMonth, fmt);
        LocalDate lastDay = nowDate.with(TemporalAdjusters.lastDayOfMonth());
        Date endDate = Date.from(lastDay.atTime(LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault()).toInstant());
        return endDate;
    }

    @Override
    public List<UnsettledProBusinessVO> dealData(List<UnsettledProBusinessVO> unsettledProBusinessVOS) {
        //处理第一行合计值
        UnsettledProBusinessVO unsettledProBusinessVO = new UnsettledProBusinessVO();
        ArrayList<UnsettledProBusinessVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(unsettledProBusinessVOS)) {
            getSumDate(unsettledProBusinessVOS, unsettledProBusinessVO);
            unsettledProBusinessVO.setNumber("合计");
            unsettledProBusinessVO.setId(IdWorker.getId());
            newList.add(unsettledProBusinessVO);
        }
        Integer number = 1;
        for (UnsettledProBusinessVO vo : unsettledProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            number++;
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337":vo.setProjectCategoryName("工业厂房");break;
                case "1470216222511185922":vo.setProjectCategoryName("公共建筑");break;
                case "1470216274176622593":vo.setProjectCategoryName("民用住宅");break;
                case "1470216311648534530":vo.setProjectCategoryName("基础设施");break;
                case "1470216348239642626":vo.setProjectCategoryName("其它");break;
            }
        }
        newList.addAll(unsettledProBusinessVOS);
        return newList;
    }
    private void getSumDate(List<UnsettledProBusinessVO> unsettledProBusinessVOS, UnsettledProBusinessVO unsettledProBusinessVO) {
        unsettledProBusinessVO.setContractAmount(unsettledProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(UnsettledProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setAcContractAmount(unsettledProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(UnsettledProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setContractIncome(unsettledProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(UnsettledProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setAcContractIncome(unsettledProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(UnsettledProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setRealCost(unsettledProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(UnsettledProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setAcRealCost(unsettledProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(UnsettledProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setOwnerCrValue(unsettledProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(UnsettledProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setOwnerCrAcValue(unsettledProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(UnsettledProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setContractReceivableMny(unsettledProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(UnsettledProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setOperatingRevenue(unsettledProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(UnsettledProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add));
        unsettledProBusinessVO.setRealRecrived(unsettledProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(UnsettledProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add));
    }
}
