package com.ejianc.business.analysis.service;

import com.ejianc.business.analysis.vo.AuthenticRightVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.analysis.bean.AuthenticRightEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 项目确权情况分析
 * 
 * @author generator
 * 
 */
public interface IAuthenticRightService extends IBaseService<AuthenticRightEntity> {
    //定时任务生成数据
    void execute(String day,String date);

    //获取项目信息
    List<AuthenticRightVO> queryProjects(String endDate);

    //工程计量台账本年开累
    List<AuthenticRightVO> getEngineermeasurementNear(String beginDate,String endDate);

    //项目月度成本分析报告本年年累
    List<AuthenticRightVO> getCostanalysisNear(String beginDate,String endDate);

    //工程计量台账开累
    List<AuthenticRightVO> getEngineermeasurement(String endDate);

    //项目月度成本分析报告开累
    List<AuthenticRightVO> getCostanalysis(String endDate);

    //工程计量台账本年开累
    List<AuthenticRightVO> getEngineermeasurementCreateTime(String endDate);

    //项目月度成本分析报告本年开累
    List<AuthenticRightVO> getCostanalysisCreateTime(String endDate);

    //查询列表
    List<AuthenticRightVO> queryList(Map<String, Object> paramMapper);

    //删除当前月份数据
    void deleteByReportingMonth(@Param(value = "reportingMonth")String reportingMonth);

    //处理数据小计合计
    List<AuthenticRightVO> processingList(List<AuthenticRightVO> authenticRightVOList);


}
