package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.bean.UnsettledProBusinessEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ActualValueVO;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProSignReserveVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ActualValueMapper;
import com.ejianc.business.analysis.bean.ActualValueEntity;
import com.ejianc.business.analysis.service.IActualValueService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 实际产值利润情况分析表
 *
 * @author generator
 *
 */
@Service("actualValueService")
public class ActualValueServiceImpl extends BaseServiceImpl<ActualValueMapper, ActualValueEntity> implements IActualValueService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IActualValueService actualValueService;
    @Autowired
    private ActualValueMapper actualValueMapper;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ActualValueEntity> lambdaFee = Wrappers.<ActualValueEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ActualValueEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ActualValueEntity::getReportingMonth, reportingMonth);
        actualValueService.remove(lambdaFee);

        //查询项目信息数据
        List<ActualValueVO> actualValueVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            actualValueVOList = actualValueMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            actualValueVOList = actualValueMapper.getProjects(null);
        }

        //获取当年月初的年月
        String startYear = CommonUtils.getSysYearAndFirstMonth()+"-1";
        Calendar date = Calendar.getInstance();
        String endYear = String.valueOf(date.get(Calendar.YEAR)) + "-12-31";

        List<Long> projectIds = actualValueVOList.stream().map(ActualValueVO::getProjectId).collect(Collectors.toList());
        //查询项目月度成本分析
        List<ActualValueVO> costanalysisVOS = actualValueMapper.queryCostanalysis(projectIds,startYear,endYear);
        Map<Long, List<ActualValueVO>> costanalysisMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            costanalysisMap = costanalysisVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        // 查询项目目标管理责任书
        List<ActualValueVO> bookVOS = actualValueMapper.queryBook(projectIds);
        Map<Long, ActualValueVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

        for (ActualValueVO vo : actualValueVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                Integer integer = costanalysisMap.get(projectId).size() - 1;// 最后一期
                vo.setYearActualCompleteValue(CommonUtils.parseYuanToWan(costanalysisMap.get(projectId).stream().map(s -> s.getAccumulateActualCompleteValue()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setYearResponsibilityCost(CommonUtils.parseYuanToWan(costanalysisMap.get(projectId).stream().map(s -> s.getYearResponsibilityCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setYearRealCost(CommonUtils.parseYuanToWan(costanalysisMap.get(projectId).stream().map(s -> s.getYearRealCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setYearActualProfit(ComputeUtil.safeSub(vo.getAccumulateActualCompleteValue(), vo.getYearRealCost()));
                vo.setAccumulateActualCompleteValue(CommonUtils.parseYuanToWan(costanalysisMap.get(projectId).get(integer).getAccumulateActualCompleteValue()));
                vo.setAccumulateResponsibilityCost(CommonUtils.parseYuanToWan(costanalysisMap.get(projectId).get(integer).getAccumulateResponsibilityCost()));
                vo.setAccumulateRealCost(CommonUtils.parseYuanToWan(costanalysisMap.get(projectId).get(integer).getAccumulateRealCost()));
                vo.setAccumulateActualProfit(ComputeUtil.safeSub(vo.getAccumulateActualCompleteValue(), vo.getAccumulateRealCost()));
                vo.setYearProfitRate(CommonUtils.calculateRate(vo.getYearActualProfit()!=null?vo.getYearActualProfit():BigDecimal.ZERO, vo.getYearActualCompleteValue()!=null?vo.getYearActualCompleteValue():BigDecimal.ZERO));
                vo.setAccumulateProfitRate(CommonUtils.calculateRate(vo.getAccumulateActualProfit()!=null?vo.getAccumulateActualProfit():BigDecimal.ZERO, vo.getAccumulateActualCompleteValue()!=null?vo.getAccumulateActualCompleteValue():BigDecimal.ZERO));
                vo.setYearReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub(vo.getYearResponsibilityCost()!=null?vo.getYearResponsibilityCost():BigDecimal.ZERO, vo.getYearRealCost()!=null?vo.getYearRealCost():BigDecimal.ZERO), vo.getYearResponsibilityCost()!=null?vo.getYearResponsibilityCost():BigDecimal.ZERO));
                vo.setAccumulateReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub(vo.getAccumulateResponsibilityCost()!=null?vo.getAccumulateResponsibilityCost():BigDecimal.ZERO, vo.getAccumulateRealCost()!=null?vo.getAccumulateRealCost():BigDecimal.ZERO), vo.getAccumulateResponsibilityCost()!=null?vo.getAccumulateResponsibilityCost():BigDecimal.ZERO));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)){
                vo.setUndertakingBenefitsRate(bookMap.get(projectId).getUndertakingBenefitsRate());
                vo.setOverallProfitMargin(bookMap.get(projectId).getOverallProfitMargin());
            }
            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());//此处是项目部id 1286211352287834113
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setTwoOrgId(orgVos.getData().getId());
                    vo.setTwoOrgName(orgVos.getData().getName());
                    vo.setTwoOrgCode(orgVos.getData().getCode());
                    vo.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                }
            }
        }
        List<ActualValueEntity> actualValueEntityList = BeanMapper.mapList(actualValueVOList, ActualValueEntity.class);
        actualValueService.saveBatch(actualValueEntityList);
    }

    @Override
    public List<ActualValueVO> dealData(List<ActualValueVO> actualValueVOS) {
        //处理第一行合计值
        ActualValueVO actualValueVO = new ActualValueVO();
        ArrayList<ActualValueVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(actualValueVOS)){
            getSumData(actualValueVOS, actualValueVO);
            actualValueVO.setNumber("合计");
            actualValueVO.setId(IdWorker.getId());
            newList.add(actualValueVO);
        }

        //计算排序字段
        for(ActualValueVO actualValueVOrder :actualValueVOS){
            actualValueVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(actualValueVOrder.getProjectStatus().intValue()));
        }

        //计算项目状态合计
        actualValueVOS = actualValueVOS.stream().sorted(Comparator.comparing(ActualValueVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ActualValueVO>> mapProjectStatusOrder = actualValueVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ActualValueVO projectStatusSumfeeVO = new ActualValueVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            newList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ActualValueVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ActualValueVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ActualValueVO orgStatusSumfeeVO = new ActualValueVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus().intValue()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                newList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ActualValueVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ActualValueVO actualValueVONum : orgStatusList){
                    actualValueVONum.setNumber(number +"");
                    number = number + 1;
                    actualValueVONum.setProjectStatusName(CommonUtils.getProjectStatusName(actualValueVONum.getProjectStatus().intValue()));
                }
                newList.addAll(orgStatusList);
            });

        });
        return newList;
    }

    private void getSumData(List<ActualValueVO> actualValueVOS, ActualValueVO actualValueVO) {
        actualValueVO.setYearActualCompleteValue(actualValueVOS.stream().filter(s->s.getAccumulateActualCompleteValue()!=null).map(ActualValueVO::getAccumulateActualCompleteValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearResponsibilityCost(actualValueVOS.stream().filter(s->s.getYearResponsibilityCost()!=null).map(ActualValueVO::getYearResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearRealCost(actualValueVOS.stream().filter(s->s.getYearRealCost()!=null).map(ActualValueVO::getYearRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearActualProfit(actualValueVOS.stream().filter(s->s.getYearActualProfit()!=null).map(ActualValueVO::getYearActualProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateActualCompleteValue(actualValueVOS.stream().filter(s->s.getAccumulateActualCompleteValue()!=null).map(ActualValueVO::getAccumulateActualCompleteValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateResponsibilityCost(actualValueVOS.stream().filter(s->s.getAccumulateResponsibilityCost()!=null).map(ActualValueVO::getAccumulateResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateRealCost(actualValueVOS.stream().filter(s->s.getAccumulateRealCost()!=null).map(ActualValueVO::getAccumulateRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateActualProfit(actualValueVOS.stream().filter(s->s.getAccumulateActualProfit()!=null).map(ActualValueVO::getAccumulateActualProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
    }


}
