package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectCheckEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProjectCheckMapper;
import com.ejianc.business.analysis.service.IProjectCheckService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.ProjectCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目考核兑现统计表
 * 
 * @author generator
 * 
 */
@Service("projectCheckService")
public class ProjectCheckServiceImpl extends BaseServiceImpl<ProjectCheckMapper, ProjectCheckEntity> implements IProjectCheckService{

    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;

    @Autowired
    private ProjectCheckMapper projectCheckMapper;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ProjectCheckEntity> lambdaFee = Wrappers.<ProjectCheckEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ProjectCheckEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectCheckEntity::getReportingMonth, reportingMonth);
        remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }
        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<ProjectCheckVO> projectCheckVOList = BeanMapper.mapList(profitIncomeVOList, ProjectCheckVO.class);
            //查询项目优化立项申报
            List<ProjectCheckVO> pcList = projectCheckMapper.quertOptimization(projectIdList);
            //查询项目优化奖励申请
            List<ProjectCheckVO> rewardList = projectCheckMapper.quertReward(projectIdList);
            //查询项目过程奖分析考核
            List<ProjectCheckVO> assessList = projectCheckMapper.quertAssess(projectIdList);
            //查询工程项目过程目标奖金审批
            List<ProjectCheckVO> approvalList = projectCheckMapper.quertApproval(projectIdList);
            //查询过程目标奖金考核发放
            List<ProjectCheckVO> nodeGrantList = projectCheckMapper.quertNodeGrant(projectIdList);
            //查询目标责任书竣工兑现审批
            List<ProjectCheckVO> finishApproveList = projectCheckMapper.quertFinishApprove(projectIdList);
            //查询竣工目标考核奖金发放
            List<ProjectCheckVO> finishOutList = projectCheckMapper.quertFinishOut(projectIdList);
            //查询兑现预留奖金返还审批
            List<ProjectCheckVO> finishRefundList = projectCheckMapper.quertFinishRefund(projectIdList);
            //总包结算考核奖审批
            List<ProjectCheckVO> generalApprovalList = projectCheckMapper.quertGeneralApproval(projectIdList);


            for(ProjectCheckVO projectCheckVO : projectCheckVOList){
                projectCheckVO.setReportingMonth(reportingMonth);
                if(CollectionUtils.isNotEmpty(pcList)){
                    Map<Long, List<ProjectCheckVO>> pcListMap = pcList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(pcListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = pcListMap.get(projectCheckVO.getProjectId());
                        BigDecimal benefitMny = projectNumList.stream().filter(s->s.getBenefitMny()!=null).map(ProjectCheckVO::getBenefitMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setPredictEarnings(benefitMny);
                        projectCheckVO.setProjectApprovalNumber(projectNumList.size());
                    }
                }

                if(CollectionUtils.isNotEmpty(rewardList)){
                    Map<Long, List<ProjectCheckVO>> rewardListMap = rewardList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(rewardListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = rewardListMap.get(projectCheckVO.getProjectId());
                        BigDecimal benefitMny2 = projectNumList.stream().filter(s->s.getBenefitMny2()!=null).map(ProjectCheckVO::getBenefitMny2)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal chairmanCashMny = projectNumList.stream().filter(s->s.getChairmanCashMny()!=null).map(ProjectCheckVO::getChairmanCashMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setAlreadyEmbodiment(projectNumList.size());
                        projectCheckVO.setNetEarning(benefitMny2);
                        projectCheckVO.setCashingMoney(chairmanCashMny);
                    }
                }

                if(CollectionUtils.isNotEmpty(assessList)){
                    Map<Long, List<ProjectCheckVO>> assessListMap = assessList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(assessListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = assessListMap.get(projectCheckVO.getProjectId());
                        projectCheckVO.setCourseAssess(projectNumList.size());
                    }
                }

                if(CollectionUtils.isNotEmpty(approvalList)){
                    Map<Long, List<ProjectCheckVO>> assessListMap = approvalList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(assessListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = assessListMap.get(projectCheckVO.getProjectId());
                        BigDecimal chairmanCashMny = projectNumList.stream().filter(s->s.getChairmanCashMny()!=null).map(ProjectCheckVO::getChairmanCashMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setCourseAssessMoney(chairmanCashMny);
                    }
                }

                if(CollectionUtils.isNotEmpty(nodeGrantList)){
                    Map<Long, List<ProjectCheckVO>> nodeGrantListMap = nodeGrantList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(nodeGrantListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = nodeGrantListMap.get(projectCheckVO.getProjectId());
                        BigDecimal actualMny = projectNumList.stream().filter(s->s.getActualMny()!=null).map(ProjectCheckVO::getActualMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setPracticalCourseAssessMoney(actualMny);
                    }
                }

                if(CollectionUtils.isNotEmpty(finishApproveList)){
                    Map<Long, List<ProjectCheckVO>> finishApproveListMap = finishApproveList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(finishApproveListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = finishApproveListMap.get(projectCheckVO.getProjectId());
                        BigDecimal chairmanCashMny = projectNumList.stream().filter(s->s.getChairmanCashMny()!=null).map(ProjectCheckVO::getChairmanCashMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setCompletedAssessMoney(chairmanCashMny);
                    }
                }

                if(CollectionUtils.isNotEmpty(finishOutList)){
                    Map<Long, List<ProjectCheckVO>> finishOutListMap = finishOutList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(finishOutListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = finishOutListMap.get(projectCheckVO.getProjectId());
                        BigDecimal actualMny = projectNumList.stream().filter(s->s.getActualMny()!=null).map(ProjectCheckVO::getActualMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setRealityMoney(actualMny);
                    }
                }

                if(CollectionUtils.isNotEmpty(finishRefundList)){
                    Map<Long, List<ProjectCheckVO>> finishRefundListMap = finishRefundList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(finishRefundListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = finishRefundListMap.get(projectCheckVO.getProjectId());
                        BigDecimal reservedMoney = projectNumList.stream().filter(s->s.getDepartmentApplyMny()!=null).map(ProjectCheckVO::getDepartmentApplyMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal chairmanActualMny = projectNumList.stream().filter(s->s.getChairmanActualMny()!=null).map(ProjectCheckVO::getChairmanActualMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        projectCheckVO.setReservedMoney(reservedMoney);
                        projectCheckVO.setReservedMoneyReturn(chairmanActualMny);

                    }
                }

                if(CollectionUtils.isNotEmpty(generalApprovalList)){
                    Map<Long, List<ProjectCheckVO>> generalApprovalListMap = generalApprovalList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(generalApprovalListMap.containsKey(projectCheckVO.getProjectId())){
                        List<ProjectCheckVO> projectNumList = generalApprovalListMap.get(projectCheckVO.getProjectId());
                        BigDecimal chairmanCashMny = projectNumList.stream().filter(s->s.getChairmanCashMny()!=null).map(ProjectCheckVO::getChairmanCashMny)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);

                        projectCheckVO.setStatementAssessMoney(chairmanCashMny);
                    }
                }

                CommonResponse<OrgVO> orgVo = orgApi.detailById(projectCheckVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        projectCheckVO.setTwoOrgId(orgVos.getData().getId());
                        projectCheckVO.setTwoOrgName(orgVos.getData().getName());
                        projectCheckVO.setTwoOrgCode(orgVos.getData().getCode());
                        projectCheckVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }

            saveBatch(BeanMapper.mapList(projectCheckVOList, ProjectCheckEntity.class));
        }

    }

    @Override
    public List<ProjectCheckVO> dealData(List<ProjectCheckVO> projectCheckVOList) {
        //处理第一行合计值
        ProjectCheckVO projectCheckVO = new ProjectCheckVO();
        ArrayList<ProjectCheckVO> conNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(projectCheckVOList)){
            getSumData(projectCheckVOList, projectCheckVO);
            projectCheckVO.setNumber("合计");
            projectCheckVO.setId(IdWorker.getId());
            conNewList.add(projectCheckVO);

            //计算排序字段
            for(ProjectCheckVO projectCheckVO1 :projectCheckVOList){
                projectCheckVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(projectCheckVO1.getProjectStatus() == null ? 6:projectCheckVO1.getProjectStatus()));
            }
            //计算项目状态合计
            projectCheckVOList = projectCheckVOList.stream().sorted(Comparator.comparing(ProjectCheckVO::getProjectStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProjectCheckVO>> mapProjectStatusOrder = projectCheckVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectStatusOrder()
                    ));

            mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
                ProjectCheckVO projectCheckVO1 = new ProjectCheckVO();
                projectCheckVO1.setNumber("项目状态合计");
                projectCheckVO1.setId(IdWorker.getId());
                projectCheckVO1.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
                getSumData(projectStatusList, projectCheckVO1);
                conNewList.add(projectCheckVO1);

                //计算组织状态合计
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectCheckVO::getOrgStatusOrder))
                        .collect(Collectors.toList());
                Map<Integer, List<ProjectCheckVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getOrgStatusOrder()
                        ));

                mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                    ProjectCheckVO orgStatusSumpayVO = new ProjectCheckVO();
                    orgStatusSumpayVO.setNumber("单位小计");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                    getSumData(orgStatusList, orgStatusSumpayVO);
                    conNewList.add(orgStatusSumpayVO);

                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectCheckVO::getProjectCreateTime))
                            .collect(Collectors.toList());
                    for (ProjectCheckVO paymentVONum : orgStatusList){
                        paymentVONum.setNumber(number +"");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setPredictEarnings(CommonUtils.parseYuanToWan(paymentVONum.getPredictEarnings()));
                        paymentVONum.setProjectApprovalNumber(CommonUtils.isIntNull(paymentVONum.getProjectApprovalNumber()));
                        paymentVONum.setAlreadyEmbodiment(CommonUtils.isIntNull(paymentVONum.getAlreadyEmbodiment()));
                        paymentVONum.setCourseAssess(CommonUtils.isIntNull(paymentVONum.getCourseAssess()));
                        paymentVONum.setNetEarning(CommonUtils.parseYuanToWan(paymentVONum.getNetEarning()));
                        paymentVONum.setCashingMoney(CommonUtils.parseYuanToWan(paymentVONum.getCashingMoney()));
                        paymentVONum.setCourseAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getCourseAssessMoney()));
                        paymentVONum.setPracticalCourseAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getPracticalCourseAssessMoney()));
                        paymentVONum.setCompletedAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getCompletedAssessMoney()));
                        paymentVONum.setRealityMoney(CommonUtils.parseYuanToWan(paymentVONum.getRealityMoney()));
                        paymentVONum.setReservedMoney(CommonUtils.parseYuanToWan(paymentVONum.getReservedMoney()));
                        paymentVONum.setReservedMoneyReturn(CommonUtils.parseYuanToWan(paymentVONum.getReservedMoneyReturn()));
                        paymentVONum.setStatementAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getStatementAssessMoney()));
                    }
                    conNewList.addAll(orgStatusList);
                });
            });
        }
        return conNewList;
    }

    private void getSumData(List<ProjectCheckVO> projectCheckVOList, ProjectCheckVO projectCheckVO) {

        Integer projectApprovalNumber = projectCheckVOList.stream().filter(s->s.getProjectApprovalNumber()!=null).map(ProjectCheckVO::getProjectApprovalNumber)
                .reduce(0, Integer::sum);
        BigDecimal predictEarnings = projectCheckVOList.stream().filter(s->s.getPredictEarnings()!=null).map(ProjectCheckVO::getPredictEarnings)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer alreadyEmbodiment = projectCheckVOList.stream().filter(s->s.getAlreadyEmbodiment()!=null).map(ProjectCheckVO::getAlreadyEmbodiment)
                .reduce(0, Integer::sum);
        BigDecimal netEarning = projectCheckVOList.stream().filter(s->s.getNetEarning()!=null).map(ProjectCheckVO::getNetEarning)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal cashingMoney = projectCheckVOList.stream().filter(s->s.getCashingMoney()!=null).map(ProjectCheckVO::getCashingMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer courseAssess = projectCheckVOList.stream().filter(s->s.getCourseAssess()!=null).map(ProjectCheckVO::getCourseAssess)
                .reduce(0, Integer::sum);
        BigDecimal courseAssessMoney = projectCheckVOList.stream().filter(s->s.getCourseAssessMoney()!=null).map(ProjectCheckVO::getCourseAssessMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal practicalCourseAssessMoney = projectCheckVOList.stream().filter(s->s.getPracticalCourseAssessMoney()!=null).map(ProjectCheckVO::getPracticalCourseAssessMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal completedAssessMoney = projectCheckVOList.stream().filter(s->s.getCompletedAssessMoney()!=null).map(ProjectCheckVO::getCompletedAssessMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal realityMoney = projectCheckVOList.stream().filter(s->s.getRealityMoney()!=null).map(ProjectCheckVO::getRealityMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reservedMoney = projectCheckVOList.stream().filter(s->s.getReservedMoney()!=null).map(ProjectCheckVO::getReservedMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reservedMoneyReturn = projectCheckVOList.stream().filter(s->s.getReservedMoneyReturn()!=null).map(ProjectCheckVO::getReservedMoneyReturn)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal statementAssessMoney = projectCheckVOList.stream().filter(s->s.getStatementAssessMoney()!=null).map(ProjectCheckVO::getStatementAssessMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        //转万元赋值
        projectCheckVO.setProjectApprovalNumber(projectApprovalNumber);
        projectCheckVO.setPredictEarnings(CommonUtils.parseYuanToWan(predictEarnings));
        projectCheckVO.setAlreadyEmbodiment(alreadyEmbodiment);
        projectCheckVO.setNetEarning(CommonUtils.parseYuanToWan(netEarning));
        projectCheckVO.setCashingMoney(CommonUtils.parseYuanToWan(cashingMoney));
        projectCheckVO.setCourseAssess(courseAssess);
        projectCheckVO.setCourseAssessMoney(CommonUtils.parseYuanToWan(courseAssessMoney));
        projectCheckVO.setPracticalCourseAssessMoney(CommonUtils.parseYuanToWan(practicalCourseAssessMoney));
        projectCheckVO.setCompletedAssessMoney(CommonUtils.parseYuanToWan(completedAssessMoney));
        projectCheckVO.setRealityMoney(CommonUtils.parseYuanToWan(realityMoney));
        projectCheckVO.setReservedMoney(CommonUtils.parseYuanToWan(reservedMoney));
        projectCheckVO.setReservedMoneyReturn(CommonUtils.parseYuanToWan(reservedMoneyReturn));
        projectCheckVO.setStatementAssessMoney(CommonUtils.parseYuanToWan(statementAssessMoney));
    }
}
