package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectIndexEntity;
import com.ejianc.business.analysis.mapper.ProjectIndexMapper;
import com.ejianc.business.analysis.service.IProjectIndexService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.MainanalysisdetailVO;
import com.ejianc.business.analysis.vo.MaineconomicindicatorsVO;
import com.ejianc.business.analysis.vo.ProjectIndexVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目工程造价指标分析
 * 
 * @author generator
 * 
 */
@Service("projectIndexService")
public class ProjectIndexServiceImpl extends BaseServiceImpl<ProjectIndexMapper, ProjectIndexEntity> implements IProjectIndexService{

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ProjectIndexMapper baseMapper;

    @Override
    public void execute(Integer inAdvanceFlag,String day,List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag,day,projectIdList);

        //先删后增
        LambdaQueryWrapper<ProjectIndexEntity> lambdaPro = Wrappers.<ProjectIndexEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaPro.in(ProjectIndexEntity::getProjectId, projectIdList);
        }
        lambdaPro.in(ProjectIndexEntity::getReportingMonth, reportingMonth);
        remove(lambdaPro);

        //查询项目信息数据
        List<ProjectIndexVO> projectIndexVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            projectIndexVOList = queryProjects(projectIdList);
        }else{
            projectIndexVOList = queryProjects(null);
        }
        //查询工程造价指标分析主表
        List<ProjectIndexVO>  analysisList = quertAnalysis(reportingMonth);

        List<Long> idList = new ArrayList<>();
        Map<Long, ProjectIndexVO> quertAnalyMap = analysisList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        if(CollectionUtils.isNotEmpty(projectIndexVOList)){
            for(ProjectIndexVO profitIncomeVO :projectIndexVOList){
                profitIncomeVO.setReportingMonth(reportingMonth);
               if(quertAnalyMap.containsKey(profitIncomeVO.getProjectId())){
                   ProjectIndexVO projectIndexVO = quertAnalyMap.get(profitIncomeVO.getProjectId());
                   profitIncomeVO.setAnalysisId(projectIndexVO.getAnalysisId());
                   idList.add(projectIndexVO.getAnalysisId());
                   profitIncomeVO.setBuildingFunction(projectIndexVO.getBuildingFunction());
                   profitIncomeVO.setBuildPlace(projectIndexVO.getBuildPlace());
                   profitIncomeVO.setStructMethod(projectIndexVO.getStructMethod());
                   profitIncomeVO.setEarthquakeFortification(projectIndexVO.getEarthquakeFortification());
                   profitIncomeVO.setEaveHeight(projectIndexVO.getEaveHeight());
                   profitIncomeVO.setPrefabricationRate(projectIndexVO.getPrefabricationRate());
                   profitIncomeVO.setAssemblySrate(projectIndexVO.getAssemblySrate());
                   profitIncomeVO.setArtificial(projectIndexVO.getArtificial());
                   profitIncomeVO.setSteelBar(projectIndexVO.getSteelBar());
                   profitIncomeVO.setConcrete(projectIndexVO.getConcrete());
                   profitIncomeVO.setCement(projectIndexVO.getCement());
                   profitIncomeVO.setSand(projectIndexVO.getSand());
                   profitIncomeVO.setCrushedStone(projectIndexVO.getCrushedStone());
                   profitIncomeVO.setBlock(projectIndexVO.getBlock());
                   profitIncomeVO.setPrecastReinforcement(projectIndexVO.getPrecastReinforcement());
                   profitIncomeVO.setPrecastConcrete(projectIndexVO.getPrecastConcrete());
                   profitIncomeVO.setStartDate(projectIndexVO.getStartDate());
                   profitIncomeVO.setCompletionDate(projectIndexVO.getCompletionDate());
               }else{
                   profitIncomeVO.setEaveHeight(BigDecimal.ZERO);
                   profitIncomeVO.setPrefabricationRate(BigDecimal.ZERO);
                   profitIncomeVO.setAssemblySrate(BigDecimal.ZERO);
                   profitIncomeVO.setArtificial(BigDecimal.ZERO);
                   profitIncomeVO.setSteelBar(BigDecimal.ZERO);
                   profitIncomeVO.setConcrete(BigDecimal.ZERO);
                   profitIncomeVO.setCement(BigDecimal.ZERO);
                   profitIncomeVO.setSand(BigDecimal.ZERO);
                   profitIncomeVO.setCrushedStone(BigDecimal.ZERO);
                   profitIncomeVO.setBlock(BigDecimal.ZERO);
                   profitIncomeVO.setPrecastReinforcement(BigDecimal.ZERO);
                   profitIncomeVO.setPrecastConcrete(BigDecimal.ZERO);
               }
            }
            //查询主要经济指标子表
            List<MaineconomicindicatorsVO>  detailList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(idList)){
                 detailList = quertAnalysisDetail(idList);
            }
            if(CollectionUtils.isNotEmpty(detailList)){
                Map<Long, List<MaineconomicindicatorsVO>> detailMap = detailList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getMid()
                        ));


                for(ProjectIndexVO profitIncomeVO :projectIndexVOList) {
                    if (detailMap.containsKey(profitIncomeVO.getAnalysisId())) {
                        List<MaineconomicindicatorsVO> maineconomicindicatorsVOList = detailMap.get(profitIncomeVO.getAnalysisId());
                        Map<String, MaineconomicindicatorsVO> mainMap = maineconomicindicatorsVOList.stream().collect(Collectors.toMap(x->x.getSerialNumber(), Function.identity(),(k1, k2) ->k2));
                        if(mainMap.containsKey("1.1")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.1");
                            profitIncomeVO.setEarthCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setEarthCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setEarthCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("1.2")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.2");
                            profitIncomeVO.setBasicsCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setBasicsCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setBasicsCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("1.3")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.3");
                            profitIncomeVO.setSubjectCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setSubjectCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setSubjectCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("1.4")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.4");
                            profitIncomeVO.setMasonryCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setMasonryCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setMasonryCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }

                        if(mainMap.containsKey("1.5")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.5");
                            profitIncomeVO.setWaterproofCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setWaterproofCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setWaterproofCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("1.6")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.6");
                            profitIncomeVO.setPrefabricatedCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setPrefabricatedCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setPrefabricatedCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        // 建筑工程其他 造价（元）
                        if(mainMap.containsKey("1.8")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("1.8");
                            profitIncomeVO.setElseArchitectureCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setElseArchitectureCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setElseArchitectureCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }


                        if(mainMap.containsKey("2.1")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("2.1");
                            profitIncomeVO.setFlooringCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setFlooringCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setFlooringCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("2.2")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("2.2");
                            profitIncomeVO.setWallCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setWallCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setWallCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("2.3")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("2.3");
                            profitIncomeVO.setCeilingCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setCeilingCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setCeilingCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }

                        if(mainMap.containsKey("2.4")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("2.4");
                            profitIncomeVO.setDoorsCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDoorsCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDoorsCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("2.5")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("2.5");
                            profitIncomeVO.setOilPaintCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setOilPaintCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setOilPaintCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        // 装饰工程其他 造价（元）
                        if(mainMap.containsKey("2.6")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("2.6");
                            profitIncomeVO.setDecorationElseCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDecorationElseCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDecorationElseCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }


                        if(mainMap.containsKey("3.1")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("3.1");
                            profitIncomeVO.setElectricCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setElectricCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setElectricCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("3.2")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("3.2");
                            profitIncomeVO.setDrainCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDrainCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDrainCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("3.3")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("3.3");
                            profitIncomeVO.setHeatingCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setHeatingCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setHeatingCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }

                        if(mainMap.containsKey("3.4")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("3.4");
                            profitIncomeVO.setVentilateCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setVentilateCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setVentilateCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("3.5")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("3.5");
                            profitIncomeVO.setConditionerPaintCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setConditionerPaintCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setConditionerPaintCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        // 安装工程其他 造价（元）
                        if(mainMap.containsKey("3.6")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("3.6");
                            profitIncomeVO.setInstallElseCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setInstallElseCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setInstallElseCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }


                        if(mainMap.containsKey("4.1")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.1");
                            profitIncomeVO.setSafetyCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setSafetyCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setSafetyCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("4.2")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.2");
                            profitIncomeVO.setTemplateCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setTemplateCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setTemplateCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("4.3")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.3");
                            profitIncomeVO.setStagingCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setStagingCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setStagingCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }

                        if(mainMap.containsKey("4.4")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.4");
                            profitIncomeVO.setCarriageCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setCarriageCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setCarriageCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("4.5")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.5");
                            profitIncomeVO.setTemporaryCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setTemporaryCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setTemporaryCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        // 安装工程其他 造价（元）
                        if(mainMap.containsKey("4.6")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.6");
                            profitIncomeVO.setDrainWaterCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDrainWaterCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDrainWaterCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if(mainMap.containsKey("4.7")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.7");
                            profitIncomeVO.setRainCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setRainCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setRainCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        // 安装工程其他 造价（元）
                        if(mainMap.containsKey("4.8")){
                            MaineconomicindicatorsVO maineconomicindicatorsVO = mainMap.get("4.8");
                            profitIncomeVO.setMeasureElseCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setMeasureElseCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setMeasureElseCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                    }
                }
            }

            //查询主要经济指标（全费用）
            List<MainanalysisdetailVO>  mainanalysisdetailVOList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(idList)){
                mainanalysisdetailVOList = quertMainanalyDetail(idList);
            }
            if(CollectionUtils.isNotEmpty(mainanalysisdetailVOList)){
                Map<Long, List<MainanalysisdetailVO>> mainanalysisdetailMap = mainanalysisdetailVOList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getMid()
                        ));

                for(ProjectIndexVO profitIncomeVO :projectIndexVOList) {
                    if (mainanalysisdetailMap.containsKey(profitIncomeVO.getAnalysisId())) {
                        List<MainanalysisdetailVO> maineconomicindicatorsVOList = mainanalysisdetailMap.get(profitIncomeVO.getAnalysisId());
                        Map<String, MainanalysisdetailVO> mainMap = maineconomicindicatorsVOList.stream().collect(Collectors.toMap(x->x.getProjectMainName(), Function.identity(),(k1, k2) ->k2));
                        if(mainMap.containsKey("建筑工程")){
                            MainanalysisdetailVO maineconomicindicatorsVO = mainMap.get("建筑工程");
                            profitIncomeVO.setArchitectureCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setArchitectureCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setArchitectureCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());

                        }
                        if(mainMap.containsKey("装饰工程")){
                            MainanalysisdetailVO maineconomicindicatorsVO = mainMap.get("装饰工程");
                            profitIncomeVO.setDecorationCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setDecorationCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setDecorationCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                        }
                        if(mainMap.containsKey("安装工程")){
                            MainanalysisdetailVO maineconomicindicatorsVO = mainMap.get("安装工程");
                            profitIncomeVO.setInstallationCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setInstallationCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setInstallationCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                        }
                        if(mainMap.containsKey("其他")){
                            MainanalysisdetailVO maineconomicindicatorsVO = mainMap.get("其他");
                            profitIncomeVO.setElseEngineeringCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setElseEngineeringCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setElseEngineeringCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                        }
                    }
                }
            }
            //补全二级组织信息
            for(ProjectIndexVO profitIncomeVO : projectIndexVOList){
                CommonResponse<OrgVO> orgVo = iOrgApi.detailById(profitIncomeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        profitIncomeVO.setTwoOrgId(orgVos.getData().getId());
                        profitIncomeVO.setTwoOrgName(orgVos.getData().getName());
                        profitIncomeVO.setTwoOrgCode(orgVos.getData().getCode());
                        profitIncomeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }

            Map<Long, ProjectIndexVO> projectIndexVOListMap = projectIndexVOList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            List<ProjectIndexVO> projectIndexVOS = new ArrayList<>();
            for(ProjectIndexVO projectIndexVO : analysisList){
                if(projectIndexVOListMap.containsKey(projectIndexVO.getProjectId())){
                    ProjectIndexVO projectIndexVO1 = projectIndexVOListMap.get(projectIndexVO.getProjectId());
                    projectIndexVOS.add(projectIndexVO1);
                }
            }

            if(CollectionUtils.isNotEmpty(projectIndexVOS)){
                saveBatch(BeanMapper.mapList(projectIndexVOS, ProjectIndexEntity.class));
            }
        }
    }

    @Override
    public List<ProjectIndexVO> queryProjects(List<Long> idList) {
        return baseMapper.getProjects(idList);
    }

    @Override
    public List<ProjectIndexVO> quertAnalysis(String endDate) {
        return baseMapper.quertAnalysis(endDate);
    }

    @Override
    public List<MaineconomicindicatorsVO> quertAnalysisDetail(List<Long> idList) {
        return baseMapper.quertAnalysisDetail(idList);
    }

    @Override
    public List<MainanalysisdetailVO> quertMainanalyDetail(List<Long> idList) {
        return baseMapper.quertMainanalyDetail(idList);
    }

    @Override
    public List<ProjectIndexVO> dealData(List<ProjectIndexVO> projectIndexVOS) {

        List<ProjectIndexVO> feeNewList = new ArrayList<>();

        //计算排序字段
        for(ProjectIndexVO projectIndexVO :projectIndexVOS){
            projectIndexVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(projectIndexVO.getProjectStatus() == null ? 6:projectIndexVO.getProjectStatus()));
        }

        projectIndexVOS = projectIndexVOS.stream().sorted(Comparator.comparing(ProjectIndexVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ProjectIndexVO>> mapProjectStatusOrder = projectIndexVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectIndexVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProjectIndexVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{

                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectIndexVO::getProjectCreateTime))
                        .collect(Collectors.toList());

                feeNewList.addAll(orgStatusList);
            });

        });
        Integer number = 1;
        for (ProjectIndexVO feeVONum : feeNewList){
            feeVONum.setNumber(number +"");
            number = number + 1;
            feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
        }
        return feeNewList;
    }

}
