/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"profitIncome"})
public class ProfitIncomeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProfitIncomeService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProfitIncomeVO> saveOrUpdate(@RequestBody ProfitIncomeVO saveOrUpdateVO) {
        ProfitIncomeEntity entity = (ProfitIncomeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProfitIncomeEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ProfitIncomeVO vo = (ProfitIncomeVO)BeanMapper.map((Object)((Object)entity), ProfitIncomeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProfitIncomeVO> queryDetail(Long id) {
        ProfitIncomeEntity entity = (ProfitIncomeEntity)((Object)this.service.selectById(id));
        ProfitIncomeVO vo = (ProfitIncomeVO)BeanMapper.map((Object)((Object)entity), ProfitIncomeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProfitIncomeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProfitIncomeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List projectPaymentVOList = BeanMapper.mapList((Iterable)page.getRecords(), ProfitIncomeVO.class);
        List<ProfitIncomeVO> feeNewList = this.service.processingList(projectPaymentVOList);
        pageData.setRecords(feeNewList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String reportingMonth = null;
        if (param.getParams().get("reportingMonth") != null) {
            reportingMonth = ((Parameter)param.getParams().get("reportingMonth")).getValue().toString();
        }
        List list = this.service.queryList(param);
        List<ProfitIncomeVO> feeNewList = this.service.processingList(BeanMapper.mapList((Iterable)list, ProfitIncomeVO.class));
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", feeNewList);
        CommonUtils.setExcelName(response, reportingMonth, "\u9879\u76ee\u6536\u5165\u5206\u6790", "excel/ProfitIncome.xlsx", beans);
    }

    public static String getdate(String date) {
        String[] datel = date.split(" ");
        String[] date2 = datel[0].split("-");
        String date4 = date2[0] + "\u5e74" + date2[1] + "\u6708";
        return date4;
    }

    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        String day = request.getParameter("day");
        this.service.execute(null, day, null);
        return CommonResponse.success((String)"\u6536\u5165\u5206\u6790\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/executeTest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> executeTest(@RequestParam(value="inAdvanceFlag", required=false) Integer inAdvanceFlag, @RequestParam(value="day", required=false) String day, @RequestParam(value="projectIdList", required=false) List<Long> projectIdList) {
        this.service.execute(inAdvanceFlag, day, projectIdList);
        return CommonResponse.success((String)"\u6536\u5165\u5206\u6790\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }
}

