/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProfitEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProfitMapper;
import com.ejianc.business.analysis.service.IProfitService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProfitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="profitService")
public class ProfitServiceImpl
extends BaseServiceImpl<ProfitMapper, ProfitEntity>
implements IProfitService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ProfitMapper profitMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProfitService profitService;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProfitEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProfitEntity::getReportingMonth, (Object)reportingMonth);
        this.profitService.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList) : this.profitIncomeMapper.getProjects(null);
        List<ProfitVO> bqData = this.profitMapper.getIncomeData(reportingMonth, projectIdList);
        List<ProfitVO> ljData = this.profitMapper.getLjData(reportingMonth, projectIdList);
        Map<Object, Object> mapIncome = new HashMap();
        Map<Object, Object> mapLj = new HashMap();
        if (CollectionUtils.isNotEmpty(bqData)) {
            mapIncome = bqData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isNotEmpty(ljData)) {
            mapLj = ljData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List feeVOList = BeanMapper.mapList(profitIncomeVOList, ProfitVO.class);
            for (ProfitVO feeVO : feeVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                List feeVOS;
                feeVO.setReportingMonth(reportingMonth);
                feeVO.setCreateTime(new Date());
                if (mapIncome.containsKey(feeVO.getProjectId())) {
                    feeVOS = (List)mapIncome.get(feeVO.getProjectId());
                    ProfitVO feeVOIncome = (ProfitVO)feeVOS.stream().findFirst().get();
                    feeVO.setIncomeMny(CommonUtils.parseNullValue(feeVOIncome.getIncomeMny()));
                } else {
                    feeVO.setIncomeMny(BigDecimal.ZERO);
                }
                if (mapLj.containsKey(feeVO.getProjectId())) {
                    feeVOS = (List)mapLj.get(feeVO.getProjectId());
                    List collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    ProfitVO feeVOLj = (ProfitVO)collectCompare.stream().findFirst().get();
                    feeVO.setCostMny(CommonUtils.parseNullValue(feeVOLj.getCostMny()));
                } else {
                    feeVO.setCostMny(BigDecimal.ZERO);
                }
                if (!(orgVo = this.orgApi.detailById(feeVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                feeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                feeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                feeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                feeVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            List feeEntityList = BeanMapper.mapList((Iterable)feeVOList, ProfitEntity.class);
            this.profitService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<ProfitVO> dealData(List<ProfitVO> feeVOS) {
        ProfitVO feeVO = new ProfitVO();
        ArrayList<ProfitVO> feeNewList = new ArrayList<ProfitVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            feeNewList.add(feeVO);
        }
        for (ProfitVO profitVO : feeVOS) {
            profitVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(profitVO.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<ProfitVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            ProfitVO projectStatusSumfeeVO = new ProfitVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<ProfitVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProfitVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProfitVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                ProfitVO orgStatusSumfeeVO = new ProfitVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProfitVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((ProfitVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<ProfitVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProfitVO::getProjectCreateTime)).collect(Collectors.toList());
                for (ProfitVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    feeVONum.setIncomeMny(CommonUtils.parseYuanToWan(feeVONum.getIncomeMny()));
                    feeVONum.setCostMny(CommonUtils.parseYuanToWan(feeVONum.getCostMny()));
                    feeVONum.setProfitMny(feeVONum.getIncomeMny().subtract(feeVONum.getCostMny()));
                    feeVONum.setProfitRate(CommonUtils.calculateRate(feeVONum.getProfitMny(), feeVONum.getIncomeMny()));
                }
                feeNewList.addAll((Collection<ProfitVO>)orgStatusList);
            });
        });
        return feeNewList;
    }

    private void getSumData(List<ProfitVO> feeVOS, ProfitVO feeVO) {
        BigDecimal incomeMny = feeVOS.stream().filter(s -> s.getIncomeMny() != null).map(ProfitVO::getIncomeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal costMny = feeVOS.stream().filter(s -> s.getCostMny() != null).map(ProfitVO::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setIncomeMny(CommonUtils.parseYuanToWan(incomeMny));
        feeVO.setCostMny(CommonUtils.parseYuanToWan(costMny));
        feeVO.setProfitMny(feeVO.getIncomeMny().subtract(feeVO.getCostMny()));
        feeVO.setProfitRate(CommonUtils.calculateRate(feeVO.getProfitMny(), feeVO.getIncomeMny()));
    }
}

