/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectPaymentEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProjectPaymentMapper;
import com.ejianc.business.analysis.service.IProjectPaymentService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectPaymentService")
public class ProjectPaymentServiceImpl
extends BaseServiceImpl<ProjectPaymentMapper, ProjectPaymentEntity>
implements IProjectPaymentService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProjectPaymentEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectPaymentEntity::getReportingMonth, (Object)reportingMonth);
        this.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList) : this.profitIncomeMapper.getProjects(null);
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        List<ProjectPaymentVO> enginnerList = this.projectPaymentMapper.quertEngineermeasurement(yearMonth, reportingMonth, projectIdList);
        List<ProjectPaymentVO> enginnerTotalList = this.projectPaymentMapper.quertEngineermeasurementTotal(reportingMonth, projectIdList);
        List<ProjectPaymentVO> costanalysisList = this.projectPaymentMapper.quertCostanalysis(yearMonth, reportingMonth, projectIdList);
        List<ProjectPaymentVO> costanalysisTotalList = this.projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);
        List<ProjectPaymentVO> quertPaymentTotalList = this.projectPaymentMapper.quertPaymentTotal(reportingMonth, projectIdList);
        List<ProjectPaymentVO> quertAnalysisList = this.projectPaymentMapper.quertAnalysis(reportingMonth, projectIdList);
        if (CollectionUtils.isNotEmpty(quertAnalysisList)) {
            List<ProjectPaymentVO> quertCosthuizongList;
            ArrayList<Long> idList = new ArrayList<Long>();
            for (ProjectPaymentVO paymentVO : quertAnalysisList) {
                idList.add(paymentVO.getAnalysisId());
            }
            if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty(quertCosthuizongList = this.projectPaymentMapper.quertCosthuizong(idList))) {
                Map<Long, List<ProjectPaymentVO>> quertCosthuizongListMap = quertCosthuizongList.stream().collect(Collectors.groupingBy(s -> s.getAnalysisId()));
                for (ProjectPaymentVO paymentVO : quertAnalysisList) {
                    if (!quertCosthuizongListMap.containsKey(paymentVO.getAnalysisId())) continue;
                    List<ProjectPaymentVO> projectPaymentVOList = quertCosthuizongListMap.get(paymentVO.getAnalysisId());
                    BigDecimal acostActual = projectPaymentVOList.stream().filter(s -> s.getAcostActual() != null).map(ProjectPaymentVO::getAcostActual).reduce(BigDecimal.ZERO, BigDecimal::add);
                    paymentVO.setAcostActual(acostActual);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List projectPaymentVOList = BeanMapper.mapList(profitIncomeVOList, ProjectPaymentVO.class);
            for (ProjectPaymentVO projectPaymentVO : projectPaymentVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                Map quertAnalysisListMap;
                Map quertPaymentTotalListMap;
                Map costanalysisTotalListMap;
                Map costanalysisListMap;
                Map enginnerTotalListMap;
                Map enginnerListMap;
                ProjectPaymentVO paymentVO;
                projectPaymentVO.setReportingMonth(reportingMonth);
                if (CollectionUtils.isNotEmpty(enginnerList) && (enginnerListMap = enginnerList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)enginnerListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setOwnerAffirmProductionNear(CommonUtils.parseNullValue(paymentVO.getOwnerAffirmProductionNear()));
                    projectPaymentVO.setContractReceiptNear(CommonUtils.parseNullValue(paymentVO.getContractReceiptNear()));
                    projectPaymentVO.setProjectFundsNear(CommonUtils.parseNullValue(paymentVO.getProjectFundsNear()));
                }
                if (CollectionUtils.isNotEmpty(enginnerTotalList) && (enginnerTotalListMap = enginnerTotalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)enginnerTotalListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setOwnerAffirmProduction(CommonUtils.parseNullValue(paymentVO.getOwnerAffirmProduction()));
                    projectPaymentVO.setContractReceipt(CommonUtils.parseNullValue(paymentVO.getContractReceipt()));
                    projectPaymentVO.setProjectFunds(CommonUtils.parseNullValue(paymentVO.getProjectFunds()));
                }
                if (CollectionUtils.isNotEmpty(costanalysisList) && (costanalysisListMap = costanalysisList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)costanalysisListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setActualFinishProductionNear(CommonUtils.parseNullValue(paymentVO.getActualFinishProductionNear()));
                    projectPaymentVO.setActualCostNear(CommonUtils.parseNullValue(paymentVO.getActualCostNear()));
                }
                if (CollectionUtils.isNotEmpty(costanalysisTotalList) && (costanalysisTotalListMap = costanalysisTotalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)costanalysisTotalListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setActualFinishProduction(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                    projectPaymentVO.setActualCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
                }
                if (CollectionUtils.isNotEmpty(quertPaymentTotalList) && (quertPaymentTotalListMap = quertPaymentTotalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)quertPaymentTotalListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setAccountsPayableTotal(CommonUtils.parseNullValue(paymentVO.getAccountsPayableTotal()));
                    projectPaymentVO.setHavePaidTotal(CommonUtils.parseNullValue(paymentVO.getHavePaidTotal()));
                }
                if (CollectionUtils.isNotEmpty(quertAnalysisList) && (quertAnalysisListMap = quertAnalysisList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)quertAnalysisListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setAmountPayable(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(paymentVO.getAccountsPayableTotal()), (BigDecimal)CommonUtils.parseNullValue(paymentVO.getAcostActual())));
                    projectPaymentVO.setAmountPaid(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(paymentVO.getHavePaidTotal()), (BigDecimal)CommonUtils.parseNullValue(paymentVO.getAcostActual())));
                }
                if (!(orgVo = this.orgApi.detailById(projectPaymentVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                projectPaymentVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                projectPaymentVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                projectPaymentVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                projectPaymentVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
            }
            this.saveBatch(BeanMapper.mapList((Iterable)projectPaymentVOList, ProjectPaymentEntity.class));
        }
    }

    @Override
    public List<ProjectPaymentVO> dealData(List<ProjectPaymentVO> projectPaymentVOList) {
        ProjectPaymentVO projectPaymentVO = new ProjectPaymentVO();
        ArrayList<ProjectPaymentVO> proNewList = new ArrayList<ProjectPaymentVO>();
        if (CollectionUtils.isNotEmpty(projectPaymentVOList)) {
            this.getSumData(projectPaymentVOList, projectPaymentVO);
            projectPaymentVO.setNumber("\u5408\u8ba1");
            projectPaymentVO.setId(IdWorker.getId());
            proNewList.add(projectPaymentVO);
            for (ProjectPaymentVO paymentVO : projectPaymentVOList) {
                paymentVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(paymentVO.getProjectStatus() == null ? 6 : paymentVO.getProjectStatus()));
            }
            projectPaymentVOList = projectPaymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getProjectStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProjectPaymentVO>> mapProjectStatusOrder = projectPaymentVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
            mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
                ProjectPaymentVO paymentVO = new ProjectPaymentVO();
                paymentVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
                paymentVO.setId(IdWorker.getId());
                paymentVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
                this.getSumData((List<ProjectPaymentVO>)projectStatusList, paymentVO);
                proNewList.add(paymentVO);
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getOrgStatusOrder)).collect(Collectors.toList());
                Map<Integer, List<ProjectPaymentVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
                mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                    ProjectPaymentVO orgStatusSumpayVO = new ProjectPaymentVO();
                    orgStatusSumpayVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProjectPaymentVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(((ProjectPaymentVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getTwoOrgName());
                    this.getSumData((List<ProjectPaymentVO>)orgStatusList, orgStatusSumpayVO);
                    proNewList.add(orgStatusSumpayVO);
                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getProjectCreateTime)).collect(Collectors.toList());
                    for (ProjectPaymentVO paymentVONum : orgStatusList) {
                        paymentVONum.setNumber(number + "");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setOwnerAffirmProductionNear(CommonUtils.parseYuanToWan(paymentVONum.getOwnerAffirmProductionNear()));
                        paymentVONum.setActualFinishProductionNear(CommonUtils.parseYuanToWan(paymentVONum.getActualFinishProductionNear()));
                        paymentVONum.setActualCostNear(CommonUtils.parseYuanToWan(paymentVONum.getActualCostNear()));
                        paymentVONum.setContractReceiptNear(CommonUtils.parseYuanToWan(paymentVONum.getContractReceiptNear()));
                        paymentVONum.setProjectFundsNear(CommonUtils.parseYuanToWan(paymentVONum.getProjectFundsNear()));
                        paymentVONum.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(paymentVONum.getOwnerAffirmProduction()));
                        paymentVONum.setActualFinishProduction(CommonUtils.parseYuanToWan(paymentVONum.getActualFinishProduction()));
                        paymentVONum.setActualCost(CommonUtils.parseYuanToWan(paymentVONum.getActualCost()));
                        paymentVONum.setContractReceipt(CommonUtils.parseYuanToWan(paymentVONum.getContractReceipt()));
                        paymentVONum.setProjectFunds(CommonUtils.parseYuanToWan(paymentVONum.getProjectFunds()));
                        paymentVONum.setAdvance(CommonUtils.parseYuanToWan(paymentVONum.getAdvance()));
                        paymentVONum.setAmountPayable(CommonUtils.parseYuanToWan(paymentVONum.getAmountPayable()));
                        paymentVONum.setAmountPaid(CommonUtils.parseYuanToWan(paymentVONum.getAmountPaid()));
                        paymentVONum.setConfirmationRateNear(CommonUtils.calculateRate(paymentVONum.getOwnerAffirmProductionNear(), paymentVONum.getActualFinishProductionNear()));
                        paymentVONum.setConfirmationRate(CommonUtils.calculateRate(paymentVONum.getOwnerAffirmProduction(), paymentVONum.getActualFinishProduction()));
                        paymentVONum.setNonPayment(ComputeUtil.safeSub((BigDecimal)paymentVONum.getContractReceipt(), (BigDecimal)paymentVONum.getProjectFunds()));
                        paymentVONum.setNearTotal(CommonUtils.calculateRate(paymentVONum.getProjectFundsNear(), paymentVONum.getOwnerAffirmProductionNear()));
                        paymentVONum.setNearAccumulated(CommonUtils.calculateRate(paymentVONum.getProjectFunds(), paymentVONum.getOwnerAffirmProduction()));
                        paymentVONum.setContractReceiptRate(CommonUtils.calculateRate(paymentVONum.getProjectFunds(), paymentVONum.getContractReceipt()));
                        paymentVONum.setGatheringProject(ComputeUtil.safeSub((BigDecimal)paymentVONum.getProjectFunds(), (BigDecimal)paymentVONum.getAdvance()));
                        paymentVONum.setCostRate(CommonUtils.calculateRate(paymentVONum.getGatheringProject(), paymentVONum.getActualCost()));
                        paymentVONum.setAccountPayable(ComputeUtil.safeSub((BigDecimal)paymentVONum.getAmountPayable(), (BigDecimal)paymentVONum.getAmountPaid()));
                        paymentVONum.setCostToRate(CommonUtils.calculateRate(paymentVONum.getAmountPaid(), projectPaymentVO.getActualCost()));
                    }
                    proNewList.addAll((Collection<ProjectPaymentVO>)orgStatusList);
                });
            });
        }
        return proNewList;
    }

    private void getSumData(List<ProjectPaymentVO> projectPaymentVOList, ProjectPaymentVO projectPaymentVO) {
        BigDecimal ownerAffirmProductionNear = projectPaymentVOList.stream().filter(s -> s.getOwnerAffirmProductionNear() != null).map(ProjectPaymentVO::getOwnerAffirmProductionNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProductionNear = projectPaymentVOList.stream().filter(s -> s.getActualFinishProductionNear() != null).map(ProjectPaymentVO::getActualFinishProductionNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCostNear = projectPaymentVOList.stream().filter(s -> s.getActualCostNear() != null).map(ProjectPaymentVO::getActualCostNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceiptNear = projectPaymentVOList.stream().filter(s -> s.getContractReceiptNear() != null).map(ProjectPaymentVO::getContractReceiptNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFundsNear = projectPaymentVOList.stream().filter(s -> s.getProjectFundsNear() != null).map(ProjectPaymentVO::getProjectFundsNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ownerAffirmProduction = projectPaymentVOList.stream().filter(s -> s.getOwnerAffirmProduction() != null).map(ProjectPaymentVO::getOwnerAffirmProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProduction = projectPaymentVOList.stream().filter(s -> s.getActualFinishProduction() != null).map(ProjectPaymentVO::getActualFinishProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCost = projectPaymentVOList.stream().filter(s -> s.getActualCost() != null).map(ProjectPaymentVO::getActualCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceipt = projectPaymentVOList.stream().filter(s -> s.getContractReceipt() != null).map(ProjectPaymentVO::getContractReceipt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFunds = projectPaymentVOList.stream().filter(s -> s.getProjectFunds() != null).map(ProjectPaymentVO::getProjectFunds).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal advance = projectPaymentVOList.stream().filter(s -> s.getAdvance() != null).map(ProjectPaymentVO::getAdvance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPayable = projectPaymentVOList.stream().filter(s -> s.getAmountPayable() != null).map(ProjectPaymentVO::getAmountPayable).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPaid = projectPaymentVOList.stream().filter(s -> s.getAmountPaid() != null).map(ProjectPaymentVO::getAmountPaid).reduce(BigDecimal.ZERO, BigDecimal::add);
        projectPaymentVO.setOwnerAffirmProductionNear(CommonUtils.parseYuanToWan(ownerAffirmProductionNear));
        projectPaymentVO.setActualFinishProductionNear(CommonUtils.parseYuanToWan(actualFinishProductionNear));
        projectPaymentVO.setActualCostNear(CommonUtils.parseYuanToWan(actualCostNear));
        projectPaymentVO.setContractReceiptNear(CommonUtils.parseYuanToWan(contractReceiptNear));
        projectPaymentVO.setProjectFundsNear(CommonUtils.parseYuanToWan(projectFundsNear));
        projectPaymentVO.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(ownerAffirmProduction));
        projectPaymentVO.setActualFinishProduction(CommonUtils.parseYuanToWan(actualFinishProduction));
        projectPaymentVO.setActualCost(CommonUtils.parseYuanToWan(actualCost));
        projectPaymentVO.setContractReceipt(CommonUtils.parseYuanToWan(contractReceipt));
        projectPaymentVO.setProjectFunds(CommonUtils.parseYuanToWan(projectFunds));
        projectPaymentVO.setAdvance(CommonUtils.parseYuanToWan(advance));
        projectPaymentVO.setAmountPayable(CommonUtils.parseYuanToWan(amountPayable));
        projectPaymentVO.setAmountPaid(CommonUtils.parseYuanToWan(amountPaid));
        projectPaymentVO.setConfirmationRateNear(CommonUtils.calculateRate(projectPaymentVO.getOwnerAffirmProductionNear(), projectPaymentVO.getActualFinishProductionNear()));
        projectPaymentVO.setConfirmationRate(CommonUtils.calculateRate(projectPaymentVO.getOwnerAffirmProduction(), projectPaymentVO.getActualFinishProduction()));
        projectPaymentVO.setNonPayment(ComputeUtil.safeSub((BigDecimal)projectPaymentVO.getContractReceipt(), (BigDecimal)projectPaymentVO.getProjectFunds()));
        projectPaymentVO.setNearTotal(CommonUtils.calculateRate(projectPaymentVO.getProjectFundsNear(), projectPaymentVO.getOwnerAffirmProductionNear()));
        projectPaymentVO.setNearAccumulated(CommonUtils.calculateRate(projectPaymentVO.getProjectFunds(), projectPaymentVO.getOwnerAffirmProduction()));
        projectPaymentVO.setContractReceiptRate(CommonUtils.calculateRate(projectPaymentVO.getProjectFunds(), projectPaymentVO.getContractReceipt()));
        projectPaymentVO.setGatheringProject(ComputeUtil.safeSub((BigDecimal)projectPaymentVO.getProjectFunds(), (BigDecimal)projectPaymentVO.getAdvance()));
        projectPaymentVO.setCostRate(CommonUtils.calculateRate(projectPaymentVO.getGatheringProject(), projectPaymentVO.getActualCost()));
        projectPaymentVO.setAccountPayable(ComputeUtil.safeSub((BigDecimal)projectPaymentVO.getAmountPayable(), (BigDecimal)projectPaymentVO.getAmountPaid()));
        projectPaymentVO.setCostToRate(CommonUtils.calculateRate(projectPaymentVO.getAmountPaid(), projectPaymentVO.getActualCost()));
    }
}

