/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.SettledProBusinessEntity;
import com.ejianc.business.analysis.mapper.SettledProBusinessMapper;
import com.ejianc.business.analysis.service.ISettledProBusinessService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.SettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settledProBusinessService")
public class SettledProBusinessServiceImpl
extends BaseServiceImpl<SettledProBusinessMapper, SettledProBusinessEntity>
implements ISettledProBusinessService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISettledProBusinessService settledProBusinessService;
    @Autowired
    private SettledProBusinessMapper settledProBusinessMapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(SettledProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(SettledProBusinessEntity::getReportingMonth, (Object)reportingMonth);
        this.settledProBusinessService.remove((Wrapper)lambdaFee);
        List<Object> settledProBusinessVOList = new ArrayList();
        settledProBusinessVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.settledProBusinessMapper.queryProjectIds(projectIdList) : this.settledProBusinessMapper.queryProjectIds(null);
        List<Long> projectIds = settledProBusinessVOList.stream().map(SettledProBusinessVO::getProjectId).collect(Collectors.toList());
        List<SettledProBusinessVO> contractVOS = this.settledProBusinessMapper.queryContract(projectIds);
        Map<Object, Object> contractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<SettledProBusinessVO> bookVOS = this.settledProBusinessMapper.queryBook(projectIds);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<SettledProBusinessVO> costanalysisVOS = this.settledProBusinessMapper.queryCostanalysis(projectIds, reportingMonth);
        Map<Object, Object> costanalysisMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            costanalysisMap = costanalysisVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        SettledProBusinessVO settlementFinalizedVO = this.settledProBusinessMapper.querySettlementFinalized(projectIds);
        List<SettledProBusinessVO> applyVOS = this.settledProBusinessMapper.queryApply(projectIds);
        List<SettledProBusinessVO> engineermeasurementVOS = this.settledProBusinessMapper.queryEngineermeasurement(projectIds, reportingMonth);
        Map<Object, Object> engineermeasurementMap = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementVOS)) {
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        for (SettledProBusinessVO settledProBusinessVO : settledProBusinessVOList) {
            CommonResponse orgVO;
            CommonResponse fourOrgVO;
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            CommonResponse orgVo;
            settledProBusinessVO.setReportingMonth(reportingMonth);
            Long projectId = settledProBusinessVO.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                settledProBusinessVO.setPromoter(((SettledProBusinessVO)contractMap.get(projectId)).getPromoter());
                settledProBusinessVO.setPromoterName(((SettledProBusinessVO)contractMap.get(projectId)).getPromoterName());
                settledProBusinessVO.setProjectLocation(((SettledProBusinessVO)contractMap.get(projectId)).getProjectLocation());
                settledProBusinessVO.setContractSignTime(((SettledProBusinessVO)contractMap.get(projectId)).getContractSignTime());
                settledProBusinessVO.setContractStartDate(((SettledProBusinessVO)contractMap.get(projectId)).getContractStartDate());
                settledProBusinessVO.setContractEndDate(((SettledProBusinessVO)contractMap.get(projectId)).getContractEndDate());
                settledProBusinessVO.setContractAmount(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)contractMap.get(projectId)).getContractAmount()));
                settledProBusinessVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)contractMap.get(projectId)).getAcContractAmount()));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                settledProBusinessVO.setUndertakeRate(((SettledProBusinessVO)bookMap.get(projectId)).getUndertakeRate());
                settledProBusinessVO.setTargetRate(((SettledProBusinessVO)bookMap.get(projectId)).getTargetRate());
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                settledProBusinessVO.setContractIncome(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)costanalysisMap.get(projectId)).getContractIncome()));
                settledProBusinessVO.setAcContractIncome(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)costanalysisMap.get(projectId)).getContractIncome()));
                settledProBusinessVO.setRealCost(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)costanalysisMap.get(projectId)).getRealCost()));
                settledProBusinessVO.setAcRealCost(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)costanalysisMap.get(projectId)).getRealCost()));
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                settledProBusinessVO.setSettlementAmount(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)engineermeasurementMap.get(projectId)).getSettlementAmount()));
                settledProBusinessVO.setAcSettlementAmount(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)engineermeasurementMap.get(projectId)).getSettlementAmount()));
                settledProBusinessVO.setContractReceivableMny(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)engineermeasurementMap.get(projectId)).getContractReceivableMny()));
                settledProBusinessVO.setOperatingRevenue(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)engineermeasurementMap.get(projectId)).getOperatingRevenue()));
                settledProBusinessVO.setRealRecrived(CommonUtils.parseYuanToWanZ(((SettledProBusinessVO)engineermeasurementMap.get(projectId)).getRealRecrived()));
            }
            if (settlementFinalizedVO != null) {
                settledProBusinessVO.setSettlementFinalizeDate(settlementFinalizedVO.getCreateTime());
            }
            if ((orgVo = this.orgApi.detailById(settledProBusinessVO.getProjectDepartmentId())).isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                settledProBusinessVO.setThreeOrgId(((OrgVO)orgVos.getData()).getId());
                settledProBusinessVO.setThreeOrgName(((OrgVO)orgVos.getData()).getName());
            }
            if (settledProBusinessVO.getFourOrgId() != null && (fourOrgVO = this.orgApi.detailById(settledProBusinessVO.getFourOrgId())).isSuccess() && null != fourOrgVO.getData()) {
                settledProBusinessVO.setFourOrgName(((OrgVO)fourOrgVO.getData()).getName());
            }
            if (settledProBusinessVO.getContractorName() == null && (orgVO = this.orgApi.detailById(settledProBusinessVO.getContractor())).isSuccess() && null != orgVO.getData()) {
                settledProBusinessVO.setContractorName(((OrgVO)orgVO.getData()).getName());
            }
            settledProBusinessVO.setSettlementCycleDays(ComputeUtil.safeDiv((BigDecimal)new BigDecimal(settledProBusinessVO.getSettlementFinalizeDate().getTime() - settledProBusinessVO.getEndDate().getTime()), (BigDecimal)new BigDecimal(86400000)));
            settledProBusinessVO.setProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)(settledProBusinessVO.getSettlementAmount() != null ? settledProBusinessVO.getSettlementAmount() : BigDecimal.ZERO), (BigDecimal)(settledProBusinessVO.getRealCost() != null ? settledProBusinessVO.getRealCost() : BigDecimal.ZERO)), settledProBusinessVO.getSettlementAmount() != null ? settledProBusinessVO.getSettlementAmount() : BigDecimal.ZERO));
            settledProBusinessVO.setAcProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)(settledProBusinessVO.getAcSettlementAmount() != null ? settledProBusinessVO.getAcSettlementAmount() : BigDecimal.ZERO), (BigDecimal)(settledProBusinessVO.getAcRealCost() != null ? settledProBusinessVO.getAcRealCost() : BigDecimal.ZERO)), settledProBusinessVO.getAcSettlementAmount() != null ? settledProBusinessVO.getAcSettlementAmount() : BigDecimal.ZERO));
            if (settledProBusinessVO.getAcProfitRate().compareTo(settledProBusinessVO.getTargetRate()) == 1) {
                settledProBusinessVO.setCompleteTargetBenefitFlag(Integer.valueOf(1));
            } else {
                settledProBusinessVO.setCompleteTargetBenefitFlag(Integer.valueOf(0));
            }
            if (applyVOS.size() != 0) {
                settledProBusinessVO.setCompleteExamineCashAuditFlag(Integer.valueOf(1));
                continue;
            }
            settledProBusinessVO.setCompleteExamineCashAuditFlag(Integer.valueOf(0));
        }
        List settledProBusinessEntityList = BeanMapper.mapList(settledProBusinessVOList, SettledProBusinessEntity.class);
        this.settledProBusinessService.saveBatch(settledProBusinessEntityList);
    }

    @Override
    public List<SettledProBusinessVO> dealData(List<SettledProBusinessVO> settledProBusinessVOS) {
        SettledProBusinessVO settledProBusinessVO = new SettledProBusinessVO();
        ArrayList<SettledProBusinessVO> newList = new ArrayList<SettledProBusinessVO>();
        if (CollectionUtils.isNotEmpty(settledProBusinessVOS)) {
            this.getSumDate(settledProBusinessVOS, settledProBusinessVO);
            settledProBusinessVO.setNumber("\u5408\u8ba1");
            settledProBusinessVO.setId(Long.valueOf(IdWorker.getId()));
            newList.add(settledProBusinessVO);
        }
        Integer number = 1;
        for (SettledProBusinessVO vo : settledProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            Object object = number;
            Integer n = number = Integer.valueOf(number + 1);
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337": {
                    vo.setProjectCategoryName("\u5de5\u4e1a\u5382\u623f");
                    break;
                }
                case "1470216222511185922": {
                    vo.setProjectCategoryName("\u516c\u5171\u5efa\u7b51");
                    break;
                }
                case "1470216274176622593": {
                    vo.setProjectCategoryName("\u6c11\u7528\u4f4f\u5b85");
                    break;
                }
                case "1470216311648534530": {
                    vo.setProjectCategoryName("\u57fa\u7840\u8bbe\u65bd");
                    break;
                }
                case "1470216348239642626": {
                    vo.setProjectCategoryName("\u5176\u5b83");
                }
            }
            switch (vo.getCompleteTargetBenefitFlag()) {
                case 0: {
                    vo.setCompleteTargetBenefitFlagName("\u5426");
                    break;
                }
                case 1: {
                    vo.setCompleteTargetBenefitFlagName("\u662f");
                }
            }
            switch (vo.getCompleteExamineCashAuditFlag()) {
                case 0: {
                    vo.setCompleteExamineCashAuditFlagName("\u5426");
                    break;
                }
                case 1: {
                    vo.setCompleteExamineCashAuditFlagName("\u662f");
                }
            }
        }
        newList.addAll(settledProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<SettledProBusinessVO> settledProBusinessVOS, SettledProBusinessVO settledProBusinessVO) {
        settledProBusinessVO.setContractAmount(settledProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(SettledProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setAcContractAmount(settledProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(SettledProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setContractIncome(settledProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(SettledProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setAcContractIncome(settledProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(SettledProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setRealCost(settledProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(SettledProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setAcRealCost(settledProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(SettledProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setContractReceivableMny(settledProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(SettledProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setOperatingRevenue(settledProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(SettledProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add));
        settledProBusinessVO.setRealRecrived(settledProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(SettledProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add));
    }
}

