package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目工程造价指标分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_project_index")
public class ProjectIndexEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="analysis_id")
    private Long analysisId; // 查询工程造价指标分析主键id
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="building_function")
    private String buildingFunction; // 建筑功能
    @TableField(value="build_place")
    private String buildPlace; // 建设地点
    @TableField(value="struct_method")
    private String structMethod; // 结构类型
    @TableField(value="earthquake_fortification")
    private String earthquakeFortification; // 抗震设防
    @TableField(value="eave_height")
    private BigDecimal eaveHeight; // 檐高
    @TableField(value="prefabrication_rate")
    private BigDecimal prefabricationRate; // 预制率
    @TableField(value="assembly_srate")
    private BigDecimal assemblySrate; // 装配率
    @TableField(value="total_cost")
    private BigDecimal totalCost; // 总造价(元)
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="completion_date")
    private Date completionDate; // 竣工日期
    @TableField(value="artificial")
    private BigDecimal artificial; //人工（工日）
    @TableField(value="steel_bar")
    private BigDecimal steelBar; // 钢筋
    @TableField(value="concrete")
    private BigDecimal concrete; // 混凝土
    @TableField(value="cement")
    private BigDecimal cement; // 水泥
    @TableField(value="sand")
    private BigDecimal sand; // 砂
    @TableField(value="crushed_stone")
    private BigDecimal crushedStone; // 碎石
    @TableField(value="block")
    private BigDecimal block; // 砌块
    @TableField(value="precast_reinforcement")
    private BigDecimal precastReinforcement; // 预制构件钢筋
    @TableField(value="precast_concrete")
    private BigDecimal precastConcrete; // 预制构件混凝土
    @TableField(value="architecture_cost")
    private BigDecimal architectureCost; // 建筑工程 造价（元）
    @TableField(value="architecture_cost_percentage")
    private BigDecimal architectureCostPercentage; // 建筑工程 占总造价百分比（%）
    @TableField(value="architecture_cost_centiare")
    private BigDecimal architectureCostCentiare; // 建筑工程 平方米造价（元/㎡）
    @TableField(value="decoration_cost")
    private BigDecimal decorationCost; // 装饰工程 造价（元）
    @TableField(value="decoration_cost_percentage")
    private BigDecimal decorationCostPercentage; // 装饰工程 占总造价百分比（%）
    @TableField(value="decoration_cost_centiare")
    private BigDecimal decorationCostCentiare; // 装饰工程 平方米造价（元/㎡）
    @TableField(value="installation_cost")
    private BigDecimal installationCost; // 安装工程 造价（元）
    @TableField(value="installation_cost_percentage")
    private BigDecimal installationCostPercentage; // 安装工程 占总造价百分比（%）
    @TableField(value="installation_cost_centiare")
    private BigDecimal installationCostCentiare; // 安装工程 平方米造价（元/㎡）
    @TableField(value="else_engineering_cost")
    private BigDecimal elseEngineeringCost; // 其他工程 造价（元）
    @TableField(value="else_engineering_cost_percentage")
    private BigDecimal elseEngineeringCostPercentage; // 其他工程 占总造价百分比（%）
    @TableField(value="else_engineering_cost_centiare")
    private BigDecimal elseEngineeringCostCentiare; // 其他工程 平方米造价（元/㎡）
    @TableField(value="earth_cost")
    private BigDecimal earthCost; // 土石方 造价（元）
    @TableField(value="earth_cost_percentage")
    private BigDecimal earthCostPercentage; // 土石方 占总造价百分比（%）
    @TableField(value="earth_cost_centiare")
    private BigDecimal earthCostCentiare; // 土石方 平方米造价（元/㎡）
    @TableField(value="basics_cost")
    private BigDecimal basicsCost; //基础钢筋混凝土结构 造价（元）
    @TableField(value="basics_cost_percentage")
    private BigDecimal basicsCostPercentage; //基础钢筋混凝土结构 占总造价百分比（%）
    @TableField(value="basics_cost_centiare")
    private BigDecimal basicsCostCentiare; //基础钢筋混凝土结构 平方米造价（元/㎡）
    @TableField(value="subject_cost")
    private BigDecimal subjectCost; //主体钢筋混凝土结构 造价（元）
    @TableField(value="subject_cost_percentage")
    private BigDecimal subjectCostPercentage; //主体钢筋混凝土结构 占总造价百分比（%）
    @TableField(value="subject_cost_centiare")
    private BigDecimal subjectCostCentiare; //主体钢筋混凝土结构 平方米造价（元/㎡）
    @TableField(value="masonry_cost")
    private BigDecimal masonryCost; // 砌筑 造价（元）
    @TableField(value="masonry_cost_percentage")
    private BigDecimal masonryCostPercentage; // 砌筑 占总造价百分比（%）
    @TableField(value="masonry_cost_centiare")
    private BigDecimal masonryCostCentiare; // 砌筑 平方米造价（元/㎡）
    @TableField(value="waterproof_cost")
    private BigDecimal waterproofCost; // 防水保温 造价（元）
    @TableField(value="waterproof_cost_percentage")
    private BigDecimal waterproofCostPercentage; // 防水保温 占总造价百分比（%）
    @TableField(value="waterproof_cost_centiare")
    private BigDecimal waterproofCostCentiare; // 防水保温 平方米造价（元/㎡）
    @TableField(value="prefabricated_cost")
    private BigDecimal prefabricatedCost; // 装配式构件 造价（元）
    @TableField(value="prefabricated_cost_percentage")
    private BigDecimal prefabricatedCostPercentage; // 装配式构件 占总造价百分比（%）
    @TableField(value="prefabricated_cost_centiare")
    private BigDecimal prefabricatedCostCentiare; // 装配式构件 平方米造价（元/㎡）
    @TableField(value="else_architecture_cost")
    private BigDecimal elseArchitectureCost; // 建筑工程其他 造价（元）
    @TableField(value="else_architecture_cost_percentage")
    private BigDecimal elseArchitectureCostPercentage; // 建筑工程其他 占总造价百分比（%）
    @TableField(value="else_architecture_cost_centiare")
    private BigDecimal elseArchitectureCostCentiare; // 建筑工程其他 平方米造价（元/㎡）
    @TableField(value="flooring_cost")
    private BigDecimal flooringCost; // 楼地面 造价（元）
    @TableField(value="flooring_cost_percentage")
    private BigDecimal flooringCostPercentage; // 楼地面 占总造价百分比（%）
    @TableField(value="flooring_cost_centiare")
    private BigDecimal flooringCostCentiare; // 楼地面 平方米造价（元/㎡）
    @TableField(value="wall_cost")
    private BigDecimal wallCost; // 墙柱面 造价（元）
    @TableField(value="wall_cost_percentage")
    private BigDecimal wallCostPercentage; // 墙柱面 占总造价百分比（%）
    @TableField(value="wall_cost_centiare")
    private BigDecimal wallCostCentiare; // 墙柱面 平方米造价（元/㎡）
    @TableField(value="ceiling_cost")
    private BigDecimal ceilingCost; // 天 棚 造价（元）
    @TableField(value="ceiling_cost_percentage")
    private BigDecimal ceilingCostPercentage; // 天 棚 占总造价百分比（%）
    @TableField(value="ceiling_cost_centiare")
    private BigDecimal ceilingCostCentiare; // 天 棚 平方米造价（元/㎡）
    @TableField(value="doors_cost")
    private BigDecimal doorsCost; // 门窗 造价（元）
    @TableField(value="doors_cost_percentage")
    private BigDecimal doorsCostPercentage; // 门窗 占总造价百分比（%）
    @TableField(value="doors_cost_centiare")
    private BigDecimal doorsCostCentiare; // 门窗 平方米造价（元/㎡）
    @TableField(value="oil_paint_cost")
    private BigDecimal oilPaintCost; // 油漆、裱糊 造价（元）
    @TableField(value="oil_paint_cost_percentage")
    private BigDecimal oilPaintCostPercentage; // 油漆、裱糊 占总造价百分比（%）
    @TableField(value="oil_paint_cost_centiare")
    private BigDecimal oilPaintCostCentiare; // 油漆、裱糊 平方米造价（元/㎡）
    @TableField(value="decoration_else_cost")
    private BigDecimal decorationElseCost; // 装饰工程其他 造价（元）
    @TableField(value="decoration_else_cost_percentage")
    private BigDecimal decorationElseCostPercentage; // 装饰工程其他 占总造价百分比（%）
    @TableField(value="decoration_else_cost_centiare")
    private BigDecimal decorationElseCostCentiare; // 装饰工程其他 平方米造价（元/㎡）
    @TableField(value="electric_cost")
    private BigDecimal electricCost; // 电器工程 造价（元）
    @TableField(value="electric_cost_percentage")
    private BigDecimal electricCostPercentage; // 电器工程 占总造价百分比（%）
    @TableField(value="electric_cost_centiare")
    private BigDecimal electricCostCentiare; // 电器工程 平方米造价（元/㎡）
    @TableField(value="drain_cost")
    private BigDecimal drainCost; // 给排水工程 造价（元）
    @TableField(value="drain_cost_percentage")
    private BigDecimal drainCostPercentage; // 给排水工程 占总造价百分比（%）
    @TableField(value="drain_cost_centiare")
    private BigDecimal drainCostCentiare; // 给排水工程 平方米造价（元/㎡）
    @TableField(value="heating_cost")
    private BigDecimal heatingCost; // 采暖工程 造价（元）
    @TableField(value="heating_cost_percentage")
    private BigDecimal heatingCostPercentage; // 采暖工程占总造价百分比（%）
    @TableField(value="heating_cost_centiare")
    private BigDecimal heatingCostCentiare; // 采暖工程 平方米造价（元/㎡）
    @TableField(value="ventilate_cost")
    private BigDecimal ventilateCost; // 通风工程 造价（元）
    @TableField(value="ventilate_cost_percentage")
    private BigDecimal ventilateCostPercentage; // 通风工程 占总造价百分比（%）
    @TableField(value="ventilate_cost_centiare")
    private BigDecimal ventilateCostCentiare; // 通风工程 平方米造价（元/㎡）
    @TableField(value="conditioner_paint_cost")
    private BigDecimal conditionerPaintCost; // 空调工程 造价（元）
    @TableField(value="conditioner_paint_cost_percentage")
    private BigDecimal conditionerPaintCostPercentage; // 空调工程 占总造价百分比（%）
    @TableField(value="conditioner_paint_cost_centiare")
    private BigDecimal conditionerPaintCostCentiare; // 空调工程 平方米造价（元/㎡）
    @TableField(value="install_else_cost")
    private BigDecimal installElseCost; // 安装工程其他 造价（元）
    @TableField(value="install_else_cost_percentage")
    private BigDecimal installElseCostPercentage; // 安装工程其他 占总造价百分比（%）
    @TableField(value="install_else_cost_centiare")
    private BigDecimal installElseCostCentiare; // 安装工程其他 平方米造价（元/㎡）
    @TableField(value="safety_cost")
    private BigDecimal safetyCost; // 安全、文明施工费 造价（元）
    @TableField(value="safety_cost_percentage")
    private BigDecimal safetyCostPercentage; // 安全、文明施工费 占总造价百分比（%）
    @TableField(value="safety_cost_centiare")
    private BigDecimal safetyCostCentiare; // 安全、文明施工费 平方米造价（元/㎡）
    @TableField(value="template_cost")
    private BigDecimal templateCost; // 模板及支架 造价（元）
    @TableField(value="template_cost_percentage")
    private BigDecimal templateCostPercentage; // 模板及支架 占总造价百分比（%）
    @TableField(value="template_cost_centiare")
    private BigDecimal templateCostCentiare; // 模板及支架 平方米造价（元/㎡）
    @TableField(value="staging_cost")
    private BigDecimal stagingCost; // 脚手架 造价（元）
    @TableField(value="staging_cost_percentage")
    private BigDecimal stagingCostPercentage; // 脚手架 占总造价百分比（%）
    @TableField(value="staging_cost_centiare")
    private BigDecimal stagingCostCentiare; // 脚手架 平方米造价（元/㎡）
    @TableField(value="carriage_cost")
    private BigDecimal carriageCost; // 垂直运输机械 造价（元）
    @TableField(value="carriage_cost_percentage")
    private BigDecimal carriageCostPercentage; // 垂直运输机械 占总造价百分比（%）
    @TableField(value="carriage_cost_centiare")
    private BigDecimal carriageCostCentiare; // 垂直运输机械 平方米造价（元/㎡）
    @TableField(value="temporary_cost")
    private BigDecimal temporaryCost; // 临设费用 造价（元）
    @TableField(value="temporary_cost_percentage")
    private BigDecimal temporaryCostPercentage; // 临设费用占总造价百分比（%）
    @TableField(value="temporary_cost_centiare")
    private BigDecimal temporaryCostCentiare; // 临设费用 平方米造价（元/㎡）
    @TableField(value="drain_water_cost")
    private BigDecimal drainWaterCost; // 施工排水 造价（元）
    @TableField(value="drain_water_cost_percentage")
    private BigDecimal drainWaterCostPercentage; // 施工排水 占总造价百分比（%）
    @TableField(value="drain_water_cost_centiare")
    private BigDecimal drainWaterCostCentiare; // 施工排水 平方米造价（元/㎡）
    @TableField(value="rain_cost")
    private BigDecimal rainCost; // 施工降水 造价（元）
    @TableField(value="rain_cost_percentage")
    private BigDecimal rainCostPercentage; // 施工降水 占总造价百分比（%）
    @TableField(value="rain_cost_centiare")
    private BigDecimal rainCostCentiare; // 施工降水 平方米造价（元/㎡）
    @TableField(value="measure_else_cost")
    private BigDecimal measureElseCost; // 措施费其他 造价（元）
    @TableField(value="measure_else_cost_percentage")
    private BigDecimal measureElseCostPercentage; // 措施费其他 占总造价百分比（%）
    @TableField(value="measure_else_cost_centiare")
    private BigDecimal measureElseCostCentiare; // 措施费其他 平方米造价（元/㎡）
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="number")
    private String number; // 序号

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }

    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }

    public Long getAnalysisId() {
        return analysisId;
    }

    public void setAnalysisId(Long analysisId) {
        this.analysisId = analysisId;
    }

    public BigDecimal getTotalCost() {
        return totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public String getBuildingFunction() {
        return buildingFunction;
    }

    public void setBuildingFunction(String buildingFunction) {
        this.buildingFunction = buildingFunction;
    }
    public String getBuildPlace() {
        return buildPlace;
    }

    public void setBuildPlace(String buildPlace) {
        this.buildPlace = buildPlace;
    }
    public String getStructMethod() {
        return structMethod;
    }

    public void setStructMethod(String structMethod) {
        this.structMethod = structMethod;
    }
    public String getEarthquakeFortification() {
        return earthquakeFortification;
    }

    public void setEarthquakeFortification(String earthquakeFortification) {
        this.earthquakeFortification = earthquakeFortification;
    }
    public BigDecimal getEaveHeight() {
        return eaveHeight;
    }

    public void setEaveHeight(BigDecimal eaveHeight) {
        this.eaveHeight = eaveHeight;
    }
    public BigDecimal getPrefabricationRate() {
        return prefabricationRate;
    }

    public void setPrefabricationRate(BigDecimal prefabricationRate) {
        this.prefabricationRate = prefabricationRate;
    }
    public BigDecimal getAssemblySrate() {
        return assemblySrate;
    }

    public void setAssemblySrate(BigDecimal assemblySrate) {
        this.assemblySrate = assemblySrate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }
    public BigDecimal getArtificial() {
        return artificial;
    }

    public void setArtificial(BigDecimal artificial) {
        this.artificial = artificial;
    }
    public BigDecimal getSteelBar() {
        return steelBar;
    }

    public void setSteelBar(BigDecimal steelBar) {
        this.steelBar = steelBar;
    }
    public BigDecimal getConcrete() {
        return concrete;
    }

    public void setConcrete(BigDecimal concrete) {
        this.concrete = concrete;
    }
    public BigDecimal getCement() {
        return cement;
    }

    public void setCement(BigDecimal cement) {
        this.cement = cement;
    }
    public BigDecimal getSand() {
        return sand;
    }

    public void setSand(BigDecimal sand) {
        this.sand = sand;
    }
    public BigDecimal getCrushedStone() {
        return crushedStone;
    }

    public void setCrushedStone(BigDecimal crushedStone) {
        this.crushedStone = crushedStone;
    }
    public BigDecimal getBlock() {
        return block;
    }

    public void setBlock(BigDecimal block) {
        this.block = block;
    }
    public BigDecimal getPrecastReinforcement() {
        return precastReinforcement;
    }

    public void setPrecastReinforcement(BigDecimal precastReinforcement) {
        this.precastReinforcement = precastReinforcement;
    }
    public BigDecimal getPrecastConcrete() {
        return precastConcrete;
    }

    public void setPrecastConcrete(BigDecimal precastConcrete) {
        this.precastConcrete = precastConcrete;
    }
    public BigDecimal getArchitectureCost() {
        return architectureCost;
    }

    public void setArchitectureCost(BigDecimal architectureCost) {
        this.architectureCost = architectureCost;
    }
    public BigDecimal getArchitectureCostPercentage() {
        return architectureCostPercentage;
    }

    public void setArchitectureCostPercentage(BigDecimal architectureCostPercentage) {
        this.architectureCostPercentage = architectureCostPercentage;
    }
    public BigDecimal getArchitectureCostCentiare() {
        return architectureCostCentiare;
    }

    public void setArchitectureCostCentiare(BigDecimal architectureCostCentiare) {
        this.architectureCostCentiare = architectureCostCentiare;
    }
    public BigDecimal getDecorationCost() {
        return decorationCost;
    }

    public void setDecorationCost(BigDecimal decorationCost) {
        this.decorationCost = decorationCost;
    }
    public BigDecimal getDecorationCostPercentage() {
        return decorationCostPercentage;
    }

    public void setDecorationCostPercentage(BigDecimal decorationCostPercentage) {
        this.decorationCostPercentage = decorationCostPercentage;
    }
    public BigDecimal getDecorationCostCentiare() {
        return decorationCostCentiare;
    }

    public void setDecorationCostCentiare(BigDecimal decorationCostCentiare) {
        this.decorationCostCentiare = decorationCostCentiare;
    }
    public BigDecimal getInstallationCost() {
        return installationCost;
    }

    public void setInstallationCost(BigDecimal installationCost) {
        this.installationCost = installationCost;
    }
    public BigDecimal getInstallationCostPercentage() {
        return installationCostPercentage;
    }

    public void setInstallationCostPercentage(BigDecimal installationCostPercentage) {
        this.installationCostPercentage = installationCostPercentage;
    }
    public BigDecimal getInstallationCostCentiare() {
        return installationCostCentiare;
    }

    public void setInstallationCostCentiare(BigDecimal installationCostCentiare) {
        this.installationCostCentiare = installationCostCentiare;
    }
    public BigDecimal getElseEngineeringCost() {
        return elseEngineeringCost;
    }

    public void setElseEngineeringCost(BigDecimal elseEngineeringCost) {
        this.elseEngineeringCost = elseEngineeringCost;
    }
    public BigDecimal getElseEngineeringCostPercentage() {
        return elseEngineeringCostPercentage;
    }

    public void setElseEngineeringCostPercentage(BigDecimal elseEngineeringCostPercentage) {
        this.elseEngineeringCostPercentage = elseEngineeringCostPercentage;
    }
    public BigDecimal getElseEngineeringCostCentiare() {
        return elseEngineeringCostCentiare;
    }

    public void setElseEngineeringCostCentiare(BigDecimal elseEngineeringCostCentiare) {
        this.elseEngineeringCostCentiare = elseEngineeringCostCentiare;
    }
    public BigDecimal getEarthCost() {
        return earthCost;
    }

    public void setEarthCost(BigDecimal earthCost) {
        this.earthCost = earthCost;
    }
    public BigDecimal getEarthCostPercentage() {
        return earthCostPercentage;
    }

    public void setEarthCostPercentage(BigDecimal earthCostPercentage) {
        this.earthCostPercentage = earthCostPercentage;
    }
    public BigDecimal getEarthCostCentiare() {
        return earthCostCentiare;
    }

    public void setEarthCostCentiare(BigDecimal earthCostCentiare) {
        this.earthCostCentiare = earthCostCentiare;
    }
    public BigDecimal getBasicsCost() {
        return basicsCost;
    }

    public void setBasicsCost(BigDecimal basicsCost) {
        this.basicsCost = basicsCost;
    }
    public BigDecimal getBasicsCostPercentage() {
        return basicsCostPercentage;
    }

    public void setBasicsCostPercentage(BigDecimal basicsCostPercentage) {
        this.basicsCostPercentage = basicsCostPercentage;
    }
    public BigDecimal getBasicsCostCentiare() {
        return basicsCostCentiare;
    }

    public void setBasicsCostCentiare(BigDecimal basicsCostCentiare) {
        this.basicsCostCentiare = basicsCostCentiare;
    }
    public BigDecimal getSubjectCost() {
        return subjectCost;
    }

    public void setSubjectCost(BigDecimal subjectCost) {
        this.subjectCost = subjectCost;
    }
    public BigDecimal getSubjectCostPercentage() {
        return subjectCostPercentage;
    }

    public void setSubjectCostPercentage(BigDecimal subjectCostPercentage) {
        this.subjectCostPercentage = subjectCostPercentage;
    }
    public BigDecimal getSubjectCostCentiare() {
        return subjectCostCentiare;
    }

    public void setSubjectCostCentiare(BigDecimal subjectCostCentiare) {
        this.subjectCostCentiare = subjectCostCentiare;
    }
    public BigDecimal getMasonryCost() {
        return masonryCost;
    }

    public void setMasonryCost(BigDecimal masonryCost) {
        this.masonryCost = masonryCost;
    }
    public BigDecimal getMasonryCostPercentage() {
        return masonryCostPercentage;
    }

    public void setMasonryCostPercentage(BigDecimal masonryCostPercentage) {
        this.masonryCostPercentage = masonryCostPercentage;
    }
    public BigDecimal getMasonryCostCentiare() {
        return masonryCostCentiare;
    }

    public void setMasonryCostCentiare(BigDecimal masonryCostCentiare) {
        this.masonryCostCentiare = masonryCostCentiare;
    }
    public BigDecimal getWaterproofCost() {
        return waterproofCost;
    }

    public void setWaterproofCost(BigDecimal waterproofCost) {
        this.waterproofCost = waterproofCost;
    }
    public BigDecimal getWaterproofCostPercentage() {
        return waterproofCostPercentage;
    }

    public void setWaterproofCostPercentage(BigDecimal waterproofCostPercentage) {
        this.waterproofCostPercentage = waterproofCostPercentage;
    }
    public BigDecimal getWaterproofCostCentiare() {
        return waterproofCostCentiare;
    }

    public void setWaterproofCostCentiare(BigDecimal waterproofCostCentiare) {
        this.waterproofCostCentiare = waterproofCostCentiare;
    }
    public BigDecimal getPrefabricatedCost() {
        return prefabricatedCost;
    }

    public void setPrefabricatedCost(BigDecimal prefabricatedCost) {
        this.prefabricatedCost = prefabricatedCost;
    }
    public BigDecimal getPrefabricatedCostPercentage() {
        return prefabricatedCostPercentage;
    }

    public void setPrefabricatedCostPercentage(BigDecimal prefabricatedCostPercentage) {
        this.prefabricatedCostPercentage = prefabricatedCostPercentage;
    }
    public BigDecimal getPrefabricatedCostCentiare() {
        return prefabricatedCostCentiare;
    }

    public void setPrefabricatedCostCentiare(BigDecimal prefabricatedCostCentiare) {
        this.prefabricatedCostCentiare = prefabricatedCostCentiare;
    }
    public BigDecimal getElseArchitectureCost() {
        return elseArchitectureCost;
    }

    public void setElseArchitectureCost(BigDecimal elseArchitectureCost) {
        this.elseArchitectureCost = elseArchitectureCost;
    }
    public BigDecimal getElseArchitectureCostPercentage() {
        return elseArchitectureCostPercentage;
    }

    public void setElseArchitectureCostPercentage(BigDecimal elseArchitectureCostPercentage) {
        this.elseArchitectureCostPercentage = elseArchitectureCostPercentage;
    }
    public BigDecimal getElseArchitectureCostCentiare() {
        return elseArchitectureCostCentiare;
    }

    public void setElseArchitectureCostCentiare(BigDecimal elseArchitectureCostCentiare) {
        this.elseArchitectureCostCentiare = elseArchitectureCostCentiare;
    }
    public BigDecimal getFlooringCost() {
        return flooringCost;
    }

    public void setFlooringCost(BigDecimal flooringCost) {
        this.flooringCost = flooringCost;
    }
    public BigDecimal getFlooringCostPercentage() {
        return flooringCostPercentage;
    }

    public void setFlooringCostPercentage(BigDecimal flooringCostPercentage) {
        this.flooringCostPercentage = flooringCostPercentage;
    }
    public BigDecimal getFlooringCostCentiare() {
        return flooringCostCentiare;
    }

    public void setFlooringCostCentiare(BigDecimal flooringCostCentiare) {
        this.flooringCostCentiare = flooringCostCentiare;
    }
    public BigDecimal getWallCost() {
        return wallCost;
    }

    public void setWallCost(BigDecimal wallCost) {
        this.wallCost = wallCost;
    }
    public BigDecimal getWallCostPercentage() {
        return wallCostPercentage;
    }

    public void setWallCostPercentage(BigDecimal wallCostPercentage) {
        this.wallCostPercentage = wallCostPercentage;
    }
    public BigDecimal getWallCostCentiare() {
        return wallCostCentiare;
    }

    public void setWallCostCentiare(BigDecimal wallCostCentiare) {
        this.wallCostCentiare = wallCostCentiare;
    }
    public BigDecimal getCeilingCost() {
        return ceilingCost;
    }

    public void setCeilingCost(BigDecimal ceilingCost) {
        this.ceilingCost = ceilingCost;
    }
    public BigDecimal getCeilingCostPercentage() {
        return ceilingCostPercentage;
    }

    public void setCeilingCostPercentage(BigDecimal ceilingCostPercentage) {
        this.ceilingCostPercentage = ceilingCostPercentage;
    }
    public BigDecimal getCeilingCostCentiare() {
        return ceilingCostCentiare;
    }

    public void setCeilingCostCentiare(BigDecimal ceilingCostCentiare) {
        this.ceilingCostCentiare = ceilingCostCentiare;
    }
    public BigDecimal getDoorsCost() {
        return doorsCost;
    }

    public void setDoorsCost(BigDecimal doorsCost) {
        this.doorsCost = doorsCost;
    }
    public BigDecimal getDoorsCostPercentage() {
        return doorsCostPercentage;
    }

    public void setDoorsCostPercentage(BigDecimal doorsCostPercentage) {
        this.doorsCostPercentage = doorsCostPercentage;
    }
    public BigDecimal getDoorsCostCentiare() {
        return doorsCostCentiare;
    }

    public void setDoorsCostCentiare(BigDecimal doorsCostCentiare) {
        this.doorsCostCentiare = doorsCostCentiare;
    }
    public BigDecimal getOilPaintCost() {
        return oilPaintCost;
    }

    public void setOilPaintCost(BigDecimal oilPaintCost) {
        this.oilPaintCost = oilPaintCost;
    }
    public BigDecimal getOilPaintCostPercentage() {
        return oilPaintCostPercentage;
    }

    public void setOilPaintCostPercentage(BigDecimal oilPaintCostPercentage) {
        this.oilPaintCostPercentage = oilPaintCostPercentage;
    }
    public BigDecimal getOilPaintCostCentiare() {
        return oilPaintCostCentiare;
    }

    public void setOilPaintCostCentiare(BigDecimal oilPaintCostCentiare) {
        this.oilPaintCostCentiare = oilPaintCostCentiare;
    }
    public BigDecimal getDecorationElseCost() {
        return decorationElseCost;
    }

    public void setDecorationElseCost(BigDecimal decorationElseCost) {
        this.decorationElseCost = decorationElseCost;
    }
    public BigDecimal getDecorationElseCostPercentage() {
        return decorationElseCostPercentage;
    }

    public void setDecorationElseCostPercentage(BigDecimal decorationElseCostPercentage) {
        this.decorationElseCostPercentage = decorationElseCostPercentage;
    }
    public BigDecimal getDecorationElseCostCentiare() {
        return decorationElseCostCentiare;
    }

    public void setDecorationElseCostCentiare(BigDecimal decorationElseCostCentiare) {
        this.decorationElseCostCentiare = decorationElseCostCentiare;
    }
    public BigDecimal getElectricCost() {
        return electricCost;
    }

    public void setElectricCost(BigDecimal electricCost) {
        this.electricCost = electricCost;
    }
    public BigDecimal getElectricCostPercentage() {
        return electricCostPercentage;
    }

    public void setElectricCostPercentage(BigDecimal electricCostPercentage) {
        this.electricCostPercentage = electricCostPercentage;
    }
    public BigDecimal getElectricCostCentiare() {
        return electricCostCentiare;
    }

    public void setElectricCostCentiare(BigDecimal electricCostCentiare) {
        this.electricCostCentiare = electricCostCentiare;
    }
    public BigDecimal getDrainCost() {
        return drainCost;
    }

    public void setDrainCost(BigDecimal drainCost) {
        this.drainCost = drainCost;
    }
    public BigDecimal getDrainCostPercentage() {
        return drainCostPercentage;
    }

    public void setDrainCostPercentage(BigDecimal drainCostPercentage) {
        this.drainCostPercentage = drainCostPercentage;
    }
    public BigDecimal getDrainCostCentiare() {
        return drainCostCentiare;
    }

    public void setDrainCostCentiare(BigDecimal drainCostCentiare) {
        this.drainCostCentiare = drainCostCentiare;
    }
    public BigDecimal getHeatingCost() {
        return heatingCost;
    }

    public void setHeatingCost(BigDecimal heatingCost) {
        this.heatingCost = heatingCost;
    }
    public BigDecimal getHeatingCostPercentage() {
        return heatingCostPercentage;
    }

    public void setHeatingCostPercentage(BigDecimal heatingCostPercentage) {
        this.heatingCostPercentage = heatingCostPercentage;
    }
    public BigDecimal getHeatingCostCentiare() {
        return heatingCostCentiare;
    }

    public void setHeatingCostCentiare(BigDecimal heatingCostCentiare) {
        this.heatingCostCentiare = heatingCostCentiare;
    }
    public BigDecimal getVentilateCost() {
        return ventilateCost;
    }

    public void setVentilateCost(BigDecimal ventilateCost) {
        this.ventilateCost = ventilateCost;
    }
    public BigDecimal getVentilateCostPercentage() {
        return ventilateCostPercentage;
    }

    public void setVentilateCostPercentage(BigDecimal ventilateCostPercentage) {
        this.ventilateCostPercentage = ventilateCostPercentage;
    }
    public BigDecimal getVentilateCostCentiare() {
        return ventilateCostCentiare;
    }

    public void setVentilateCostCentiare(BigDecimal ventilateCostCentiare) {
        this.ventilateCostCentiare = ventilateCostCentiare;
    }
    public BigDecimal getConditionerPaintCost() {
        return conditionerPaintCost;
    }

    public void setConditionerPaintCost(BigDecimal conditionerPaintCost) {
        this.conditionerPaintCost = conditionerPaintCost;
    }
    public BigDecimal getConditionerPaintCostPercentage() {
        return conditionerPaintCostPercentage;
    }

    public void setConditionerPaintCostPercentage(BigDecimal conditionerPaintCostPercentage) {
        this.conditionerPaintCostPercentage = conditionerPaintCostPercentage;
    }
    public BigDecimal getConditionerPaintCostCentiare() {
        return conditionerPaintCostCentiare;
    }

    public void setConditionerPaintCostCentiare(BigDecimal conditionerPaintCostCentiare) {
        this.conditionerPaintCostCentiare = conditionerPaintCostCentiare;
    }
    public BigDecimal getInstallElseCost() {
        return installElseCost;
    }

    public void setInstallElseCost(BigDecimal installElseCost) {
        this.installElseCost = installElseCost;
    }
    public BigDecimal getInstallElseCostPercentage() {
        return installElseCostPercentage;
    }

    public void setInstallElseCostPercentage(BigDecimal installElseCostPercentage) {
        this.installElseCostPercentage = installElseCostPercentage;
    }
    public BigDecimal getInstallElseCostCentiare() {
        return installElseCostCentiare;
    }

    public void setInstallElseCostCentiare(BigDecimal installElseCostCentiare) {
        this.installElseCostCentiare = installElseCostCentiare;
    }
    public BigDecimal getSafetyCost() {
        return safetyCost;
    }

    public void setSafetyCost(BigDecimal safetyCost) {
        this.safetyCost = safetyCost;
    }
    public BigDecimal getSafetyCostPercentage() {
        return safetyCostPercentage;
    }

    public void setSafetyCostPercentage(BigDecimal safetyCostPercentage) {
        this.safetyCostPercentage = safetyCostPercentage;
    }
    public BigDecimal getSafetyCostCentiare() {
        return safetyCostCentiare;
    }

    public void setSafetyCostCentiare(BigDecimal safetyCostCentiare) {
        this.safetyCostCentiare = safetyCostCentiare;
    }
    public BigDecimal getTemplateCost() {
        return templateCost;
    }

    public void setTemplateCost(BigDecimal templateCost) {
        this.templateCost = templateCost;
    }
    public BigDecimal getTemplateCostPercentage() {
        return templateCostPercentage;
    }

    public void setTemplateCostPercentage(BigDecimal templateCostPercentage) {
        this.templateCostPercentage = templateCostPercentage;
    }
    public BigDecimal getTemplateCostCentiare() {
        return templateCostCentiare;
    }

    public void setTemplateCostCentiare(BigDecimal templateCostCentiare) {
        this.templateCostCentiare = templateCostCentiare;
    }
    public BigDecimal getStagingCost() {
        return stagingCost;
    }

    public void setStagingCost(BigDecimal stagingCost) {
        this.stagingCost = stagingCost;
    }
    public BigDecimal getStagingCostPercentage() {
        return stagingCostPercentage;
    }

    public void setStagingCostPercentage(BigDecimal stagingCostPercentage) {
        this.stagingCostPercentage = stagingCostPercentage;
    }
    public BigDecimal getStagingCostCentiare() {
        return stagingCostCentiare;
    }

    public void setStagingCostCentiare(BigDecimal stagingCostCentiare) {
        this.stagingCostCentiare = stagingCostCentiare;
    }
    public BigDecimal getCarriageCost() {
        return carriageCost;
    }

    public void setCarriageCost(BigDecimal carriageCost) {
        this.carriageCost = carriageCost;
    }
    public BigDecimal getCarriageCostPercentage() {
        return carriageCostPercentage;
    }

    public void setCarriageCostPercentage(BigDecimal carriageCostPercentage) {
        this.carriageCostPercentage = carriageCostPercentage;
    }
    public BigDecimal getCarriageCostCentiare() {
        return carriageCostCentiare;
    }

    public void setCarriageCostCentiare(BigDecimal carriageCostCentiare) {
        this.carriageCostCentiare = carriageCostCentiare;
    }
    public BigDecimal getTemporaryCost() {
        return temporaryCost;
    }

    public void setTemporaryCost(BigDecimal temporaryCost) {
        this.temporaryCost = temporaryCost;
    }
    public BigDecimal getTemporaryCostPercentage() {
        return temporaryCostPercentage;
    }

    public void setTemporaryCostPercentage(BigDecimal temporaryCostPercentage) {
        this.temporaryCostPercentage = temporaryCostPercentage;
    }
    public BigDecimal getTemporaryCostCentiare() {
        return temporaryCostCentiare;
    }

    public void setTemporaryCostCentiare(BigDecimal temporaryCostCentiare) {
        this.temporaryCostCentiare = temporaryCostCentiare;
    }
    public BigDecimal getDrainWaterCost() {
        return drainWaterCost;
    }

    public void setDrainWaterCost(BigDecimal drainWaterCost) {
        this.drainWaterCost = drainWaterCost;
    }
    public BigDecimal getDrainWaterCostPercentage() {
        return drainWaterCostPercentage;
    }

    public void setDrainWaterCostPercentage(BigDecimal drainWaterCostPercentage) {
        this.drainWaterCostPercentage = drainWaterCostPercentage;
    }
    public BigDecimal getDrainWaterCostCentiare() {
        return drainWaterCostCentiare;
    }

    public void setDrainWaterCostCentiare(BigDecimal drainWaterCostCentiare) {
        this.drainWaterCostCentiare = drainWaterCostCentiare;
    }
    public BigDecimal getRainCost() {
        return rainCost;
    }

    public void setRainCost(BigDecimal rainCost) {
        this.rainCost = rainCost;
    }
    public BigDecimal getRainCostPercentage() {
        return rainCostPercentage;
    }

    public void setRainCostPercentage(BigDecimal rainCostPercentage) {
        this.rainCostPercentage = rainCostPercentage;
    }
    public BigDecimal getRainCostCentiare() {
        return rainCostCentiare;
    }

    public void setRainCostCentiare(BigDecimal rainCostCentiare) {
        this.rainCostCentiare = rainCostCentiare;
    }
    public BigDecimal getMeasureElseCost() {
        return measureElseCost;
    }

    public void setMeasureElseCost(BigDecimal measureElseCost) {
        this.measureElseCost = measureElseCost;
    }
    public BigDecimal getMeasureElseCostPercentage() {
        return measureElseCostPercentage;
    }

    public void setMeasureElseCostPercentage(BigDecimal measureElseCostPercentage) {
        this.measureElseCostPercentage = measureElseCostPercentage;
    }
    public BigDecimal getMeasureElseCostCentiare() {
        return measureElseCostCentiare;
    }

    public void setMeasureElseCostCentiare(BigDecimal measureElseCostCentiare) {
        this.measureElseCostCentiare = measureElseCostCentiare;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
