package com.ejianc.business.analysis.controller;

import java.io.Serializable;

import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.analysis.bean.AuthenticRightEntity;
import com.ejianc.business.analysis.service.IAuthenticRightService;
import com.ejianc.business.analysis.vo.AuthenticRightVO;

/**
 * 项目确权情况分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("authenticRight")
public class AuthenticRightController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IAuthenticRightService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AuthenticRightVO> saveOrUpdate(@RequestBody AuthenticRightVO saveOrUpdateVO) {
        AuthenticRightEntity entity = BeanMapper.map(saveOrUpdateVO, AuthenticRightEntity.class);
        service.saveOrUpdate(entity, false);
        AuthenticRightVO vo = BeanMapper.map(entity, AuthenticRightVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AuthenticRightVO> queryDetail(Long id) {
        AuthenticRightEntity entity = service.selectById(id);
        AuthenticRightVO vo = BeanMapper.map(entity, AuthenticRightVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuthenticRightVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AuthenticRightVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AuthenticRightVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AuthenticRightVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 筛选栏：  项目,组织 */
        String searchText = null;
        String reportingMonth = null;
        List<Integer> projectStatus = new ArrayList<>();
        if(param.getParams().get("reportingMonth") != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
        }
        if(param.getParams().get("projectStatus") != null){
            String status = param.getParams().get("projectStatus").getValue().toString();
            String[] strs = status.split(",");
            for(String s : strs){
                projectStatus.add(Integer.parseInt(s));
            }

        }
        if(param.getSearchText() != null){
            searchText = param.getSearchText();
        }
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Map<String, Object> paramMapper = new HashMap<>();
        paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
        paramMapper.put("commonOrgIds", commonOrgIds);
        paramMapper.put("departmentIds", departmentIds);
        paramMapper.put("projectStatus", projectStatus);
        paramMapper.put("searchText", searchText);
        paramMapper.put("reportingMonth", reportingMonth);//报表日期
        List<AuthenticRightVO> authenticRightVOList = service.queryList(paramMapper);


        List<AuthenticRightVO> authenticRightVOS = service.processingList(authenticRightVOList);
        IPage<AuthenticRightVO> page = new Page<>();
        page = new Page<>(page.getCurrent(), param.getPageSize(),authenticRightVOS.size());
        page.setRecords(authenticRightVOS);
        return CommonResponse.success("查询列表数据成功！",page);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AuthenticRightEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AuthenticRight-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAuthenticRightData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AuthenticRightVO>> refAuthenticRightData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AuthenticRightEntity> page = service.queryPage(param,false);
        IPage<AuthenticRightVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuthenticRightVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     *
     * @return
     */
    @RequestMapping(value = "/execute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        //定时任务设置天数，执行当前天数到上月当前天数
        String day = request.getParameter("day");
        //此日期方便手动调用接口数据
        String date = request.getParameter("date");
        service.execute(day,date);
        return CommonResponse.success("项目确权情况分析数据生成成功！");
    }

    /**
     *
     * @return
     */
    @RequestMapping(value = "/executeTest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> executeTest(String day, String date) {
       /* //定时任务设置天数，执行当前天数到上月当前天数
        String day = request.getParameter("day");
        //此日期方便手动调用接口数据
        String date = request.getParameter("date");*/
        service.execute(day,date);
        return CommonResponse.success("项目确权情况分析数据生成成功！");
    }

}
