package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectPaymentEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProjectPaymentMapper;
import com.ejianc.business.analysis.service.IProjectPaymentService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工程确权收付款情况
 * 
 * @author generator
 * 
 */
@Service("projectPaymentService")
public class ProjectPaymentServiceImpl extends BaseServiceImpl<ProjectPaymentMapper, ProjectPaymentEntity> implements IProjectPaymentService{

    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;

    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ProjectPaymentEntity> lambdaFee = Wrappers.<ProjectPaymentEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ProjectPaymentEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectPaymentEntity::getReportingMonth, reportingMonth);
        remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }

        //获取间接费明细数据
        //获取当年月初的年月
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        //查询中间计量工程计量本年值
        List<ProjectPaymentVO> enginnerList = projectPaymentMapper.quertEngineermeasurement(yearMonth, reportingMonth, projectIdList);

        //查询中间计量工程计量开累值
        List<ProjectPaymentVO> enginnerTotalList = projectPaymentMapper.quertEngineermeasurementTotal(reportingMonth, projectIdList);

        //查询实际成本本年值
        List<ProjectPaymentVO> costanalysisList = projectPaymentMapper.quertCostanalysis(yearMonth, reportingMonth, projectIdList);

        //查询实际成本开累值
        List<ProjectPaymentVO> costanalysisTotalList = projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);

        //查询付款登记
        List<ProjectPaymentVO> quertPaymentTotalList = projectPaymentMapper.quertPaymentTotal(reportingMonth,projectIdList);

        //查询实际成本
        List<ProjectPaymentVO> quertAnalysisList = projectPaymentMapper.quertAnalysis(reportingMonth,projectIdList);
        if(CollectionUtils.isNotEmpty(quertAnalysisList)){
            List<Long> idList = new ArrayList<>();
            for(ProjectPaymentVO paymentVO : quertAnalysisList){
                idList.add(paymentVO.getAnalysisId());
            }
            if(CollectionUtils.isNotEmpty(idList)){
                //实际成本明细
                List<ProjectPaymentVO>  quertCosthuizongList = projectPaymentMapper.quertCosthuizong(idList);
                if(CollectionUtils.isNotEmpty(quertCosthuizongList)){
                    Map<Long, List<ProjectPaymentVO>> quertCosthuizongListMap = quertCosthuizongList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getAnalysisId()
                            ));

                    for(ProjectPaymentVO paymentVO :quertAnalysisList){
                        if(quertCosthuizongListMap.containsKey(paymentVO.getAnalysisId())){
                            List<ProjectPaymentVO> projectPaymentVOList = quertCosthuizongListMap.get(paymentVO.getAnalysisId());
                            BigDecimal acostActual = projectPaymentVOList.stream().filter(s->s.getAcostActual()!=null).map(ProjectPaymentVO::getAcostActual)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            paymentVO.setAcostActual(acostActual);//间接费+其他
                        }
                    }
                }

            }
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<ProjectPaymentVO> projectPaymentVOList = BeanMapper.mapList(profitIncomeVOList, ProjectPaymentVO.class);
            for(ProjectPaymentVO projectPaymentVO : projectPaymentVOList){
                projectPaymentVO.setReportingMonth(reportingMonth);
                //筛入中间计量年累值
                if(CollectionUtils.isNotEmpty(enginnerList)){
                    Map<Long, ProjectPaymentVO> enginnerListMap = enginnerList.stream()
                            .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    if(enginnerListMap.containsKey(projectPaymentVO.getProjectId())){
                        ProjectPaymentVO paymentVO = enginnerListMap.get(projectPaymentVO.getProjectId());
                        projectPaymentVO.setOwnerAffirmProductionNear(CommonUtils.parseNullValue(paymentVO.getOwnerAffirmProductionNear()));
                        projectPaymentVO.setContractReceiptNear(CommonUtils.parseNullValue(paymentVO.getContractReceiptNear()));
                        projectPaymentVO.setProjectFundsNear(CommonUtils.parseNullValue(paymentVO.getProjectFundsNear()));
                    }
                }
                if(CollectionUtils.isNotEmpty(enginnerTotalList)){
                    Map<Long, ProjectPaymentVO> enginnerTotalListMap = enginnerTotalList.stream()
                            .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    //筛入中间计量开累值
                    if(enginnerTotalListMap.containsKey(projectPaymentVO.getProjectId())){
                        ProjectPaymentVO paymentVO = enginnerTotalListMap.get(projectPaymentVO.getProjectId());
                        projectPaymentVO.setOwnerAffirmProduction(CommonUtils.parseNullValue(paymentVO.getOwnerAffirmProduction()));
                        projectPaymentVO.setContractReceipt(CommonUtils.parseNullValue(paymentVO.getContractReceipt()));
                        projectPaymentVO.setProjectFunds(CommonUtils.parseNullValue(paymentVO.getProjectFunds()));
                    }
                }

                if(CollectionUtils.isNotEmpty(costanalysisList)){
                    Map<Long, ProjectPaymentVO> costanalysisListMap = costanalysisList.stream()
                            .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    //筛入实际成本本年值
                    if(costanalysisListMap.containsKey(projectPaymentVO.getProjectId())){
                        ProjectPaymentVO paymentVO = costanalysisListMap.get(projectPaymentVO.getProjectId());
                        projectPaymentVO.setActualFinishProductionNear(CommonUtils.parseNullValue(paymentVO.getActualFinishProductionNear()));
                        projectPaymentVO.setActualCostNear(CommonUtils.parseNullValue(paymentVO.getActualCostNear()));
                    }
                }
                if(CollectionUtils.isNotEmpty(costanalysisTotalList)){
                    Map<Long, ProjectPaymentVO> costanalysisTotalListMap = costanalysisTotalList.stream()
                            .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    //筛入实际成本开累值
                    if(costanalysisTotalListMap.containsKey(projectPaymentVO.getProjectId())){
                        ProjectPaymentVO paymentVO = costanalysisTotalListMap.get(projectPaymentVO.getProjectId());
                        projectPaymentVO.setActualFinishProduction(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                        projectPaymentVO.setActualCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
                    }
                }
                if(CollectionUtils.isNotEmpty(quertPaymentTotalList)){
                    Map<Long, ProjectPaymentVO> quertPaymentTotalListMap = quertPaymentTotalList.stream()
                            .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    //筛入实际成本开累值
                    if(quertPaymentTotalListMap.containsKey(projectPaymentVO.getProjectId())){
                        ProjectPaymentVO paymentVO = quertPaymentTotalListMap.get(projectPaymentVO.getProjectId());
                        projectPaymentVO.setAccountsPayableTotal(CommonUtils.parseNullValue(paymentVO.getAccountsPayableTotal()));
                        projectPaymentVO.setHavePaidTotal(CommonUtils.parseNullValue(paymentVO.getHavePaidTotal()));
                    }
                }
                //应付款金额，已付款金额赋值
                if(CollectionUtils.isNotEmpty(quertAnalysisList)){
                    Map<Long, ProjectPaymentVO> quertAnalysisListMap = quertAnalysisList.stream()
                            .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    //筛入实际成本开累值
                    if(quertAnalysisListMap.containsKey(projectPaymentVO.getProjectId())){
                        ProjectPaymentVO paymentVO = quertAnalysisListMap.get(projectPaymentVO.getProjectId());
                        projectPaymentVO.setAmountPayable(ComputeUtil.safeAdd(CommonUtils.parseNullValue(paymentVO.getAccountsPayableTotal()),CommonUtils.parseNullValue(paymentVO.getAcostActual())));//应付款金额
                        projectPaymentVO.setAmountPaid(ComputeUtil.safeAdd(CommonUtils.parseNullValue(paymentVO.getHavePaidTotal()),CommonUtils.parseNullValue(paymentVO.getAcostActual())));//已付款金额
                    }
                }
                CommonResponse<OrgVO> orgVo = orgApi.detailById(projectPaymentVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        projectPaymentVO.setTwoOrgId(orgVos.getData().getId());
                        projectPaymentVO.setTwoOrgName(orgVos.getData().getName());
                        projectPaymentVO.setTwoOrgCode(orgVos.getData().getCode());
                        projectPaymentVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }
            saveBatch(BeanMapper.mapList(projectPaymentVOList, ProjectPaymentEntity.class));
        }

    }

    @Override
    public List<ProjectPaymentVO> dealData(List<ProjectPaymentVO> projectPaymentVOList) {
        //处理第一行合计值
        ProjectPaymentVO projectPaymentVO = new ProjectPaymentVO();
        ArrayList<ProjectPaymentVO> proNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(projectPaymentVOList)){
            getSumData(projectPaymentVOList, projectPaymentVO);
            projectPaymentVO.setNumber("合计");
            projectPaymentVO.setId(IdWorker.getId());
            proNewList.add(projectPaymentVO);

            //计算排序字段
            for(ProjectPaymentVO paymentVO :projectPaymentVOList){
                paymentVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(paymentVO.getProjectStatus() == null ? 6:paymentVO.getProjectStatus()));
            }

            //计算项目状态合计
            projectPaymentVOList = projectPaymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getProjectStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProjectPaymentVO>> mapProjectStatusOrder = projectPaymentVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectStatusOrder()
                    ));

            mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
                ProjectPaymentVO paymentVO = new ProjectPaymentVO();
                paymentVO.setNumber("项目状态合计");
                paymentVO.setId(IdWorker.getId());
                paymentVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
                getSumData(projectStatusList, paymentVO);
                proNewList.add(paymentVO);

                //计算组织状态合计
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getOrgStatusOrder))
                        .collect(Collectors.toList());
                Map<Integer, List<ProjectPaymentVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getOrgStatusOrder()
                        ));

                mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                    ProjectPaymentVO orgStatusSumpayVO = new ProjectPaymentVO();
                    orgStatusSumpayVO.setNumber("单位小计");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                    getSumData(orgStatusList, orgStatusSumpayVO);
                    proNewList.add(orgStatusSumpayVO);

                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getProjectCreateTime))
                            .collect(Collectors.toList());
                    for (ProjectPaymentVO paymentVONum : orgStatusList){
                        paymentVONum.setNumber(number +"");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setOwnerAffirmProductionNear(CommonUtils.parseYuanToWan(paymentVONum.getOwnerAffirmProductionNear()));
                        paymentVONum.setActualFinishProductionNear(CommonUtils.parseYuanToWan(paymentVONum.getActualFinishProductionNear()));
                        paymentVONum.setActualCostNear(CommonUtils.parseYuanToWan(paymentVONum.getActualCostNear()));
                        paymentVONum.setContractReceiptNear(CommonUtils.parseYuanToWan(paymentVONum.getContractReceiptNear()));
                        paymentVONum.setProjectFundsNear(CommonUtils.parseYuanToWan(paymentVONum.getProjectFundsNear()));
                        paymentVONum.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(paymentVONum.getOwnerAffirmProduction()));
                        paymentVONum.setActualFinishProduction(CommonUtils.parseYuanToWan(paymentVONum.getActualFinishProduction()));
                        paymentVONum.setActualCost(CommonUtils.parseYuanToWan(paymentVONum.getActualCost()));
                        paymentVONum.setContractReceipt(CommonUtils.parseYuanToWan(paymentVONum.getContractReceipt()));
                        paymentVONum.setProjectFunds(CommonUtils.parseYuanToWan(paymentVONum.getProjectFunds()));
                        paymentVONum.setAdvance(CommonUtils.parseYuanToWan(paymentVONum.getAdvance()));
                        paymentVONum.setAmountPayable(CommonUtils.parseYuanToWan(paymentVONum.getAmountPayable()));
                        paymentVONum.setAmountPaid(CommonUtils.parseYuanToWan(paymentVONum.getAmountPaid()));

                        //计算确权率
                        paymentVONum.setConfirmationRateNear(CommonUtils.calculateRate(paymentVONum.getOwnerAffirmProductionNear(),paymentVONum.getActualFinishProductionNear()));
                        paymentVONum.setConfirmationRate(CommonUtils.calculateRate(paymentVONum.getOwnerAffirmProduction(),paymentVONum.getActualFinishProduction()));
                        paymentVONum.setNonPayment(ComputeUtil.safeSub(paymentVONum.getContractReceipt(),paymentVONum.getProjectFunds()));
                        paymentVONum.setNearTotal(CommonUtils.calculateRate(paymentVONum.getProjectFundsNear(),paymentVONum.getOwnerAffirmProductionNear()));
                        paymentVONum.setNearAccumulated(CommonUtils.calculateRate(paymentVONum.getProjectFunds(),paymentVONum.getOwnerAffirmProduction()));
                        paymentVONum.setContractReceiptRate(CommonUtils.calculateRate(paymentVONum.getProjectFunds(),paymentVONum.getContractReceipt()));
                        paymentVONum.setGatheringProject(ComputeUtil.safeSub(paymentVONum.getProjectFunds(),paymentVONum.getAdvance()));
                        paymentVONum.setCostRate(CommonUtils.calculateRate(paymentVONum.getGatheringProject(),paymentVONum.getActualCost()));
                        paymentVONum.setAccountPayable(ComputeUtil.safeSub(paymentVONum.getAmountPayable(),paymentVONum.getAmountPaid()));
                        paymentVONum.setCostToRate(CommonUtils.calculateRate(paymentVONum.getAmountPaid(),projectPaymentVO.getActualCost()));
                    }
                    proNewList.addAll(orgStatusList);
                });
            });
        }
        return proNewList;
    }

    private void getSumData(List<ProjectPaymentVO> projectPaymentVOList, ProjectPaymentVO projectPaymentVO) {

        BigDecimal ownerAffirmProductionNear = projectPaymentVOList.stream().filter(s->s.getOwnerAffirmProductionNear()!=null).map(ProjectPaymentVO::getOwnerAffirmProductionNear)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProductionNear = projectPaymentVOList.stream().filter(s->s.getActualFinishProductionNear()!=null).map(ProjectPaymentVO::getActualFinishProductionNear)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCostNear = projectPaymentVOList.stream().filter(s->s.getActualCostNear()!=null).map(ProjectPaymentVO::getActualCostNear)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceiptNear = projectPaymentVOList.stream().filter(s->s.getContractReceiptNear()!=null).map(ProjectPaymentVO::getContractReceiptNear)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFundsNear = projectPaymentVOList.stream().filter(s->s.getProjectFundsNear()!=null).map(ProjectPaymentVO::getProjectFundsNear)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ownerAffirmProduction = projectPaymentVOList.stream().filter(s->s.getOwnerAffirmProduction()!=null).map(ProjectPaymentVO::getOwnerAffirmProduction)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProduction = projectPaymentVOList.stream().filter(s->s.getActualFinishProduction()!=null).map(ProjectPaymentVO::getActualFinishProduction)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCost = projectPaymentVOList.stream().filter(s->s.getActualCost()!=null).map(ProjectPaymentVO::getActualCost)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceipt = projectPaymentVOList.stream().filter(s->s.getContractReceipt()!=null).map(ProjectPaymentVO::getContractReceipt)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFunds = projectPaymentVOList.stream().filter(s->s.getProjectFunds()!=null).map(ProjectPaymentVO::getProjectFunds)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal advance = projectPaymentVOList.stream().filter(s->s.getAdvance()!=null).map(ProjectPaymentVO::getAdvance)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPayable = projectPaymentVOList.stream().filter(s->s.getAmountPayable()!=null).map(ProjectPaymentVO::getAmountPayable)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPaid = projectPaymentVOList.stream().filter(s->s.getAmountPaid()!=null).map(ProjectPaymentVO::getAmountPaid)
                .reduce(BigDecimal.ZERO, BigDecimal::add);


        //转万元赋值
        projectPaymentVO.setOwnerAffirmProductionNear(CommonUtils.parseYuanToWan(ownerAffirmProductionNear));
        projectPaymentVO.setActualFinishProductionNear(CommonUtils.parseYuanToWan(actualFinishProductionNear));
        projectPaymentVO.setActualCostNear(CommonUtils.parseYuanToWan(actualCostNear));
        projectPaymentVO.setContractReceiptNear(CommonUtils.parseYuanToWan(contractReceiptNear));
        projectPaymentVO.setProjectFundsNear(CommonUtils.parseYuanToWan(projectFundsNear));
        projectPaymentVO.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(ownerAffirmProduction));
        projectPaymentVO.setActualFinishProduction(CommonUtils.parseYuanToWan(actualFinishProduction));
        projectPaymentVO.setActualCost(CommonUtils.parseYuanToWan(actualCost));
        projectPaymentVO.setContractReceipt(CommonUtils.parseYuanToWan(contractReceipt));
        projectPaymentVO.setProjectFunds(CommonUtils.parseYuanToWan(projectFunds));
        projectPaymentVO.setAdvance(CommonUtils.parseYuanToWan(advance));
        projectPaymentVO.setAmountPayable(CommonUtils.parseYuanToWan(amountPayable));
        projectPaymentVO.setAmountPaid(CommonUtils.parseYuanToWan(amountPaid));

        //计算确权率
        projectPaymentVO.setConfirmationRateNear(CommonUtils.calculateRate(projectPaymentVO.getOwnerAffirmProductionNear(),projectPaymentVO.getActualFinishProductionNear()));
        projectPaymentVO.setConfirmationRate(CommonUtils.calculateRate(projectPaymentVO.getOwnerAffirmProduction(),projectPaymentVO.getActualFinishProduction()));
        projectPaymentVO.setNonPayment(ComputeUtil.safeSub(projectPaymentVO.getContractReceipt(),projectPaymentVO.getProjectFunds()));
        projectPaymentVO.setNearTotal(CommonUtils.calculateRate(projectPaymentVO.getProjectFundsNear(),projectPaymentVO.getOwnerAffirmProductionNear()));
        projectPaymentVO.setNearAccumulated(CommonUtils.calculateRate(projectPaymentVO.getProjectFunds(),projectPaymentVO.getOwnerAffirmProduction()));
        projectPaymentVO.setContractReceiptRate(CommonUtils.calculateRate(projectPaymentVO.getProjectFunds(),projectPaymentVO.getContractReceipt()));
        projectPaymentVO.setGatheringProject(ComputeUtil.safeSub(projectPaymentVO.getProjectFunds(),projectPaymentVO.getAdvance()));
        projectPaymentVO.setCostRate(CommonUtils.calculateRate(projectPaymentVO.getGatheringProject(),projectPaymentVO.getActualCost()));
        projectPaymentVO.setAccountPayable(ComputeUtil.safeSub(projectPaymentVO.getAmountPayable(),projectPaymentVO.getAmountPaid()));
        projectPaymentVO.setCostToRate(CommonUtils.calculateRate(projectPaymentVO.getAmountPaid(),projectPaymentVO.getActualCost()));

    }
}
