package com.ejianc.business.analysis.service.impl;

import com.ejianc.business.analysis.bean.UpdateProjectEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.UpdateProjectMapper;
import com.ejianc.business.analysis.service.*;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.RequestVO;
import com.ejianc.business.analysis.vo.UpdateProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 更新报表
 * 
 * @author generator
 * 
 */
@Service("updateProjectService")
public class UpdateProjectServiceImpl extends BaseServiceImpl<UpdateProjectMapper, UpdateProjectEntity> implements IUpdateProjectService{
    @Autowired
    private IActualValueService actualValueService;//实际产值利润情况分析表 1
    @Autowired
    private ICompleteSettlementService completeSettlementService;//项目成本指标分析3
    @Autowired
    private IConstructionBudgetService constructionBudgetService;//施工图预算编制情况 4
    @Autowired
    private IConstructProBusinessService constructProBusinessService;//在建项目商务报表 5
    @Autowired
    private IFeeService feeService;//现场管理费 6
    @Autowired
    private IGoldService goldService;//项目财务两金分析 7
    @Autowired
    private IProDurationDelayService proDurationDelayService;//工期延误项目成本风险化解情况 8
    @Autowired
    private IProfitService profitService;//财务账面利润情况 9
    @Autowired
    private IProfitIncomeService profitIncomeService;//收入分析 10
    @Autowired
    private IProjectBusinessService projectBusinessService;//中建科技项目商务策划分析管理报表 11
    @Autowired
    private IProjectCheckService projectCheckService;//项目考核兑现统计表 12
    @Autowired
    private IProjectIndexService projectIndexService;//项目工程造价指标分析 13
    @Autowired
    private IProjectPaymentService projectPaymentService;//工程确权收付款情况 14
    @Autowired
    private IProSignReserveService proSignReserveService;//项目责任书签订及风险金预留情况 15
    @Autowired
    private IQualityService qualityService;//项目工程质量问题增加成本统计表 16
    @Autowired
    private IRiskService riskService;//项目人员风险金预留分配表 17
    @Autowired
    private ISettledProBusinessService settledProBusinessService;//竣工已结算项目商务报表 18
    @Autowired
    private IUnsettledProBusinessService unsettledProBusinessService;//竣工未结算项目商务报表 19
    @Autowired
    private ICostService costService;//薪酬及三公费用占现场经费比例分析 20
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;


    @Override
    public void updateProject(RequestVO requestVO) {
        //实际产值利润情况分析表  actualValue/preExecute
        if(requestVO.getBillState() == 1){
            actualValueService.execute(null,null,requestVO.getProjectIdList());
        }
        //项目成本指标分析
        if(requestVO.getBillState() == 3){
            completeSettlementService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 4){
            constructionBudgetService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 5){
            constructProBusinessService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 6){
            feeService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 7){
            goldService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 8){
            proDurationDelayService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 9){
            profitService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 10){
            profitIncomeService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 11){
            projectBusinessService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 12){
            projectCheckService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 13){
            projectIndexService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 14){
            projectPaymentService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 15){
            proSignReserveService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 16){
            qualityService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 17){
            riskService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 18){
            settledProBusinessService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 19){
            unsettledProBusinessService.execute(null,null,requestVO.getProjectIdList());
        }
        if(requestVO.getBillState() == 20){
            costService.execute(null,null,requestVO.getProjectIdList());
        }

        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(requestVO.getProjectIdList())){
            profitIncomeVOList = profitIncomeMapper.getProjects(requestVO.getProjectIdList());
            List<UpdateProjectVO> updateProjectVOList = BeanMapper.mapList(profitIncomeVOList, UpdateProjectVO.class);
            for(UpdateProjectVO updateProjectVO : updateProjectVOList){
                updateProjectVO.setReportingMonth(requestVO.getReportingMonth());
                updateProjectVO.setAnalusisName(requestVO.getAnalusisName());
                updateProjectVO.setUpdateUserName(requestVO.getUpdateUserName());
            }
            saveBatch(BeanMapper.mapList(updateProjectVOList, UpdateProjectEntity.class));
        }

    }
}
