/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.FeeMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IFeeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feeService")
public class FeeServiceImpl
extends BaseServiceImpl<FeeMapper, FeeEntity>
implements IFeeService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private FeeMapper feeMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IFeeService feeService;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(FeeEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(FeeEntity::getReportingMonth, (Object)reportingMonth);
        this.feeService.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList) : this.profitIncomeMapper.getProjects(null);
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        List<FeeVO> bqData = this.feeMapper.getBqData(yearMonth, reportingMonth, projectIdList);
        List<FeeVO> ljData = this.feeMapper.getLjData(reportingMonth, projectIdList);
        Map<Object, Object> mapBq = new HashMap();
        Map<Object, Object> mapLj = new HashMap();
        if (CollectionUtils.isNotEmpty(bqData)) {
            mapBq = bqData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isNotEmpty(ljData)) {
            mapLj = ljData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List feeVOList = BeanMapper.mapList(profitIncomeVOList, FeeVO.class);
            for (FeeVO feeVO : feeVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                List feeVOS;
                feeVO.setReportingMonth(reportingMonth);
                feeVO.setCreateTime(new Date());
                if (mapBq.containsKey(feeVO.getProjectId())) {
                    feeVOS = (List)mapBq.get(feeVO.getProjectId());
                    FeeVO feeVOBq = (FeeVO)feeVOS.stream().findFirst().get();
                    feeVO.setYearProduction(CommonUtils.parseNullValue(feeVOBq.getYearProduction()));
                    feeVO.setYearFee(CommonUtils.parseNullValue(feeVOBq.getYearFee()));
                } else {
                    feeVO.setYearProduction(BigDecimal.ZERO);
                    feeVO.setYearFee(BigDecimal.ZERO);
                }
                if (mapLj.containsKey(feeVO.getProjectId())) {
                    feeVOS = (List)mapLj.get(feeVO.getProjectId());
                    List collectCompare = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    FeeVO feeVOLj = (FeeVO)collectCompare.stream().findFirst().get();
                    feeVO.setSumProduction(CommonUtils.parseNullValue(feeVOLj.getSumProduction()));
                    feeVO.setSumFee(CommonUtils.parseNullValue(feeVOLj.getSumFee()));
                } else {
                    feeVO.setSumProduction(BigDecimal.ZERO);
                    feeVO.setSumFee(BigDecimal.ZERO);
                }
                if (!(orgVo = this.orgApi.detailById(feeVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                feeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                feeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                feeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                feeVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            List feeEntityList = BeanMapper.mapList((Iterable)feeVOList, FeeEntity.class);
            this.feeService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<FeeVO> dealData(List<FeeVO> feeVOS) {
        FeeVO feeVO = new FeeVO();
        ArrayList<FeeVO> feeNewList = new ArrayList<FeeVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            feeNewList.add(feeVO);
        }
        for (FeeVO feeVO2 : feeVOS) {
            feeVO2.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVO2.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<FeeVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            FeeVO projectStatusSumfeeVO = new FeeVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<FeeVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(FeeVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<FeeVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                FeeVO orgStatusSumfeeVO = new FeeVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((FeeVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((FeeVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<FeeVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(FeeVO::getProjectCreateTime)).collect(Collectors.toList());
                for (FeeVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    feeVONum.setYearProduction(CommonUtils.parseYuanToWan(feeVONum.getYearProduction()));
                    feeVONum.setYearFee(CommonUtils.parseYuanToWan(feeVONum.getYearFee()));
                    feeVONum.setSumProduction(CommonUtils.parseYuanToWan(feeVONum.getSumProduction()));
                    feeVONum.setSumFee(CommonUtils.parseYuanToWan(feeVONum.getSumFee()));
                    feeVONum.setYearRate(CommonUtils.calculateRate(feeVONum.getYearFee(), feeVONum.getYearProduction()));
                    feeVONum.setSumRate(CommonUtils.calculateRate(feeVONum.getSumFee(), feeVONum.getSumProduction()));
                }
                feeNewList.addAll((Collection<FeeVO>)orgStatusList);
            });
        });
        return feeNewList;
    }

    private void getSumData(List<FeeVO> feeVOS, FeeVO feeVO) {
        BigDecimal yearProduction = feeVOS.stream().map(FeeVO::getYearProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yearFee = feeVOS.stream().map(FeeVO::getYearFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumProduction = feeVOS.stream().map(FeeVO::getSumProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumFee = feeVOS.stream().map(FeeVO::getSumFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setYearProduction(CommonUtils.parseYuanToWan(yearProduction));
        feeVO.setYearFee(CommonUtils.parseYuanToWan(yearFee));
        feeVO.setSumProduction(CommonUtils.parseYuanToWan(sumProduction));
        feeVO.setSumFee(CommonUtils.parseYuanToWan(sumFee));
        feeVO.setYearRate(CommonUtils.calculateRate(feeVO.getYearFee(), feeVO.getYearProduction()));
        feeVO.setSumRate(CommonUtils.calculateRate(feeVO.getSumFee(), feeVO.getSumProduction()));
    }
}

