/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="profitIncomeService")
public class ProfitIncomeServiceImpl
extends BaseServiceImpl<ProfitIncomeMapper, ProfitIncomeEntity>
implements IProfitIncomeService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ProfitIncomeMapper mapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaPro = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaPro.in(ProfitIncomeEntity::getProjectId, projectIdList);
        }
        lambdaPro.in(ProfitIncomeEntity::getReportingMonth, new Object[]{reportingMonth});
        this.remove((Wrapper)lambdaPro);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.queryProjects(projectIdList) : (inAdvanceFlag == 1 ? this.queryProjects(null) : this.queryProjects(null));
        List<ProfitIncomeVO> costanalysisList = this.queryCostanalysis(reportingMonth);
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                List<ProfitIncomeVO> engineermeasurementList;
                Map<Long, List<ProfitIncomeVO>> costanalysisListGrBy;
                profitIncomeVO.setReportingMonth(reportingMonth);
                if (CollectionUtils.isNotEmpty(costanalysisList) && (costanalysisListGrBy = costanalysisList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(profitIncomeVO.getProjectId())) {
                    List<ProfitIncomeVO> profitIncomeVOS = costanalysisListGrBy.get(profitIncomeVO.getProjectId());
                    List collectCompare = profitIncomeVOS.stream().sorted(Comparator.comparing(ProfitIncomeVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    ProfitIncomeVO profitIncomeVO1 = (ProfitIncomeVO)collectCompare.stream().findFirst().get();
                    profitIncomeVO.setRealProduct(profitIncomeVO1.getCumulativeIncome() == null ? new BigDecimal("0") : profitIncomeVO1.getCumulativeIncome());
                    profitIncomeVO.setCostAnalysisCreateTime(profitIncomeVO1.getCostAnalysisCreateTime());
                    profitIncomeVO.setCreateTime(new Date());
                }
                if (CollectionUtils.isNotEmpty(engineermeasurementList = this.queryEngineermeasurement(reportingMonth))) {
                    Map engineermeasurementListMap = engineermeasurementList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
                    if (engineermeasurementListMap.containsKey(profitIncomeVO.getProjectId())) {
                        ProfitIncomeVO profitIncomeVO1 = (ProfitIncomeVO)engineermeasurementListMap.get(profitIncomeVO.getProjectId());
                        profitIncomeVO.setNotarizeProduct(profitIncomeVO1.getCurrentBatch() == null ? new BigDecimal(0) : profitIncomeVO1.getCurrentBatch());
                    } else {
                        profitIncomeVO.setNotarizeProduct(new BigDecimal(0));
                    }
                }
                if (profitIncomeVO.getProjectStatus() != null && profitIncomeVO.getProjectStatus() == 5) {
                    profitIncomeVO.setNotarizeProduct(CommonUtils.setBigDecimalDefaultValue(profitIncomeVO.getRealProduct()));
                }
                profitIncomeVO.setUnliquidated(ComputeUtil.safeSub((BigDecimal)profitIncomeVO.getRealProduct(), (BigDecimal)profitIncomeVO.getNotarizeProduct()));
                CommonResponse orgVo = this.iOrgApi.detailById(profitIncomeVO.getProjectDepartmentId());
                if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                profitIncomeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                profitIncomeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                profitIncomeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                profitIncomeVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            this.logger.info("-----------------------------------------\u6536\u5165\u5206\u6790\u751f\u6210\u6570\u636e,\u622a\u6b62\u65e5\u671f:" + reportingMonth + " :" + JSONObject.toJSONString(profitIncomeVOList));
            this.saveBatch(BeanMapper.mapList(profitIncomeVOList, ProfitIncomeEntity.class));
        }
    }

    @Override
    public List<ProfitIncomeVO> queryProject(String endDate) {
        return ((ProfitIncomeMapper)this.baseMapper).getProject(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryCostanalysis(String endDate) {
        return ((ProfitIncomeMapper)this.baseMapper).getCostanalysis(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryEngineermeasurement(String endDate) {
        return ((ProfitIncomeMapper)this.baseMapper).getEngineermeasurement(endDate);
    }

    @Override
    public List<ProfitIncomeVO> queryProjects(List<Long> idList) {
        return ((ProfitIncomeMapper)this.baseMapper).getProjects(idList);
    }

    @Override
    public List<ProfitIncomeVO> processingList(List<ProfitIncomeVO> profitIncomeVOList) {
        ProfitIncomeVO profitIncomeVO = new ProfitIncomeVO();
        ArrayList<ProfitIncomeVO> feeNewList = new ArrayList<ProfitIncomeVO>();
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            this.getSumData(profitIncomeVOList, profitIncomeVO);
            profitIncomeVO.setNumber("\u5408\u8ba1");
            profitIncomeVO.setId(Long.valueOf(com.ejianc.support.idworker.util.IdWorker.getId()));
            feeNewList.add(profitIncomeVO);
        }
        Iterator<Object> iterator = profitIncomeVOList.iterator();
        while (iterator.hasNext()) {
            ProfitIncomeVO profitIncomeVO2;
            profitIncomeVO2.setProjectStatusOrder(CommonUtils.getProjectOrderNum((profitIncomeVO2 = (ProfitIncomeVO)iterator.next()).getProjectStatus() == null ? 6 : profitIncomeVO2.getProjectStatus()));
        }
        profitIncomeVOList = profitIncomeVOList.stream().sorted(Comparator.comparing(ProfitIncomeVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<ProfitIncomeVO>> mapProjectStatusOrder = profitIncomeVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            ProfitIncomeVO projectStatusSumfeeVO = new ProfitIncomeVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(com.ejianc.support.idworker.util.IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<ProfitIncomeVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProfitIncomeVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProfitIncomeVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                ProfitIncomeVO orgStatusSumfeeVO = new ProfitIncomeVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProfitIncomeVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((ProfitIncomeVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<ProfitIncomeVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProfitIncomeVO::getProjectCreateTime)).collect(Collectors.toList());
                for (ProfitIncomeVO proNum : orgStatusList) {
                    proNum.setNumber(number + "");
                    number = number + 1;
                    proNum.setProjectStatusName(CommonUtils.getProjectStatusName(proNum.getProjectStatus()));
                    proNum.setRealProduct(CommonUtils.parseYuanToWan(proNum.getRealProduct()));
                    proNum.setNotarizeProduct(CommonUtils.parseYuanToWan(proNum.getNotarizeProduct()));
                    proNum.setUnliquidated(CommonUtils.parseYuanToWan(proNum.getUnliquidated()));
                }
                feeNewList.addAll((Collection<ProfitIncomeVO>)orgStatusList);
            });
        });
        return feeNewList;
    }

    private void getSumData(List<ProfitIncomeVO> profitIncomeVOList, ProfitIncomeVO feeVO) {
        BigDecimal realProduct = profitIncomeVOList.stream().filter(s -> s.getRealProduct() != null).map(ProfitIncomeVO::getRealProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal notarizeProduct = profitIncomeVOList.stream().filter(s -> s.getNotarizeProduct() != null).map(ProfitIncomeVO::getNotarizeProduct).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal unliquidated = profitIncomeVOList.stream().filter(s -> s.getUnliquidated() != null).map(ProfitIncomeVO::getUnliquidated).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setRealProduct(CommonUtils.parseYuanToWan(realProduct));
        feeVO.setNotarizeProduct(CommonUtils.parseYuanToWan(notarizeProduct));
        feeVO.setUnliquidated(CommonUtils.parseYuanToWan(unliquidated));
    }

    @Override
    public List<ProfitIncomeVO> queryListPage(Map<String, Object> paramMapper) {
        return this.mapper.queryList(paramMapper);
    }

    @Override
    public void deleteByReportingMonth(String reportingMonth) {
        this.mapper.deleteByReportingMonth(reportingMonth);
    }
}

