/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.QualityEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.QualityMapper;
import com.ejianc.business.analysis.service.IQualityService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.QualityVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qualityService")
public class QualityServiceImpl
extends BaseServiceImpl<QualityMapper, QualityEntity>
implements IQualityService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private IQualityService qualityService;
    @Autowired
    private QualityMapper qualityMapper;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(QualityEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(QualityEntity::getReportingMonth, (Object)reportingMonth);
        this.qualityService.remove((Wrapper)lambdaFee);
        List<Long> projectIds = this.qualityMapper.getProjectIds(reportingMonth);
        ArrayList<Long> projectIdAll = new ArrayList();
        List<Object> profitIncomeVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            profitIncomeVOList = this.profitIncomeMapper.getProjects(projectIdList);
            projectIdAll = projectIdList;
        } else {
            profitIncomeVOList = this.profitIncomeMapper.getProjects(projectIds);
            projectIdAll = projectIds;
        }
        List<QualityVO> riskVOList = this.qualityMapper.getDataAll(reportingMonth, projectIdAll);
        Map<Object, Object> mapPro = new HashMap();
        Map<Object, Object> mapProAndPeriod = new HashMap();
        if (CollectionUtils.isNotEmpty(riskVOList)) {
            mapPro = riskVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            mapProAndPeriod = riskVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId() + "-" + s.getReportingMonth()));
        }
        ArrayList lastList = new ArrayList();
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List riskVOProList = BeanMapper.mapList(profitIncomeVOList, QualityVO.class);
            for (QualityVO riskVO : riskVOProList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                riskVO.setReportingMonth(reportingMonth);
                riskVO.setCreateTime(new Date());
                if (!mapPro.containsKey(riskVO.getProjectId())) continue;
                List riskVOS = (List)mapPro.get(riskVO.getProjectId());
                List collectCompare = riskVOS.stream().sorted(Comparator.comparing(QualityVO::getReportingMonth).reversed()).collect(Collectors.toList());
                QualityVO riskVOPeriod = (QualityVO)collectCompare.stream().findFirst().get();
                String key = riskVO.getProjectId() + "-" + riskVOPeriod.getReportingMonth();
                if (!mapProAndPeriod.containsKey(key)) continue;
                List riskVOListLast = (List)mapProAndPeriod.get(key);
                CommonResponse orgVo = this.orgApi.detailById(riskVO.getProjectDepartmentId());
                if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                    for (QualityVO riskVOLast : riskVOListLast) {
                        riskVOLast.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                        riskVOLast.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                        riskVOLast.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                        riskVOLast.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
                        riskVOLast.setOrgId(riskVO.getOrgId());
                        riskVOLast.setOrgName(riskVO.getOrgName());
                        riskVOLast.setProjectDepartmentId(riskVO.getProjectDepartmentId());
                        riskVOLast.setProjectName(riskVO.getProjectName());
                        riskVOLast.setProjectCode(riskVO.getProjectCode());
                        riskVOLast.setProjectStatus(riskVO.getProjectStatus());
                        riskVOLast.setCreateTime(new Date());
                        riskVOLast.setProjectCreateTime(riskVO.getProjectCreateTime());
                        riskVOLast.setReportingMonth(reportingMonth);
                    }
                }
                lastList.addAll(riskVOListLast);
            }
        }
        if (CollectionUtils.isNotEmpty(lastList)) {
            List riskEntityList = BeanMapper.mapList(lastList, QualityEntity.class);
            this.qualityService.saveBatch(riskEntityList);
        }
    }

    @Override
    public List<QualityVO> dealData(List<QualityVO> feeVOS) {
        QualityVO feeVO = new QualityVO();
        ArrayList<QualityVO> feeNewList = new ArrayList<QualityVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            feeNewList.add(feeVO);
        }
        for (QualityVO qualityVO : feeVOS) {
            qualityVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(qualityVO.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(QualityVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<QualityVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            QualityVO projectStatusSumfeeVO = new QualityVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<QualityVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(QualityVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<QualityVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                QualityVO orgStatusSumfeeVO = new QualityVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((QualityVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((QualityVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<QualityVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(QualityVO::getProjectCreateTime)).collect(Collectors.toList());
                for (QualityVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    feeVONum.setAddCost(CommonUtils.parseYuanToWan(feeVONum.getAddCost()));
                    feeVONum.setBuckleCost(CommonUtils.parseYuanToWan(feeVONum.getBuckleCost()));
                }
                feeNewList.addAll((Collection<QualityVO>)orgStatusList);
            });
        });
        return feeNewList;
    }

    private void getSumData(List<QualityVO> feeVOS, QualityVO feeVO) {
        BigDecimal addCost = feeVOS.stream().filter(s -> s.getAddCost() != null).map(QualityVO::getAddCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal buckleCost = feeVOS.stream().filter(s -> s.getBuckleCost() != null).map(QualityVO::getBuckleCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setAddCost(CommonUtils.parseYuanToWan(addCost));
        feeVO.setBuckleCost(CommonUtils.parseYuanToWan(buckleCost));
    }
}

