package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目成本指标分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_complete_settlement")
public class CompleteSettlementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="build_function")
    private String buildFunction; // 建筑功能
    @TableField(value="struct_method")
    private String structMethod; // 结构形式
    @TableField(value="build_height")
    private String buildHeight; // 建筑物高度
    @TableField(value="build_floor_height")
    private String buildFloorHeight; // 层高
    @TableField(value="prefabrication_rate")
    private BigDecimal prefabricationRate; // 预制率
    @TableField(value="assembly_rate")
    private BigDecimal assemblyRate; // 装配率
    @TableField(value="total_money")
    private BigDecimal totalMoney; // 总成本
    @TableField(value="land_top_build_area")
    private BigDecimal landTopBuildArea; // 地上建筑面积
    @TableField(value="land_down_build_area")
    private BigDecimal landDownBuildArea; // 地下建筑面积
    @TableField(value="per_meter_cost")
    private BigDecimal perMeterCost; // 每平米成本（元/㎡）
    @TableField(value="civil_quantity")
    private BigDecimal civilQuantity; // 土建（元／㎡）
    @TableField(value="civil_ground")
    private BigDecimal civilGround; // 土建地上
    @TableField(value="civil_underground")
    private BigDecimal civilUnderground; // 土建（元/㎡）地下
    @TableField(value="reinforcement_content_quantity")
    private BigDecimal reinforcementContentQuantity; // 现浇钢筋含量（kg/㎡）合计
    @TableField(value="reinforcement_content_ground")
    private BigDecimal reinforcementContentGround; // 现浇钢筋含量（kg/㎡）地上
    @TableField(value="reinforcement_content_underground")
    private BigDecimal reinforcementContentUnderground; // 现浇钢筋含量（kg/㎡）地下
    @TableField(value="concrete_content_quantity")
    private BigDecimal concreteContentQuantity; // 现浇砼含量（m³／㎡）合计
    @TableField(value="concrete_content_ground")
    private BigDecimal concreteContentGround; // 现浇砼凝土含量（m³／㎡）地上
    @TableField(value="concrete_content_underground")
    private BigDecimal concreteContentUnderground; // 现浇砼凝土含量（m³／㎡）地下
    @TableField(value ="precast_reinforcement_ground")
    private java.math.BigDecimal precastReinforcementGround; // 预制构件钢筋地上（kg／㎡）
    @TableField(value ="precast_reinforcement_underground")
    private java.math.BigDecimal precastReinforcementUnderground; // 预制构件钢筋地下（kg／㎡）
    @TableField(value ="precast_reinforcement_quantity")
    private java.math.BigDecimal precastReinforcementQuantity; // 预制构件钢筋合计（kg／㎡）
    @TableField(value="precast_concrete_quantity")
    private BigDecimal precastConcreteQuantity; // 预制构件混凝土合计（m³/㎡）
    @TableField(value="precast_concrete_ground")
    private BigDecimal precastConcreteGround; // 预制构件混凝土地上（m³/㎡）
    @TableField(value="precast_concrete_underground")
    private BigDecimal precastConcreteUnderground; // 预制构件混凝土地下（m³/㎡）
    @TableField(value="masonry_content_quantity")
    private BigDecimal masonryContentQuantity; // 砌体含量（m³／㎡）合计
    @TableField(value="masonry_content_ground")
    private BigDecimal masonryContentGround; // 砌体含量（m³／㎡）地上
    @TableField(value="masonry_content_underground")
    private BigDecimal masonryContentUnderground; // 砌体含量（m³／㎡）地下
    @TableField(value="window_content_quantity")
    private BigDecimal windowContentQuantity; // 门窗含量（㎡／㎡）合计
    @TableField(value="window_content_ground")
    private BigDecimal windowContentGround; // 门窗含量（㎡／㎡）地上
    @TableField(value="window_content_underground")
    private BigDecimal windowContentUnderground; // 门窗含量（㎡／㎡）地下
    @TableField(value="cement_content_ground")
    private BigDecimal cementContentGround; // 水泥含量（t／㎡）地上
    @TableField(value="cement_content_quantity")
    private BigDecimal cementContentQuantity; // 水泥含量（t／㎡）合计
    @TableField(value="cement_content_underground")
    private BigDecimal cementContentUnderground; // 水泥含量（t／㎡）地下
    @TableField(value="template_ground")
    private BigDecimal templateGround; // 模板（㎡／㎡）地上
    @TableField(value="template_quantity")
    private BigDecimal templateQuantity; // 模板（㎡／㎡）合计
    @TableField(value="template_underground")
    private BigDecimal templateUnderground; // 模板（㎡／㎡）地下
    @TableField(value="scaffold_ground")
    private BigDecimal scaffoldGround; // 脚手架（㎡／㎡）地上
    @TableField(value="scaffold_quantity")
    private BigDecimal scaffoldQuantity; // 脚手架（㎡／㎡）合计
    @TableField(value="scaffold_underground")
    private BigDecimal scaffoldUnderground; // 脚手架（㎡／㎡）地下
    @TableField(value="waterproof_insulation_ground1")
    private BigDecimal waterproofInsulationGround1; // 防水保温（㎡／㎡）地上
    @TableField(value="waterproof_insulation_ground2")
    private BigDecimal waterproofInsulationGround2; // 防水保温（㎡／㎡）地上
    @TableField(value="waterproof_insulation_quantity")
    private BigDecimal waterproofInsulationQuantity; // 防水保温（㎡／㎡）合计
    @TableField(value="flooring_ground")
    private BigDecimal flooringGround; // 楼地面地上（㎡/㎡）
    @TableField(value="flooring_underground")
    private BigDecimal flooringUnderground; // 楼地面地下（㎡/㎡）
    @TableField(value="flooring_quantity")
    private BigDecimal flooringQuantity; // 楼地面合计（㎡/㎡）
    @TableField(value="wall_cylinder_ground")
    private BigDecimal wallCylinderGround; // 墙柱面地上（㎡/㎡）
    @TableField(value="wall_cylinder_underground")
    private BigDecimal wallCylinderUnderground; // 墙柱面地下（㎡/㎡）
    @TableField(value="wall_cylinder_quantity")
    private BigDecimal wallCylinderQuantity; // 墙柱面合计（㎡/㎡）
    @TableField(value="ceiling_ground")
    private BigDecimal ceilingGround; // 天棚地上（㎡/㎡）
    @TableField(value="ceiling_underground")
    private BigDecimal ceilingUnderground; // 天棚地下（㎡/㎡）
    @TableField(value="ceiling_quantity")
    private BigDecimal ceilingQuantity; // 天棚合计（㎡/㎡）
    @TableField(value="doors_windows_ground")
    private BigDecimal doorsWindowsGround; // 门窗地上（㎡/㎡）
    @TableField(value="doors_windows_underground")
    private BigDecimal doorsWindowsUnderground; // 门窗地下（㎡/㎡）
    @TableField(value="doors_windows_quantity")
    private BigDecimal doorsWindowsQuantity; // 门窗合计（㎡/㎡）
    @TableField(value="electric_wire_ground")
    private BigDecimal electricWireGround; // 电线，电缆地上（m/㎡）
    @TableField(value="electric_wire_underground")
    private BigDecimal electricWireUnderground; // 电线，电缆地下（m/㎡）
    @TableField(value="electric_wire_quantity")
    private BigDecimal electricWireQuantity; // 电线，电缆合计（m/㎡）
    @TableField(value="ventilating_duct_ground")
    private BigDecimal ventilatingDuctGround; // 通风管道地上（m/㎡）
    @TableField(value="ventilating_duct_underground")
    private BigDecimal ventilatingDuctUnderground; // 通风管道地下（m/㎡）
    @TableField(value="ventilating_duct_quantity")
    private BigDecimal ventilatingDuctQuantity; // 通风管道合计（m/㎡）
    @TableField(value="fire_main_ground")
    private BigDecimal fireMainGround; // 消防管道地上（m/㎡）
    @TableField(value="fire_main_underground")
    private BigDecimal fireMainUnderground; // 消防管道地下（m/㎡）
    @TableField(value="fire_main_quantity")
    private BigDecimal fireMainQuantity; // 消防管道合计（m/㎡）
    @TableField(value="water_supply_ground")
    private BigDecimal waterSupplyGround; // 给排水地上（m/㎡）
    @TableField(value="water_supply_underground")
    private BigDecimal waterSupplyUnderground; // 给排水地下（m/㎡）
    @TableField(value="water_supply_quantity")
    private BigDecimal waterSupplyQuantity; // 给排水合计（m/㎡）
    @TableField(value="air_conditionerwater_ground")
    private BigDecimal airConditionerwaterGround; // 空调机地上（台/㎡）
    @TableField(value="air_conditionerwater_underground")
    private BigDecimal airConditionerwaterUnderground; // 空调机地下（台/㎡）
    @TableField(value="air_conditionerwater_quantity")
    private BigDecimal airConditionerwaterQuantity; // 空调机合计（台/㎡）
    @TableField(value="refined_decoration_ground")
    private BigDecimal refinedDecorationGround; // 精装修地上（元/㎡）
    @TableField(value="refined_decoration_underground")
    private BigDecimal refinedDecorationUnderground; // 精装修地下（元/㎡）
    @TableField(value="refined_decoration_quantity")
    private BigDecimal refinedDecorationQuantity; // 精装修合计（元/㎡）
    @TableField(value="outdoor_garden")
    private BigDecimal outdoorGarden; // 室外园林（元/㎡）
    @TableField(value="small_municipality")
    private BigDecimal smallMunicipality; // 小市政（元/㎡）
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="completion_date")
    private Date completionDate; // 竣工日期
    @TableField(value="source_id")
    private Long sourceId; // 项目成本还原指标分析主键id
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期


    public BigDecimal getPrecastReinforcementGround() {
        return precastReinforcementGround;
    }

    public void setPrecastReinforcementGround(BigDecimal precastReinforcementGround) {
        this.precastReinforcementGround = precastReinforcementGround;
    }

    public BigDecimal getPrecastReinforcementUnderground() {
        return precastReinforcementUnderground;
    }

    public void setPrecastReinforcementUnderground(BigDecimal precastReinforcementUnderground) {
        this.precastReinforcementUnderground = precastReinforcementUnderground;
    }

    public BigDecimal getPrecastReinforcementQuantity() {
        return precastReinforcementQuantity;
    }

    public void setPrecastReinforcementQuantity(BigDecimal precastReinforcementQuantity) {
        this.precastReinforcementQuantity = precastReinforcementQuantity;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public String getBuildFunction() {
        return buildFunction;
    }

    public void setBuildFunction(String buildFunction) {
        this.buildFunction = buildFunction;
    }
    public String getStructMethod() {
        return structMethod;
    }

    public void setStructMethod(String structMethod) {
        this.structMethod = structMethod;
    }
    public String getBuildHeight() {
        return buildHeight;
    }

    public void setBuildHeight(String buildHeight) {
        this.buildHeight = buildHeight;
    }
    public String getBuildFloorHeight() {
        return buildFloorHeight;
    }

    public void setBuildFloorHeight(String buildFloorHeight) {
        this.buildFloorHeight = buildFloorHeight;
    }
    public BigDecimal getPrefabricationRate() {
        return prefabricationRate;
    }

    public void setPrefabricationRate(BigDecimal prefabricationRate) {
        this.prefabricationRate = prefabricationRate;
    }
    public BigDecimal getAssemblyRate() {
        return assemblyRate;
    }

    public void setAssemblyRate(BigDecimal assemblyRate) {
        this.assemblyRate = assemblyRate;
    }
    public BigDecimal getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(BigDecimal totalMoney) {
        this.totalMoney = totalMoney;
    }
    public BigDecimal getLandTopBuildArea() {
        return landTopBuildArea;
    }

    public void setLandTopBuildArea(BigDecimal landTopBuildArea) {
        this.landTopBuildArea = landTopBuildArea;
    }
    public BigDecimal getLandDownBuildArea() {
        return landDownBuildArea;
    }

    public void setLandDownBuildArea(BigDecimal landDownBuildArea) {
        this.landDownBuildArea = landDownBuildArea;
    }
    public BigDecimal getPerMeterCost() {
        return perMeterCost;
    }

    public void setPerMeterCost(BigDecimal perMeterCost) {
        this.perMeterCost = perMeterCost;
    }
    public BigDecimal getCivilQuantity() {
        return civilQuantity;
    }

    public void setCivilQuantity(BigDecimal civilQuantity) {
        this.civilQuantity = civilQuantity;
    }
    public BigDecimal getCivilGround() {
        return civilGround;
    }

    public void setCivilGround(BigDecimal civilGround) {
        this.civilGround = civilGround;
    }
    public BigDecimal getCivilUnderground() {
        return civilUnderground;
    }

    public void setCivilUnderground(BigDecimal civilUnderground) {
        this.civilUnderground = civilUnderground;
    }
    public BigDecimal getReinforcementContentQuantity() {
        return reinforcementContentQuantity;
    }

    public void setReinforcementContentQuantity(BigDecimal reinforcementContentQuantity) {
        this.reinforcementContentQuantity = reinforcementContentQuantity;
    }
    public BigDecimal getReinforcementContentGround() {
        return reinforcementContentGround;
    }

    public void setReinforcementContentGround(BigDecimal reinforcementContentGround) {
        this.reinforcementContentGround = reinforcementContentGround;
    }
    public BigDecimal getReinforcementContentUnderground() {
        return reinforcementContentUnderground;
    }

    public void setReinforcementContentUnderground(BigDecimal reinforcementContentUnderground) {
        this.reinforcementContentUnderground = reinforcementContentUnderground;
    }
    public BigDecimal getConcreteContentQuantity() {
        return concreteContentQuantity;
    }

    public void setConcreteContentQuantity(BigDecimal concreteContentQuantity) {
        this.concreteContentQuantity = concreteContentQuantity;
    }
    public BigDecimal getConcreteContentGround() {
        return concreteContentGround;
    }

    public void setConcreteContentGround(BigDecimal concreteContentGround) {
        this.concreteContentGround = concreteContentGround;
    }
    public BigDecimal getConcreteContentUnderground() {
        return concreteContentUnderground;
    }

    public void setConcreteContentUnderground(BigDecimal concreteContentUnderground) {
        this.concreteContentUnderground = concreteContentUnderground;
    }
    public BigDecimal getPrecastConcreteQuantity() {
        return precastConcreteQuantity;
    }

    public void setPrecastConcreteQuantity(BigDecimal precastConcreteQuantity) {
        this.precastConcreteQuantity = precastConcreteQuantity;
    }
    public BigDecimal getPrecastConcreteGround() {
        return precastConcreteGround;
    }

    public void setPrecastConcreteGround(BigDecimal precastConcreteGround) {
        this.precastConcreteGround = precastConcreteGround;
    }
    public BigDecimal getPrecastConcreteUnderground() {
        return precastConcreteUnderground;
    }

    public void setPrecastConcreteUnderground(BigDecimal precastConcreteUnderground) {
        this.precastConcreteUnderground = precastConcreteUnderground;
    }
    public BigDecimal getMasonryContentQuantity() {
        return masonryContentQuantity;
    }

    public void setMasonryContentQuantity(BigDecimal masonryContentQuantity) {
        this.masonryContentQuantity = masonryContentQuantity;
    }
    public BigDecimal getMasonryContentGround() {
        return masonryContentGround;
    }

    public void setMasonryContentGround(BigDecimal masonryContentGround) {
        this.masonryContentGround = masonryContentGround;
    }
    public BigDecimal getMasonryContentUnderground() {
        return masonryContentUnderground;
    }

    public void setMasonryContentUnderground(BigDecimal masonryContentUnderground) {
        this.masonryContentUnderground = masonryContentUnderground;
    }
    public BigDecimal getWindowContentQuantity() {
        return windowContentQuantity;
    }

    public void setWindowContentQuantity(BigDecimal windowContentQuantity) {
        this.windowContentQuantity = windowContentQuantity;
    }
    public BigDecimal getWindowContentGround() {
        return windowContentGround;
    }

    public void setWindowContentGround(BigDecimal windowContentGround) {
        this.windowContentGround = windowContentGround;
    }
    public BigDecimal getWindowContentUnderground() {
        return windowContentUnderground;
    }

    public void setWindowContentUnderground(BigDecimal windowContentUnderground) {
        this.windowContentUnderground = windowContentUnderground;
    }
    public BigDecimal getCementContentGround() {
        return cementContentGround;
    }

    public void setCementContentGround(BigDecimal cementContentGround) {
        this.cementContentGround = cementContentGround;
    }
    public BigDecimal getCementContentQuantity() {
        return cementContentQuantity;
    }

    public void setCementContentQuantity(BigDecimal cementContentQuantity) {
        this.cementContentQuantity = cementContentQuantity;
    }
    public BigDecimal getCementContentUnderground() {
        return cementContentUnderground;
    }

    public void setCementContentUnderground(BigDecimal cementContentUnderground) {
        this.cementContentUnderground = cementContentUnderground;
    }
    public BigDecimal getTemplateGround() {
        return templateGround;
    }

    public void setTemplateGround(BigDecimal templateGround) {
        this.templateGround = templateGround;
    }
    public BigDecimal getTemplateQuantity() {
        return templateQuantity;
    }

    public void setTemplateQuantity(BigDecimal templateQuantity) {
        this.templateQuantity = templateQuantity;
    }
    public BigDecimal getTemplateUnderground() {
        return templateUnderground;
    }

    public void setTemplateUnderground(BigDecimal templateUnderground) {
        this.templateUnderground = templateUnderground;
    }
    public BigDecimal getScaffoldGround() {
        return scaffoldGround;
    }

    public void setScaffoldGround(BigDecimal scaffoldGround) {
        this.scaffoldGround = scaffoldGround;
    }
    public BigDecimal getScaffoldQuantity() {
        return scaffoldQuantity;
    }

    public void setScaffoldQuantity(BigDecimal scaffoldQuantity) {
        this.scaffoldQuantity = scaffoldQuantity;
    }
    public BigDecimal getScaffoldUnderground() {
        return scaffoldUnderground;
    }

    public void setScaffoldUnderground(BigDecimal scaffoldUnderground) {
        this.scaffoldUnderground = scaffoldUnderground;
    }
    public BigDecimal getWaterproofInsulationGround1() {
        return waterproofInsulationGround1;
    }

    public void setWaterproofInsulationGround1(BigDecimal waterproofInsulationGround1) {
        this.waterproofInsulationGround1 = waterproofInsulationGround1;
    }
    public BigDecimal getWaterproofInsulationGround2() {
        return waterproofInsulationGround2;
    }

    public void setWaterproofInsulationGround2(BigDecimal waterproofInsulationGround2) {
        this.waterproofInsulationGround2 = waterproofInsulationGround2;
    }
    public BigDecimal getWaterproofInsulationQuantity() {
        return waterproofInsulationQuantity;
    }

    public void setWaterproofInsulationQuantity(BigDecimal waterproofInsulationQuantity) {
        this.waterproofInsulationQuantity = waterproofInsulationQuantity;
    }
    public BigDecimal getFlooringGround() {
        return flooringGround;
    }

    public void setFlooringGround(BigDecimal flooringGround) {
        this.flooringGround = flooringGround;
    }
    public BigDecimal getFlooringUnderground() {
        return flooringUnderground;
    }

    public void setFlooringUnderground(BigDecimal flooringUnderground) {
        this.flooringUnderground = flooringUnderground;
    }
    public BigDecimal getFlooringQuantity() {
        return flooringQuantity;
    }

    public void setFlooringQuantity(BigDecimal flooringQuantity) {
        this.flooringQuantity = flooringQuantity;
    }
    public BigDecimal getWallCylinderGround() {
        return wallCylinderGround;
    }

    public void setWallCylinderGround(BigDecimal wallCylinderGround) {
        this.wallCylinderGround = wallCylinderGround;
    }
    public BigDecimal getWallCylinderUnderground() {
        return wallCylinderUnderground;
    }

    public void setWallCylinderUnderground(BigDecimal wallCylinderUnderground) {
        this.wallCylinderUnderground = wallCylinderUnderground;
    }
    public BigDecimal getWallCylinderQuantity() {
        return wallCylinderQuantity;
    }

    public void setWallCylinderQuantity(BigDecimal wallCylinderQuantity) {
        this.wallCylinderQuantity = wallCylinderQuantity;
    }
    public BigDecimal getCeilingGround() {
        return ceilingGround;
    }

    public void setCeilingGround(BigDecimal ceilingGround) {
        this.ceilingGround = ceilingGround;
    }
    public BigDecimal getCeilingUnderground() {
        return ceilingUnderground;
    }

    public void setCeilingUnderground(BigDecimal ceilingUnderground) {
        this.ceilingUnderground = ceilingUnderground;
    }
    public BigDecimal getCeilingQuantity() {
        return ceilingQuantity;
    }

    public void setCeilingQuantity(BigDecimal ceilingQuantity) {
        this.ceilingQuantity = ceilingQuantity;
    }
    public BigDecimal getDoorsWindowsGround() {
        return doorsWindowsGround;
    }

    public void setDoorsWindowsGround(BigDecimal doorsWindowsGround) {
        this.doorsWindowsGround = doorsWindowsGround;
    }
    public BigDecimal getDoorsWindowsUnderground() {
        return doorsWindowsUnderground;
    }

    public void setDoorsWindowsUnderground(BigDecimal doorsWindowsUnderground) {
        this.doorsWindowsUnderground = doorsWindowsUnderground;
    }
    public BigDecimal getDoorsWindowsQuantity() {
        return doorsWindowsQuantity;
    }

    public void setDoorsWindowsQuantity(BigDecimal doorsWindowsQuantity) {
        this.doorsWindowsQuantity = doorsWindowsQuantity;
    }
    public BigDecimal getElectricWireGround() {
        return electricWireGround;
    }

    public void setElectricWireGround(BigDecimal electricWireGround) {
        this.electricWireGround = electricWireGround;
    }
    public BigDecimal getElectricWireUnderground() {
        return electricWireUnderground;
    }

    public void setElectricWireUnderground(BigDecimal electricWireUnderground) {
        this.electricWireUnderground = electricWireUnderground;
    }
    public BigDecimal getElectricWireQuantity() {
        return electricWireQuantity;
    }

    public void setElectricWireQuantity(BigDecimal electricWireQuantity) {
        this.electricWireQuantity = electricWireQuantity;
    }
    public BigDecimal getVentilatingDuctGround() {
        return ventilatingDuctGround;
    }

    public void setVentilatingDuctGround(BigDecimal ventilatingDuctGround) {
        this.ventilatingDuctGround = ventilatingDuctGround;
    }
    public BigDecimal getVentilatingDuctUnderground() {
        return ventilatingDuctUnderground;
    }

    public void setVentilatingDuctUnderground(BigDecimal ventilatingDuctUnderground) {
        this.ventilatingDuctUnderground = ventilatingDuctUnderground;
    }
    public BigDecimal getVentilatingDuctQuantity() {
        return ventilatingDuctQuantity;
    }

    public void setVentilatingDuctQuantity(BigDecimal ventilatingDuctQuantity) {
        this.ventilatingDuctQuantity = ventilatingDuctQuantity;
    }
    public BigDecimal getFireMainGround() {
        return fireMainGround;
    }

    public void setFireMainGround(BigDecimal fireMainGround) {
        this.fireMainGround = fireMainGround;
    }
    public BigDecimal getFireMainUnderground() {
        return fireMainUnderground;
    }

    public void setFireMainUnderground(BigDecimal fireMainUnderground) {
        this.fireMainUnderground = fireMainUnderground;
    }
    public BigDecimal getFireMainQuantity() {
        return fireMainQuantity;
    }

    public void setFireMainQuantity(BigDecimal fireMainQuantity) {
        this.fireMainQuantity = fireMainQuantity;
    }
    public BigDecimal getWaterSupplyGround() {
        return waterSupplyGround;
    }

    public void setWaterSupplyGround(BigDecimal waterSupplyGround) {
        this.waterSupplyGround = waterSupplyGround;
    }
    public BigDecimal getWaterSupplyUnderground() {
        return waterSupplyUnderground;
    }

    public void setWaterSupplyUnderground(BigDecimal waterSupplyUnderground) {
        this.waterSupplyUnderground = waterSupplyUnderground;
    }
    public BigDecimal getWaterSupplyQuantity() {
        return waterSupplyQuantity;
    }

    public void setWaterSupplyQuantity(BigDecimal waterSupplyQuantity) {
        this.waterSupplyQuantity = waterSupplyQuantity;
    }
    public BigDecimal getAirConditionerwaterGround() {
        return airConditionerwaterGround;
    }

    public void setAirConditionerwaterGround(BigDecimal airConditionerwaterGround) {
        this.airConditionerwaterGround = airConditionerwaterGround;
    }
    public BigDecimal getAirConditionerwaterUnderground() {
        return airConditionerwaterUnderground;
    }

    public void setAirConditionerwaterUnderground(BigDecimal airConditionerwaterUnderground) {
        this.airConditionerwaterUnderground = airConditionerwaterUnderground;
    }
    public BigDecimal getAirConditionerwaterQuantity() {
        return airConditionerwaterQuantity;
    }

    public void setAirConditionerwaterQuantity(BigDecimal airConditionerwaterQuantity) {
        this.airConditionerwaterQuantity = airConditionerwaterQuantity;
    }
    public BigDecimal getRefinedDecorationGround() {
        return refinedDecorationGround;
    }

    public void setRefinedDecorationGround(BigDecimal refinedDecorationGround) {
        this.refinedDecorationGround = refinedDecorationGround;
    }
    public BigDecimal getRefinedDecorationUnderground() {
        return refinedDecorationUnderground;
    }

    public void setRefinedDecorationUnderground(BigDecimal refinedDecorationUnderground) {
        this.refinedDecorationUnderground = refinedDecorationUnderground;
    }
    public BigDecimal getRefinedDecorationQuantity() {
        return refinedDecorationQuantity;
    }

    public void setRefinedDecorationQuantity(BigDecimal refinedDecorationQuantity) {
        this.refinedDecorationQuantity = refinedDecorationQuantity;
    }
    public BigDecimal getOutdoorGarden() {
        return outdoorGarden;
    }

    public void setOutdoorGarden(BigDecimal outdoorGarden) {
        this.outdoorGarden = outdoorGarden;
    }
    public BigDecimal getSmallMunicipality() {
        return smallMunicipality;
    }

    public void setSmallMunicipality(BigDecimal smallMunicipality) {
        this.smallMunicipality = smallMunicipality;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
    
}
