package com.ejianc.business.analysis.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.service.IProfitIncomeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收入分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("profitIncome")
public class ProfitIncomeController implements Serializable {

	private static final long serialVersionUID = 1L;


    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProfitIncomeService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProfitIncomeVO> saveOrUpdate(@RequestBody ProfitIncomeVO saveOrUpdateVO) {
    	ProfitIncomeEntity entity = BeanMapper.map(saveOrUpdateVO, ProfitIncomeEntity.class);
    	service.saveOrUpdate(entity, false);
    	ProfitIncomeVO vo = BeanMapper.map(entity, ProfitIncomeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProfitIncomeVO> queryDetail(Long id) {
    	ProfitIncomeEntity entity = service.selectById(id);
    	ProfitIncomeVO vo = BeanMapper.map(entity, ProfitIncomeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProfitIncomeVO> vos) {
        service.removeByIds(vos.stream().map(ProfitIncomeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProfitIncomeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ProfitIncomeEntity> page = service.queryPage(param,false);
        IPage<ProfitIncomeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProfitIncomeVO> projectPaymentVOList = BeanMapper.mapList(page.getRecords(), ProfitIncomeVO.class);
        List<ProfitIncomeVO> feeNewList = service.processingList(projectPaymentVOList);
        pageData.setRecords(feeNewList);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        String reportingMonth = null;
        if(param.getParams().get("reportingMonth") != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
        }
        List<ProfitIncomeEntity> list = service.queryList(param);
        List<ProfitIncomeVO> feeNewList = service.processingList(BeanMapper.mapList(list, ProfitIncomeVO.class));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", feeNewList);
        CommonUtils.setExcelName(response, reportingMonth,"项目收入分析","excel/ProfitIncome.xlsx", beans);

    }
    public static String getdate(String date) {
        String[] datel = date.split(" ");
        String[] date2 = datel[0].split("-");
        String date4 = date2[0] + "年" + date2[1] + "月";
        return date4;
    }


    /**
     *
     * @return
     */
    @RequestMapping(value = "/execute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        //定时任务设置天数，执行当前天数到上月当前天数
        String day = request.getParameter("day");
        service.execute(null,day,null);
        return CommonResponse.success("收入分析数据生成成功！");
    }

    /**
     *预生成本期数据
     * flag:1代表预生成按钮
     * @return
     */
    @RequestMapping(value = "/executeTest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> executeTest( @RequestParam(value = "inAdvanceFlag", required = false)Integer inAdvanceFlag, @RequestParam(value = "day", required = false) String day,@RequestParam(value = "projectIdList", required = false) List<Long> projectIdList) {
        service.execute(inAdvanceFlag,day,projectIdList);
        return CommonResponse.success("收入分析数据生成成功！");
    }


}
