package com.ejianc.business.analysis.controller;

import java.io.Serializable;

import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.RequestVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.analysis.bean.QualityEntity;
import com.ejianc.business.analysis.service.IQualityService;
import com.ejianc.business.analysis.vo.QualityVO;

/**
 * 项目工程质量问题增加成本统计表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quality")
public class QualityController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IQualityService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QualityVO> saveOrUpdate(@RequestBody QualityVO saveOrUpdateVO) {
    	QualityEntity entity = BeanMapper.map(saveOrUpdateVO, QualityEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	QualityVO vo = BeanMapper.map(entity, QualityVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QualityVO> queryDetail(Long id) {
    	QualityEntity entity = service.selectById(id);
    	QualityVO vo = BeanMapper.map(entity, QualityVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QualityVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (QualityVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(QualityVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        String reportingMonth = null;
        if(param.getParams().get("reportingMonth") != null){
            reportingMonth = param.getParams().get("reportingMonth").getValue().toString();
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<QualityEntity> list = service.queryList(param);
        List<QualityVO> feeVOS = BeanMapper.mapList(list, QualityVO.class);
        List<QualityVO> feeNewList = service.dealData(feeVOS);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", feeNewList);
        CommonUtils.setExcelName(response, reportingMonth,"项目工程质量问题增加成本统计表","excel/Quality.xlsx", beans);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refQualityData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QualityVO>> refQualityData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QualityEntity> page = service.queryPage(param,false);
        IPage<QualityVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QualityVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     *预生成本期数据
     * flag:1代表预生成按钮
     * @return
     */
    @RequestMapping(value = "/preExecute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> preExecute(@RequestBody RequestVO requestVO) {
        service.execute(requestVO.getInAdvanceFlag(),requestVO.getDay(),requestVO.getProjectIdList());
        return CommonResponse.success("数据生成成功！");
    }
    /**
     *
     * @return
     */
    @RequestMapping(value = "/execute", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        String day = request.getParameter("day");
        service.execute(null,day,null);
        return CommonResponse.success("数据生成成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QualityVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(!orgResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取本下组织信息失败！");
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<QualityEntity> page = service.queryPage(param,false);
        IPage<QualityVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<QualityVO> feeVOS = BeanMapper.mapList(page.getRecords(), QualityVO.class);
        List<QualityVO> feeNewList = service.dealData(feeVOS);
        pageData.setRecords(feeNewList);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
}
