package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructProBusinessVO;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ConstructProBusinessMapper;
import com.ejianc.business.analysis.bean.ConstructProBusinessEntity;
import com.ejianc.business.analysis.service.IConstructProBusinessService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 在建项目商务报表
 *
 * @author generator
 *
 */
@Service("constructProBusinessService")
public class ConstructProBusinessServiceImpl extends BaseServiceImpl<ConstructProBusinessMapper, ConstructProBusinessEntity> implements IConstructProBusinessService{

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConstructProBusinessService constructProBusinessService;
    @Autowired
    private ConstructProBusinessMapper constructProBusinessMapper;
    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ConstructProBusinessEntity> lambdaFee = Wrappers.<ConstructProBusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ConstructProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructProBusinessEntity::getReportingMonth, reportingMonth);

        constructProBusinessService.remove(lambdaFee);

        //查询项目信息数据
        List<ConstructProBusinessVO> constructProBusinessVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            constructProBusinessVOList = constructProBusinessMapper.queryProjectIds(projectIdList);
        }else{
            //等于1代表预生成数据
            constructProBusinessVOList = constructProBusinessMapper.queryProjectIds(null);
        }

        List<Long> projectIds = constructProBusinessVOList.stream().map(ConstructProBusinessVO::getProjectId).collect(Collectors.toList());
        // 查询施工类合同
        List<ConstructProBusinessVO> contractVOS = constructProBusinessMapper.queryContract(projectIds);
        Map<Long, ConstructProBusinessVO> contractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目目标管理责任书
        List<ConstructProBusinessVO> bookVOS = constructProBusinessMapper.queryBook(projectIds);
        Map<Long, ConstructProBusinessVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目商务策划会签
        List<ConstructProBusinessVO> countersignatureVOS = constructProBusinessMapper.queryCountersignature(projectIds);
        Map<Long, ConstructProBusinessVO> countersignatureMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(countersignatureVOS)) {
            countersignatureMap = countersignatureVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目商务策划效果
        List<ConstructProBusinessVO> businessplanningeffectVOS = constructProBusinessMapper.queryBusinessplanningeffect(projectIds);
        Map<Long, ConstructProBusinessVO> businessplanningeffectMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(businessplanningeffectVOS)) {
            businessplanningeffectMap = businessplanningeffectVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目月度成本分析报告
        List<ConstructProBusinessVO> costanalysisVOS = constructProBusinessMapper.queryCostanalysis(projectIds,reportingMonth);
        Map<Long, ConstructProBusinessVO> costanalysisMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            for (ConstructProBusinessVO costanalysisVO : costanalysisVOS) {
                if (!costanalysisMap.containsKey(costanalysisVO.getProjectId())) {
                    costanalysisMap.put(costanalysisVO.getProjectId(), costanalysisVO);
                }else {
                    if (costanalysisMap.get(costanalysisVO.getProjectId()).getContractIncome()==null && costanalysisVO.getContractIncome() != null) {
                        costanalysisMap.get(costanalysisVO.getProjectId()).setContractIncome(costanalysisVO.getContractIncome());
                    }
                    if (costanalysisMap.get(costanalysisVO.getProjectId()).getRealCost()==null && costanalysisVO.getRealCost() != null) {
                        costanalysisMap.get(costanalysisVO.getProjectId()).setRealCost(costanalysisVO.getRealCost());
                    }
                }
            }
        }
        // 查询项目月度成本分析报告往期值
        List<UnsettledProBusinessVO> costanalysisHistoryVOS = unsettledProBusinessMapper.queryCostanalysisHistory(projectIds,getEndDateNear());
        Map<Long,List<UnsettledProBusinessVO>> costanalysisHistoryGrBy = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisHistoryVOS)) {
            costanalysisHistoryGrBy= costanalysisHistoryVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }

        // 查询工程计量台账
        List<ConstructProBusinessVO> engineermeasurementVOS = constructProBusinessMapper.queryEngineermeasurement(projectIds,reportingMonth);
        Map<Long, List<ConstructProBusinessVO>> engineermeasurementMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(engineermeasurementVOS)){
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        // 查询工程计量台账往期值
        List<UnsettledProBusinessVO> engineermeasurementHistoryVOS = unsettledProBusinessMapper.queryEngineermeasurementHistory(projectIds,reportingMonth);
        Map<Long,List<UnsettledProBusinessVO>> engineermeasurementHistoryGrBy = new HashMap<>();
        if (CollectionUtils.isNotEmpty(engineermeasurementHistoryVOS)) {
            engineermeasurementHistoryGrBy= engineermeasurementHistoryVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }
        for (ConstructProBusinessVO vo : constructProBusinessVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                vo.setPromoter(contractMap.get(projectId).getPromoter());
                vo.setPromoterName(contractMap.get(projectId).getPromoterName());
                vo.setProjectLocation(contractMap.get(projectId).getProjectLocation());
                vo.setContractSignTime(contractMap.get(projectId).getContractSignTime());
                vo.setContractStartDate(contractMap.get(projectId).getContractStartDate());
                vo.setContractEndDate(contractMap.get(projectId).getContractEndDate());
                // 合同“变更后金额”有值时取值，否则取“合同签订金额”
                vo.setContractAmount(CommonUtils.parseYuanToWanZ(contractMap.get(projectId).getAfterChangeAmount()!=null?contractMap.get(projectId).getAfterChangeAmount():contractMap.get(projectId).getContractAmountByContract()));
                vo.setAcContractAmount(CommonUtils.parseYuanToWanZ(contractMap.get(projectId).getAcContractAmount()));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setUndertakeRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakeRate()));
                vo.setTargetRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getTargetRate()));
                vo.setSignDate(bookMap.get(projectId).getSignDate());
            }
            if (!countersignatureMap.isEmpty() && countersignatureMap.containsKey(projectId)) {
                vo.setBusinessPlanApprovalDate(countersignatureMap.get(projectId).getBusinessPlanApprovalDate());
            }
            if (!businessplanningeffectMap.isEmpty() && businessplanningeffectMap.containsKey(projectId)) {
                vo.setPlanExpectedRevenueGenerationAmount(CommonUtils.parseNullValue(businessplanningeffectMap.get(projectId).getPlanExpectedRevenueGenerationAmount()));
                vo.setPlanRevenueGenerationAmount(CommonUtils.setBigDecimalDefaultValue(businessplanningeffectMap.get(projectId).getPlanRevenueGenerationAmount()));
            }
            if (!costanalysisHistoryGrBy.isEmpty() && costanalysisHistoryGrBy.containsKey(projectId)) {
                List<UnsettledProBusinessVO> businessVOList = costanalysisHistoryGrBy.get(projectId);
                List<UnsettledProBusinessVO> collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                vo.setCumulativeIncome(CommonUtils.parseYuanToWanZ(collectCompare.stream().findFirst().get().getCumulativeIncome()));
                vo.setCumulativeIncomeYou(CommonUtils.parseYuanToWanZ(collectCompare.stream().findFirst().get().getCumulativeIncome()));
            }
            if (!engineermeasurementHistoryGrBy.isEmpty() && engineermeasurementHistoryGrBy.containsKey(projectId)) {
                List<UnsettledProBusinessVO> businessVOList = engineermeasurementHistoryGrBy.get(projectId);
                List<UnsettledProBusinessVO> collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                vo.setCumulativeBatch(CommonUtils.parseYuanToWanZ(collectCompare.stream().findFirst().get().getCumulativeBatch()));
                vo.setCumulativeBatchYou(CommonUtils.parseYuanToWanZ(collectCompare.stream().findFirst().get().getCumulativeBatch()));
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                vo.setContractIncome(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getContractIncome()));
                vo.setAcContractIncome(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getContractIncome()));
                vo.setRealCost(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getRealCost()));
                vo.setAcRealCost(CommonUtils.parseYuanToWanZ(costanalysisMap.get(projectId).getRealCost()));
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                vo.setOwnerCrValue(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).stream().map(it -> it.getCurrentBatch()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setOwnerCrAcValue(vo.getOwnerCrValue());
                vo.setContractReceivableMny(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).stream().map(it -> it.getCurrentReceivables()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setOperatingRevenue(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).stream().map(it -> it.getFinanceReportIncome()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setRealRecrived(CommonUtils.parseYuanToWanZ(engineermeasurementMap.get(projectId).stream().map(it -> it.getCurrentCollection()).reduce(BigDecimal.ZERO, BigDecimal::add)));
                vo.setSettlementFlag(1);// 是否办理其中结算  否:0  是:1
            } else {
                vo.setSettlementFlag(0);// 是否办理其中结算  否:0  是:1
            }
            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setThreeOrgId(orgVos.getData().getId());
                    vo.setThreeOrgName(orgVos.getData().getName());
                }
            }
            vo.setPergaContractAmountProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getPlanExpectedRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractAmount())));//策划预计创效金额占自施合同额比
            vo.setPrgaContractIncomeProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getPlanRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractIncome())));//策划创效金额占自施产值比
            vo.setProfit(ComputeUtil.safeSub(CommonUtils.setBigDecimalDefaultValue(vo.getContractIncome()),CommonUtils.setBigDecimalDefaultValue(vo.getRealCost())));//利润
            vo.setProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getProfit()), CommonUtils.setBigDecimalDefaultValue(vo.getContractIncome())));//利润率(%)
            vo.setAcProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getProfit()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractIncome())));//自施利润率(%)
            vo.setValueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerCrValue()),CommonUtils.setBigDecimalDefaultValue(vo.getContractIncome())));//产值确权率(%)
            vo.setAcValueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerCrAcValue()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractIncome())));//自施产值确权率(%)
            vo.setRevenueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerCrValue()), CommonUtils.setBigDecimalDefaultValue(vo.getOperatingRevenue())));//营收确权率(%)
            if (vo.getFourOrgId() != null) {
                CommonResponse<OrgVO> fourOrgVO = orgApi.detailById(vo.getFourOrgId());
                if (fourOrgVO.isSuccess() && null != fourOrgVO.getData()) {
                    vo.setFourOrgName(fourOrgVO.getData().getName());// 股份公司四级单位
                }
            }
            if (vo.getContractorName() == null) {
                CommonResponse<OrgVO> orgVO = orgApi.detailById(vo.getContractor());
                if (orgVO.isSuccess() && null != orgVO.getData()) {
                    vo.setContractorName(orgVO.getData().getName());// 承包人名称
                }
            }
        }
        List<ConstructProBusinessEntity> constructProBusinessEntityList = BeanMapper.mapList(constructProBusinessVOList, ConstructProBusinessEntity.class);
        constructProBusinessService.saveBatch(constructProBusinessEntityList);
    }

    @Override
    public List<ConstructProBusinessVO> dealData(List<ConstructProBusinessVO> constructProBusinessVOS) {
        //处理第一行合计值
        ConstructProBusinessVO constructProBusinessVO = new ConstructProBusinessVO();
        ArrayList<ConstructProBusinessVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(constructProBusinessVOS)) {
            getSumDate(constructProBusinessVOS, constructProBusinessVO);
            constructProBusinessVO.setNumber("合计");
            constructProBusinessVO.setId(IdWorker.getId());
            newList.add(constructProBusinessVO);
        }
        Integer number = 1;
        for (ConstructProBusinessVO vo : constructProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            number++;
            vo.setProjectStatusName(CommonUtils.getProjectStatusName(vo.getProjectStatus()));
            switch (vo.getSettlementFlag()) {
                case 0:vo.setSettlementFlagName("否");break;
                case 1:vo.setSettlementFlagName("是");break;
            }
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337":vo.setProjectCategoryName("工业厂房");break;
                case "1470216222511185922":vo.setProjectCategoryName("公共建筑");break;
                case "1470216274176622593":vo.setProjectCategoryName("民用住宅");break;
                case "1470216311648534530":vo.setProjectCategoryName("基础设施");break;
                case "1470216348239642626":vo.setProjectCategoryName("其它");break;
            }
        }

        newList.addAll(constructProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<ConstructProBusinessVO> constructProBusinessVOS, ConstructProBusinessVO constructProBusinessVO) {
        constructProBusinessVO.setContractAmount(constructProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(ConstructProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractAmount(constructProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ConstructProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanExpectedRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanExpectedRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractIncome(constructProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(ConstructProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractIncome(constructProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(ConstructProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealCost(constructProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(ConstructProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcRealCost(constructProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(ConstructProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setProfit(constructProBusinessVOS.stream().filter(s -> s.getProfit() != null).map(ConstructProBusinessVO::getProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(ConstructProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrAcValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(ConstructProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractReceivableMny(constructProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(ConstructProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOperatingRevenue(constructProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(ConstructProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealRecrived(constructProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(ConstructProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    //减去一年
    private static String getEndDateNear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.YEAR, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }
}
