package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.bean.GoldEntity;
import com.ejianc.business.analysis.mapper.FeeMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IFeeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.business.analysis.vo.GoldVO;
import com.ejianc.business.analysis.vo.GoldVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.GoldMapper;
import com.ejianc.business.analysis.bean.GoldEntity;
import com.ejianc.business.analysis.service.IGoldService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目财务两金分析
 * 
 * @author generator
 * 
 */
@Service("goldService")
public class GoldServiceImpl extends BaseServiceImpl<GoldMapper, GoldEntity> implements IGoldService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private GoldMapper goldMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoldService goldService;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<GoldEntity> lambdaFee = Wrappers.<GoldEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(GoldEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(GoldEntity::getReportingMonth, reportingMonth);
        goldService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }

        //获取累计值
        List<GoldVO> ljData = goldMapper.getLjData(reportingMonth, projectIdList);
        Map<Long, List<GoldVO>> mapLj = new HashMap<>();
        if (CollectionUtils.isNotEmpty(ljData)){
            mapLj = ljData.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<GoldVO> feeVOList = BeanMapper.mapList(profitIncomeVOList, GoldVO.class);
            for (GoldVO feeVO : feeVOList){
                feeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                feeVO.setCreateTime(new Date());
                //设置累计值
                if (mapLj.containsKey(feeVO.getProjectId())){
                    List<GoldVO> feeVOS = mapLj.get(feeVO.getProjectId());
                    //排序获取最近的月份数据
                    List<GoldVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(GoldVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    GoldVO feeVOLj = collectCompare.stream().findFirst().get();
                    feeVO.setCashFlow(CommonUtils.parseNullValue(feeVOLj.getCashFlow()));
                    feeVO.setCompletedBalance(CommonUtils.parseNullValue(feeVOLj.getCompletedBalance()));
                    feeVO.setStockUp(CommonUtils.parseNullValue(feeVOLj.getStockUp()));
                    feeVO.setAccountReceive(CommonUtils.parseNullValue(feeVOLj.getAccountReceive()));
                    feeVO.setAccountsReceive(CommonUtils.parseNullValue(feeVOLj.getAccountsReceive()));
                    feeVO.setAccountsPayable(CommonUtils.parseNullValue(feeVOLj.getAccountsPayable()));
                    feeVO.setOpenDollars(CommonUtils.parseNullValue(feeVOLj.getOpenDollars()));
                    feeVO.setOpenDept(CommonUtils.parseNullValue(feeVOLj.getOpenDept()));
                    feeVO.setContractual(CommonUtils.parseNullValue(feeVOLj.getContractual()));
                }else{
                    feeVO.setCashFlow(BigDecimal.ZERO);
                    feeVO.setCompletedBalance(BigDecimal.ZERO);
                    feeVO.setStockUp(BigDecimal.ZERO);
                    feeVO.setAccountReceive(BigDecimal.ZERO);
                    feeVO.setAccountsReceive(BigDecimal.ZERO);
                    feeVO.setAccountsPayable(BigDecimal.ZERO);
                    feeVO.setOpenDollars(BigDecimal.ZERO);
                    feeVO.setOpenDept(BigDecimal.ZERO);
                    feeVO.setContractual(BigDecimal.ZERO);
                }
                //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(feeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        feeVO.setTwoOrgId(orgVos.getData().getId());
                        feeVO.setTwoOrgName(orgVos.getData().getName());
                        feeVO.setTwoOrgCode(orgVos.getData().getCode());
                        feeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());

                    }
                }
            }

            List<GoldEntity> feeEntityList = BeanMapper.mapList(feeVOList, GoldEntity.class);
            goldService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<GoldVO> dealData(List<GoldVO> feeVOS) {
        //转万元
        for(GoldVO feeVONum : feeVOS){
            //转万元赋值
            feeVONum.setCashFlow(CommonUtils.parseYuanToWan(feeVONum.getCashFlow()));
            feeVONum.setCompletedBalance(CommonUtils.parseYuanToWan(feeVONum.getCompletedBalance()));
            feeVONum.setStockUp(CommonUtils.parseYuanToWan(feeVONum.getStockUp()));
            feeVONum.setAccountReceive(CommonUtils.parseYuanToWan(feeVONum.getAccountReceive()));
            feeVONum.setAccountsReceive(CommonUtils.parseYuanToWan(feeVONum.getAccountsReceive()));
            feeVONum.setOpenDollars(CommonUtils.parseYuanToWan(feeVONum.getOpenDollars()));
            feeVONum.setOpenDept(CommonUtils.parseYuanToWan(feeVONum.getOpenDept()));
            feeVONum.setContractual(CommonUtils.parseYuanToWan(feeVONum.getContractual()));
            feeVONum.setAccountsPayable(CommonUtils.parseYuanToWan(feeVONum.getAccountsPayable()));
        }
        //处理第一行合计值
        GoldVO feeVO = new GoldVO();
        ArrayList<GoldVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }

        //计算排序字段
        for(GoldVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
        }
        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(GoldVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<GoldVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            GoldVO projectStatusSumfeeVO = new GoldVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(GoldVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<GoldVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                GoldVO orgStatusSumfeeVO = new GoldVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(GoldVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (GoldVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));

                    //转万元赋值
//                    feeVONum.setCashFlow(CommonUtils.parseYuanToWan(feeVONum.getCashFlow()));
//                    feeVONum.setCompletedBalance(CommonUtils.parseYuanToWan(feeVONum.getCompletedBalance()));
//                    feeVONum.setStockUp(CommonUtils.parseYuanToWan(feeVONum.getStockUp()));
//                    feeVONum.setAccountReceive(CommonUtils.parseYuanToWan(feeVONum.getAccountReceive()));
//                    feeVONum.setAccountsReceive(CommonUtils.parseYuanToWan(feeVONum.getAccountsReceive()));
//                    feeVONum.setOpenDollars(CommonUtils.parseYuanToWan(feeVONum.getOpenDollars()));
//                    feeVONum.setOpenDept(CommonUtils.parseYuanToWan(feeVONum.getOpenDept()));
//                    feeVONum.setContractual(CommonUtils.parseYuanToWan(feeVONum.getContractual()));
//                    feeVONum.setAccountsPayable(CommonUtils.parseYuanToWan(feeVONum.getAccountsPayable()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });
        return feeNewList;
    }

    private void getSumData(List<GoldVO> feeVOS, GoldVO feeVO) {



        BigDecimal cashFlow = feeVOS.stream().map(GoldVO::getCashFlow)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal completedBalance = feeVOS.stream().map(GoldVO::getCompletedBalance)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal stockUp = feeVOS.stream().map(GoldVO::getStockUp)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountReceive = feeVOS.stream().map(GoldVO::getAccountReceive)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountsReceive = feeVOS.stream().map(GoldVO::getAccountsReceive)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountsPayable = feeVOS.stream().map(GoldVO::getAccountsPayable)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal openDollars = feeVOS.stream().map(GoldVO::getOpenDollars)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal openDept = feeVOS.stream().map(GoldVO::getOpenDept)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractual = feeVOS.stream().map(GoldVO::getContractual)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
//        转万元赋值
        feeVO.setCashFlow(cashFlow);
        feeVO.setCompletedBalance(completedBalance);
        feeVO.setStockUp(stockUp);
        feeVO.setAccountReceive(accountReceive);
        feeVO.setAccountsReceive(accountsReceive);
        feeVO.setOpenDollars(openDollars);
        feeVO.setOpenDept(openDept);
        feeVO.setContractual(contractual);
        feeVO.setAccountsPayable(accountsPayable);

    }

}
