package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectBusinessEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.business.analysis.vo.ProjectBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.analysis.mapper.ProjectBusinessMapper;
import com.ejianc.business.analysis.service.IProjectBusinessService;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 中建科技项目商务策划分析管理报表
 * 
 * @author generator
 * 
 */
@Service("projectBusinessService")
public class ProjectBusinessServiceImpl extends BaseServiceImpl<ProjectBusinessMapper, ProjectBusinessEntity> implements IProjectBusinessService{

    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;

    @Autowired
    private ProjectBusinessMapper projectBusinessMapper;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ProjectBusinessEntity> lambdaFee = Wrappers.<ProjectBusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ProjectBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectBusinessEntity::getReportingMonth, reportingMonth);
        remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }
        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<ProjectBusinessVO> projectBusinessVOList = BeanMapper.mapList(profitIncomeVOList, ProjectBusinessVO.class);
            //查询实际成本
            List<ProjectBusinessVO> costanalysisList = projectBusinessMapper.getCostanalysis(reportingMonth,projectIdList);
            //查询商务策划会签
            List<ProjectBusinessVO> countersignatureList = projectBusinessMapper.queryCountersignature(projectIdList);
            //查询项目商务策划效果
            List<ProjectBusinessVO> businessplanningeffectList = projectBusinessMapper.queryBusinessplanningeffect(projectIdList);


            for(ProjectBusinessVO projectBusinessVO : projectBusinessVOList){
                projectBusinessVO.setReportingMonth(reportingMonth);
                if(CollectionUtils.isNotEmpty(costanalysisList)){
                    Map<Long, List<ProjectBusinessVO>> costanalysisListGrBy =costanalysisList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));

                    if(costanalysisListGrBy.containsKey(projectBusinessVO.getProjectId())){
                        List<ProjectBusinessVO> projectBusinessVOS = costanalysisListGrBy.get(projectBusinessVO.getProjectId());
                        //排序获取最近的月份数据
                        List<ProjectBusinessVO> collectCompare = projectBusinessVOS.stream().sorted(Comparator.comparing(ProjectBusinessVO::getReportingMonth).reversed())
                                .collect(Collectors.toList());
                        ProjectBusinessVO projectBusinessVO1 = collectCompare.stream().findFirst().get();
                        projectBusinessVO.setRealityMoney(CommonUtils.parseNullValue(projectBusinessVO1.getSumPlanCost()));
                    }
                }
                if(CollectionUtils.isNotEmpty(countersignatureList)){
                    Map<Long, List<ProjectBusinessVO>> countersignatureListMap = countersignatureList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getProjectId()
                            ));
                    if(countersignatureListMap.containsKey(projectBusinessVO.getProjectId())){
                        List<ProjectBusinessVO> projectBusinessVOS = countersignatureListMap.get(projectBusinessVO.getProjectId());
                        projectBusinessVO.setBusinessFlag(projectBusinessVOS.size() > 0 ? "是":"否");
                    }else{
                        projectBusinessVO.setBusinessFlag("否");
                    }
                }
                if(CollectionUtils.isNotEmpty(businessplanningeffectList)){
                    Map<Long, ProjectBusinessVO> businessplanningeffectListMap = businessplanningeffectList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                    if(businessplanningeffectListMap.containsKey(projectBusinessVO.getProjectId())){
                        ProjectBusinessVO projectBusinessVO1 = businessplanningeffectListMap.get(projectBusinessVO.getProjectId());
                        projectBusinessVO.setApprovalTotal(CommonUtils.isIntNull(projectBusinessVO1.getSetUpItem()));
                        projectBusinessVO.setPredictMoney(CommonUtils.parseNullValue(projectBusinessVO1.getExpectEffect()));
                        projectBusinessVO.setAmount(CommonUtils.isIntNull(projectBusinessVO1.getImplementItem()));
                        projectBusinessVO.setPlanMoney(CommonUtils.parseNullValue(projectBusinessVO1.getPlanEffect()));
                    }
                }

                CommonResponse<OrgVO> orgVo = orgApi.detailById(projectBusinessVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        projectBusinessVO.setTwoOrgId(orgVos.getData().getId());
                        projectBusinessVO.setTwoOrgName(orgVos.getData().getName());
                        projectBusinessVO.setTwoOrgCode(orgVos.getData().getCode());
                        projectBusinessVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }

            }

            saveBatch(BeanMapper.mapList(projectBusinessVOList, ProjectBusinessEntity.class));
        }
    }

    @Override
    public List<ProjectBusinessVO> dealData(List<ProjectBusinessVO> projectBusinessVOList) {
        //处理第一行合计值
        ProjectBusinessVO projectBusinessVO = new ProjectBusinessVO();
        ArrayList<ProjectBusinessVO> conNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(projectBusinessVOList)){
            getSumData(projectBusinessVOList, projectBusinessVO);
            projectBusinessVO.setNumber("合计");
            projectBusinessVO.setId(IdWorker.getId());
            conNewList.add(projectBusinessVO);

            //计算排序字段
            for(ProjectBusinessVO projectBusinessVO1 :projectBusinessVOList){
                projectBusinessVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(projectBusinessVO1.getProjectStatus() == null ? 6:projectBusinessVO1.getProjectStatus()));
            }
            //计算项目状态合计
            projectBusinessVOList = projectBusinessVOList.stream().sorted(Comparator.comparing(ProjectBusinessVO::getProjectStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProjectBusinessVO>> mapProjectStatusOrder = projectBusinessVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectStatusOrder()
                    ));

            mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
                ProjectBusinessVO projectBusinessVO1 = new ProjectBusinessVO();
                projectBusinessVO1.setNumber("项目状态合计");
                projectBusinessVO1.setId(IdWorker.getId());
                projectBusinessVO1.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
                getSumData(projectStatusList, projectBusinessVO1);
                conNewList.add(projectBusinessVO1);

                //计算组织状态合计
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectBusinessVO::getOrgStatusOrder))
                        .collect(Collectors.toList());
                Map<Integer, List<ProjectBusinessVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getOrgStatusOrder()
                        ));

                mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                    ProjectBusinessVO orgStatusSumpayVO = new ProjectBusinessVO();
                    orgStatusSumpayVO.setNumber("单位小计");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                    getSumData(orgStatusList, orgStatusSumpayVO);
                    conNewList.add(orgStatusSumpayVO);

                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectBusinessVO::getProjectCreateTime))
                            .collect(Collectors.toList());
                    for (ProjectBusinessVO paymentVONum : orgStatusList){
                        paymentVONum.setNumber(number +"");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setRealityMoney(CommonUtils.parseYuanToWanZ(paymentVONum.getRealityMoney()));
                        paymentVONum.setApprovalTotal(CommonUtils.isIntNull(paymentVONum.getApprovalTotal()));
                        paymentVONum.setAmount(CommonUtils.isIntNull(paymentVONum.getAmount()));
                        paymentVONum.setPlanMoney(CommonUtils.parseYuanToWanZ(paymentVONum.getPlanMoney()));
                        paymentVONum.setPredictMoney(CommonUtils.parseYuanToWanZ(paymentVONum.getPredictMoney()));
                        paymentVONum.setPredictRatio(CommonUtils.calculateRate(paymentVONum.getPredictMoney(),paymentVONum.getRealityMoney()));
                        paymentVONum.setPlanRatio(CommonUtils.calculateRate(paymentVONum.getPredictMoney(),paymentVONum.getRealityMoney()));
                    }
                    conNewList.addAll(orgStatusList);
                });
            });
        }
        return conNewList;
    }

    private void getSumData(List<ProjectBusinessVO> projectBusinessVOList, ProjectBusinessVO projectBusinessVO) {
        BigDecimal realityMoney = projectBusinessVOList.stream().filter(s->s.getRealityMoney()!=null).map(ProjectBusinessVO::getRealityMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer approvalTotal = projectBusinessVOList.stream().filter(s->s.getApprovalTotal()!=null).map(ProjectBusinessVO::getApprovalTotal)
                .reduce(0, Integer::sum);
        Integer amount = projectBusinessVOList.stream().filter(s->s.getAmount()!=null).map(ProjectBusinessVO::getAmount)
                .reduce(0, Integer::sum);
        BigDecimal planMoney = projectBusinessVOList.stream().filter(s->s.getPlanMoney()!=null).map(ProjectBusinessVO::getPlanMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal predictMoney = projectBusinessVOList.stream().filter(s->s.getPredictMoney()!=null).map(ProjectBusinessVO::getPredictMoney)
                .reduce(BigDecimal.ZERO, BigDecimal::add);


        //转万元赋值
        projectBusinessVO.setRealityMoney(CommonUtils.parseYuanToWanZ(realityMoney));
        projectBusinessVO.setApprovalTotal(CommonUtils.isIntNull(approvalTotal));
        projectBusinessVO.setAmount(CommonUtils.isIntNull(amount));
        projectBusinessVO.setPlanMoney(CommonUtils.parseYuanToWanZ(planMoney));
        projectBusinessVO.setPredictMoney(CommonUtils.parseYuanToWanZ(predictMoney));
        projectBusinessVO.setPredictRatio(CommonUtils.calculateRate(projectBusinessVO.getPredictMoney(),projectBusinessVO.getRealityMoney()));
        projectBusinessVO.setPlanRatio(CommonUtils.calculateRate(projectBusinessVO.getPredictMoney(),projectBusinessVO.getRealityMoney()));
    }
}
