package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.MathUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.FeeMapper;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.service.IFeeService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 现场管理费
 * 
 * @author generator
 * 
 */
@Service("feeService")
public class FeeServiceImpl extends BaseServiceImpl<FeeMapper, FeeEntity> implements IFeeService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private FeeMapper feeMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IFeeService feeService;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<FeeEntity> lambdaFee = Wrappers.<FeeEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(FeeEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(FeeEntity::getReportingMonth, reportingMonth);
        feeService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }

        //获取间接费明细数据
        //获取当年月初的年月
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        //获取去本期值
        List<FeeVO> bqData = feeMapper.getBqData(yearMonth, reportingMonth, projectIdList);
        //获取累计值
        List<FeeVO> ljData = feeMapper.getLjData(reportingMonth, projectIdList);
        Map<Long, List<FeeVO>> mapBq = new HashMap<>();
        Map<Long, List<FeeVO>> mapLj = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bqData)){
            mapBq = bqData.stream().collect(
            Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }
        if (CollectionUtils.isNotEmpty(ljData)){
            mapLj = ljData.stream().collect(
            Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }

        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<FeeVO> feeVOList = BeanMapper.mapList(profitIncomeVOList, FeeVO.class);
            for (FeeVO feeVO : feeVOList){
                feeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                feeVO.setCreateTime(new Date());
                //设置本年值
                if (mapBq.containsKey(feeVO.getProjectId())){
                    List<FeeVO> feeVOS = mapBq.get(feeVO.getProjectId());
                    FeeVO feeVOBq = feeVOS.stream().findFirst().get();
                    feeVO.setYearProduction(CommonUtils.parseNullValue(feeVOBq.getYearProduction()));
                    feeVO.setYearFee(CommonUtils.parseNullValue(feeVOBq.getYearFee()));
                }else{
                    feeVO.setYearProduction(BigDecimal.ZERO);
                    feeVO.setYearFee(BigDecimal.ZERO);
                }
                //设置累计值
                if (mapLj.containsKey(feeVO.getProjectId())){
                    List<FeeVO> feeVOS = mapLj.get(feeVO.getProjectId());
                    //排序获取最近的月份数据
                    List<FeeVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    FeeVO feeVOLj = collectCompare.stream().findFirst().get();
                    feeVO.setSumProduction(CommonUtils.parseNullValue(feeVOLj.getSumProduction()));
                    feeVO.setSumFee(CommonUtils.parseNullValue(feeVOLj.getSumFee()));
                }else{
                    feeVO.setSumProduction(BigDecimal.ZERO);
                    feeVO.setSumFee(BigDecimal.ZERO);
                }
                //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(feeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        feeVO.setTwoOrgId(orgVos.getData().getId());
                        feeVO.setTwoOrgName(orgVos.getData().getName());
                        feeVO.setTwoOrgCode(orgVos.getData().getCode());
                        feeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }

            List<FeeEntity> feeEntityList = BeanMapper.mapList(feeVOList, FeeEntity.class);
            feeService.saveBatch(feeEntityList);
        }

    }

    @Override
    public List<FeeVO> dealData(List<FeeVO> feeVOS) {

        //转万元
        for(FeeVO feeVO : feeVOS){
            feeVO.setYearProduction(CommonUtils.parseYuanToWan(feeVO.getYearProduction()));
            feeVO.setYearFee(CommonUtils.parseYuanToWan(feeVO.getYearFee()));
            feeVO.setSumProduction(CommonUtils.parseYuanToWan(feeVO.getSumProduction()));
            feeVO.setSumFee(CommonUtils.parseYuanToWan(feeVO.getSumFee()));
        }

        //处理第一行合计值
        FeeVO feeVO = new FeeVO();
        ArrayList<FeeVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }

        //计算排序字段
        for(FeeVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
        }

        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<FeeVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            FeeVO projectStatusSumfeeVO = new FeeVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(FeeVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<FeeVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                FeeVO orgStatusSumfeeVO = new FeeVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(FeeVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (FeeVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
//                    //转万元赋值
//                    feeVONum.setYearProduction(CommonUtils.parseYuanToWan(feeVONum.getYearProduction()));
//                    feeVONum.setYearFee(CommonUtils.parseYuanToWan(feeVONum.getYearFee()));
//                    feeVONum.setSumProduction(CommonUtils.parseYuanToWan(feeVONum.getSumProduction()));
//                    feeVONum.setSumFee(CommonUtils.parseYuanToWan(feeVONum.getSumFee()));
                    //计算占比
                    feeVONum.setYearRate(CommonUtils.calculateRate(feeVONum.getYearFee(),feeVONum.getYearProduction()));
                    feeVONum.setSumRate(CommonUtils.calculateRate(feeVONum.getSumFee(),feeVONum.getSumProduction()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });
        return feeNewList;
    }

    private void getSumData(List<FeeVO> feeVOS, FeeVO feeVO) {


        BigDecimal yearProduction = feeVOS.stream().map(FeeVO::getYearProduction)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yearFee = feeVOS.stream().map(FeeVO::getYearFee)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumProduction = feeVOS.stream().map(FeeVO::getSumProduction)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumFee = feeVOS.stream().map(FeeVO::getSumFee)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        //转万元赋值
        feeVO.setYearProduction(yearProduction);
        feeVO.setYearFee(yearFee);
        feeVO.setSumProduction(sumProduction);
        feeVO.setSumFee(sumFee);
        //计算占比
        feeVO.setYearRate(CommonUtils.calculateRate(feeVO.getYearFee(),feeVO.getYearProduction()));
        feeVO.setSumRate(CommonUtils.calculateRate(feeVO.getSumFee(),feeVO.getSumProduction()));

    }

}
