/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.GoldEntity;
import com.ejianc.business.analysis.mapper.GoldMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IGoldService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.GoldVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goldService")
public class GoldServiceImpl
extends BaseServiceImpl<GoldMapper, GoldEntity>
implements IGoldService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private GoldMapper goldMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoldService goldService;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(GoldEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(GoldEntity::getReportingMonth, (Object)reportingMonth);
        this.goldService.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList) : this.profitIncomeMapper.getProjects(null);
        List<GoldVO> ljData = this.goldMapper.getLjData(reportingMonth, projectIdList);
        Map<Object, Object> mapLj = new HashMap();
        if (CollectionUtils.isNotEmpty(ljData)) {
            mapLj = ljData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List feeVOList = BeanMapper.mapList(profitIncomeVOList, GoldVO.class);
            for (GoldVO feeVO : feeVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                feeVO.setReportingMonth(reportingMonth);
                feeVO.setCreateTime(new Date());
                if (mapLj.containsKey(feeVO.getProjectId())) {
                    List feeVOS = (List)mapLj.get(feeVO.getProjectId());
                    List collectCompare = feeVOS.stream().sorted(Comparator.comparing(GoldVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    GoldVO feeVOLj = (GoldVO)collectCompare.stream().findFirst().get();
                    feeVO.setCashFlow(CommonUtils.parseNullValue(feeVOLj.getCashFlow()));
                    feeVO.setCompletedBalance(CommonUtils.parseNullValue(feeVOLj.getCompletedBalance()));
                    feeVO.setStockUp(CommonUtils.parseNullValue(feeVOLj.getStockUp()));
                    feeVO.setAccountReceive(CommonUtils.parseNullValue(feeVOLj.getAccountReceive()));
                    feeVO.setAccountsReceive(CommonUtils.parseNullValue(feeVOLj.getAccountsReceive()));
                    feeVO.setAccountsPayable(CommonUtils.parseNullValue(feeVOLj.getAccountsPayable()));
                    feeVO.setOpenDollars(CommonUtils.parseNullValue(feeVOLj.getOpenDollars()));
                    feeVO.setOpenDept(CommonUtils.parseNullValue(feeVOLj.getOpenDept()));
                    feeVO.setContractual(CommonUtils.parseNullValue(feeVOLj.getContractual()));
                } else {
                    feeVO.setCashFlow(BigDecimal.ZERO);
                    feeVO.setCompletedBalance(BigDecimal.ZERO);
                    feeVO.setStockUp(BigDecimal.ZERO);
                    feeVO.setAccountReceive(BigDecimal.ZERO);
                    feeVO.setAccountsReceive(BigDecimal.ZERO);
                    feeVO.setAccountsPayable(BigDecimal.ZERO);
                    feeVO.setOpenDollars(BigDecimal.ZERO);
                    feeVO.setOpenDept(BigDecimal.ZERO);
                    feeVO.setContractual(BigDecimal.ZERO);
                }
                if (!(orgVo = this.orgApi.detailById(feeVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                feeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                feeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                feeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                feeVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            List feeEntityList = BeanMapper.mapList((Iterable)feeVOList, GoldEntity.class);
            this.goldService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<GoldVO> dealData(List<GoldVO> feeVOS) {
        for (GoldVO goldVO : feeVOS) {
            goldVO.setCashFlow(CommonUtils.parseYuanToWan(goldVO.getCashFlow()));
            goldVO.setCompletedBalance(CommonUtils.parseYuanToWan(goldVO.getCompletedBalance()));
            goldVO.setStockUp(CommonUtils.parseYuanToWan(goldVO.getStockUp()));
            goldVO.setAccountReceive(CommonUtils.parseYuanToWan(goldVO.getAccountReceive()));
            goldVO.setAccountsReceive(CommonUtils.parseYuanToWan(goldVO.getAccountsReceive()));
            goldVO.setOpenDollars(CommonUtils.parseYuanToWan(goldVO.getOpenDollars()));
            goldVO.setOpenDept(CommonUtils.parseYuanToWan(goldVO.getOpenDept()));
            goldVO.setContractual(CommonUtils.parseYuanToWan(goldVO.getContractual()));
            goldVO.setAccountsPayable(CommonUtils.parseYuanToWan(goldVO.getAccountsPayable()));
        }
        GoldVO feeVO = new GoldVO();
        ArrayList<GoldVO> arrayList = new ArrayList<GoldVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            arrayList.add(feeVO);
        }
        for (GoldVO goldVO : feeVOS) {
            goldVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(goldVO.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(GoldVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<GoldVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            GoldVO projectStatusSumfeeVO = new GoldVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<GoldVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(GoldVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<GoldVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                GoldVO orgStatusSumfeeVO = new GoldVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((GoldVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((GoldVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<GoldVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(GoldVO::getProjectCreateTime)).collect(Collectors.toList());
                for (GoldVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                }
                feeNewList.addAll((Collection<GoldVO>)orgStatusList);
            });
        });
        return arrayList;
    }

    private void getSumData(List<GoldVO> feeVOS, GoldVO feeVO) {
        BigDecimal cashFlow = feeVOS.stream().map(GoldVO::getCashFlow).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal completedBalance = feeVOS.stream().map(GoldVO::getCompletedBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal stockUp = feeVOS.stream().map(GoldVO::getStockUp).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountReceive = feeVOS.stream().map(GoldVO::getAccountReceive).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountsReceive = feeVOS.stream().map(GoldVO::getAccountsReceive).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountsPayable = feeVOS.stream().map(GoldVO::getAccountsPayable).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal openDollars = feeVOS.stream().map(GoldVO::getOpenDollars).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal openDept = feeVOS.stream().map(GoldVO::getOpenDept).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractual = feeVOS.stream().map(GoldVO::getContractual).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setCashFlow(cashFlow);
        feeVO.setCompletedBalance(completedBalance);
        feeVO.setStockUp(stockUp);
        feeVO.setAccountReceive(accountReceive);
        feeVO.setAccountsReceive(accountsReceive);
        feeVO.setOpenDollars(openDollars);
        feeVO.setOpenDept(openDept);
        feeVO.setContractual(contractual);
        feeVO.setAccountsPayable(accountsPayable);
    }
}

