/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectBusinessEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProjectBusinessMapper;
import com.ejianc.business.analysis.service.IProjectBusinessService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProjectBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectBusinessService")
public class ProjectBusinessServiceImpl
extends BaseServiceImpl<ProjectBusinessMapper, ProjectBusinessEntity>
implements IProjectBusinessService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ProjectBusinessMapper projectBusinessMapper;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProjectBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectBusinessEntity::getReportingMonth, (Object)reportingMonth);
        this.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList) : this.profitIncomeMapper.getProjects(null);
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List projectBusinessVOList = BeanMapper.mapList(profitIncomeVOList, ProjectBusinessVO.class);
            List<ProjectBusinessVO> costanalysisList = this.projectBusinessMapper.getCostanalysis(reportingMonth, projectIdList);
            List<ProjectBusinessVO> countersignatureList = this.projectBusinessMapper.queryCountersignature(projectIdList);
            List<ProjectBusinessVO> businessplanningeffectList = this.projectBusinessMapper.queryBusinessplanningeffect(projectIdList);
            for (ProjectBusinessVO projectBusinessVO : projectBusinessVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                Map businessplanningeffectListMap;
                List<ProjectBusinessVO> projectBusinessVOS;
                Map<Long, List<ProjectBusinessVO>> costanalysisListGrBy;
                projectBusinessVO.setReportingMonth(reportingMonth);
                if (CollectionUtils.isNotEmpty(costanalysisList) && (costanalysisListGrBy = costanalysisList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectBusinessVO.getProjectId())) {
                    projectBusinessVOS = costanalysisListGrBy.get(projectBusinessVO.getProjectId());
                    List collectCompare = projectBusinessVOS.stream().sorted(Comparator.comparing(ProjectBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    ProjectBusinessVO projectBusinessVO1 = (ProjectBusinessVO)((Object)collectCompare.stream().findFirst().get());
                    projectBusinessVO.setRealityMoney(CommonUtils.parseNullValue(projectBusinessVO1.getSumPlanCost()));
                }
                if (CollectionUtils.isNotEmpty(countersignatureList)) {
                    Map<Long, List<ProjectBusinessVO>> countersignatureListMap = countersignatureList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
                    if (countersignatureListMap.containsKey(projectBusinessVO.getProjectId())) {
                        projectBusinessVOS = countersignatureListMap.get(projectBusinessVO.getProjectId());
                        projectBusinessVO.setBusinessFlag(projectBusinessVOS.size() > 0 ? "\u662f" : "\u5426");
                    } else {
                        projectBusinessVO.setBusinessFlag("\u5426");
                    }
                }
                if (CollectionUtils.isNotEmpty(businessplanningeffectList) && (businessplanningeffectListMap = businessplanningeffectList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectBusinessVO.getProjectId())) {
                    ProjectBusinessVO projectBusinessVO1 = (ProjectBusinessVO)((Object)businessplanningeffectListMap.get(projectBusinessVO.getProjectId()));
                    projectBusinessVO.setApprovalTotal(CommonUtils.isIntNull(projectBusinessVO1.getSetUpItem()));
                    projectBusinessVO.setPredictMoney(CommonUtils.parseNullValue(projectBusinessVO1.getExpectEffect()));
                    projectBusinessVO.setAmount(CommonUtils.isIntNull(projectBusinessVO1.getImplementItem()));
                    projectBusinessVO.setPlanMoney(CommonUtils.parseNullValue(projectBusinessVO1.getPlanEffect()));
                }
                if (!(orgVo = this.orgApi.detailById(projectBusinessVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                projectBusinessVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                projectBusinessVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                projectBusinessVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                projectBusinessVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
            }
            this.saveBatch(BeanMapper.mapList((Iterable)projectBusinessVOList, ProjectBusinessEntity.class));
        }
    }

    @Override
    public List<ProjectBusinessVO> dealData(List<ProjectBusinessVO> projectBusinessVOList) {
        for (ProjectBusinessVO paymentVONum : projectBusinessVOList) {
            paymentVONum.setRealityMoney(CommonUtils.parseYuanToWanZ(paymentVONum.getRealityMoney()));
        }
        ProjectBusinessVO projectBusinessVO = new ProjectBusinessVO();
        ArrayList<ProjectBusinessVO> conNewList = new ArrayList<ProjectBusinessVO>();
        if (CollectionUtils.isNotEmpty(projectBusinessVOList)) {
            this.getSumData(projectBusinessVOList, projectBusinessVO);
            projectBusinessVO.setNumber("\u5408\u8ba1");
            projectBusinessVO.setId(IdWorker.getId());
            conNewList.add(projectBusinessVO);
            for (ProjectBusinessVO projectBusinessVO1 : projectBusinessVOList) {
                projectBusinessVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(projectBusinessVO1.getProjectStatus() == null ? 6 : projectBusinessVO1.getProjectStatus()));
            }
            projectBusinessVOList = projectBusinessVOList.stream().sorted(Comparator.comparing(ProjectBusinessVO::getProjectStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProjectBusinessVO>> mapProjectStatusOrder = projectBusinessVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
            mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
                ProjectBusinessVO projectBusinessVO1 = new ProjectBusinessVO();
                projectBusinessVO1.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
                projectBusinessVO1.setId(IdWorker.getId());
                projectBusinessVO1.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
                this.getSumData((List<ProjectBusinessVO>)projectStatusList, projectBusinessVO1);
                conNewList.add(projectBusinessVO1);
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectBusinessVO::getOrgStatusOrder)).collect(Collectors.toList());
                Map<Integer, List<ProjectBusinessVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
                mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                    ProjectBusinessVO orgStatusSumpayVO = new ProjectBusinessVO();
                    orgStatusSumpayVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProjectBusinessVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(((ProjectBusinessVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getTwoOrgName());
                    this.getSumData((List<ProjectBusinessVO>)orgStatusList, orgStatusSumpayVO);
                    conNewList.add(orgStatusSumpayVO);
                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectBusinessVO::getProjectCreateTime)).collect(Collectors.toList());
                    for (ProjectBusinessVO paymentVONum : orgStatusList) {
                        paymentVONum.setNumber(number + "");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setApprovalTotal(CommonUtils.isIntNull(paymentVONum.getApprovalTotal()));
                        paymentVONum.setAmount(CommonUtils.isIntNull(paymentVONum.getAmount()));
                        paymentVONum.setPlanMoney(paymentVONum.getPlanMoney());
                        paymentVONum.setPredictMoney(paymentVONum.getPredictMoney());
                        paymentVONum.setPredictRatio(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(paymentVONum.getPredictMoney()), CommonUtils.setBigDecimalDefaultValue(paymentVONum.getRealityMoney())));
                        paymentVONum.setPlanRatio(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(paymentVONum.getPlanMoney()), CommonUtils.setBigDecimalDefaultValue(paymentVONum.getRealityMoney())));
                    }
                    conNewList.addAll((Collection<ProjectBusinessVO>)orgStatusList);
                });
            });
        }
        return conNewList;
    }

    private void getSumData(List<ProjectBusinessVO> projectBusinessVOList, ProjectBusinessVO projectBusinessVO) {
        BigDecimal realityMoney = projectBusinessVOList.stream().filter(s -> s.getRealityMoney() != null).map(ProjectBusinessVO::getRealityMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer approvalTotal = projectBusinessVOList.stream().filter(s -> s.getApprovalTotal() != null).map(ProjectBusinessVO::getApprovalTotal).reduce(0, Integer::sum);
        Integer amount = projectBusinessVOList.stream().filter(s -> s.getAmount() != null).map(ProjectBusinessVO::getAmount).reduce(0, Integer::sum);
        BigDecimal planMoney = projectBusinessVOList.stream().filter(s -> s.getPlanMoney() != null).map(ProjectBusinessVO::getPlanMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal predictMoney = projectBusinessVOList.stream().filter(s -> s.getPredictMoney() != null).map(ProjectBusinessVO::getPredictMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        projectBusinessVO.setRealityMoney(realityMoney);
        projectBusinessVO.setApprovalTotal(CommonUtils.isIntNull(approvalTotal));
        projectBusinessVO.setAmount(CommonUtils.isIntNull(amount));
        projectBusinessVO.setPlanMoney(planMoney);
        projectBusinessVO.setPredictMoney(predictMoney);
        projectBusinessVO.setPredictRatio(CommonUtils.calculateRate(projectBusinessVO.getPredictMoney(), projectBusinessVO.getRealityMoney()));
        projectBusinessVO.setPlanRatio(CommonUtils.calculateRate(projectBusinessVO.getPlanMoney(), projectBusinessVO.getRealityMoney()));
    }
}

