/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.RiskEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.RiskMapper;
import com.ejianc.business.analysis.service.IRiskService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.RiskVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="riskService")
public class RiskServiceImpl
extends BaseServiceImpl<RiskMapper, RiskEntity>
implements IRiskService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private IRiskService riskService;
    @Autowired
    private RiskMapper riskMapper;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(RiskEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(RiskEntity::getReportingMonth, (Object)reportingMonth);
        this.riskService.remove((Wrapper)lambdaFee);
        List<Long> projectIds = this.riskMapper.getProjectIds(reportingMonth);
        ArrayList<Long> projectIdAll = new ArrayList();
        List<Object> profitIncomeVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            profitIncomeVOList = this.profitIncomeMapper.getProjects(projectIdList);
            projectIdAll = projectIdList;
        } else {
            profitIncomeVOList = this.profitIncomeMapper.getProjects(projectIds);
            projectIdAll = projectIds;
        }
        List<RiskVO> riskVOList = this.riskMapper.getDataAll(reportingMonth, projectIdAll);
        Map<Object, Object> mapPro = new HashMap();
        Map<Object, Object> mapProAndPeriod = new HashMap();
        if (CollectionUtils.isNotEmpty(riskVOList)) {
            mapPro = riskVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            mapProAndPeriod = riskVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId() + "-" + s.getReportingMonth()));
        }
        ArrayList lastList = new ArrayList();
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List riskVOProList = BeanMapper.mapList(profitIncomeVOList, RiskVO.class);
            for (RiskVO riskVO : riskVOProList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                riskVO.setReportingMonth(reportingMonth);
                riskVO.setCreateTime(new Date());
                if (!mapPro.containsKey(riskVO.getProjectId())) continue;
                List riskVOS = (List)mapPro.get(riskVO.getProjectId());
                List collectCompare = riskVOS.stream().sorted(Comparator.comparing(RiskVO::getReportingMonth).reversed()).collect(Collectors.toList());
                RiskVO riskVOPeriod = (RiskVO)collectCompare.stream().findFirst().get();
                String key = riskVO.getProjectId() + "-" + riskVOPeriod.getReportingMonth();
                if (!mapProAndPeriod.containsKey(key)) continue;
                List riskVOListLast = (List)mapProAndPeriod.get(key);
                CommonResponse orgVo = this.orgApi.detailById(riskVO.getProjectDepartmentId());
                if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                    for (RiskVO riskVOLast : riskVOListLast) {
                        riskVOLast.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                        riskVOLast.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                        riskVOLast.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                        riskVOLast.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
                        riskVOLast.setOrgId(riskVO.getOrgId());
                        riskVOLast.setOrgName(riskVO.getOrgName());
                        riskVOLast.setProjectDepartmentId(riskVO.getProjectDepartmentId());
                        riskVOLast.setProjectName(riskVO.getProjectName());
                        riskVOLast.setProjectCode(riskVO.getProjectCode());
                        riskVOLast.setProjectStatus(riskVO.getProjectStatus());
                        riskVOLast.setCreateTime(new Date());
                        riskVOLast.setProjectCreateTime(riskVO.getProjectCreateTime());
                        riskVOLast.setReportingMonth(reportingMonth);
                    }
                }
                lastList.addAll(riskVOListLast);
            }
        }
        if (CollectionUtils.isNotEmpty(lastList)) {
            List riskEntityList = BeanMapper.mapList(lastList, RiskEntity.class);
            this.riskService.saveBatch(riskEntityList);
        }
    }

    @Override
    public List<RiskVO> dealData(List<RiskVO> feeVOS) {
        if (CollectionUtils.isEmpty(feeVOS)) {
            return new ArrayList<RiskVO>();
        }
        RiskVO feeVO = new RiskVO();
        ArrayList<RiskVO> feeNewList = new ArrayList<RiskVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            feeNewList.add(feeVO);
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(RiskVO::getOrgStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<RiskVO>> mapOrgStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
        mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
            RiskVO orgStatusSumfeeVO = new RiskVO();
            orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
            orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((RiskVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
            orgStatusSumfeeVO.setTwoOrgName(((RiskVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
            this.getSumData((List<RiskVO>)orgStatusList, orgStatusSumfeeVO);
            feeNewList.add(orgStatusSumfeeVO);
            Integer number = 1;
            orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(RiskVO::getProjectCreateTime)).collect(Collectors.toList());
            for (RiskVO feeVONum : orgStatusList) {
                feeVONum.setNumber(number + "");
                number = number + 1;
                feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
            }
            feeNewList.addAll((Collection<RiskVO>)orgStatusList);
        });
        return feeNewList;
    }

    private void getSumData(List<RiskVO> riskVOS, RiskVO riskVO) {
        BigDecimal yMny = riskVOS.stream().map(RiskVO::getYMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal aMny = riskVOS.stream().map(RiskVO::getAMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ysMny = riskVOS.stream().map(RiskVO::getYSMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal asMny = riskVOS.stream().map(RiskVO::getASMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        riskVO.setYMny(yMny);
        riskVO.setAMny(aMny);
        riskVO.setYSMny(ysMny);
        riskVO.setASMny(asMny);
    }
}

