/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.SettleEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.SettleMapper;
import com.ejianc.business.analysis.service.ISettleService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISettleService settleService;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(SettleEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(SettleEntity::getReportingMonth, (Object)reportingMonth);
        this.settleService.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList) : this.profitIncomeMapper.getProjects(null);
        List<SettleVO> listContract = this.settleMapper.getContractNum(projectIdList);
        Map<Object, Object> listContractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listContractMap = listContract.stream().collect(Collectors.toMap(SettleVO::getProjectId, SettleVO::getContractNum));
        }
        List<SettleVO> listContractType = this.settleMapper.getContractTypeNum(projectIdList);
        Map<Object, Object> listContractTypetMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listContractTypetMap = listContractType.stream().collect(Collectors.toMap(s -> s.getProjectId() + "-" + s.getContractStatusName(), SettleVO::getContractNum));
        }
        List<SettleVO> listSettle = this.settleMapper.getSettleMny(projectIdList);
        Map<Object, Object> listSettlMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listSettlMap = listSettle.stream().collect(Collectors.toMap(s -> s.getProjectId(), SettleVO::getSettleMny));
        }
        List<SettleVO> listSp = this.settleMapper.getSpMny(projectIdList);
        Map<Object, Object> listSpMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listSpMap = listSp.stream().collect(Collectors.toMap(s -> s.getProjectId(), SettleVO::getSettleMny));
        }
        List<SettleVO> listPayMny = this.settleMapper.getPayMny(projectIdList);
        Map<Object, Object> listPayMnyMap = new HashMap();
        Map<Object, Object> listPayMnyPeriodMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listPayMnyMap = listPayMny.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            listPayMnyPeriodMap = listPayMny.stream().collect(Collectors.groupingBy(s -> s.getProjectId() + "-" + s.getReportingMonth()));
        }
        List<SettleVO> listContractTypeMny = this.settleMapper.getContractTypeMny(projectIdList);
        Map<Object, Object> listContractTypeMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listContractTypeMnyMap = listContractTypeMny.stream().collect(Collectors.toMap(s -> s.getProjectId() + "-" + s.getContractStatusName(), SettleVO::getSettleMny));
        }
        List<SettleVO> listContractPayMny = this.settleMapper.getContractPayMny(projectIdList);
        Map<Object, Object> listContractPayMnyPeriodMap = new HashMap();
        Map<Object, Object> listContractPayMnyMap = new HashMap();
        if (CollectionUtils.isNotEmpty(listContract)) {
            listContractPayMnyMap = listContractPayMny.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        HashMap twoOrgMap = new HashMap();
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List feeVOList = BeanMapper.mapList(profitIncomeVOList, SettleVO.class);
            for (SettleVO feeVO : feeVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                BigDecimal lwSettleMny;
                List settleVOList;
                BigDecimal settleMny;
                feeVO.setReportingMonth(reportingMonth);
                feeVO.setCreateTime(new Date());
                if (listContractMap.containsKey(feeVO.getProjectId())) {
                    BigDecimal contractNum = (BigDecimal)listContractMap.get(feeVO.getProjectId());
                    feeVO.setContractNum(CommonUtils.parseNullValue(contractNum));
                } else {
                    feeVO.setContractNum(BigDecimal.ZERO);
                }
                String keyYjyj = feeVO.getProjectId() + "-\u5df2\u7ae3\u5df2\u7ed3";
                String keyYjwj = feeVO.getProjectId() + "-\u5df2\u7ae3\u672a\u7ed3";
                if (listContractTypetMap.containsKey(keyYjyj)) {
                    BigDecimal yjyjNum = (BigDecimal)listContractTypetMap.get(keyYjyj);
                    BigDecimal yjwjNum = (BigDecimal)listContractTypetMap.get(keyYjwj);
                    feeVO.setYjyjNum(CommonUtils.parseNullValue(yjyjNum));
                    feeVO.setYjwjNum(CommonUtils.parseNullValue(yjwjNum));
                } else {
                    feeVO.setYjyjNum(BigDecimal.ZERO);
                    feeVO.setYjwjNum(BigDecimal.ZERO);
                }
                if (listSettlMap.containsKey(feeVO.getProjectId())) {
                    settleMny = (BigDecimal)listSettlMap.get(feeVO.getProjectId());
                    feeVO.setSettleMny(CommonUtils.parseNullValue(settleMny));
                } else {
                    feeVO.setSettleMny(BigDecimal.ZERO);
                }
                if (listSpMap.containsKey(feeVO.getProjectId())) {
                    settleMny = (BigDecimal)listSpMap.get(feeVO.getProjectId());
                    feeVO.setClaimMny(CommonUtils.parseNullValue(settleMny));
                } else {
                    feeVO.setClaimMny(BigDecimal.ZERO);
                }
                if (listPayMnyMap.containsKey(feeVO.getProjectId())) {
                    settleVOList = (List)listPayMnyMap.get(feeVO.getProjectId());
                    List collectCompare = settleVOList.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    SettleVO periodVO = (SettleVO)collectCompare.stream().findFirst().get();
                    feeVO.setYfMny(CommonUtils.parseNullValue(periodVO.getYfMny()));
                    feeVO.setPayMny(CommonUtils.parseNullValue(periodVO.getPayMny()));
                    feeVO.setYfwfMny(CommonUtils.parseNullValue(periodVO.getYfwfMny()));
                } else {
                    feeVO.setYfMny(BigDecimal.ZERO);
                    feeVO.setPayMny(BigDecimal.ZERO);
                    feeVO.setYfwfMny(BigDecimal.ZERO);
                }
                if (listContractTypeMnyMap.containsKey(feeVO.getProjectId() + "-\u52b3\u52a1\u5206\u5305")) {
                    lwSettleMny = (BigDecimal)listContractTypeMnyMap.get(feeVO.getProjectId() + "-\u52b3\u52a1\u5206\u5305");
                    feeVO.setLwSettleMny(CommonUtils.parseNullValue(lwSettleMny));
                } else {
                    feeVO.setLwSettleMny(BigDecimal.ZERO);
                }
                if (listContractTypeMnyMap.containsKey(feeVO.getProjectId() + "-\u4e13\u4e1a\u5206\u5305")) {
                    lwSettleMny = (BigDecimal)listContractTypeMnyMap.get(feeVO.getProjectId() + "-\u4e13\u4e1a\u5206\u5305");
                    feeVO.setZySettleMny(CommonUtils.parseNullValue(lwSettleMny));
                } else {
                    feeVO.setZySettleMny(BigDecimal.ZERO);
                }
                if (listContractPayMnyMap.containsKey(feeVO.getProjectId())) {
                    String keyLw;
                    settleVOList = (List)listContractPayMnyMap.get(feeVO.getProjectId());
                    listContractPayMnyPeriodMap = settleVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId() + "-" + s.getContractStatusName()));
                    if (listContractPayMnyPeriodMap.containsKey(keyLw = feeVO.getProjectId() + "-\u52b3\u52a1\u5206\u5305")) {
                        List settleVOS = (List)listContractPayMnyPeriodMap.get(keyLw);
                        List collectCompare = settleVOS.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed()).collect(Collectors.toList());
                        SettleVO periodVO = (SettleVO)collectCompare.stream().findFirst().get();
                        feeVO.setLwPayMny(CommonUtils.parseNullValue(periodVO.getLwSettleMny()));
                    } else {
                        feeVO.setLwPayMny(BigDecimal.ZERO);
                    }
                    String keyZy = feeVO.getProjectId() + "-\u4e13\u4e1a\u5206\u5305";
                    if (listContractPayMnyPeriodMap.containsKey(keyZy)) {
                        List settleVOS = (List)listContractPayMnyPeriodMap.get(keyZy);
                        List collectCompare = settleVOS.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed()).collect(Collectors.toList());
                        SettleVO periodVO = (SettleVO)collectCompare.stream().findFirst().get();
                        feeVO.setZyPayMny(CommonUtils.parseNullValue(periodVO.getLwSettleMny()));
                    } else {
                        feeVO.setZyPayMny(BigDecimal.ZERO);
                    }
                }
                feeVO.setContractNum(CommonUtils.parseNullValue(feeVO.getContractNum()));
                feeVO.setYjyjNum(CommonUtils.parseNullValue(feeVO.getYjyjNum()));
                feeVO.setYjwjNum(CommonUtils.parseNullValue(feeVO.getYjwjNum()));
                feeVO.setSettleMny(CommonUtils.parseNullValue(feeVO.getSettleMny()));
                feeVO.setClaimMny(CommonUtils.parseNullValue(feeVO.getClaimMny()));
                feeVO.setYfMny(CommonUtils.parseNullValue(feeVO.getYfMny()));
                feeVO.setPayMny(CommonUtils.parseNullValue(feeVO.getPayMny()));
                feeVO.setYfwfMny(CommonUtils.parseNullValue(feeVO.getYfwfMny()));
                feeVO.setLwSettleMny(CommonUtils.parseNullValue(feeVO.getLwSettleMny()));
                feeVO.setZySettleMny(CommonUtils.parseNullValue(feeVO.getZySettleMny()));
                feeVO.setLwPayMny(CommonUtils.parseNullValue(feeVO.getLwPayMny()));
                feeVO.setZyPayMny(CommonUtils.parseNullValue(feeVO.getZyPayMny()));
                feeVO.setYjyjNum(CommonUtils.parseNullValue(feeVO.getYjyjNum()));
                feeVO.setYjwjNum(CommonUtils.parseNullValue(feeVO.getYjwjNum()));
                CommonResponse orgVo = this.orgApi.detailById(feeVO.getProjectDepartmentId());
                if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                feeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                feeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getName());
                feeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                feeVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            List feeEntityList = BeanMapper.mapList((Iterable)feeVOList, SettleEntity.class);
            this.settleService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<SettleVO> dealData(List<SettleVO> feeVOS) {
        for (SettleVO settleVO : feeVOS) {
            settleVO.setSettleMny(CommonUtils.parseYuanToWan(settleVO.getSettleMny()));
            settleVO.setClaimMny(CommonUtils.parseYuanToWan(settleVO.getClaimMny()));
            settleVO.setYfMny(CommonUtils.parseYuanToWan(settleVO.getYfMny()));
            settleVO.setPayMny(CommonUtils.parseYuanToWan(settleVO.getPayMny()));
            settleVO.setYfwfMny(CommonUtils.parseYuanToWan(settleVO.getYfwfMny()));
            settleVO.setLwSettleMny(CommonUtils.parseYuanToWan(settleVO.getLwSettleMny()));
            settleVO.setLwPayMny(CommonUtils.parseYuanToWan(settleVO.getLwPayMny()));
            settleVO.setZySettleMny(CommonUtils.parseYuanToWan(settleVO.getZySettleMny()));
            settleVO.setZyPayMny(CommonUtils.parseYuanToWan(settleVO.getZyPayMny()));
        }
        SettleVO feeVO = new SettleVO();
        ArrayList<SettleVO> arrayList = new ArrayList<SettleVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            arrayList.add(feeVO);
        }
        for (SettleVO settleVO : feeVOS) {
            settleVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(settleVO.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(SettleVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<SettleVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            SettleVO projectStatusSumfeeVO = new SettleVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<SettleVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(SettleVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<SettleVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                SettleVO orgStatusSumfeeVO = new SettleVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((SettleVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((SettleVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<SettleVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(SettleVO::getProjectCreateTime)).collect(Collectors.toList());
                for (SettleVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    feeVONum.setContractNum(CommonUtils.parseNullValue(feeVONum.getContractNum()));
                    feeVONum.setLwRate(CommonUtils.calculateRate(feeVONum.getLwPayMny(), feeVONum.getLwSettleMny()));
                    feeVONum.setZyRate(CommonUtils.calculateRate(feeVONum.getZyPayMny(), feeVONum.getZySettleMny()));
                    feeVONum.setSettleRate(CommonUtils.calculateRate(feeVONum.getYjyjNum(), feeVONum.getYjyjNum().add(feeVONum.getYjwjNum())));
                    feeVONum.setClaimRate(CommonUtils.calculateRate(feeVONum.getClaimMny(), feeVONum.getZySettleMny().add(feeVONum.getLwSettleMny())));
                }
                feeNewList.addAll((Collection<SettleVO>)orgStatusList);
            });
        });
        return arrayList;
    }

    private void getSumData(List<SettleVO> feeVOS, SettleVO feeVO) {
        BigDecimal contractNum = feeVOS.stream().map(SettleVO::getContractNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yjyjNum = feeVOS.stream().map(SettleVO::getYjyjNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yjwjNum = feeVOS.stream().map(SettleVO::getYjwjNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal settleMny = feeVOS.stream().map(SettleVO::getSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal claimMny = feeVOS.stream().map(SettleVO::getClaimMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yfMny = feeVOS.stream().map(SettleVO::getYfMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payMny = feeVOS.stream().map(SettleVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yfwfMny = feeVOS.stream().map(SettleVO::getYfwfMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal lwSettleMny = feeVOS.stream().map(SettleVO::getLwSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal lwPayMny = feeVOS.stream().map(SettleVO::getLwPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal zySettleMny = feeVOS.stream().map(SettleVO::getZySettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal zyPayMny = feeVOS.stream().map(SettleVO::getZyPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setContractNum(CommonUtils.parseNullValue(contractNum));
        feeVO.setSettleMny(settleMny);
        feeVO.setClaimMny(claimMny);
        feeVO.setYfMny(yfMny);
        feeVO.setPayMny(payMny);
        feeVO.setYfwfMny(yfwfMny);
        feeVO.setLwSettleMny(lwSettleMny);
        feeVO.setLwPayMny(lwPayMny);
        feeVO.setZySettleMny(zySettleMny);
        feeVO.setZyPayMny(zyPayMny);
        feeVO.setLwRate(CommonUtils.calculateRate(lwPayMny, lwSettleMny));
        feeVO.setZyRate(CommonUtils.calculateRate(zyPayMny, zySettleMny));
        feeVO.setSettleRate(CommonUtils.calculateRate(yjyjNum, yjyjNum.add(yjwjNum)));
        feeVO.setClaimRate(CommonUtils.calculateRate(feeVO.getClaimMny(), feeVO.getZySettleMny().add(feeVO.getLwSettleMny())));
    }

    private void getOrg(Map<Long, SettleVO> twoOrgMap, List<SettleVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (SettleVO settleVO : list) {
                if (!twoOrgMap.containsKey(settleVO.getProjectId())) continue;
                this.getTwoOrgData(twoOrgMap, settleVO);
            }
        }
    }

    private void getTwoOrgData(Map<Long, SettleVO> twoOrgMap, SettleVO settleVO) {
        SettleVO settleVOPro = twoOrgMap.get(settleVO.getProjectId());
        settleVO.setTwoOrgId(settleVOPro.getTwoOrgId());
        settleVO.setTwoOrgName(settleVOPro.getTwoOrgName());
        settleVO.setProjectStatus(settleVOPro.getProjectStatus());
    }
}

