/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.service.IProSignReserveService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProSignReserveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="proSignReserveService")
public class ProSignReserveServiceImpl
extends BaseServiceImpl<ProSignReserveMapper, ProSignReserveEntity>
implements IProSignReserveService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProSignReserveService proSignReserveService;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProSignReserveEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProSignReserveEntity::getReportingMonth, (Object)reportingMonth);
        this.proSignReserveService.remove((Wrapper)lambdaFee);
        List<Object> proSignReserveVOList = new ArrayList();
        proSignReserveVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.proSignReserveMapper.getProjects(projectIdList) : this.proSignReserveMapper.getProjects(null);
        List<Long> projectIds = proSignReserveVOList.stream().map(ProSignReserveVO::getProjectId).collect(Collectors.toList());
        List<ProSignReserveVO> contractVOS = this.proSignReserveMapper.queryContract(projectIds, reportingMonth);
        Map<Object, Object> contractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            for (ProSignReserveVO contractVO : contractVOS) {
                contractVO.setContractAmount(contractVO.getAfterChangeAmount() != null ? contractVO.getAfterChangeAmount() : CommonUtils.setBigDecimalDefaultValue(contractVO.getContractAmountByContract()));
            }
            contractMap = contractVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ProSignReserveVO> bookVOS = this.proSignReserveMapper.queryBook(projectIds);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProSignReserveVO> allocateVOS = this.proSignReserveMapper.queryAllocate(projectIds);
        Map<Object, Object> allocateMap = new HashMap();
        if (CollectionUtils.isNotEmpty(allocateVOS)) {
            allocateMap = allocateVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        for (ProSignReserveVO proSignReserveVO : proSignReserveVOList) {
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            proSignReserveVO.setReportingMonth(reportingMonth);
            Long projectId = proSignReserveVO.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                proSignReserveVO.setContractSignTime(((ProSignReserveVO)((List)contractMap.get(projectId)).get(0)).getCreateTime());
                proSignReserveVO.setContractAmount(((List)contractMap.get(projectId)).stream().map(it -> it.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
                proSignReserveVO.setAcContractAmount(((List)contractMap.get(projectId)).stream().map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                proSignReserveVO.setBookSignTime(((ProSignReserveVO)bookMap.get(projectId)).getBookSignTime());
                proSignReserveVO.setResponsibilityCost(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getResponsibilityCost()));
                proSignReserveVO.setUndertakingBenefits(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getUndertakingBenefits()));
                proSignReserveVO.setUndertakingBenefitsRate(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getUndertakingBenefitsRate()));
                proSignReserveVO.setOverallProfitMargin(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getUndertakingBenefits()), CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getTurninBase())));
            }
            if (!allocateMap.isEmpty() && allocateMap.containsKey(projectId)) {
                proSignReserveVO.setTrsReservedAmount(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)((List)allocateMap.get(projectId)).get(0)).getTrsReservedAmount()));
                proSignReserveVO.setApprovedReservedAmount(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)((List)allocateMap.get(projectId)).get(0)).getApprovedReservedAmount()));
                proSignReserveVO.setActualReservedAmount(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)((List)allocateMap.get(projectId)).get(0)).getActualReservedAmount()));
            }
            proSignReserveVO.setRiskReserve(CommonUtils.calculateRate(proSignReserveVO.getActualReservedAmount() != null ? proSignReserveVO.getActualReservedAmount() : BigDecimal.ZERO, proSignReserveVO.getApprovedReservedAmount() != null ? proSignReserveVO.getApprovedReservedAmount() : BigDecimal.ZERO));
            CommonResponse orgVo = this.orgApi.detailById(proSignReserveVO.getProjectDepartmentId());
            if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
            proSignReserveVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
            proSignReserveVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
            proSignReserveVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
            proSignReserveVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
        }
        List proSignReserveEntityList = BeanMapper.mapList(proSignReserveVOList, ProSignReserveEntity.class);
        this.proSignReserveService.saveBatch(proSignReserveEntityList);
    }

    @Override
    public List<ProSignReserveVO> dealData(List<ProSignReserveVO> proSignReserveVOS) {
        ProSignReserveVO proSignReserveVO = new ProSignReserveVO();
        ArrayList<ProSignReserveVO> newList = new ArrayList<ProSignReserveVO>();
        if (CollectionUtils.isNotEmpty(proSignReserveVOS)) {
            this.getSumData(proSignReserveVOS, proSignReserveVO);
            proSignReserveVO.setNumber("\u5408\u8ba1");
            proSignReserveVO.setId(Long.valueOf(IdWorker.getId()));
            newList.add(proSignReserveVO);
        }
        for (ProSignReserveVO proSignReserveVO2 : proSignReserveVOS) {
            proSignReserveVO2.setProjectStatusOrder(CommonUtils.getProjectOrderNum(proSignReserveVO2.getProjectStatus().intValue()));
        }
        proSignReserveVOS = proSignReserveVOS.stream().sorted(Comparator.comparing(ProSignReserveVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<ProSignReserveVO>> mapProjectStatusOrder = proSignReserveVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            ProSignReserveVO projectStatusSumVO = new ProSignReserveVO();
            projectStatusSumVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<ProSignReserveVO>)projectStatusList, projectStatusSumVO);
            newList.add(projectStatusSumVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProSignReserveVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProSignReserveVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                ProSignReserveVO orgStatusSumVO = new ProSignReserveVO();
                orgStatusSumVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProSignReserveVO)orgStatusList.stream().findFirst().get()).getProjectStatus().intValue()));
                orgStatusSumVO.setTwoOrgName(((ProSignReserveVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<ProSignReserveVO>)orgStatusList, orgStatusSumVO);
                newList.add(orgStatusSumVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProSignReserveVO::getProjectCreateTime)).collect(Collectors.toList());
                for (ProSignReserveVO proSignReserveVONum : orgStatusList) {
                    proSignReserveVONum.setNumber(number + "");
                    number = number + 1;
                    proSignReserveVONum.setProjectStatusName(CommonUtils.getProjectStatusName(proSignReserveVONum.getProjectStatus().intValue()));
                    proSignReserveVONum.setContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getContractAmount()));
                    proSignReserveVONum.setAcContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getAcContractAmount()));
                    proSignReserveVONum.setResponsibilityCost(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getResponsibilityCost()));
                    proSignReserveVONum.setUndertakingBenefits(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getUndertakingBenefits()));
                    proSignReserveVONum.setTrsReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getTrsReservedAmount()));
                    proSignReserveVONum.setApprovedReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getApprovedReservedAmount()));
                    proSignReserveVONum.setActualReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getActualReservedAmount()));
                }
                newList.addAll((Collection<ProSignReserveVO>)orgStatusList);
            });
        });
        return newList;
    }

    private void getSumData(List<ProSignReserveVO> proSignReserveVOS, ProSignReserveVO proSignReserveVO) {
        proSignReserveVO.setContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getContractAmount() != null).map(it -> it.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getAcContractAmount() != null).map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setResponsibilityCost(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getResponsibilityCost() != null).map(it -> it.getResponsibilityCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setTrsReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getTrsReservedAmount() != null).map(it -> it.getTrsReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setApprovedReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getApprovedReservedAmount() != null).map(it -> it.getApprovedReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setActualReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getActualReservedAmount() != null).map(it -> it.getActualReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setUndertakingBenefits(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getUndertakingBenefits() != null).map(it -> it.getUndertakingBenefits()).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }
}

