/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectIndexEntity;
import com.ejianc.business.analysis.mapper.ProjectIndexMapper;
import com.ejianc.business.analysis.service.IProjectIndexService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.MainanalysisdetailVO;
import com.ejianc.business.analysis.vo.MaineconomicindicatorsVO;
import com.ejianc.business.analysis.vo.ProjectIndexVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectIndexService")
public class ProjectIndexServiceImpl
extends BaseServiceImpl<ProjectIndexMapper, ProjectIndexEntity>
implements IProjectIndexService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ProjectIndexMapper baseMapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaPro = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaPro.in(ProjectIndexEntity::getProjectId, projectIdList);
        }
        lambdaPro.in(ProjectIndexEntity::getReportingMonth, new Object[]{reportingMonth});
        this.remove((Wrapper)lambdaPro);
        List<Object> projectIndexVOList = new ArrayList();
        projectIndexVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.queryProjects(projectIdList) : this.queryProjects(null);
        List<ProjectIndexVO> analysisList = this.quertAnalysis(reportingMonth);
        if (CollectionUtils.isNotEmpty(analysisList)) {
            ArrayList<Long> idList = new ArrayList<Long>();
            Map<Long, List<ProjectIndexVO>> projectIndexVOGrBy = analysisList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            if (CollectionUtils.isNotEmpty(projectIndexVOList)) {
                for (ProjectIndexVO profitIncomeVO : projectIndexVOList) {
                    profitIncomeVO.setReportingMonth(reportingMonth);
                    if (projectIndexVOGrBy.containsKey(profitIncomeVO.getProjectId())) {
                        List<ProjectIndexVO> projectIndexVOS = projectIndexVOGrBy.get(profitIncomeVO.getProjectId());
                        List collectCompare = projectIndexVOS.stream().sorted(Comparator.comparing(BaseVO::getCreateTime).reversed()).collect(Collectors.toList());
                        ProjectIndexVO projectIndexVO = (ProjectIndexVO)((Object)collectCompare.stream().findFirst().get());
                        profitIncomeVO.setAnalysisId(projectIndexVO.getAnalysisId());
                        idList.add(projectIndexVO.getAnalysisId());
                        profitIncomeVO.setBuildingFunction(projectIndexVO.getBuildingFunction());
                        profitIncomeVO.setBuildPlace(projectIndexVO.getBuildPlace());
                        profitIncomeVO.setStructMethod(projectIndexVO.getStructMethod());
                        profitIncomeVO.setEarthquakeFortification(projectIndexVO.getEarthquakeFortification());
                        profitIncomeVO.setEaveHeight(projectIndexVO.getEaveHeight());
                        profitIncomeVO.setPrefabricationRate(projectIndexVO.getPrefabricationRate());
                        profitIncomeVO.setAssemblySrate(projectIndexVO.getAssemblySrate());
                        profitIncomeVO.setArtificial(projectIndexVO.getArtificial());
                        profitIncomeVO.setSteelBar(projectIndexVO.getSteelBar());
                        profitIncomeVO.setConcrete(projectIndexVO.getConcrete());
                        profitIncomeVO.setCement(projectIndexVO.getCement());
                        profitIncomeVO.setSand(projectIndexVO.getSand());
                        profitIncomeVO.setCrushedStone(projectIndexVO.getCrushedStone());
                        profitIncomeVO.setBlock(projectIndexVO.getBlock());
                        profitIncomeVO.setPrecastReinforcement(projectIndexVO.getPrecastReinforcement());
                        profitIncomeVO.setPrecastConcrete(projectIndexVO.getPrecastConcrete());
                        profitIncomeVO.setStartDate(projectIndexVO.getStartDate());
                        profitIncomeVO.setCompletionDate(projectIndexVO.getCompletionDate());
                        continue;
                    }
                    profitIncomeVO.setEaveHeight(BigDecimal.ZERO);
                    profitIncomeVO.setPrefabricationRate(BigDecimal.ZERO);
                    profitIncomeVO.setAssemblySrate(BigDecimal.ZERO);
                    profitIncomeVO.setArtificial(BigDecimal.ZERO);
                    profitIncomeVO.setSteelBar(BigDecimal.ZERO);
                    profitIncomeVO.setConcrete(BigDecimal.ZERO);
                    profitIncomeVO.setCement(BigDecimal.ZERO);
                    profitIncomeVO.setSand(BigDecimal.ZERO);
                    profitIncomeVO.setCrushedStone(BigDecimal.ZERO);
                    profitIncomeVO.setBlock(BigDecimal.ZERO);
                    profitIncomeVO.setPrecastReinforcement(BigDecimal.ZERO);
                    profitIncomeVO.setPrecastConcrete(BigDecimal.ZERO);
                }
                List<Object> detailList = new ArrayList();
                if (CollectionUtils.isNotEmpty(idList)) {
                    detailList = this.quertAnalysisDetail(idList);
                }
                if (CollectionUtils.isNotEmpty(detailList)) {
                    Map<Long, List<MaineconomicindicatorsVO>> detailMap = detailList.stream().collect(Collectors.groupingBy(s -> s.getMid()));
                    for (Object profitIncomeVO : projectIndexVOList) {
                        MaineconomicindicatorsVO maineconomicindicatorsVO;
                        if (!detailMap.containsKey(profitIncomeVO.getAnalysisId())) continue;
                        List<MaineconomicindicatorsVO> maineconomicindicatorsVOList = detailMap.get(profitIncomeVO.getAnalysisId());
                        Map mainMap = maineconomicindicatorsVOList.stream().collect(Collectors.toMap(x -> x.getSerialNumber(), Function.identity(), (k1, k2) -> k2));
                        if (mainMap.containsKey("1.1")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.1"));
                            profitIncomeVO.setEarthCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setEarthCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setEarthCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("1.2")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.2"));
                            profitIncomeVO.setBasicsCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setBasicsCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setBasicsCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("1.3")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.3"));
                            profitIncomeVO.setSubjectCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setSubjectCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setSubjectCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("1.4")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.4"));
                            profitIncomeVO.setMasonryCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setMasonryCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setMasonryCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("1.5")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.5"));
                            profitIncomeVO.setWaterproofCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setWaterproofCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setWaterproofCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("1.6")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.6"));
                            profitIncomeVO.setPrefabricatedCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setPrefabricatedCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setPrefabricatedCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("1.7")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("1.7"));
                            profitIncomeVO.setElseArchitectureCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setElseArchitectureCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setElseArchitectureCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("2.1")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("2.1"));
                            profitIncomeVO.setFlooringCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setFlooringCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setFlooringCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("2.2")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("2.2"));
                            profitIncomeVO.setWallCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setWallCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setWallCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("2.3")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("2.3"));
                            profitIncomeVO.setCeilingCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setCeilingCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setCeilingCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("2.4")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("2.4"));
                            profitIncomeVO.setDoorsCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDoorsCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDoorsCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("2.5")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("2.5"));
                            profitIncomeVO.setOilPaintCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setOilPaintCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setOilPaintCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("2.6")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("2.6"));
                            profitIncomeVO.setDecorationElseCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDecorationElseCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDecorationElseCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("3.1")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("3.1"));
                            profitIncomeVO.setElectricCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setElectricCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setElectricCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("3.2")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("3.2"));
                            profitIncomeVO.setDrainCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDrainCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDrainCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("3.3")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("3.3"));
                            profitIncomeVO.setHeatingCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setHeatingCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setHeatingCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("3.4")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("3.4"));
                            profitIncomeVO.setVentilateCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setVentilateCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setVentilateCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("3.5")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("3.5"));
                            profitIncomeVO.setConditionerPaintCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setConditionerPaintCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setConditionerPaintCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("3.6")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("3.6"));
                            profitIncomeVO.setInstallElseCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setInstallElseCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setInstallElseCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.1")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.1"));
                            profitIncomeVO.setSafetyCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setSafetyCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setSafetyCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.2")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.2"));
                            profitIncomeVO.setTemplateCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setTemplateCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setTemplateCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.3")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.3"));
                            profitIncomeVO.setStagingCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setStagingCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setStagingCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.4")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.4"));
                            profitIncomeVO.setCarriageCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setCarriageCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setCarriageCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.5")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.5"));
                            profitIncomeVO.setTemporaryCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setTemporaryCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setTemporaryCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.6")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.6"));
                            profitIncomeVO.setDrainWaterCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setDrainWaterCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setDrainWaterCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (mainMap.containsKey("4.7")) {
                            maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.7"));
                            profitIncomeVO.setRainCost(maineconomicindicatorsVO.getManufacturingCost());
                            profitIncomeVO.setRainCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                            profitIncomeVO.setRainCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                            profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                        }
                        if (!mainMap.containsKey("4.8")) continue;
                        maineconomicindicatorsVO = (MaineconomicindicatorsVO)((Object)mainMap.get("4.8"));
                        profitIncomeVO.setMeasureElseCost(maineconomicindicatorsVO.getManufacturingCost());
                        profitIncomeVO.setMeasureElseCostPercentage(maineconomicindicatorsVO.getConstructionCost());
                        profitIncomeVO.setMeasureElseCostCentiare(maineconomicindicatorsVO.getSquareMeterCost());
                        profitIncomeVO.setRemark(maineconomicindicatorsVO.getRemarks());
                    }
                }
                List<Object> mainanalysisdetailVOList = new ArrayList();
                if (CollectionUtils.isNotEmpty(idList)) {
                    mainanalysisdetailVOList = this.quertMainanalyDetail(idList);
                }
                if (CollectionUtils.isNotEmpty(mainanalysisdetailVOList)) {
                    Map<Long, List<MainanalysisdetailVO>> mainanalysisdetailMap = mainanalysisdetailVOList.stream().collect(Collectors.groupingBy(s -> s.getMid()));
                    for (ProjectIndexVO profitIncomeVO : projectIndexVOList) {
                        MainanalysisdetailVO maineconomicindicatorsVO;
                        if (!mainanalysisdetailMap.containsKey(profitIncomeVO.getAnalysisId())) continue;
                        List maineconomicindicatorsVOList = (List)mainanalysisdetailMap.get(profitIncomeVO.getAnalysisId());
                        BigDecimal totalCost = maineconomicindicatorsVOList.stream().filter(s -> s.getManufacturingMainCost() != null).map(MainanalysisdetailVO::getManufacturingMainCost).reduce(BigDecimal.ZERO, BigDecimal::add);
                        profitIncomeVO.setTotalCost(totalCost == null ? BigDecimal.ZERO : totalCost);
                        Map mainMap = maineconomicindicatorsVOList.stream().collect(Collectors.toMap(x -> x.getProjectMainName(), Function.identity(), (k1, k2) -> k2));
                        if (mainMap.containsKey("\u5efa\u7b51\u5de5\u7a0b")) {
                            maineconomicindicatorsVO = (MainanalysisdetailVO)((Object)mainMap.get("\u5efa\u7b51\u5de5\u7a0b"));
                            profitIncomeVO.setArchitectureCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setArchitectureCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setArchitectureCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                        }
                        if (mainMap.containsKey("\u88c5\u9970\u5de5\u7a0b")) {
                            maineconomicindicatorsVO = (MainanalysisdetailVO)((Object)mainMap.get("\u88c5\u9970\u5de5\u7a0b"));
                            profitIncomeVO.setDecorationCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setDecorationCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setDecorationCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                        }
                        if (mainMap.containsKey("\u5b89\u88c5\u5de5\u7a0b")) {
                            maineconomicindicatorsVO = (MainanalysisdetailVO)((Object)mainMap.get("\u5b89\u88c5\u5de5\u7a0b"));
                            profitIncomeVO.setInstallationCost(maineconomicindicatorsVO.getManufacturingMainCost());
                            profitIncomeVO.setInstallationCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                            profitIncomeVO.setInstallationCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                        }
                        if (!mainMap.containsKey("\u5176\u4ed6")) continue;
                        maineconomicindicatorsVO = (MainanalysisdetailVO)((Object)mainMap.get("\u5176\u4ed6"));
                        profitIncomeVO.setElseEngineeringCost(maineconomicindicatorsVO.getManufacturingMainCost());
                        profitIncomeVO.setElseEngineeringCostPercentage(maineconomicindicatorsVO.getConstructionMainCost());
                        profitIncomeVO.setElseEngineeringCostCentiare(maineconomicindicatorsVO.getSquareMeterMainCost());
                    }
                }
                for (Object profitIncomeVO : projectIndexVOList) {
                    String innerCode;
                    String[] strs;
                    CommonResponse orgVos;
                    CommonResponse orgVo = this.iOrgApi.detailById(profitIncomeVO.getProjectDepartmentId());
                    if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                    profitIncomeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                    profitIncomeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                    profitIncomeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                    profitIncomeVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
                }
                Map projectIndexVOListMap = projectIndexVOList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
                ArrayList<ProjectIndexVO> projectIndexVOS = new ArrayList<ProjectIndexVO>();
                for (ProjectIndexVO projectIndexVO : analysisList) {
                    if (!projectIndexVOListMap.containsKey(projectIndexVO.getProjectId())) continue;
                    ProjectIndexVO projectIndexVO1 = (ProjectIndexVO)((Object)projectIndexVOListMap.get(projectIndexVO.getProjectId()));
                    projectIndexVOS.add(projectIndexVO1);
                }
                if (CollectionUtils.isNotEmpty(projectIndexVOS)) {
                    this.saveBatch(BeanMapper.mapList(projectIndexVOS, ProjectIndexEntity.class));
                }
            }
        }
    }

    @Override
    public List<ProjectIndexVO> queryProjects(List<Long> idList) {
        return this.baseMapper.getProjects(idList);
    }

    @Override
    public List<ProjectIndexVO> quertAnalysis(String endDate) {
        return this.baseMapper.quertAnalysis(endDate);
    }

    @Override
    public List<MaineconomicindicatorsVO> quertAnalysisDetail(List<Long> idList) {
        return this.baseMapper.quertAnalysisDetail(idList);
    }

    @Override
    public List<MainanalysisdetailVO> quertMainanalyDetail(List<Long> idList) {
        return this.baseMapper.quertMainanalyDetail(idList);
    }

    @Override
    public List<ProjectIndexVO> dealData(List<ProjectIndexVO> projectIndexVOS) {
        ArrayList<ProjectIndexVO> feeNewList = new ArrayList<ProjectIndexVO>();
        for (ProjectIndexVO projectIndexVO : projectIndexVOS) {
            projectIndexVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(projectIndexVO.getProjectStatus() == null ? 6 : projectIndexVO.getProjectStatus()));
        }
        projectIndexVOS = projectIndexVOS.stream().sorted(Comparator.comparing(ProjectIndexVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<ProjectIndexVO>> mapProjectStatusOrder = projectIndexVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectIndexVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProjectIndexVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectIndexVO::getProjectCreateTime)).collect(Collectors.toList());
                feeNewList.addAll((Collection<ProjectIndexVO>)orgStatusList);
            });
        });
        Integer number = 1;
        for (ProjectIndexVO feeVONum : feeNewList) {
            feeVONum.setNumber(number + "");
            number = number + 1;
            feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
        }
        return feeNewList;
    }
}

