/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProDurationDelayEntity;
import com.ejianc.business.analysis.mapper.ProDurationDelayMapper;
import com.ejianc.business.analysis.service.IProDurationDelayService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProDurationDelayVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="proDurationDelayService")
public class ProDurationDelayServiceImpl
extends BaseServiceImpl<ProDurationDelayMapper, ProDurationDelayEntity>
implements IProDurationDelayService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProDurationDelayService proDurationDelayService;
    @Autowired
    private ProDurationDelayMapper proDurationDelayMapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProDurationDelayEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProDurationDelayEntity::getReportingMonth, (Object)reportingMonth);
        this.proDurationDelayService.remove((Wrapper)lambdaFee);
        List<Object> projectdelaypVOS = new ArrayList();
        projectdelaypVOS = CollectionUtils.isNotEmpty(projectIdList) ? this.proDurationDelayMapper.queryProjectIds(projectIdList, reportingMonth) : this.proDurationDelayMapper.queryProjectIds(null, reportingMonth);
        List<ProDurationDelayVO> startList = this.proDurationDelayMapper.getGqStartDate();
        Map<Object, Object> startListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(startList)) {
            startListMap = startList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isEmpty(projectdelaypVOS)) {
            throw new BusinessException("\u5f53\u524d\u6708\u4efd\u524d\u6ca1\u6709\u5df2\u751f\u6548\u7684\u5de5\u671f\u5ef6\u8bef\u5355");
        }
        Map<Long, List<ProDurationDelayVO>> projectdelaypMap = projectdelaypVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        List<Long> projectIds = projectdelaypVOS.stream().map(ProDurationDelayVO::getProjectId).collect(Collectors.toList());
        List<ProDurationDelayVO> proDurationDelayVOS = this.proDurationDelayMapper.queryProject(projectIds);
        for (ProDurationDelayVO vo : proDurationDelayVOS) {
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            Long projectId = vo.getProjectId();
            Integer integer = projectdelaypMap.get(projectId).size() - 1;
            vo.setReportingMonth(reportingMonth);
            if (startListMap.containsKey(projectId)) {
                List proDurationDelayVOList = (List)startListMap.get(projectId);
                List collectCompare = proDurationDelayVOList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getBeginDelayTime)).collect(Collectors.toList());
                vo.setBeginDelayTime(((ProDurationDelayVO)collectCompare.stream().findFirst().get()).getBeginDelayTime());
                List collectCompareEnd = proDurationDelayVOList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getEndDelayTime).reversed()).collect(Collectors.toList());
                vo.setEndDelayTime(((ProDurationDelayVO)collectCompareEnd.stream().findFirst().get()).getEndDelayTime());
            }
            vo.setDelayDaysCasej(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayDaysCasej() != null).map(it -> it.getDelayDaysCasej()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayDaysCasey(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayDaysCasey() != null).map(it -> it.getDelayDaysCasey()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayDaysTotal(ComputeUtil.safeAdd((BigDecimal)vo.getDelayDaysCasej(), (BigDecimal)vo.getDelayDaysCasey()));
            vo.setDelayCostCasej(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayCostCasej() != null).map(it -> it.getDelayCostCasej()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayCostCasey(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayCostCasey() != null).map(it -> it.getDelayCostCasey()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayCostTotal(ComputeUtil.safeAdd((BigDecimal)vo.getDelayCostCasej(), (BigDecimal)vo.getDelayCostCasey()));
            vo.setDelayClaimEstimate(projectdelaypMap.get(projectId).get(integer).getDelayClaimEstimate());
            vo.setDelayClaimBasis(projectdelaypMap.get(projectId).get(integer).getDelayClaimBasis());
            vo.setDelayClaimTime(projectdelaypMap.get(projectId).get(integer).getDelayClaimTime());
            vo.setCompensateDate(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateDate() != null).map(it -> it.getCompensateDate()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setCompensateCost(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateCost() != null).map(it -> it.getCompensateCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setCompensateSubmit(projectdelaypMap.get(projectId).get(integer).getCompensateSubmit());
            vo.setCompensateConfirmDays(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateConfirmDays() != null).map(it -> it.getCompensateConfirmDays()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setCompensateConfirmDate(projectdelaypMap.get(projectId).get(integer).getCompensateConfirmDate());
            vo.setCompensateConfirmCost(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateConfirmCost() != null).map(it -> it.getCompensateConfirmCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setProjectCompletionDays(projectdelaypMap.get(projectId).get(integer).getProjectCompletionDays());
            vo.setProjectCompletionCost(projectdelaypMap.get(projectId).get(integer).getProjectCompletionCost());
            vo.setPersonLiable(projectdelaypMap.get(projectId).get(integer).getPersonLiable());
            vo.setEstimatedCompletionTime(projectdelaypMap.get(projectId).get(integer).getEstimatedCompletionTime());
            vo.setResolutionMeasures(projectdelaypMap.get(projectId).get(integer).getResolutionMeasures());
            vo.setRemarks(projectdelaypMap.get(projectId).get(integer).getRemarks());
            CommonResponse orgVo = this.orgApi.detailById(vo.getProjectDepartmentId());
            if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
            vo.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
            vo.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
            vo.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
            vo.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
        }
        List proDurationDelayEntityList = BeanMapper.mapList(proDurationDelayVOS, ProDurationDelayEntity.class);
        this.proDurationDelayService.saveBatch(proDurationDelayEntityList);
    }

    @Override
    public List<ProDurationDelayVO> dealData(List<ProDurationDelayVO> proDurationDelayVOS) {
        ProDurationDelayVO proDurationDelayVO = new ProDurationDelayVO();
        ArrayList<ProDurationDelayVO> newList = new ArrayList<ProDurationDelayVO>();
        if (CollectionUtils.isNotEmpty(proDurationDelayVOS)) {
            this.getSumData(proDurationDelayVOS, proDurationDelayVO);
            proDurationDelayVO.setNumber("\u5408\u8ba1");
            proDurationDelayVO.setId(Long.valueOf(IdWorker.getId()));
            newList.add(proDurationDelayVO);
        }
        for (ProDurationDelayVO proDurationDelayVO2 : proDurationDelayVOS) {
            proDurationDelayVO2.setProjectStatusOrder(CommonUtils.getProjectOrderNum(proDurationDelayVO2.getProjectStatus().intValue()));
        }
        proDurationDelayVOS = proDurationDelayVOS.stream().sorted(Comparator.comparing(ProDurationDelayVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<ProDurationDelayVO>> mapProjectStatusOrder = proDurationDelayVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            ProDurationDelayVO projectStatusSumVO = new ProDurationDelayVO();
            projectStatusSumVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            this.getSumData((List<ProDurationDelayVO>)projectStatusList, projectStatusSumVO);
            newList.add(projectStatusSumVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProDurationDelayVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                ProDurationDelayVO orgStatusSumVO = new ProDurationDelayVO();
                orgStatusSumVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProDurationDelayVO)orgStatusList.stream().findFirst().get()).getProjectStatus().intValue()));
                orgStatusSumVO.setTwoOrgName(((ProDurationDelayVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<ProDurationDelayVO>)orgStatusList, orgStatusSumVO);
                newList.add(orgStatusSumVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getProjectCreateTime)).collect(Collectors.toList());
                for (ProDurationDelayVO proDurationDelayVONum : orgStatusList) {
                    proDurationDelayVONum.setNumber(number + "");
                    number = number + 1;
                    proDurationDelayVONum.setProjectStatusName(CommonUtils.getProjectStatusName(proDurationDelayVONum.getProjectStatus().intValue()));
                    proDurationDelayVONum.setDelayCostTotal(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayCostTotal()));
                    proDurationDelayVONum.setDelayCostCasej(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayCostCasej()));
                    proDurationDelayVONum.setDelayCostCasey(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayCostCasey()));
                    proDurationDelayVONum.setDelayClaimBasis(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayClaimBasis()));
                    proDurationDelayVONum.setCompensateCost(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getCompensateCost()));
                    proDurationDelayVONum.setCompensateConfirmCost(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getCompensateConfirmCost()));
                    proDurationDelayVONum.setProjectCompletionCost(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getProjectCompletionCost()));
                }
                newList.addAll((Collection<ProDurationDelayVO>)orgStatusList);
            });
        });
        return newList;
    }

    private void getSumData(List<ProDurationDelayVO> proDurationDelayVOS, ProDurationDelayVO proDurationDelayVO) {
        proDurationDelayVO.setDelayDaysTotal(proDurationDelayVOS.stream().map(it -> it.getDelayDaysTotal()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setDelayDaysCasej(proDurationDelayVOS.stream().map(it -> it.getDelayDaysCasej()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setDelayDaysCasey(proDurationDelayVOS.stream().map(it -> it.getDelayDaysCasey()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setDelayCostTotal(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayCostTotal()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayCostCasej(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayCostCasej()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayCostCasey(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayCostCasey()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayClaimEstimate(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayClaimEstimate()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayClaimBasis(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayClaimBasis()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setCompensateDate(proDurationDelayVOS.stream().map(it -> it.getCompensateDate()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setCompensateCost(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getCompensateCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setCompensateConfirmDays(proDurationDelayVOS.stream().map(it -> it.getCompensateConfirmDays()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setCompensateConfirmCost(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getCompensateConfirmCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setProjectCompletionDays(proDurationDelayVOS.stream().map(it -> it.getProjectCompletionDays()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setProjectCompletionCost(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getProjectCompletionCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }
}

