/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class CommonUtils {
    public static final String defaultErrMsg = "\u63a8\u9001\u6570\u636e\u5931\u8d25\uff01";
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";

    private CommonUtils() {
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse) {
        return CommonUtils.checkCommonResponse(commonResponse, true, null, null);
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, Logger logger) {
        return CommonUtils.checkCommonResponse(commonResponse, true, null, logger);
    }

    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, boolean isThrow, String errMsg, Logger logger) {
        if (!commonResponse.isSuccess()) {
            if (logger != null) {
                logger.info("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8c03\u7528\u7ed3\u679c\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)commonResponse.isSuccess(), (Object)commonResponse.getMsg());
            }
            if (isThrow) {
                throw new BusinessException(StringUtils.isNotEmpty((CharSequence)errMsg) ? errMsg : commonResponse.getMsg());
            }
            return false;
        }
        try {
            String dataString;
            Object data = commonResponse.getData();
            if (data instanceof String) {
                dataString = String.valueOf(data);
                if (noPower.equals(dataString)) {
                    throw new BusinessException(dataString);
                }
            } else {
                dataString = JSONObject.toJSONString((Object)data);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataString);
            if (StringUtils.isNotEmpty((CharSequence)dataString) && jsonObject.containsKey((Object)"code")) {
                CommonResponse check = (CommonResponse)JSONObject.toJavaObject((JSON)jsonObject, CommonResponse.class);
                if (isThrow && !check.isSuccess()) {
                    if (logger != null) {
                        logger.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)check.getMsg());
                    }
                    throw new BusinessException(StringUtils.isNotEmpty((CharSequence)errMsg) ? errMsg : check.getMsg());
                }
                return check.isSuccess();
            }
            throw new BusinessException(defaultErrMsg);
        }
        catch (BusinessException be) {
            if (logger != null) {
                logger.error(be.getErrorMsg());
            }
            throw be;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff01\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fjson\u6216CommonResponse");
            }
            if (isThrow) {
                throw new BusinessException(defaultErrMsg);
            }
            return true;
        }
    }

    public static BigDecimal setBigDecimalDefaultValue(BigDecimal v) {
        if (v == null) {
            return BigDecimal.ZERO;
        }
        return v;
    }

    public static Integer isIntNull(Integer v) {
        if (v == null) {
            return 0;
        }
        return v;
    }

    public static BigDecimal parseCsValue(BigDecimal a, BigDecimal b) {
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, 8, 4);
    }

    public static BigDecimal calculateRate(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, 8, 4).multiply(new BigDecimal(100));
    }

    public static BigDecimal parseYuanToWan(BigDecimal a) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return a.divide(new BigDecimal(10000), 0, 4);
    }

    public static BigDecimal parseYuanToWanZ(BigDecimal a) {
        if (a == null) {
            return BigDecimal.ZERO;
        }
        return a.divide(new BigDecimal(10000), 0, 4);
    }

    public static BigDecimal parseNullValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public static String getEndDate(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String endDate = null;
        if (StringUtils.isNotEmpty((CharSequence)day)) {
            if (!day.equals(DateFormatUtils.format((Date)new Date(), (String)"d"))) {
                throw new BusinessException("\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u5339\u914d\u8bbe\u7f6e\u65e5\u671f");
            }
            endDate = CommonUtils.getEndDate();
        }
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            endDate = CommonUtils.getEndDate();
        }
        if (inAdvanceFlag != null && inAdvanceFlag == 1) {
            endDate = CommonUtils.getEndDateNow();
        }
        return endDate;
    }

    private static String getEndDateNow() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }

    private static String getEndDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(2, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }

    public static String getSysYearAndFirstMonth() {
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        return year + "-01";
    }

    public static Integer getProjectOrderNum(Integer status) {
        Integer projectStatusOrder = null;
        if (status == 1) {
            projectStatusOrder = 1;
        }
        if (status == 2) {
            projectStatusOrder = 2;
        }
        if (status == 3) {
            projectStatusOrder = 4;
        }
        if (status == 4) {
            projectStatusOrder = 3;
        }
        if (status == 5) {
            projectStatusOrder = 5;
        }
        if (status == 6) {
            projectStatusOrder = 6;
        }
        return projectStatusOrder;
    }

    public static String getProjectStatusName(Integer status) {
        String projectStatusName = null;
        if (status == 1) {
            projectStatusName = "\u672a\u5f00\u5de5";
        }
        if (status == 2) {
            projectStatusName = "\u5728\u5efa";
        }
        if (status == 3) {
            projectStatusName = "\u5b8c\u5de5\u672a\u7ae3";
        }
        if (status == 4) {
            projectStatusName = "\u505c\u7f13\u5efa";
        }
        if (status == 5) {
            projectStatusName = "\u7ae3\u5de5\u672a\u7ed3\u7b97";
        }
        if (status == 6) {
            projectStatusName = "\u7ae3\u5de5\u5df2\u7ed3\u7b97";
        }
        return projectStatusName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExcelName(HttpServletResponse response, String reportingMonth, String nodeName, String excelName, Map<String, Object> beans) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            beans.put("dateFormat", dateFormat);
            beans.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource(excelName);
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), beans);
            Sheet sheet = workbook.getSheetAt(0);
            sheet.getRow(0).getCell(0).setCellValue("\u622a\u81f3" + CommonUtils.getdate(reportingMonth) + nodeName);
            workbook.write((OutputStream)outputStream);
        }
        catch (Exception var18) {
            var18.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException var17) {
                    var17.printStackTrace();
                }
            }
        }
    }

    public static String getdate(String date) {
        String[] datel = date.split(" ");
        String[] date2 = datel[0].split("-");
        String date4 = date2[0] + "\u5e74" + date2[1] + "\u6708";
        return date4;
    }
}

