package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目考核兑现统计表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_project_check")
public class ProjectCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="project_approval_number")
    private Integer projectApprovalNumber; // 立项数量（个）
    @TableField(value="predict_earnings")
    private BigDecimal predictEarnings; // 预计收益（万元）
    @TableField(value="already_embodiment")
    private Integer alreadyEmbodiment; // 已实施项
    @TableField(value="net_earning")
    private BigDecimal netEarning; // 实现净效益（万元）
    @TableField(value="cashing_money")
    private BigDecimal cashingMoney; // 兑现金额（万元）
    @TableField(value="course_assess")
    private Integer courseAssess; // 过程考核（次）
    @TableField(value="course_assess_money")
    private BigDecimal courseAssessMoney; // 过程考核应兑现金额（万元）
    @TableField(value="practical_course_assess_money")
    private BigDecimal practicalCourseAssessMoney; // 过程考核实际已兑现金额（万元）
    @TableField(value="completed_assess_money")
    private BigDecimal completedAssessMoney; // 竣工考核应兑现金额（万元）
    @TableField(value="reality_money")
    private BigDecimal realityMoney; // 实际发放金额
    @TableField(value="reserved_money")
    private BigDecimal reservedMoney; // 预留奖金
    @TableField(value="reserved_money_return")
    private BigDecimal reservedMoneyReturn; // 预留奖金返还金额（万元）
    @TableField(value="statement_assess_money")
    private BigDecimal statementAssessMoney; // 总包结算考核兑现金额（万元）
    @TableField(value="remake")
    private String remake; // 备注
    @TableField(value="short_name")
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
    public Integer getProjectApprovalNumber() {
        return projectApprovalNumber;
    }

    public void setProjectApprovalNumber(Integer projectApprovalNumber) {
        this.projectApprovalNumber = projectApprovalNumber;
    }
    public BigDecimal getPredictEarnings() {
        return predictEarnings;
    }

    public void setPredictEarnings(BigDecimal predictEarnings) {
        this.predictEarnings = predictEarnings;
    }
    public Integer getAlreadyEmbodiment() {
        return alreadyEmbodiment;
    }

    public void setAlreadyEmbodiment(Integer alreadyEmbodiment) {
        this.alreadyEmbodiment = alreadyEmbodiment;
    }
    public BigDecimal getNetEarning() {
        return netEarning;
    }

    public void setNetEarning(BigDecimal netEarning) {
        this.netEarning = netEarning;
    }
    public BigDecimal getCashingMoney() {
        return cashingMoney;
    }

    public void setCashingMoney(BigDecimal cashingMoney) {
        this.cashingMoney = cashingMoney;
    }

    public Integer getCourseAssess() {
        return courseAssess;
    }

    public void setCourseAssess(Integer courseAssess) {
        this.courseAssess = courseAssess;
    }

    public BigDecimal getCourseAssessMoney() {
        return courseAssessMoney;
    }

    public void setCourseAssessMoney(BigDecimal courseAssessMoney) {
        this.courseAssessMoney = courseAssessMoney;
    }
    public BigDecimal getPracticalCourseAssessMoney() {
        return practicalCourseAssessMoney;
    }

    public void setPracticalCourseAssessMoney(BigDecimal practicalCourseAssessMoney) {
        this.practicalCourseAssessMoney = practicalCourseAssessMoney;
    }
    public BigDecimal getCompletedAssessMoney() {
        return completedAssessMoney;
    }

    public void setCompletedAssessMoney(BigDecimal completedAssessMoney) {
        this.completedAssessMoney = completedAssessMoney;
    }
    public BigDecimal getRealityMoney() {
        return realityMoney;
    }

    public void setRealityMoney(BigDecimal realityMoney) {
        this.realityMoney = realityMoney;
    }
    public BigDecimal getReservedMoney() {
        return reservedMoney;
    }

    public void setReservedMoney(BigDecimal reservedMoney) {
        this.reservedMoney = reservedMoney;
    }
    public BigDecimal getReservedMoneyReturn() {
        return reservedMoneyReturn;
    }

    public void setReservedMoneyReturn(BigDecimal reservedMoneyReturn) {
        this.reservedMoneyReturn = reservedMoneyReturn;
    }
    public BigDecimal getStatementAssessMoney() {
        return statementAssessMoney;
    }

    public void setStatementAssessMoney(BigDecimal statementAssessMoney) {
        this.statementAssessMoney = statementAssessMoney;
    }
    public String getRemake() {
        return remake;
    }

    public void setRemake(String remake) {
        this.remake = remake;
    }
    
}
