package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.CompleteSettlementEntity;
import com.ejianc.business.analysis.mapper.CompleteSettlementMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.ICompleteSettlementService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.CompleteSettlementVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目工程造价指标分析
 * 
 * @author generator
 * 
 */
@Service("completeSettlementService")
public class CompleteSettlementServiceImpl extends BaseServiceImpl<CompleteSettlementMapper, CompleteSettlementEntity> implements ICompleteSettlementService{

    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;

    @Autowired
    private CompleteSettlementMapper completeSettlementMapper;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<CompleteSettlementEntity> lambdaFee = Wrappers.<CompleteSettlementEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(CompleteSettlementEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(CompleteSettlementEntity::getReportingMonth, reportingMonth);
        remove(lambdaFee);
        
        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null);
        }

        if(CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<CompleteSettlementVO> completeSettlementVOList = BeanMapper.mapList(profitIncomeVOList, CompleteSettlementVO.class);
            Map<Long, CompleteSettlementVO> completeSettlementVOMap = completeSettlementVOList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            //查询项目成本指标分析
            List<CompleteSettlementVO> completeSettlementVOS = quertRestoremetricsanalyse(reportingMonth,projectIdList);
            //查询实际成本
            List<CompleteSettlementVO> quertAnalysisList = quertAnalysis(reportingMonth,projectIdList);

            if(CollectionUtils.isNotEmpty(completeSettlementVOS)){
                List<CompleteSettlementVO> completeSettlementVOSList = new ArrayList<>();
                //分组
                Map<Long, List<CompleteSettlementVO>> completeSettlementVOSGrBy =completeSettlementVOS.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getProjectId()
                        ));
                //遍历
                completeSettlementVOSGrBy.forEach((orgStatusKey,orgStatusList)->{
                    //排序
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getCreateTime).reversed())
                            .collect(Collectors.toList());
                    completeSettlementVOSList.add(orgStatusList.stream().findFirst().get());
                });
                for(CompleteSettlementVO completeSettlementVO : completeSettlementVOSList){
                    if(completeSettlementVOMap.containsKey(completeSettlementVO.getProjectId())){
                        CompleteSettlementVO completeSettlementVO1 = completeSettlementVOMap.get(completeSettlementVO.getProjectId());
                        completeSettlementVO.setReportingMonth(reportingMonth);
                        completeSettlementVO.setProjectStatus(completeSettlementVO1.getProjectStatus());
                        completeSettlementVO.setProjectDepartmentId(completeSettlementVO1.getProjectDepartmentId());
                        completeSettlementVO.setProjectCode(completeSettlementVO1.getProjectCode());
                        completeSettlementVO.setProjectCreateTime(completeSettlementVO1.getProjectCreateTime());
                        completeSettlementVO.setTenantId(completeSettlementVO1.getTenantId());
                        completeSettlementVO.setOrgId(completeSettlementVO1.getOrgId());
                        completeSettlementVO.setOrgName(completeSettlementVO1.getOrgName());
                        CommonResponse<OrgVO> orgVo = orgApi.detailById(completeSettlementVO.getProjectDepartmentId());//此处是项目部id
                        if (orgVo.isSuccess() && null != orgVo.getData()) {
                            String innerCode = orgVo.getData().getInnerCode();
                            String[] strs = innerCode.split("\\|");
                            CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                            if (orgVos.isSuccess() && null != orgVos.getData()) {
                                //二级组织信息
                                completeSettlementVO.setTwoOrgId(orgVos.getData().getId());
                                completeSettlementVO.setTwoOrgName(orgVos.getData().getShortName());
                                completeSettlementVO.setTwoOrgCode(orgVos.getData().getCode());
                                completeSettlementVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                            }
                        }
                    }
                    if(CollectionUtils.isNotEmpty(quertAnalysisList)){
                        Map<Long, List<CompleteSettlementVO>> costanalysisListGrBy =quertAnalysisList.stream().collect(
                                Collectors.groupingBy(
                                        s -> s.getProjectId()
                                ));

                        if(costanalysisListGrBy.containsKey(completeSettlementVO.getProjectId())){
                            List<CompleteSettlementVO> completeSettlementVO1 = costanalysisListGrBy.get(completeSettlementVO.getProjectId());
                            //排序获取最近的月份数据
                            List<CompleteSettlementVO> collectCompare = completeSettlementVO1.stream().sorted(Comparator.comparing(CompleteSettlementVO::getReportingMonth).reversed())
                                    .collect(Collectors.toList());
                            CompleteSettlementVO completeSettlementVO2 = collectCompare.stream().findFirst().get();
                            completeSettlementVO.setTotalMoney(completeSettlementVO2.getSumPlanCost());
                           //每米成本
                            completeSettlementVO.setPerMeterCost(ComputeUtil.safeMultiply(CommonUtils.setBigDecimalDefaultValue(completeSettlementVO2.getSumPlanCost()),CommonUtils.setBigDecimalDefaultValue(completeSettlementVO.getBuildArea())));
                        }
                    }
                }
                saveBatch( BeanMapper.mapList(completeSettlementVOS, CompleteSettlementEntity.class));
            }

        }

    }

    @Override
    public List<CompleteSettlementVO> dealData(List<CompleteSettlementVO> completeSettlementVOList) {
        List<CompleteSettlementVO> feeNewList = new ArrayList<>();

        //计算排序字段
        for(CompleteSettlementVO completeSettlementVO :completeSettlementVOList){
            completeSettlementVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(completeSettlementVO.getProjectStatus()));
        }

        completeSettlementVOList = completeSettlementVOList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<CompleteSettlementVO>> mapProjectStatusOrder = completeSettlementVOList.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<CompleteSettlementVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{

                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getProjectCreateTime))
                        .collect(Collectors.toList());

                feeNewList.addAll(orgStatusList);
            });

        });
        Integer number = 1;
        for (CompleteSettlementVO compVONum : feeNewList){
            compVONum.setNumber(number +"");
            number = number + 1;
            compVONum.setProjectStatusName(CommonUtils.getProjectStatusName(compVONum.getProjectStatus()));
            compVONum.setTotalMoney(CommonUtils.parseYuanToWanZ(compVONum.getTotalMoney()));
        }
        
        return feeNewList;
    }

    @Override
    public List<CompleteSettlementVO> quertRestoremetricsanalyse(String endDate,List<Long> idList) {
        return completeSettlementMapper.quertRestoremetricsanalyse(endDate,idList);
    }

    @Override
    public List<CompleteSettlementVO> quertAnalysis(String endDate, List<Long> projectIdList) {
        return completeSettlementMapper.quertAnalysis(endDate,projectIdList);
    }
}
