package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.UnsettledProBusinessEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProDurationDelayVO;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ProDurationDelayMapper;
import com.ejianc.business.analysis.bean.ProDurationDelayEntity;
import com.ejianc.business.analysis.service.IProDurationDelayService;
import org.w3c.dom.stylesheets.LinkStyle;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工期延误项目成本风险化解情况
 *
 * @author generator
 */
@Service("proDurationDelayService")
public class ProDurationDelayServiceImpl extends BaseServiceImpl<ProDurationDelayMapper, ProDurationDelayEntity> implements IProDurationDelayService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProDurationDelayService proDurationDelayService;
    @Autowired
    private ProDurationDelayMapper proDurationDelayMapper;

    @Override

    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ProDurationDelayEntity> lambdaFee = Wrappers.<ProDurationDelayEntity>lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProDurationDelayEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProDurationDelayEntity::getReportingMonth, reportingMonth);
        proDurationDelayService.remove(lambdaFee);

        List<ProDurationDelayVO> projectdelaypVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            projectdelaypVOS = proDurationDelayMapper.queryProjectIds(projectIdList,reportingMonth);
        }else{
            //等于1代表预生成数据
            projectdelaypVOS = proDurationDelayMapper.queryProjectIds(null,reportingMonth);
        }

        //查询工期延误开始时间和结束时间
        List<ProDurationDelayVO> startList = proDurationDelayMapper.getGqStartDate();
        Map<Long,List<ProDurationDelayVO>> startListMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(startList)){
            startListMap = startList.stream().collect(Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }

        if (CollectionUtils.isEmpty(projectdelaypVOS)) {
            throw new BusinessException("当前月份前没有已生效的工期延误单");
        }
        Map<Long, List<ProDurationDelayVO>> projectdelaypMap = projectdelaypVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        List<Long> projectIds = projectdelaypVOS.stream().map(ProDurationDelayVO::getProjectId).collect(Collectors.toList());
        //查询项目信息数据
        List<ProDurationDelayVO> proDurationDelayVOS = proDurationDelayMapper.queryProject(projectIds);
        for (ProDurationDelayVO vo : proDurationDelayVOS) {
            Long projectId = vo.getProjectId();
            Integer integer = projectdelaypMap.get(projectId).size() - 1;// 最后一期
            vo.setReportingMonth(reportingMonth);
            // 取最后一期数据
            if (startListMap.containsKey(projectId)){
                List<ProDurationDelayVO> proDurationDelayVOList = startListMap.get(projectId);
                List<ProDurationDelayVO> collectCompare = proDurationDelayVOList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getBeginDelayTime))
                        .collect(Collectors.toList());
                vo.setBeginDelayTime(collectCompare.stream().findFirst().get().getBeginDelayTime());
                List<ProDurationDelayVO> collectCompareEnd = proDurationDelayVOList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getEndDelayTime).reversed())
                        .collect(Collectors.toList());
                vo.setEndDelayTime(collectCompareEnd.stream().findFirst().get().getEndDelayTime());
            }
            // 该项目下所有数据累加，元转换成万元
            vo.setDelayDaysCasej(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayDaysCasej()!=null).map(it -> it.getDelayDaysCasej()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayDaysCasey(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayDaysCasey() != null).map(it -> it.getDelayDaysCasey()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayDaysTotal(ComputeUtil.safeAdd(vo.getDelayDaysCasej(), vo.getDelayDaysCasey()));
            vo.setDelayCostCasej(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayCostCasej() != null).map(it -> it.getDelayCostCasej()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayCostCasey(projectdelaypMap.get(projectId).stream().filter(s -> s.getDelayCostCasey() != null).map(it -> it.getDelayCostCasey()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setDelayCostTotal(ComputeUtil.safeAdd(vo.getDelayCostCasej(), vo.getDelayCostCasey()));
            vo.setDelayClaimEstimate(projectdelaypMap.get(projectId).get(integer).getDelayClaimEstimate());
            vo.setDelayClaimBasis(projectdelaypMap.get(projectId).get(integer).getDelayClaimBasis());
            vo.setDelayClaimTime(projectdelaypMap.get(projectId).get(integer).getDelayClaimTime());
            vo.setCompensateDate(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateDate()!=null).map(it -> it.getCompensateDate()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setCompensateCost(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateCost()!=null).map(it -> it.getCompensateCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setCompensateSubmit(projectdelaypMap.get(projectId).get(integer).getCompensateSubmit());
            vo.setCompensateConfirmDays(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateConfirmDays()!=null).map(it -> it.getCompensateConfirmDays()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setCompensateConfirmDate(projectdelaypMap.get(projectId).get(integer).getCompensateConfirmDate());
            vo.setCompensateConfirmCost(projectdelaypMap.get(projectId).stream().filter(s -> s.getCompensateConfirmCost()!=null).map(it -> it.getCompensateConfirmCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setProjectCompletionDays(projectdelaypMap.get(projectId).get(integer).getProjectCompletionDays());
            vo.setProjectCompletionCost(projectdelaypMap.get(projectId).get(integer).getProjectCompletionCost());
            vo.setPersonLiable(projectdelaypMap.get(projectId).get(integer).getPersonLiable());
            vo.setEstimatedCompletionTime(projectdelaypMap.get(projectId).get(integer).getEstimatedCompletionTime());
            vo.setResolutionMeasures(projectdelaypMap.get(projectId).get(integer).getResolutionMeasures());
            vo.setRemarks(projectdelaypMap.get(projectId).get(integer).getRemarks());

            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setTwoOrgId(orgVos.getData().getId());
                    vo.setTwoOrgCode(orgVos.getData().getCode());
                    vo.setTwoOrgName(orgVos.getData().getShortName());
                    vo.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                }
            }
        }
        List<ProDurationDelayEntity> proDurationDelayEntityList = BeanMapper.mapList(proDurationDelayVOS, ProDurationDelayEntity.class);
        proDurationDelayService.saveBatch(proDurationDelayEntityList);
    }

    @Override
    public List<ProDurationDelayVO> dealData(List<ProDurationDelayVO> proDurationDelayVOS) {
        //处理第一行合计值
        ProDurationDelayVO proDurationDelayVO = new ProDurationDelayVO();
        ArrayList<ProDurationDelayVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(proDurationDelayVOS)) {
            getSumData(proDurationDelayVOS, proDurationDelayVO);
            proDurationDelayVO.setNumber("合计");
            proDurationDelayVO.setId(IdWorker.getId());
            newList.add(proDurationDelayVO);
        }

        //计算排序字段
        for (ProDurationDelayVO proDurationDelayVOrder : proDurationDelayVOS) {
            proDurationDelayVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(proDurationDelayVOrder.getProjectStatus().intValue()));
        }

        //计算项目状态合计
        proDurationDelayVOS = proDurationDelayVOS.stream().sorted(Comparator.comparing(ProDurationDelayVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ProDurationDelayVO>> mapProjectStatusOrder = proDurationDelayVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ProDurationDelayVO projectStatusSumVO = new ProDurationDelayVO();
            projectStatusSumVO.setNumber("项目状态合计");
            projectStatusSumVO.setId(IdWorker.getId());
            projectStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumVO);
            newList.add(projectStatusSumVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProDurationDelayVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ProDurationDelayVO orgStatusSumVO = new ProDurationDelayVO();
                orgStatusSumVO.setNumber("单位小计");
                orgStatusSumVO.setId(IdWorker.getId());
                orgStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus().intValue()));
                orgStatusSumVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumVO);
                newList.add(orgStatusSumVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProDurationDelayVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ProDurationDelayVO proDurationDelayVONum : orgStatusList){
                    proDurationDelayVONum.setNumber(number +"");
                    number = number + 1;
                    proDurationDelayVONum.setProjectStatusName(CommonUtils.getProjectStatusName(proDurationDelayVONum.getProjectStatus().intValue()));
                    //转万元赋值
                    proDurationDelayVONum.setDelayCostTotal(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayCostTotal()));
                    proDurationDelayVONum.setDelayCostCasej(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayCostCasej()));
                    proDurationDelayVONum.setDelayCostCasey(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayCostCasey()));
                    proDurationDelayVONum.setDelayClaimBasis(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getDelayClaimBasis()));
                    proDurationDelayVONum.setCompensateCost(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getCompensateCost()));
                    proDurationDelayVONum.setCompensateConfirmCost(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getCompensateConfirmCost()));
                    proDurationDelayVONum.setProjectCompletionCost(CommonUtils.parseYuanToWanZ(proDurationDelayVONum.getProjectCompletionCost()));
                }
                newList.addAll(orgStatusList);
            });

        });
        return newList;
    }

    private void getSumData(List<ProDurationDelayVO> proDurationDelayVOS, ProDurationDelayVO proDurationDelayVO) {
        proDurationDelayVO.setDelayDaysTotal(proDurationDelayVOS.stream().map(it -> it.getDelayDaysTotal()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setDelayDaysCasej(proDurationDelayVOS.stream().map(it -> it.getDelayDaysCasej()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setDelayDaysCasey(proDurationDelayVOS.stream().map(it -> it.getDelayDaysCasey()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setDelayCostTotal(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayCostTotal()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayCostCasej(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayCostCasej()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayCostCasey(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayCostCasey()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayClaimEstimate(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayClaimEstimate()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setDelayClaimBasis(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getDelayClaimBasis()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setCompensateDate(proDurationDelayVOS.stream().map(it -> it.getCompensateDate()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setCompensateCost(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getCompensateCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setCompensateConfirmDays(proDurationDelayVOS.stream().map(it -> it.getCompensateConfirmDays()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setCompensateConfirmCost(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getCompensateConfirmCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proDurationDelayVO.setProjectCompletionDays(proDurationDelayVOS.stream().map(it -> it.getProjectCompletionDays()).reduce(BigDecimal.ZERO, BigDecimal::add));
        proDurationDelayVO.setProjectCompletionCost(CommonUtils.parseYuanToWanZ(proDurationDelayVOS.stream().map(it -> it.getProjectCompletionCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }


}
