package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.service.IProSignReserveService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目责任书签订及风险金预留情况
 *
 * @author generator
 *
 */
@Service("proSignReserveService")
public class ProSignReserveServiceImpl extends BaseServiceImpl<ProSignReserveMapper, ProSignReserveEntity> implements IProSignReserveService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProSignReserveService proSignReserveService;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;


    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ProSignReserveEntity> lambdaFee = Wrappers.<ProSignReserveEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ProSignReserveEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProSignReserveEntity::getReportingMonth, reportingMonth);
        proSignReserveService.remove(lambdaFee);

        //查询项目信息数据
        List<ProSignReserveVO> proSignReserveVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            proSignReserveVOList = proSignReserveMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            proSignReserveVOList = proSignReserveMapper.getProjects(null);
        }

        List<Long> projectIds = proSignReserveVOList.stream().map(ProSignReserveVO::getProjectId).collect(Collectors.toList());

        // 查询施工类合同
        List<ProSignReserveVO> contractVOS = proSignReserveMapper.queryContract(projectIds,reportingMonth);
        Map<Long, List<ProSignReserveVO>> contractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            for (ProSignReserveVO contractVO : contractVOS) {
                contractVO.setContractAmount(contractVO.getAfterChangeAmount() != null ? contractVO.getAfterChangeAmount() : CommonUtils.setBigDecimalDefaultValue(contractVO.getContractAmountByContract()));
            }
            contractMap = contractVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        // 查询项目目标管理责任书
        List<ProSignReserveVO> bookVOS = proSignReserveMapper.queryBook(projectIds);
        Map<Long, ProSignReserveVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

        // 查询项目部人员风险金预留分配表
        List<ProSignReserveVO> allocateVOS = proSignReserveMapper.queryAllocate(projectIds);
        Map<Long,  List<ProSignReserveVO>> allocateMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(allocateVOS)) {
            allocateMap = allocateVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }

        for (ProSignReserveVO vo : proSignReserveVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)){
                vo.setContractSignTime(contractMap.get(projectId).get(0).getCreateTime());
                vo.setContractAmount(contractMap.get(projectId).stream().map(it -> it.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setAcContractAmount(contractMap.get(projectId).stream().map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setBookSignTime(bookMap.get(projectId).getBookSignTime());
                vo.setResponsibilityCost(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getResponsibilityCost()));
                vo.setUndertakingBenefits(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakingBenefits()));
                vo.setUndertakingBenefitsRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakingBenefitsRate()));
                vo.setOverallProfitMargin(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakingBenefits()),CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getTurninBase())));
            }
            if (!allocateMap.isEmpty() && allocateMap.containsKey(projectId)) {
                vo.setTrsReservedAmount(CommonUtils.setBigDecimalDefaultValue(allocateMap.get(projectId).get(0).getTrsReservedAmount()));
                vo.setApprovedReservedAmount(CommonUtils.setBigDecimalDefaultValue(allocateMap.get(projectId).get(0).getApprovedReservedAmount()));
                vo.setActualReservedAmount(CommonUtils.setBigDecimalDefaultValue(allocateMap.get(projectId).get(0).getActualReservedAmount()));
            }
            vo.setRiskReserve(CommonUtils.calculateRate(vo.getActualReservedAmount()!=null?vo.getActualReservedAmount():BigDecimal.ZERO, vo.getApprovedReservedAmount()!=null?vo.getApprovedReservedAmount():BigDecimal.ZERO));

            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setTwoOrgId(orgVos.getData().getId());
                    vo.setTwoOrgName(orgVos.getData().getShortName());
                    vo.setTwoOrgCode(orgVos.getData().getCode());
                    vo.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                }
            }
        }
        List<ProSignReserveEntity> proSignReserveEntityList = BeanMapper.mapList(proSignReserveVOList, ProSignReserveEntity.class);
        proSignReserveService.saveBatch(proSignReserveEntityList);
    }

    @Override
    public List<ProSignReserveVO> dealData(List<ProSignReserveVO> proSignReserveVOS) {
        //处理第一行合计值
        ProSignReserveVO proSignReserveVO = new ProSignReserveVO();
        ArrayList<ProSignReserveVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(proSignReserveVOS)){
            getSumData(proSignReserveVOS, proSignReserveVO);
            proSignReserveVO.setNumber("合计");
            proSignReserveVO.setId(IdWorker.getId());
            newList.add(proSignReserveVO);
        }

        //计算排序字段
        for(ProSignReserveVO proSignReserveVOrder :proSignReserveVOS){
            proSignReserveVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(proSignReserveVOrder.getProjectStatus().intValue()));
        }

        //计算项目状态合计
        proSignReserveVOS = proSignReserveVOS.stream().sorted(Comparator.comparing(ProSignReserveVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ProSignReserveVO>> mapProjectStatusOrder = proSignReserveVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));
        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ProSignReserveVO projectStatusSumVO = new ProSignReserveVO();
            projectStatusSumVO.setNumber("项目状态合计");
            projectStatusSumVO.setId(IdWorker.getId());
            projectStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumVO);
            newList.add(projectStatusSumVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProSignReserveVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProSignReserveVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ProSignReserveVO orgStatusSumVO = new ProSignReserveVO();
                orgStatusSumVO.setNumber("单位小计");
                orgStatusSumVO.setId(IdWorker.getId());
                orgStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus().intValue()));
                orgStatusSumVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumVO);
                newList.add(orgStatusSumVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProSignReserveVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ProSignReserveVO proSignReserveVONum : orgStatusList){
                    proSignReserveVONum.setNumber(number +"");
                    number = number + 1;
                    proSignReserveVONum.setProjectStatusName(CommonUtils.getProjectStatusName(proSignReserveVONum.getProjectStatus().intValue()));
                    proSignReserveVONum.setContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getContractAmount()));
                    proSignReserveVONum.setAcContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getAcContractAmount()));
                    proSignReserveVONum.setResponsibilityCost(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getResponsibilityCost()));
                    proSignReserveVONum.setUndertakingBenefits(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getUndertakingBenefits()));
                    proSignReserveVONum.setTrsReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getTrsReservedAmount()));
                    proSignReserveVONum.setApprovedReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getApprovedReservedAmount()));
                    proSignReserveVONum.setActualReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVONum.getActualReservedAmount()));
                }
                newList.addAll(orgStatusList);
            });

        });
        return newList;
    }

    private void getSumData(List<ProSignReserveVO> proSignReserveVOS, ProSignReserveVO proSignReserveVO) {
        proSignReserveVO.setContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getContractAmount() != null).map(it -> it.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getAcContractAmount() != null).map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setResponsibilityCost(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getResponsibilityCost() != null).map(it -> it.getResponsibilityCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setTrsReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getTrsReservedAmount() != null).map(it -> it.getTrsReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setApprovedReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getApprovedReservedAmount() != null).map(it -> it.getApprovedReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setActualReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getActualReservedAmount() != null).map(it -> it.getActualReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setUndertakingBenefits(CommonUtils.parseYuanToWanZ(proSignReserveVOS.stream().filter(it -> it.getUndertakingBenefits() != null).map(it -> it.getUndertakingBenefits()).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }
}
