package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.QualityEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.QualityMapper;
import com.ejianc.business.analysis.service.IQualityService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.QualityVO;
import com.ejianc.business.analysis.vo.RiskVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目工程质量问题增加成本统计表
 * 
 * @author generator
 * 
 */
@Service("qualityService")
public class QualityServiceImpl extends BaseServiceImpl<QualityMapper, QualityEntity> implements IQualityService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private IQualityService qualityService;
    @Autowired
    private QualityMapper qualityMapper;
    @Autowired
    private IOrgApi orgApi;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<QualityEntity> lambdaFee = Wrappers.<QualityEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(QualityEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(QualityEntity::getReportingMonth, reportingMonth);
        qualityService.remove(lambdaFee);

        //获取项目工程质量问题增加成本统计表包含的项目id
        List<Long> projectIds = qualityMapper.getProjectIds(reportingMonth);

        //查询项目信息数据
        List<Long> projectIdAll = new ArrayList<>();
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList);
            projectIdAll = projectIdList;
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIds);
            projectIdAll = projectIds;
        }

        //获取所有符合条件的业务数据
        List<QualityVO> riskVOList = qualityMapper.getDataAll(reportingMonth,projectIdAll);

        Map<Long, List<QualityVO>> mapPro = new HashMap<>();
        Map<String, List<QualityVO>> mapProAndPeriod = new HashMap<>();

        if (CollectionUtils.isNotEmpty(riskVOList)){
            mapPro = riskVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
            mapProAndPeriod = riskVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId() +"-"+s.getReportingMonth()
                    ));
        }

        //最新的数据
        ArrayList<QualityVO> lastList = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<QualityVO> riskVOProList = BeanMapper.mapList(profitIncomeVOList, QualityVO.class);
            for (QualityVO riskVO : riskVOProList){
                riskVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                riskVO.setCreateTime(new Date());
                //取每个项目最近一期的数据
                if (mapPro.containsKey(riskVO.getProjectId())){
                    List<QualityVO> riskVOS = mapPro.get(riskVO.getProjectId());
                    List<QualityVO> collectCompare = riskVOS.stream().sorted(Comparator.comparing(QualityVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    QualityVO riskVOPeriod = collectCompare.stream().findFirst().get();
                    String key = riskVO.getProjectId() +"-" + riskVOPeriod.getReportingMonth();
                    if (mapProAndPeriod.containsKey(key)){
                        List<QualityVO> riskVOListLast = mapProAndPeriod.get(key);
                        //补全二级组织信息
                        CommonResponse<OrgVO> orgVo = orgApi.detailById(riskVO.getProjectDepartmentId());//此处是项目部id
                        if (orgVo.isSuccess() && null != orgVo.getData()) {
                            String innerCode = orgVo.getData().getInnerCode();
                            String[] strs = innerCode.split("\\|");
                            CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                            if (orgVos.isSuccess() && null != orgVos.getData()) {
                                //二级组织信息
                                for (QualityVO riskVOLast : riskVOListLast){
                                    riskVOLast.setTwoOrgId(orgVos.getData().getId());
                                    riskVOLast.setTwoOrgName(orgVos.getData().getShortName());
                                    riskVOLast.setTwoOrgCode(orgVos.getData().getCode());
                                    riskVOLast.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                                    riskVOLast.setOrgId(riskVO.getOrgId());
                                    riskVOLast.setOrgName(riskVO.getOrgName());
                                    riskVOLast.setProjectDepartmentId(riskVO.getProjectDepartmentId());
                                    riskVOLast.setProjectName(riskVO.getProjectName());
                                    riskVOLast.setProjectCode(riskVO.getProjectCode());
                                    riskVOLast.setProjectStatus(riskVO.getProjectStatus());
                                    riskVOLast.setCreateTime(new Date());
                                    riskVOLast.setProjectCreateTime(riskVO.getProjectCreateTime());
                                    riskVOLast.setReportingMonth(reportingMonth);

                                }
                            }
                        }

                        lastList.addAll(riskVOListLast);
                    }
                }

            }

        }
        //新增数据
        if(CollectionUtils.isNotEmpty(lastList)){
            List<QualityEntity> riskEntityList = BeanMapper.mapList(lastList, QualityEntity.class);
            qualityService.saveBatch(riskEntityList);
        }
    }

    @Override
    public List<QualityVO> dealData(List<QualityVO> feeVOS) {
        //转万元
        for(QualityVO feeVONum : feeVOS){
            feeVONum.setAddCost(CommonUtils.parseYuanToWan(feeVONum.getAddCost()));
            feeVONum.setBuckleCost(CommonUtils.parseYuanToWan(feeVONum.getBuckleCost()));
        }
        //处理第一行合计值
        QualityVO feeVO = new QualityVO();
        ArrayList<QualityVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }

        //计算排序字段
        for(QualityVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
//            feeVOrder.setOrgStatusOrder(CommonUtils.getOrgOrderNum(feeVOrder.getTwoOrgName()));
        }

        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(QualityVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<QualityVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            QualityVO projectStatusSumfeeVO = new QualityVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(QualityVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<QualityVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                QualityVO orgStatusSumfeeVO = new QualityVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(QualityVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (QualityVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    //转万元赋值
//                    feeVONum.setAddCost(CommonUtils.parseYuanToWan(feeVONum.getAddCost()));
//                    feeVONum.setBuckleCost(CommonUtils.parseYuanToWan(feeVONum.getBuckleCost()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });

        return feeNewList;
    }

    private void getSumData(List<QualityVO> feeVOS, QualityVO feeVO) {
        BigDecimal addCost = feeVOS.stream().filter(s->s.getAddCost() != null).map(QualityVO::getAddCost)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal buckleCost = feeVOS.stream().filter(s->s.getBuckleCost() != null).map(QualityVO::getBuckleCost)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        //转万元赋值
        feeVO.setAddCost(addCost);
        feeVO.setBuckleCost(buckleCost);

    }
}
