/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.analysis.bean.AuthenticRightEntity;
import com.ejianc.business.analysis.service.IAuthenticRightService;
import com.ejianc.business.analysis.vo.AuthenticRightVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"authenticRight"})
public class AuthenticRightController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAuthenticRightService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AuthenticRightVO> saveOrUpdate(@RequestBody AuthenticRightVO saveOrUpdateVO) {
        AuthenticRightEntity entity = (AuthenticRightEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AuthenticRightEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        AuthenticRightVO vo = (AuthenticRightVO)BeanMapper.map((Object)((Object)entity), AuthenticRightVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AuthenticRightVO> queryDetail(Long id) {
        AuthenticRightEntity entity = (AuthenticRightEntity)((Object)this.service.selectById(id));
        AuthenticRightVO vo = (AuthenticRightVO)BeanMapper.map((Object)((Object)entity), AuthenticRightVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuthenticRightVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AuthenticRightVO authenticRightVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AuthenticRightVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String searchText = null;
        String reportingMonth = null;
        ArrayList<Integer> projectStatus = new ArrayList<Integer>();
        if (param.getParams().get("reportingMonth") != null) {
            reportingMonth = ((Parameter)param.getParams().get("reportingMonth")).getValue().toString();
        }
        if (param.getParams().get("projectStatus") != null) {
            String[] strs;
            String status = ((Parameter)param.getParams().get("projectStatus")).getValue().toString();
            for (String s : strs = status.split(",")) {
                projectStatus.add(Integer.parseInt(s));
            }
        }
        if (param.getSearchText() != null) {
            searchText = param.getSearchText();
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        HashMap<String, Object> paramMapper = new HashMap<String, Object>();
        paramMapper.put("tenantId", InvocationInfoProxy.getTenantid());
        paramMapper.put("commonOrgIds", commonOrgIds);
        paramMapper.put("departmentIds", departmentIds);
        paramMapper.put("projectStatus", projectStatus);
        paramMapper.put("searchText", searchText);
        paramMapper.put("reportingMonth", reportingMonth);
        List<AuthenticRightVO> authenticRightVOList = this.service.queryList(paramMapper);
        List<AuthenticRightVO> authenticRightVOS = this.service.processingList(authenticRightVOList);
        Page page = new Page();
        page = new Page(page.getCurrent(), (long)param.getPageSize(), (long)authenticRightVOS.size());
        page.setRecords(authenticRightVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AuthenticRight-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAuthenticRightData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AuthenticRightVO>> refAuthenticRightData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AuthenticRightVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> execute(HttpServletRequest request) {
        String date = request.getParameter("date");
        String day = null;
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String value = request.getParameter(name);
            JSONArray jsonArray = JSONArray.parseArray((String)value);
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            JSONArray parameters = JSONArray.parseArray((String)jsonObject.get((Object)"parameters").toString());
            JSONObject parametersJSONObject = parameters.getJSONObject(0);
            day = parametersJSONObject.get((Object)"value").toString();
            this.logger.info("day" + day);
        }
        this.service.execute(day, date);
        return CommonResponse.success((String)"\u9879\u76ee\u786e\u6743\u60c5\u51b5\u5206\u6790\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/executeTest"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> executeTest(String day, String date) {
        this.service.execute(day, date);
        return CommonResponse.success((String)"\u9879\u76ee\u786e\u6743\u60c5\u51b5\u5206\u6790\u6570\u636e\u751f\u6210\u6210\u529f\uff01");
    }
}

