/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.UnsettledProBusinessEntity;
import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.service.IUnsettledProBusinessService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unsettledProBusinessService")
public class UnsettledProBusinessServiceImpl
extends BaseServiceImpl<UnsettledProBusinessMapper, UnsettledProBusinessEntity>
implements IUnsettledProBusinessService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IUnsettledProBusinessService unsettledProBusinessService;
    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(UnsettledProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(UnsettledProBusinessEntity::getReportingMonth, (Object)reportingMonth);
        this.unsettledProBusinessService.remove((Wrapper)lambdaFee);
        List<Object> unsettledProBusinessVOList = new ArrayList();
        unsettledProBusinessVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.unsettledProBusinessMapper.queryProjectIds(projectIdList) : this.unsettledProBusinessMapper.queryProjectIds(null);
        List<Long> projectIds = unsettledProBusinessVOList.stream().map(UnsettledProBusinessVO::getProjectId).collect(Collectors.toList());
        List<UnsettledProBusinessVO> contractVOS = this.unsettledProBusinessMapper.queryContract(projectIds);
        Map<Object, Object> contractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<UnsettledProBusinessVO> bookVOS = this.unsettledProBusinessMapper.queryBook(projectIds);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<UnsettledProBusinessVO> costanalysisVOS = this.unsettledProBusinessMapper.queryCostanalysis(projectIds, reportingMonth);
        Map<Object, Object> costanalysisMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            costanalysisMap = costanalysisVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<UnsettledProBusinessVO> costanalysisHistoryVOS = this.unsettledProBusinessMapper.queryCostanalysisHistory(projectIds, UnsettledProBusinessServiceImpl.getEndDateNear());
        Map<Object, Object> costanalysisHistoryGrBy = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisHistoryVOS)) {
            costanalysisHistoryGrBy = costanalysisHistoryVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<UnsettledProBusinessVO> engineermeasurementVOS = this.unsettledProBusinessMapper.queryEngineermeasurement(projectIds, reportingMonth);
        Map<Object, Object> engineermeasurementMap = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementVOS)) {
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<UnsettledProBusinessVO> engineermeasurementHistoryVOS = this.unsettledProBusinessMapper.queryEngineermeasurementHistory(projectIds, reportingMonth);
        Map<Object, Object> engineermeasurementHistoryGrBy = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementHistoryVOS)) {
            engineermeasurementHistoryGrBy = engineermeasurementHistoryVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        for (UnsettledProBusinessVO unsettledProBusinessVO : unsettledProBusinessVOList) {
            CommonResponse orgVO;
            CommonResponse fourOrgVO;
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            CommonResponse orgVo;
            List collectCompare;
            List businessVOList;
            unsettledProBusinessVO.setReportEndDate(this.changDate(reportingMonth));
            unsettledProBusinessVO.setReportingMonth(reportingMonth);
            Long projectId = unsettledProBusinessVO.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                unsettledProBusinessVO.setPromoter(((UnsettledProBusinessVO)contractMap.get(projectId)).getPromoter());
                unsettledProBusinessVO.setPromoterName(((UnsettledProBusinessVO)contractMap.get(projectId)).getPromoterName());
                unsettledProBusinessVO.setProjectLocation(((UnsettledProBusinessVO)contractMap.get(projectId)).getProjectLocation());
                unsettledProBusinessVO.setContractSignTime(((UnsettledProBusinessVO)contractMap.get(projectId)).getContractSignTime());
                unsettledProBusinessVO.setContractStartDate(((UnsettledProBusinessVO)contractMap.get(projectId)).getContractStartDate());
                unsettledProBusinessVO.setContractEndDate(((UnsettledProBusinessVO)contractMap.get(projectId)).getContractEndDate());
                unsettledProBusinessVO.setContractAmount(((UnsettledProBusinessVO)contractMap.get(projectId)).getContractAmount());
                unsettledProBusinessVO.setAcContractAmount(((UnsettledProBusinessVO)contractMap.get(projectId)).getAcContractAmount());
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                unsettledProBusinessVO.setUndertakeRate(((UnsettledProBusinessVO)bookMap.get(projectId)).getUndertakeRate());
                unsettledProBusinessVO.setTargetRate(((UnsettledProBusinessVO)bookMap.get(projectId)).getTargetRate());
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                unsettledProBusinessVO.setContractIncome(((UnsettledProBusinessVO)costanalysisMap.get(projectId)).getContractIncome());
                unsettledProBusinessVO.setAcContractIncome(((UnsettledProBusinessVO)costanalysisMap.get(projectId)).getContractIncome());
                unsettledProBusinessVO.setRealCost(((UnsettledProBusinessVO)costanalysisMap.get(projectId)).getRealCost());
                unsettledProBusinessVO.setAcRealCost(((UnsettledProBusinessVO)costanalysisMap.get(projectId)).getRealCost());
            }
            if (!costanalysisHistoryGrBy.isEmpty() && costanalysisHistoryGrBy.containsKey(projectId)) {
                businessVOList = (List)costanalysisHistoryGrBy.get(projectId);
                collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                unsettledProBusinessVO.setCumulativeIncome(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome());
                unsettledProBusinessVO.setCumulativeIncomeYou(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome());
            }
            if (!engineermeasurementHistoryGrBy.isEmpty() && engineermeasurementHistoryGrBy.containsKey(projectId)) {
                businessVOList = (List)engineermeasurementHistoryGrBy.get(projectId);
                collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                unsettledProBusinessVO.setCumulativeBatch(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeBatch());
                unsettledProBusinessVO.setCumulativeBatchYou(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeBatch());
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                unsettledProBusinessVO.setOwnerCrValue(((UnsettledProBusinessVO)engineermeasurementMap.get(projectId)).getOwnerCrValue());
                unsettledProBusinessVO.setOwnerCrAcValue(((UnsettledProBusinessVO)engineermeasurementMap.get(projectId)).getOwnerCrValue());
                unsettledProBusinessVO.setContractReceivableMny(((UnsettledProBusinessVO)engineermeasurementMap.get(projectId)).getContractReceivableMny());
                unsettledProBusinessVO.setOperatingRevenue(((UnsettledProBusinessVO)engineermeasurementMap.get(projectId)).getOperatingRevenue());
                unsettledProBusinessVO.setRealRecrived(((UnsettledProBusinessVO)engineermeasurementMap.get(projectId)).getRealRecrived());
            }
            if ((orgVo = this.orgApi.detailById(unsettledProBusinessVO.getProjectDepartmentId())).isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                unsettledProBusinessVO.setThreeOrgId(((OrgVO)orgVos.getData()).getId());
                unsettledProBusinessVO.setThreeOrgName(((OrgVO)orgVos.getData()).getName());
            }
            if (unsettledProBusinessVO.getFourOrgId() != null && (fourOrgVO = this.orgApi.detailById(unsettledProBusinessVO.getFourOrgId())).isSuccess() && null != fourOrgVO.getData()) {
                unsettledProBusinessVO.setFourOrgName(((OrgVO)fourOrgVO.getData()).getName());
            }
            if (unsettledProBusinessVO.getContractorName() == null && (orgVO = this.orgApi.detailById(unsettledProBusinessVO.getContractor())).isSuccess() && null != orgVO.getData()) {
                unsettledProBusinessVO.setContractorName(((OrgVO)orgVO.getData()).getName());
            }
            if (unsettledProBusinessVO.getReportEndDate() != null && unsettledProBusinessVO.getEndDate() != null) {
                unsettledProBusinessVO.setUnsrttledDays(ComputeUtil.safeDiv((BigDecimal)new BigDecimal(unsettledProBusinessVO.getReportEndDate().getTime() - unsettledProBusinessVO.getEndDate().getTime()), (BigDecimal)new BigDecimal(86400000)));
            }
            unsettledProBusinessVO.setProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)(unsettledProBusinessVO.getContractIncome() != null ? unsettledProBusinessVO.getContractIncome() : BigDecimal.ZERO), (BigDecimal)(unsettledProBusinessVO.getRealCost() != null ? unsettledProBusinessVO.getRealCost() : BigDecimal.ZERO)), unsettledProBusinessVO.getContractIncome() != null ? unsettledProBusinessVO.getContractIncome() : BigDecimal.ZERO));
            unsettledProBusinessVO.setAcProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)(unsettledProBusinessVO.getAcContractIncome() != null ? unsettledProBusinessVO.getAcContractIncome() : BigDecimal.ZERO), (BigDecimal)(unsettledProBusinessVO.getAcRealCost() != null ? unsettledProBusinessVO.getAcRealCost() : BigDecimal.ZERO)), unsettledProBusinessVO.getAcContractIncome() != null ? unsettledProBusinessVO.getAcContractIncome() : BigDecimal.ZERO));
        }
        List unsettledProBusinessEntityList = BeanMapper.mapList(unsettledProBusinessVOList, UnsettledProBusinessEntity.class);
        this.unsettledProBusinessService.saveBatch(unsettledProBusinessEntityList);
    }

    @Override
    public Date changDate(String reportingMonth) {
        LocalDate date = LocalDate.now();
        String[] data = String.valueOf(date).split("-");
        String lastDayOfMonth = reportingMonth + "-" + data[2];
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.parse(lastDayOfMonth, fmt);
        LocalDate lastDay = nowDate.with(TemporalAdjusters.lastDayOfMonth());
        Date endDate = Date.from(lastDay.atTime(LocalTime.MIDNIGHT).atZone(ZoneId.systemDefault()).toInstant());
        return endDate;
    }

    @Override
    public List<UnsettledProBusinessVO> dealData(List<UnsettledProBusinessVO> unsettledProBusinessVOS) {
        UnsettledProBusinessVO unsettledProBusinessVO = new UnsettledProBusinessVO();
        ArrayList<UnsettledProBusinessVO> newList = new ArrayList<UnsettledProBusinessVO>();
        if (CollectionUtils.isNotEmpty(unsettledProBusinessVOS)) {
            this.getSumDate(unsettledProBusinessVOS, unsettledProBusinessVO);
            unsettledProBusinessVO.setNumber("\u5408\u8ba1");
            unsettledProBusinessVO.setId(Long.valueOf(IdWorker.getId()));
            newList.add(unsettledProBusinessVO);
        }
        Integer number = 1;
        for (UnsettledProBusinessVO vo : unsettledProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            Object object = number;
            Integer n = number = Integer.valueOf(number + 1);
            vo.setContractAmount(CommonUtils.parseYuanToWanZ(vo.getContractAmount()));
            vo.setAcContractAmount(CommonUtils.parseYuanToWanZ(vo.getAcContractAmount()));
            vo.setContractIncome(CommonUtils.parseYuanToWanZ(vo.getContractIncome()));
            vo.setAcContractIncome(CommonUtils.parseYuanToWanZ(vo.getAcContractIncome()));
            vo.setRealCost(CommonUtils.parseYuanToWanZ(vo.getRealCost()));
            vo.setAcRealCost(CommonUtils.parseYuanToWanZ(vo.getAcRealCost()));
            vo.setCumulativeIncome(CommonUtils.parseYuanToWanZ(vo.getCumulativeIncome()));
            vo.setCumulativeIncomeYou(CommonUtils.parseYuanToWanZ(vo.getCumulativeIncomeYou()));
            vo.setCumulativeBatch(CommonUtils.parseYuanToWanZ(vo.getCumulativeBatch()));
            vo.setCumulativeBatchYou(CommonUtils.parseYuanToWanZ(vo.getCumulativeBatchYou()));
            vo.setOwnerCrValue(CommonUtils.parseYuanToWanZ(vo.getOwnerCrValue()));
            vo.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(vo.getOwnerCrAcValue()));
            vo.setContractReceivableMny(CommonUtils.parseYuanToWanZ(vo.getContractReceivableMny()));
            vo.setOperatingRevenue(CommonUtils.parseYuanToWanZ(vo.getOperatingRevenue()));
            vo.setRealRecrived(CommonUtils.parseYuanToWanZ(vo.getRealRecrived()));
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337": {
                    vo.setProjectCategoryName("\u5de5\u4e1a\u5382\u623f");
                    break;
                }
                case "1470216222511185922": {
                    vo.setProjectCategoryName("\u516c\u5171\u5efa\u7b51");
                    break;
                }
                case "1470216274176622593": {
                    vo.setProjectCategoryName("\u6c11\u7528\u4f4f\u5b85");
                    break;
                }
                case "1470216311648534530": {
                    vo.setProjectCategoryName("\u57fa\u7840\u8bbe\u65bd");
                    break;
                }
                case "1470216348239642626": {
                    vo.setProjectCategoryName("\u5176\u5b83");
                }
            }
        }
        newList.addAll(unsettledProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<UnsettledProBusinessVO> unsettledProBusinessVOS, UnsettledProBusinessVO unsettledProBusinessVO) {
        unsettledProBusinessVO.setContractAmount(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(UnsettledProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(UnsettledProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setContractIncome(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(UnsettledProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setAcContractIncome(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(UnsettledProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setRealCost(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(UnsettledProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setAcRealCost(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(UnsettledProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setOwnerCrValue(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(UnsettledProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(UnsettledProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setContractReceivableMny(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(UnsettledProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setOperatingRevenue(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(UnsettledProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        unsettledProBusinessVO.setRealRecrived(CommonUtils.parseYuanToWanZ(unsettledProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(UnsettledProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }

    private static String getEndDateNear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(1, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }
}

