/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.analysis.bean.AuthenticRightEntity;
import com.ejianc.business.analysis.mapper.AuthenticRightMapper;
import com.ejianc.business.analysis.service.IAuthenticRightService;
import com.ejianc.business.analysis.vo.AuthenticRightVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="authenticRightService")
public class AuthenticRightServiceImpl
extends BaseServiceImpl<AuthenticRightMapper, AuthenticRightEntity>
implements IAuthenticRightService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AuthenticRightMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public void execute(String day, String date) {
        List<AuthenticRightVO> list;
        List<AuthenticRightVO> costanalysisCreateTimeList;
        List<AuthenticRightVO> engineermeasurementList;
        List<AuthenticRightVO> costanalysisList;
        List<AuthenticRightVO> costanalysisNearList;
        String beginDate = null;
        String endDate = null;
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            Date executeDate = null;
            Object stateDate = null;
            try {
                stateDate = DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM-dd"});
                executeDate = DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            beginDate = DateFormatUtils.format(stateDate, (String)"yyyy-01-01");
            endDate = DateFormatUtils.format((Date)DateUtils.addMonths(executeDate, (int)-1), (String)"yyyy-MM-dd");
        } else {
            if (!day.equals(DateFormatUtils.format((Date)new Date(), (String)"d"))) {
                throw new BusinessException("\u5f53\u524d\u65e5\u671f\uff0c\u4e0d\u5339\u914d\u8bbe\u7f6e\u65e5\u671f");
            }
            beginDate = DateFormatUtils.format((Date)new Date(), (String)"yyyy-01-01");
            endDate = DateFormatUtils.format((Date)DateUtils.addMonths((Date)new Date(), (int)-1), (String)"yyyy-MM-dd");
        }
        List<AuthenticRightVO> authenticRightVOList = this.queryProjects(endDate);
        for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
            Object innerCode;
            String[] stringArray;
            CommonResponse commonResponse;
            Date createDate = null;
            try {
                createDate = DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            authenticRightVO.setCreateTime(new Date());
            authenticRightVO.setReportingMonth(createDate);
            CommonResponse orgVo = this.iOrgApi.detailById(authenticRightVO.getProjectDepartmentId());
            if (!orgVo.isSuccess() || null == orgVo.getData() || !(commonResponse = this.iOrgApi.detailById(Long.valueOf(Long.parseLong((stringArray = ((String)(innerCode = ((OrgVO)orgVo.getData()).getInnerCode())).split("\\|"))[1])))).isSuccess() || null == commonResponse.getData()) continue;
            authenticRightVO.setTwoOrgId(((OrgVO)commonResponse.getData()).getId());
            authenticRightVO.setTwoOrgName(((OrgVO)commonResponse.getData()).getShortName());
            authenticRightVO.setTwoOrgCode(((OrgVO)commonResponse.getData()).getCode());
        }
        List<AuthenticRightVO> costanalysisListNear = this.getCostanalysisNear(beginDate, endDate);
        if (CollectionUtils.isNotEmpty(costanalysisListNear)) {
            Map maps = costanalysisListNear.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                Long k = authenticRightVO.getProjectId();
                if (!maps.containsKey(k)) continue;
                AuthenticRightVO cvo = (AuthenticRightVO)maps.get(k);
                authenticRightVO.setRealProductYear(cvo.getRealProductYear());
                authenticRightVO.setActualCostYear(cvo.getActualCostYear());
            }
        } else {
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                authenticRightVO.setRealProductYear(new BigDecimal(0));
                authenticRightVO.setActualCostYear(new BigDecimal(0));
            }
        }
        if (CollectionUtils.isNotEmpty(costanalysisNearList = this.getEngineermeasurementNear(beginDate, endDate))) {
            Map maps = costanalysisNearList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                Long k = authenticRightVO.getProjectId();
                if (!maps.containsKey(k)) continue;
                AuthenticRightVO cvo = (AuthenticRightVO)maps.get(k);
                authenticRightVO.setNotarizeProductYear(cvo.getNotarizeProductYear());
            }
        } else {
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                authenticRightVO.setNotarizeProductYear(new BigDecimal(0));
            }
        }
        if (CollectionUtils.isNotEmpty(costanalysisList = this.getCostanalysis(endDate))) {
            Map maps = costanalysisList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                Long l = authenticRightVO.getProjectId();
                if (!maps.containsKey(l)) continue;
                AuthenticRightVO cvo = (AuthenticRightVO)maps.get(l);
                authenticRightVO.setRealProductTotal(cvo.getRealProductTotal());
                authenticRightVO.setActualCostTotal(cvo.getActualCostTotal());
            }
        } else {
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                authenticRightVO.setRealProductTotal(new BigDecimal(0));
                authenticRightVO.setActualCostTotal(new BigDecimal(0));
            }
        }
        if (CollectionUtils.isNotEmpty(engineermeasurementList = this.getEngineermeasurement(endDate))) {
            Map maps = engineermeasurementList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                Long l = authenticRightVO.getProjectId();
                if (!maps.containsKey(l)) continue;
                AuthenticRightVO authenticRightVO2 = (AuthenticRightVO)maps.get(l);
                authenticRightVO.setNotarizeProductTotal(authenticRightVO2.getNotarizeProductTotal());
            }
        } else {
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                authenticRightVO.setNotarizeProductTotal(new BigDecimal(0));
            }
        }
        if (CollectionUtils.isNotEmpty(costanalysisCreateTimeList = this.getCostanalysisCreateTime(endDate))) {
            Map map = costanalysisCreateTimeList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            for (AuthenticRightVO vo : authenticRightVOList) {
                Long l = vo.getProjectId();
                if (!map.containsKey(l)) continue;
                AuthenticRightVO authenticRightVO = (AuthenticRightVO)map.get(l);
                vo.setCostAnalyseCreateTime(authenticRightVO.getCostAnalyseCreateTime());
            }
        }
        if (CollectionUtils.isNotEmpty(list = this.getEngineermeasurementCreateTime(endDate))) {
            Map map = list.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            for (AuthenticRightVO vo : authenticRightVOList) {
                Long l = vo.getProjectId();
                if (!map.containsKey(l)) continue;
                AuthenticRightVO authenticRightVO = (AuthenticRightVO)map.get(l);
                vo.setProjectUnitCreateTime(authenticRightVO.getProjectUnitCreateTime());
            }
        }
        for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
            authenticRightVO.setNotarizeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)(authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductYear()), (BigDecimal)(authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") : authenticRightVO.getActualCostYear())), (BigDecimal)new BigDecimal("100")));
            authenticRightVO.setNotarizeRateTotal(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)(authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductTotal()), (BigDecimal)(authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") : authenticRightVO.getActualCostTotal())), (BigDecimal)new BigDecimal("100")));
            authenticRightVO.setAuthenticRightRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)(authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductYear()), (BigDecimal)(authenticRightVO.getRealProductYear() == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear())), (BigDecimal)new BigDecimal("100")));
            authenticRightVO.setAuthenticRightRateTotal(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)(authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductTotal()), (BigDecimal)(authenticRightVO.getRealProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal())), (BigDecimal)new BigDecimal("100")));
        }
        this.logger.info("-----------------------------------------\u9879\u76ee\u786e\u6743\u60c5\u51b5\u5206\u6790\u751f\u6210\u6570\u636e,\u622a\u6b62\u65e5\u671f:" + endDate + " :" + JSONObject.toJSONString(authenticRightVOList));
        if (CollectionUtils.isNotEmpty(authenticRightVOList)) {
            this.deleteByReportingMonth(endDate);
            this.saveOrUpdateBatch(BeanMapper.mapList(authenticRightVOList, AuthenticRightEntity.class));
        }
    }

    @Override
    public List<AuthenticRightVO> queryProjects(String endDate) {
        return this.mapper.getProjects(endDate);
    }

    @Override
    public List<AuthenticRightVO> getEngineermeasurementNear(String beginDate, String endDate) {
        return this.mapper.getEngineermeasurementNear(beginDate, endDate);
    }

    @Override
    public List<AuthenticRightVO> getCostanalysisNear(String beginDate, String endDate) {
        return this.mapper.getCostanalysisNear(beginDate, endDate);
    }

    @Override
    public List<AuthenticRightVO> getEngineermeasurement(String endDate) {
        return this.mapper.getEngineermeasurement(endDate);
    }

    @Override
    public List<AuthenticRightVO> getCostanalysis(String endDate) {
        return this.mapper.getCostanalysis(endDate);
    }

    @Override
    public List<AuthenticRightVO> getEngineermeasurementCreateTime(String endDate) {
        return this.mapper.getEngineermeasurementCreateTime(endDate);
    }

    @Override
    public List<AuthenticRightVO> getCostanalysisCreateTime(String endDate) {
        return this.mapper.getCostanalysisCreateTime(endDate);
    }

    @Override
    public List<AuthenticRightVO> queryList(Map<String, Object> paramMapper) {
        return this.mapper.queryList(paramMapper);
    }

    @Override
    public void deleteByReportingMonth(String reportingMonth) {
        this.mapper.deleteByReportingMonth(reportingMonth);
    }

    @Override
    public List<AuthenticRightVO> processingList(List<AuthenticRightVO> authenticRightVOList) {
        ArrayList<AuthenticRightVO> authenticRightVOS = new ArrayList<AuthenticRightVO>();
        ArrayList<AuthenticRightVO> authenticRightVOS1 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightTotalVO = new AuthenticRightVO();
        BigDecimal notarizeProductYear1 = new BigDecimal("0");
        BigDecimal realProductYear1 = new BigDecimal("0");
        BigDecimal actualCostYear1 = new BigDecimal("0");
        BigDecimal notarizeProductTotal1 = new BigDecimal("0");
        BigDecimal realProductTotal1 = new BigDecimal("0");
        BigDecimal actualCostTotal1 = new BigDecimal("0");
        BigDecimal notarizeRate1 = new BigDecimal("0");
        BigDecimal authenticRightRate1 = new BigDecimal("0");
        BigDecimal notarizeRateTotal1 = new BigDecimal("0");
        BigDecimal authenticRightRateTotal1 = new BigDecimal("0");
        ArrayList<AuthenticRightVO> authenticRightVOList1 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightVO1 = new AuthenticRightVO();
        BigDecimal notarizeProductYear2 = new BigDecimal("0");
        BigDecimal realProductYear2 = new BigDecimal("0");
        BigDecimal actualCostYear2 = new BigDecimal("0");
        BigDecimal notarizeProductTotal2 = new BigDecimal("0");
        BigDecimal realProductTotal2 = new BigDecimal("0");
        BigDecimal actualCostTotal2 = new BigDecimal("0");
        BigDecimal notarizeRate2 = new BigDecimal("0");
        BigDecimal authenticRightRate2 = new BigDecimal("0");
        BigDecimal notarizeRateTotal2 = new BigDecimal("0");
        BigDecimal authenticRightRateTotal2 = new BigDecimal("0");
        ArrayList<AuthenticRightVO> authenticRightVOList2 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightVO2 = new AuthenticRightVO();
        BigDecimal notarizeProductYear3 = new BigDecimal("0");
        BigDecimal realProductYear3 = new BigDecimal("0");
        BigDecimal actualCostYear3 = new BigDecimal("0");
        BigDecimal notarizeProductTotal3 = new BigDecimal("0");
        BigDecimal realProductTotal3 = new BigDecimal("0");
        BigDecimal actualCostTotal3 = new BigDecimal("0");
        BigDecimal notarizeRate3 = new BigDecimal("0");
        BigDecimal authenticRightRate3 = new BigDecimal("0");
        BigDecimal notarizeRateTotal3 = new BigDecimal("0");
        BigDecimal authenticRightRateTotal3 = new BigDecimal("0");
        ArrayList<AuthenticRightVO> authenticRightVOList3 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightVO3 = new AuthenticRightVO();
        BigDecimal notarizeProductYear4 = new BigDecimal("0");
        BigDecimal realProductYear4 = new BigDecimal("0");
        BigDecimal actualCostYear4 = new BigDecimal("0");
        BigDecimal notarizeProductTotal4 = new BigDecimal("0");
        BigDecimal realProductTotal4 = new BigDecimal("0");
        BigDecimal actualCostTotal4 = new BigDecimal("0");
        BigDecimal notarizeRate4 = new BigDecimal("0");
        BigDecimal authenticRightRate4 = new BigDecimal("0");
        BigDecimal notarizeRateTotal4 = new BigDecimal("0");
        BigDecimal authenticRightRateTotal4 = new BigDecimal("0");
        ArrayList<AuthenticRightVO> authenticRightVOList4 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightVO4 = new AuthenticRightVO();
        BigDecimal notarizeProductYear5 = new BigDecimal("0");
        BigDecimal realProductYear5 = new BigDecimal("0");
        BigDecimal actualCostYear5 = new BigDecimal("0");
        BigDecimal notarizeProductTotal5 = new BigDecimal("0");
        BigDecimal realProductTotal5 = new BigDecimal("0");
        BigDecimal actualCostTotal5 = new BigDecimal("0");
        BigDecimal notarizeRate5 = new BigDecimal("0");
        BigDecimal authenticRightRate5 = new BigDecimal("0");
        BigDecimal notarizeRateTotal5 = new BigDecimal("0");
        BigDecimal authenticRightRateTotal5 = new BigDecimal("0");
        ArrayList<AuthenticRightVO> authenticRightVOList5 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightVO5 = new AuthenticRightVO();
        BigDecimal notarizeProductYear6 = new BigDecimal("0");
        BigDecimal realProductYear6 = new BigDecimal("0");
        BigDecimal actualCostYear6 = new BigDecimal("0");
        BigDecimal notarizeProductTotal6 = new BigDecimal("0");
        BigDecimal realProductTotal6 = new BigDecimal("0");
        BigDecimal actualCostTotal6 = new BigDecimal("0");
        BigDecimal notarizeRate6 = new BigDecimal("0");
        BigDecimal authenticRightRate6 = new BigDecimal("0");
        BigDecimal notarizeRateTotal6 = new BigDecimal("0");
        BigDecimal authenticRightRateTotal6 = new BigDecimal("0");
        ArrayList<AuthenticRightVO> authenticRightVOList6 = new ArrayList<AuthenticRightVO>();
        AuthenticRightVO authenticRightVO6 = new AuthenticRightVO();
        BigDecimal notarizeProductYearTotoal = new BigDecimal("0");
        BigDecimal realProductYearTotal = new BigDecimal("0");
        BigDecimal actualCostYearTotal = new BigDecimal("0");
        BigDecimal notarizeProductTotalTotal = new BigDecimal("0");
        BigDecimal realProductTotalTotal = new BigDecimal("0");
        BigDecimal actualCostTotalTotal = new BigDecimal("0");
        BigDecimal notarizeRateTotal = new BigDecimal("0");
        BigDecimal authenticRightRateTotal = new BigDecimal("0");
        BigDecimal notarizeRateTotalTotal = new BigDecimal("0");
        BigDecimal authenticRightRateTotalTotal = new BigDecimal("0");
        AuthenticRightVO authenticRightVOTotal = new AuthenticRightVO();
        for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
            if (authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 1) {
                authenticRightVOList1.add(authenticRightVO);
            }
            if (authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 2) {
                authenticRightVOList2.add(authenticRightVO);
            }
            if (authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 3) {
                authenticRightVOList3.add(authenticRightVO);
            }
            if (authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 4) {
                authenticRightVOList4.add(authenticRightVO);
            }
            if (authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 5) {
                authenticRightVOList5.add(authenticRightVO);
            }
            if (authenticRightVO.getProjectStatus() == null || authenticRightVO.getProjectStatus() != 6) continue;
            authenticRightVOList6.add(authenticRightVO);
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOList1)) {
            authenticRightVOS.addAll(AuthenticRightServiceImpl.countList(authenticRightVOList1));
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOList2)) {
            authenticRightVOS.addAll(AuthenticRightServiceImpl.countList(authenticRightVOList2));
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOList3)) {
            authenticRightVOS.addAll(AuthenticRightServiceImpl.countList(authenticRightVOList3));
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOList4)) {
            authenticRightVOS.addAll(AuthenticRightServiceImpl.countList(authenticRightVOList4));
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOList5)) {
            authenticRightVOS.addAll(AuthenticRightServiceImpl.countList(authenticRightVOList5));
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOList6)) {
            authenticRightVOS.addAll(AuthenticRightServiceImpl.countList(authenticRightVOList6));
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOS)) {
            for (AuthenticRightVO authenticRightVO : authenticRightVOS) {
                if (!"\u5c0f\u8ba1".equals(authenticRightVO.getNumber())) continue;
                authenticRightVOS1.add(authenticRightVO);
            }
        }
        if (CollectionUtils.isNotEmpty(authenticRightVOS1)) {
            authenticRightTotalVO = AuthenticRightServiceImpl.countTotalList(authenticRightVOS1);
        }
        if (authenticRightTotalVO != null) {
            authenticRightVOS.add(authenticRightTotalVO);
        }
        return authenticRightVOS;
    }

    public static List<AuthenticRightVO> countList(List<AuthenticRightVO> authenticRightVOList) {
        if (CollectionUtils.isNotEmpty(authenticRightVOList)) {
            int i;
            BigDecimal notarizeProductYear = new BigDecimal("0");
            BigDecimal realProductYear = new BigDecimal("0");
            BigDecimal actualCostYear = new BigDecimal("0");
            BigDecimal notarizeProductTotal = new BigDecimal("0");
            BigDecimal realProductTotal = new BigDecimal("0");
            BigDecimal actualCostTotal = new BigDecimal("0");
            BigDecimal notarizeRate = new BigDecimal("0");
            BigDecimal authenticRightRate = new BigDecimal("0");
            BigDecimal notarizeRateTotal = new BigDecimal("0");
            BigDecimal authenticRightRateTotal = new BigDecimal("0");
            ArrayList<AuthenticRightVO> authenticRightVOS = new ArrayList<AuthenticRightVO>();
            AuthenticRightVO authenticRightVO1 = new AuthenticRightVO();
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                notarizeProductYear = ComputeUtil.safeAdd((BigDecimal)notarizeProductYear, (BigDecimal)(authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductYear()));
                realProductYear = ComputeUtil.safeAdd((BigDecimal)realProductYear, (BigDecimal)(authenticRightVO.getRealProductYear() == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear()));
                actualCostYear = ComputeUtil.safeAdd((BigDecimal)actualCostYear, (BigDecimal)(authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") : authenticRightVO.getActualCostYear()));
                notarizeProductTotal = ComputeUtil.safeAdd((BigDecimal)notarizeProductTotal, (BigDecimal)(authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductTotal()));
                realProductTotal = ComputeUtil.safeAdd((BigDecimal)realProductTotal, (BigDecimal)(authenticRightVO.getRealProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal()));
                actualCostTotal = ComputeUtil.safeAdd((BigDecimal)actualCostTotal, (BigDecimal)(authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") : authenticRightVO.getActualCostTotal()));
                notarizeRate = ComputeUtil.safeAdd((BigDecimal)notarizeRate, (BigDecimal)(authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeRate()));
                authenticRightRate = ComputeUtil.safeAdd((BigDecimal)authenticRightRate, (BigDecimal)(authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") : authenticRightVO.getAuthenticRightRate()));
                notarizeRateTotal = ComputeUtil.safeAdd((BigDecimal)notarizeRateTotal, (BigDecimal)(authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeRateTotal()));
                authenticRightRateTotal = ComputeUtil.safeAdd((BigDecimal)authenticRightRateTotal, (BigDecimal)(authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") : authenticRightVO.getAuthenticRightRateTotal()));
                authenticRightVOS.add(authenticRightVO);
            }
            for (i = 0; i < authenticRightVOS.size(); ++i) {
                ((AuthenticRightVO)authenticRightVOS.get(i)).setNumber("" + (i + 1) + "");
            }
            for (i = 0; i < authenticRightVOS.size(); ++i) {
                if (((AuthenticRightVO)authenticRightVOS.get(i)).getProjectStatus() == 1) {
                    ((AuthenticRightVO)authenticRightVOS.get(i)).setProjectStatusName("\u672a\u5f00\u5de5");
                }
                if (((AuthenticRightVO)authenticRightVOS.get(i)).getProjectStatus() == 2) {
                    ((AuthenticRightVO)authenticRightVOS.get(i)).setProjectStatusName("\u5728\u5efa");
                }
                if (((AuthenticRightVO)authenticRightVOS.get(i)).getProjectStatus() == 3) {
                    ((AuthenticRightVO)authenticRightVOS.get(i)).setProjectStatusName("\u505c\u7f13\u5efa");
                }
                if (((AuthenticRightVO)authenticRightVOS.get(i)).getProjectStatus() == 4) {
                    ((AuthenticRightVO)authenticRightVOS.get(i)).setProjectStatusName("\u7ae3\u5de5\u672a\u7ed3\u7b97");
                }
                if (((AuthenticRightVO)authenticRightVOS.get(i)).getProjectStatus() == 5) {
                    ((AuthenticRightVO)authenticRightVOS.get(i)).setProjectStatusName("\u7ae3\u5de5\u5df2\u7ed3\u7b97");
                }
                if (((AuthenticRightVO)authenticRightVOS.get(i)).getProjectStatus() != 6) continue;
                ((AuthenticRightVO)authenticRightVOS.get(i)).setProjectStatusName("\u5b8c\u5de5");
            }
            authenticRightVO1.setNumber("\u5c0f\u8ba1");
            authenticRightVO1.setId(Long.valueOf(IdWorker.getId()));
            authenticRightVO1.setNotarizeProductYear(notarizeProductYear);
            authenticRightVO1.setRealProductYear(realProductYear);
            authenticRightVO1.setActualCostYear(notarizeProductYear);
            authenticRightVO1.setNotarizeProductTotal(notarizeProductTotal);
            authenticRightVO1.setRealProductTotal(realProductTotal);
            authenticRightVO1.setActualCostTotal(actualCostTotal);
            authenticRightVO1.setNotarizeRate(notarizeRate);
            authenticRightVO1.setAuthenticRightRate(authenticRightRate);
            authenticRightVO1.setNotarizeRateTotal(notarizeRateTotal);
            authenticRightVO1.setAuthenticRightRateTotal(authenticRightRateTotal);
            authenticRightVOS.add(authenticRightVO1);
            for (AuthenticRightVO authenticRightVO : authenticRightVOS) {
                authenticRightVO.setNotarizeProductYear(ComputeUtil.safeDiv((BigDecimal)authenticRightVO.getNotarizeProductYear(), (BigDecimal)new BigDecimal(10000)));
                authenticRightVO.setRealProductYear(ComputeUtil.safeDiv((BigDecimal)authenticRightVO.getRealProductYear(), (BigDecimal)new BigDecimal(10000)));
                authenticRightVO.setActualCostYear(ComputeUtil.safeDiv((BigDecimal)authenticRightVO.getActualCostYear(), (BigDecimal)new BigDecimal(10000)));
                authenticRightVO.setNotarizeProductTotal(ComputeUtil.safeDiv((BigDecimal)authenticRightVO.getNotarizeProductTotal(), (BigDecimal)new BigDecimal(10000)));
                authenticRightVO.setRealProductTotal(ComputeUtil.safeDiv((BigDecimal)authenticRightVO.getRealProductTotal(), (BigDecimal)new BigDecimal(10000)));
                authenticRightVO.setActualCostTotal(ComputeUtil.safeDiv((BigDecimal)authenticRightVO.getActualCostTotal(), (BigDecimal)new BigDecimal(10000)));
            }
            return authenticRightVOS;
        }
        return null;
    }

    public static AuthenticRightVO countTotalList(List<AuthenticRightVO> authenticRightVOList) {
        if (CollectionUtils.isNotEmpty(authenticRightVOList)) {
            BigDecimal notarizeProductYear = new BigDecimal("0");
            BigDecimal realProductYear = new BigDecimal("0");
            BigDecimal actualCostYear = new BigDecimal("0");
            BigDecimal notarizeProductTotal = new BigDecimal("0");
            BigDecimal realProductTotal = new BigDecimal("0");
            BigDecimal actualCostTotal = new BigDecimal("0");
            BigDecimal notarizeRate = new BigDecimal("0");
            BigDecimal authenticRightRate = new BigDecimal("0");
            BigDecimal notarizeRateTotal = new BigDecimal("0");
            BigDecimal authenticRightRateTotal = new BigDecimal("0");
            ArrayList authenticRightVOS = new ArrayList();
            AuthenticRightVO authenticRightVO1 = new AuthenticRightVO();
            for (AuthenticRightVO authenticRightVO : authenticRightVOList) {
                if (!"\u5c0f\u8ba1".equals(authenticRightVO.getNumber())) continue;
                notarizeProductYear = ComputeUtil.safeAdd((BigDecimal)notarizeProductYear, (BigDecimal)(authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductYear()));
                realProductYear = ComputeUtil.safeAdd((BigDecimal)realProductYear, (BigDecimal)(authenticRightVO.getRealProductYear() == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear()));
                actualCostYear = ComputeUtil.safeAdd((BigDecimal)actualCostYear, (BigDecimal)(authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") : authenticRightVO.getActualCostYear()));
                notarizeProductTotal = ComputeUtil.safeAdd((BigDecimal)notarizeProductTotal, (BigDecimal)(authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductTotal()));
                realProductTotal = ComputeUtil.safeAdd((BigDecimal)realProductTotal, (BigDecimal)(authenticRightVO.getRealProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal()));
                actualCostTotal = ComputeUtil.safeAdd((BigDecimal)actualCostTotal, (BigDecimal)(authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") : authenticRightVO.getActualCostTotal()));
                notarizeRate = ComputeUtil.safeAdd((BigDecimal)notarizeRate, (BigDecimal)(authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeRate()));
                authenticRightRate = ComputeUtil.safeAdd((BigDecimal)authenticRightRate, (BigDecimal)(authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") : authenticRightVO.getAuthenticRightRate()));
                notarizeRateTotal = ComputeUtil.safeAdd((BigDecimal)notarizeRateTotal, (BigDecimal)(authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeRateTotal()));
                authenticRightRateTotal = ComputeUtil.safeAdd((BigDecimal)authenticRightRateTotal, (BigDecimal)(authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") : authenticRightVO.getAuthenticRightRateTotal()));
            }
            authenticRightVO1.setNumber("\u5408\u8ba1");
            authenticRightVO1.setId(Long.valueOf(IdWorker.getId()));
            authenticRightVO1.setNotarizeProductYear(notarizeProductYear);
            authenticRightVO1.setRealProductYear(realProductYear);
            authenticRightVO1.setActualCostYear(notarizeProductYear);
            authenticRightVO1.setNotarizeProductTotal(notarizeProductTotal);
            authenticRightVO1.setRealProductTotal(realProductTotal);
            authenticRightVO1.setActualCostTotal(actualCostTotal);
            authenticRightVO1.setNotarizeRate(notarizeRate);
            authenticRightVO1.setAuthenticRightRate(authenticRightRate);
            authenticRightVO1.setNotarizeRateTotal(notarizeRateTotal);
            authenticRightVO1.setAuthenticRightRateTotal(authenticRightRateTotal);
            return authenticRightVO1;
        }
        return null;
    }

    public static BigDecimal getBigDecimalSum(BigDecimal i, BigDecimal ... arg) {
        BigDecimal sum = i;
        for (BigDecimal b : arg) {
            sum = sum.add(b);
        }
        return sum;
    }
}

