/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ConstructProBusinessEntity;
import com.ejianc.business.analysis.mapper.ConstructProBusinessMapper;
import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.service.IConstructProBusinessService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructProBusinessVO;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="constructProBusinessService")
public class ConstructProBusinessServiceImpl
extends BaseServiceImpl<ConstructProBusinessMapper, ConstructProBusinessEntity>
implements IConstructProBusinessService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConstructProBusinessService constructProBusinessService;
    @Autowired
    private ConstructProBusinessMapper constructProBusinessMapper;
    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ConstructProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructProBusinessEntity::getReportingMonth, (Object)reportingMonth);
        this.constructProBusinessService.remove((Wrapper)lambdaFee);
        List<Object> constructProBusinessVOList = new ArrayList();
        constructProBusinessVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.constructProBusinessMapper.queryProjectIds(projectIdList) : this.constructProBusinessMapper.queryProjectIds(null);
        List<Long> projectIds = constructProBusinessVOList.stream().map(ConstructProBusinessVO::getProjectId).collect(Collectors.toList());
        List<ConstructProBusinessVO> contractVOS = this.constructProBusinessMapper.queryContract(projectIds);
        Map<Object, Object> contractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> bookVOS = this.constructProBusinessMapper.queryBook(projectIds);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> countersignatureVOS = this.constructProBusinessMapper.queryCountersignature(projectIds);
        Map<Object, Object> countersignatureMap = new HashMap();
        if (CollectionUtils.isNotEmpty(countersignatureVOS)) {
            countersignatureMap = countersignatureVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> businessplanningeffectVOS = this.constructProBusinessMapper.queryBusinessplanningeffect(projectIds);
        Map<Object, Object> businessplanningeffectMap = new HashMap();
        if (CollectionUtils.isNotEmpty(businessplanningeffectVOS)) {
            businessplanningeffectMap = businessplanningeffectVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> costanalysisVOS = this.constructProBusinessMapper.queryCostanalysis(projectIds, reportingMonth);
        HashMap<Long, ConstructProBusinessVO> costanalysisMap = new HashMap<Long, ConstructProBusinessVO>();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            for (ConstructProBusinessVO costanalysisVO : costanalysisVOS) {
                if (!costanalysisMap.containsKey(costanalysisVO.getProjectId())) {
                    costanalysisMap.put(costanalysisVO.getProjectId(), costanalysisVO);
                    continue;
                }
                if (((ConstructProBusinessVO)costanalysisMap.get(costanalysisVO.getProjectId())).getContractIncome() == null && costanalysisVO.getContractIncome() != null) {
                    ((ConstructProBusinessVO)costanalysisMap.get(costanalysisVO.getProjectId())).setContractIncome(costanalysisVO.getContractIncome());
                }
                if (((ConstructProBusinessVO)costanalysisMap.get(costanalysisVO.getProjectId())).getRealCost() != null || costanalysisVO.getRealCost() == null) continue;
                ((ConstructProBusinessVO)costanalysisMap.get(costanalysisVO.getProjectId())).setRealCost(costanalysisVO.getRealCost());
            }
        }
        String dateLast = ConstructProBusinessServiceImpl.getEndDateLast();
        this.logger.info("dateLast" + dateLast);
        List<UnsettledProBusinessVO> costanalysisHistoryVOS = this.unsettledProBusinessMapper.queryCostanalysisHistory(projectIds, ConstructProBusinessServiceImpl.getEndDateLast());
        Map<Object, Object> costanalysisHistoryGrBy = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisHistoryVOS)) {
            costanalysisHistoryGrBy = costanalysisHistoryVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ConstructProBusinessVO> engineermeasurementVOS = this.constructProBusinessMapper.queryEngineermeasurement(projectIds, reportingMonth);
        Map<Object, Object> engineermeasurementMap = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementVOS)) {
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<UnsettledProBusinessVO> engineermeasurementHistoryVOS = this.unsettledProBusinessMapper.queryEngineermeasurementHistory(projectIds, reportingMonth);
        Map<Object, Object> engineermeasurementHistoryGrBy = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementHistoryVOS)) {
            engineermeasurementHistoryGrBy = engineermeasurementHistoryVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        for (ConstructProBusinessVO constructProBusinessVO : constructProBusinessVOList) {
            CommonResponse orgVO;
            CommonResponse fourOrgVO;
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            List collectCompare;
            List businessVOList;
            constructProBusinessVO.setReportingMonth(reportingMonth);
            Long projectId = constructProBusinessVO.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                constructProBusinessVO.setPromoter(((ConstructProBusinessVO)contractMap.get(projectId)).getPromoter());
                constructProBusinessVO.setPromoterName(((ConstructProBusinessVO)contractMap.get(projectId)).getPromoterName());
                constructProBusinessVO.setProjectLocation(((ConstructProBusinessVO)contractMap.get(projectId)).getProjectLocation());
                constructProBusinessVO.setContractSignTime(((ConstructProBusinessVO)contractMap.get(projectId)).getContractSignTime());
                constructProBusinessVO.setContractStartDate(((ConstructProBusinessVO)contractMap.get(projectId)).getContractStartDate());
                constructProBusinessVO.setContractEndDate(((ConstructProBusinessVO)contractMap.get(projectId)).getContractEndDate());
                constructProBusinessVO.setContractAmount(((ConstructProBusinessVO)contractMap.get(projectId)).getAfterChangeAmount() != null ? ((ConstructProBusinessVO)contractMap.get(projectId)).getAfterChangeAmount() : ((ConstructProBusinessVO)contractMap.get(projectId)).getContractAmountByContract());
                constructProBusinessVO.setAcContractAmount(((ConstructProBusinessVO)contractMap.get(projectId)).getAcContractAmount());
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                constructProBusinessVO.setUndertakeRate(CommonUtils.setBigDecimalDefaultValue(((ConstructProBusinessVO)bookMap.get(projectId)).getUndertakeRate()));
                constructProBusinessVO.setTargetRate(CommonUtils.setBigDecimalDefaultValue(((ConstructProBusinessVO)bookMap.get(projectId)).getTargetRate()));
                constructProBusinessVO.setSignDate(((ConstructProBusinessVO)bookMap.get(projectId)).getSignDate());
            }
            if (!countersignatureMap.isEmpty() && countersignatureMap.containsKey(projectId)) {
                constructProBusinessVO.setBusinessPlanApprovalDate(((ConstructProBusinessVO)countersignatureMap.get(projectId)).getBusinessPlanApprovalDate());
            }
            if (!businessplanningeffectMap.isEmpty() && businessplanningeffectMap.containsKey(projectId)) {
                constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(CommonUtils.parseNullValue(((ConstructProBusinessVO)businessplanningeffectMap.get(projectId)).getPlanExpectedRevenueGenerationAmount()));
                constructProBusinessVO.setPlanRevenueGenerationAmount(CommonUtils.setBigDecimalDefaultValue(((ConstructProBusinessVO)businessplanningeffectMap.get(projectId)).getPlanRevenueGenerationAmount()));
            }
            if (!costanalysisHistoryGrBy.isEmpty() && costanalysisHistoryGrBy.containsKey(projectId)) {
                businessVOList = (List)costanalysisHistoryGrBy.get(projectId);
                collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                BigDecimal cumulativeIncome = ((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome();
                if (projectId.equals(648615025832898651L)) {
                    this.logger.info("cumulativeIncome" + JSONObject.toJSONString((Object)cumulativeIncome));
                }
                constructProBusinessVO.setCumulativeIncome(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome());
                constructProBusinessVO.setCumulativeIncomeYou(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome());
                if (projectId.equals(648615025832898651L)) {
                    this.logger.info("cumulativeIncome11" + constructProBusinessVO.getCumulativeIncome());
                }
            }
            if (!engineermeasurementHistoryGrBy.isEmpty() && engineermeasurementHistoryGrBy.containsKey(projectId)) {
                businessVOList = (List)engineermeasurementHistoryGrBy.get(projectId);
                collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                constructProBusinessVO.setCumulativeBatch(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeBatch());
                constructProBusinessVO.setCumulativeBatchYou(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeBatch());
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                constructProBusinessVO.setContractIncome(((ConstructProBusinessVO)costanalysisMap.get(projectId)).getContractIncome());
                constructProBusinessVO.setAcContractIncome(((ConstructProBusinessVO)costanalysisMap.get(projectId)).getContractIncome());
                constructProBusinessVO.setRealCost(((ConstructProBusinessVO)costanalysisMap.get(projectId)).getRealCost());
                constructProBusinessVO.setAcRealCost(((ConstructProBusinessVO)costanalysisMap.get(projectId)).getRealCost());
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                constructProBusinessVO.setOwnerCrValue(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getCurrentBatch() != null).map(it -> it.getCurrentBatch()).reduce(BigDecimal.ZERO, BigDecimal::add));
                constructProBusinessVO.setOwnerCrAcValue(constructProBusinessVO.getOwnerCrValue());
                constructProBusinessVO.setContractReceivableMny(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getCurrentReceivables() != null).map(it -> it.getCurrentReceivables()).reduce(BigDecimal.ZERO, BigDecimal::add));
                constructProBusinessVO.setOperatingRevenue(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getFinanceReportIncome() != null).map(it -> it.getFinanceReportIncome()).reduce(BigDecimal.ZERO, BigDecimal::add));
                constructProBusinessVO.setRealRecrived(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getCurrentCollection() != null).map(it -> it.getCurrentCollection()).reduce(BigDecimal.ZERO, BigDecimal::add));
                constructProBusinessVO.setSettlementFlag(Integer.valueOf(1));
            } else {
                constructProBusinessVO.setSettlementFlag(Integer.valueOf(0));
            }
            CommonResponse orgVo = this.orgApi.detailById(constructProBusinessVO.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                constructProBusinessVO.setThreeOrgId(((OrgVO)orgVos.getData()).getId());
                constructProBusinessVO.setThreeOrgName(((OrgVO)orgVos.getData()).getName());
            }
            constructProBusinessVO.setPergaContractAmountProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getPlanExpectedRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getAcContractAmount())));
            constructProBusinessVO.setPrgaContractIncomeProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getPlanRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getAcContractIncome())));
            constructProBusinessVO.setProfit(ComputeUtil.safeSub((BigDecimal)CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getContractIncome()), (BigDecimal)CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getRealCost())));
            constructProBusinessVO.setProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getProfit()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getContractIncome())));
            constructProBusinessVO.setAcProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getProfit()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getAcContractIncome())));
            constructProBusinessVO.setValueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getOwnerCrValue()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getContractIncome())));
            constructProBusinessVO.setAcValueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getOwnerCrAcValue()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getAcContractIncome())));
            constructProBusinessVO.setRevenueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getOwnerCrValue()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getOperatingRevenue())));
            if (constructProBusinessVO.getFourOrgId() != null && (fourOrgVO = this.orgApi.detailById(constructProBusinessVO.getFourOrgId())).isSuccess() && null != fourOrgVO.getData()) {
                constructProBusinessVO.setFourOrgName(((OrgVO)fourOrgVO.getData()).getName());
            }
            if (constructProBusinessVO.getContractorName() != null || !(orgVO = this.orgApi.detailById(constructProBusinessVO.getContractor())).isSuccess() || null == orgVO.getData()) continue;
            constructProBusinessVO.setContractorName(((OrgVO)orgVO.getData()).getName());
        }
        List constructProBusinessEntityList = BeanMapper.mapList(constructProBusinessVOList, ConstructProBusinessEntity.class);
        this.constructProBusinessService.saveBatch(constructProBusinessEntityList);
    }

    @Override
    public List<ConstructProBusinessVO> dealData(List<ConstructProBusinessVO> constructProBusinessVOS) {
        ConstructProBusinessVO constructProBusinessVO = new ConstructProBusinessVO();
        ArrayList<ConstructProBusinessVO> newList = new ArrayList<ConstructProBusinessVO>();
        if (CollectionUtils.isNotEmpty(constructProBusinessVOS)) {
            this.getSumDate(constructProBusinessVOS, constructProBusinessVO);
            constructProBusinessVO.setNumber("\u5408\u8ba1");
            constructProBusinessVO.setId(Long.valueOf(IdWorker.getId()));
            newList.add(constructProBusinessVO);
        }
        Integer number = 1;
        for (ConstructProBusinessVO vo : constructProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            Object object = number;
            Integer n = number = Integer.valueOf(number + 1);
            vo.setProjectStatusName(CommonUtils.getProjectStatusName(vo.getProjectStatus()));
            vo.setProjectStatusNameTwo(CommonUtils.getProjectStatusName(vo.getProjectStatus()));
            vo.setContractAmount(CommonUtils.parseYuanToWanZ(vo.getContractAmount()));
            vo.setAcContractAmount(CommonUtils.parseYuanToWanZ(vo.getAcContractAmount()));
            vo.setCumulativeIncome(CommonUtils.parseYuanToWanZ(vo.getCumulativeIncome()));
            vo.setCumulativeIncomeYou(CommonUtils.parseYuanToWanZ(vo.getCumulativeIncomeYou()));
            vo.setCumulativeBatch(CommonUtils.parseYuanToWanZ(vo.getCumulativeBatch()));
            vo.setCumulativeBatchYou(CommonUtils.parseYuanToWanZ(vo.getCumulativeBatchYou()));
            vo.setContractIncome(CommonUtils.parseYuanToWanZ(vo.getContractIncome()));
            vo.setAcContractIncome(CommonUtils.parseYuanToWanZ(vo.getAcContractIncome()));
            vo.setRealCost(CommonUtils.parseYuanToWanZ(vo.getRealCost()));
            vo.setAcRealCost(CommonUtils.parseYuanToWanZ(vo.getAcRealCost()));
            vo.setOwnerCrValue(CommonUtils.parseYuanToWanZ(vo.getOwnerCrValue()));
            vo.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(vo.getOwnerCrAcValue()));
            vo.setContractReceivableMny(CommonUtils.parseYuanToWanZ(vo.getContractReceivableMny()));
            vo.setOperatingRevenue(CommonUtils.parseYuanToWanZ(vo.getOperatingRevenue()));
            vo.setRealRecrived(CommonUtils.parseYuanToWanZ(vo.getRealRecrived()));
            switch (vo.getSettlementFlag()) {
                case 0: {
                    vo.setSettlementFlagName("\u5426");
                    break;
                }
                case 1: {
                    vo.setSettlementFlagName("\u662f");
                }
            }
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337": {
                    vo.setProjectCategoryName("\u5de5\u4e1a\u5382\u623f");
                    break;
                }
                case "1470216222511185922": {
                    vo.setProjectCategoryName("\u516c\u5171\u5efa\u7b51");
                    break;
                }
                case "1470216274176622593": {
                    vo.setProjectCategoryName("\u6c11\u7528\u4f4f\u5b85");
                    break;
                }
                case "1470216311648534530": {
                    vo.setProjectCategoryName("\u57fa\u7840\u8bbe\u65bd");
                    break;
                }
                case "1470216348239642626": {
                    vo.setProjectCategoryName("\u5176\u5b83");
                }
            }
        }
        newList.addAll(constructProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<ConstructProBusinessVO> constructProBusinessVOS, ConstructProBusinessVO constructProBusinessVO) {
        constructProBusinessVO.setContractAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(ConstructProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ConstructProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getPlanExpectedRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanExpectedRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setPlanRevenueGenerationAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getPlanRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setContractIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(ConstructProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setAcContractIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(ConstructProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setRealCost(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(ConstructProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setAcRealCost(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(ConstructProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setProfit(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getProfit() != null).map(ConstructProBusinessVO::getProfit).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setOwnerCrValue(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(ConstructProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(ConstructProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setContractReceivableMny(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(ConstructProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setOperatingRevenue(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(ConstructProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        constructProBusinessVO.setRealRecrived(CommonUtils.parseYuanToWanZ(constructProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(ConstructProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }

    private static String getEndDateNear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(1, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }

    private static String getEndDateLast() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar ca = Calendar.getInstance();
        ca.add(1, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        endDate = endDate + "-12";
        return endDate;
    }
}

