package com.ejianc.business.analysis.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工程确权收付款情况
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_project_payment")
public class ProjectPaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="owner_affirm_production_near")
    private BigDecimal ownerAffirmProductionNear; // 业主确认产值（年）/万元
    @TableField(value="actual_finish_production_near")
    private BigDecimal actualFinishProductionNear; // 实际完成产值（年）/万元
    @TableField(value="actual_cost_near")
    private BigDecimal actualCostNear; // 实际成本（年）/万元
    @TableField(value="contract_receipt_near")
    private BigDecimal contractReceiptNear; // 按合同应收款 年
    @TableField(value="project_funds_near")
    private BigDecimal projectFundsNear; // 已收工程款年
    @TableField(value="owner_affirm_production")
    private BigDecimal ownerAffirmProduction; // 业主确认产值(开累)
    @TableField(value="actual_finish_production")
    private BigDecimal actualFinishProduction; // 实际完成产值(开累)
    @TableField(value="actual_cost")
    private BigDecimal actualCost; // 实际成本(开累)
    @TableField(value="contract_receipt")
    private BigDecimal contractReceipt; // 按合同应收款(开累)
    @TableField(value="project_funds")
    private BigDecimal projectFunds; // 已收工程款(开累)
    @TableField(value="advance")
    private BigDecimal advance; // 其中预付款(开累)
    @TableField(value="amount_payable")
    private BigDecimal amountPayable; // 应付款金额
    @TableField(value="amount_paid")
    private BigDecimal amountPaid; // 已付款金额
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="number")
    private String number; // 序号
    @TableField(value="short_name")
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public BigDecimal getOwnerAffirmProductionNear() {
        return ownerAffirmProductionNear;
    }

    public void setOwnerAffirmProductionNear(BigDecimal ownerAffirmProductionNear) {
        this.ownerAffirmProductionNear = ownerAffirmProductionNear;
    }
    public BigDecimal getActualFinishProductionNear() {
        return actualFinishProductionNear;
    }

    public void setActualFinishProductionNear(BigDecimal actualFinishProductionNear) {
        this.actualFinishProductionNear = actualFinishProductionNear;
    }
    public BigDecimal getActualCostNear() {
        return actualCostNear;
    }

    public void setActualCostNear(BigDecimal actualCostNear) {
        this.actualCostNear = actualCostNear;
    }
    public BigDecimal getContractReceiptNear() {
        return contractReceiptNear;
    }

    public void setContractReceiptNear(BigDecimal contractReceiptNear) {
        this.contractReceiptNear = contractReceiptNear;
    }
    public BigDecimal getProjectFundsNear() {
        return projectFundsNear;
    }

    public void setProjectFundsNear(BigDecimal projectFundsNear) {
        this.projectFundsNear = projectFundsNear;
    }
    public BigDecimal getOwnerAffirmProduction() {
        return ownerAffirmProduction;
    }

    public void setOwnerAffirmProduction(BigDecimal ownerAffirmProduction) {
        this.ownerAffirmProduction = ownerAffirmProduction;
    }
    public BigDecimal getActualFinishProduction() {
        return actualFinishProduction;
    }

    public void setActualFinishProduction(BigDecimal actualFinishProduction) {
        this.actualFinishProduction = actualFinishProduction;
    }
    public BigDecimal getActualCost() {
        return actualCost;
    }

    public void setActualCost(BigDecimal actualCost) {
        this.actualCost = actualCost;
    }
    public BigDecimal getContractReceipt() {
        return contractReceipt;
    }

    public void setContractReceipt(BigDecimal contractReceipt) {
        this.contractReceipt = contractReceipt;
    }
    public BigDecimal getProjectFunds() {
        return projectFunds;
    }

    public void setProjectFunds(BigDecimal projectFunds) {
        this.projectFunds = projectFunds;
    }
    public BigDecimal getAdvance() {
        return advance;
    }

    public void setAdvance(BigDecimal advance) {
        this.advance = advance;
    }
    public BigDecimal getAmountPayable() {
        return amountPayable;
    }

    public void setAmountPayable(BigDecimal amountPayable) {
        this.amountPayable = amountPayable;
    }
    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }
    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
    
}
